Rem drv: <migrate type="data_upgrade" version="11.0.0.0"/>
Rem
Rem $Header: rac_data_upgrade.sql 10-jun-2008.03:49:59 shasingh Exp $
Rem
Rem rac_data_upgrade.sql
Rem
Rem Copyright (c) 2007, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rac_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shasingh    06/10/08 - lrg 3426315
Rem    sadattaw    05/05/08 - 
Rem    dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
Rem                           st_emdbsa_11.1
Rem    sadattaw    11/26/07 - 
Rem    shasingh    08/09/07 - XbranchMerge
Rem                           shasingh_11g_19509a_targets_discovery from main
Rem    ajdsouza    02/20/07 - set end metaver for cluster response 
Rem                               repository metric
Rem    mnihalan    02/07/07 - Add metadata registration for oracle_racstorage
Rem                           and oracle_racobject
Rem    mnihalan    02/07/07 - Add metadata registration for oracle_racstorage
Rem                           and oracle_racobject
Rem    mnihalan    02/14/07 - XbranchMerge mnihalan_bug-5696024 from main
Rem    sadattaw    01/16/07 - data upgrade script for racdb
Rem    sadattaw    01/16/07 - Created
Rem


Rem
Rem  Register response metrics for cluster target
Rem
BEGIN
  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '4.1',
'4.1');

  MGMT_METRIC.SET_END_TYPE_META_VER( 'cluster', 'Response', '4.1');
END;
/

-----------------------------------------------------------------------------------
-- Registering metadata Cluster Managaged Services for target type cluster and snapshot type mgmt_rac_services
-----------------------------------------------------------------------------------

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'cluster' AND SNAPSHOT_TYPE = 'mgmt_rac_services');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'cluster' AND SNAPSHOT_TYPE = 'mgmt_rac_services';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('mgmt_rac_services', 'cluster', 'L', metadata_id, 'Cluster Managaged Services', 'Y', 'Y', 'Y', 'Y', 'Y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('mgmt_rac_services', 'cluster', 'P', metadata_id, 'Cluster Managaged Services', 'Y', 'Y', 'Y', 'Y', 'Y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_RAC_SERVICES
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'Rac_Services', 'Y', 'Y', 'Y', 'Y', 'Y', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'DATABASE_UNIQUE_NAME', 'Database Unique Name', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'SERVICE_NAME', 'Service Name', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'SERVICE_TYPE', 'Service Type', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'ENABLED', 'Enabled', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'TAFPOLICY', 'TAF Policy', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'PREFERRED_INSTANCES', 'Preferred Instances', 'S', '1024', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'AVAILABLE_INSTANCES', 'Available Instances', 'S', '1024', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'RUNNING_INSTANCES', 'Running Instances', 'S', '1024', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 7);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

-- End of metadata registration for metadata Cluster Managaged Services

SET DEFINE ON 

-- Update derived materialized views
BEGIN ECM_UTIL.UPDATE_ECM_METADATA; END;
/
COMMIT;
-----------------------------------------------------------------------------------

--------------------------------------------
-- Registering metadata for target type rac_database
-- and snapshot type oracle_racstorage
--------------------------------------------
SET DEFINE OFF

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_storage');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_storage';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE)
  VALUES ('oracle_storage', 'rac_database', 'L', metadata_id, 'RecommendedSettings Problems', 'Y', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

 -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE)
    VALUES ('oracle_storage', 'rac_database', 'P', metadata_id, 'RecommendedSettings Problems', 'Y', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

-- Register metadata for table MGMT_DB_RECUSERSETTINGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
   VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'User Recommended Settings Problems', 'Y', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
   VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'USER_NAME', 'User Name', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
   INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
   VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'PROBLEM_CODE', 'Object', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1); 
   INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER) 
   VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);  

-- Register metadata for table MGMT_DB_RECTSSETTINGS_ECM 
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'Tablespace Recommended Settings Problems', 'Y', 'N', 'N', NULL, 'N', 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER) 
  VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'PROBLEM_CODE', 'Object','N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
   VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'VALUE1', 'Value 1', 'N','10', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'VALUE2', 'Value 2', 'N','10', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 3);

-- Register metadata for table MGMT_DB_RECSEGMENTSETTINGS_ECM 

   INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER) 
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'Segment RecommendedSettings Problems', 'Y', 'N', 'N', NULL, 'N', 2);
   INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_TYPE', 'Object Type', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_OWNER', 'Owner', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_NAME', 'Name', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_PARTITION', 'Partition', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_LOB_COL', 'LOB Column', 'S', '4000', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'SEGMENT_TYPE', 'Segment Type', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'PROBLEM_CODE', 'Problem', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 7);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;

-- End of metadata registration for

SET DEFINE ON
COMMIT;

--------------------------------------------
-- Registering metadata for target type rac_database
-- and snapshot type oracle_racobject
--------------------------------------------
SET DEFINE OFF

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_object');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_object';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE)
    VALUES ('oracle_object', 'rac_database', 'L', metadata_id, 'ObjectProblems', 'N', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

-- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE)
    VALUES ('oracle_object', 'rac_database', 'P', metadata_id, 'ObjectProblems', 'N', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

-- Register metadata for table MGMT_DB_INVOBJS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'Invalid Objects', 'N', 'N', 'N'
, NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_TYPE', 'Object Type', 'N', '2', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_OWNER', 'Object Owner','S', '30', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
  VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_NAME', 'Object Name', 'S', '1000', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 2);
END;
/


ALTER SESSION SET CONSTRAINTS = IMMEDIATE;

-- End of metadata registration


SET DEFINE ON
COMMIT;

