Rem
Rem $Header: db_outofbox_elements.sql 11-jun-2007.13:51:48 mnihalan Exp $
Rem
Rem db_outofbox_elements.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      db_outofbox_elements.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      !!!!!! Please update upgrade script if updates are made. !!!!!!!
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mnihalan    06/11/07 - Add user chart from SQL
Rem    qsong       08/29/05 - make target_user_table_from_sql internal
Rem    chyu        07/20/05 - modifying the type to post_creation 
Rem    gsbhatia    07/11/05 - New repmgr header impl 
Rem    rreilly     05/03/05 - add group elements 
Rem    rreilly     04/28/05 - add cumulative target type 
Rem    rreilly     04/11/05 - add new generic elems for db reports
Rem    qsong       11/12/04 - qsong_asm_reports
Rem    mnihalan    10/07/04 - Created
Rem

-- set linesize 140

SET DEFINE OFF
 
DECLARE
  l_target_types  MGMT_IP_TARGET_TYPES;
  l_param_classes MGMT_IP_PARAM_CLASSES;
    
BEGIN

  -- -------------------------------------------------------------------------
  -- Generic Element Definitions
  --
  -- NOTE: Elements will only work if the element type used in the 
  --       mgmt_ip.add_element_to_report_def call matches the type
  --       specified in the mgmt_ip.add_element_definition call.
  -- -------------------------------------------------------------------------    

  -- ----------------------------------------
  -- Create Generic Database Element Type
  -- 
  -- NOTE: Element SQL will be required to 
  --       exclude RAC Instances.
  -- Ideally this would return only Databases,
  -- but since there is no way to pass in 
  -- category props, this element type will
  -- return all instances and rac dbs
  -- ----------------------------------------

  -- Database Instance Type
  -- Use database_target_type if you only need
  -- db instances

  -- Database Type
  l_target_types := MGMT_IP_TARGET_TYPES();
  l_target_types.extend(2);
  l_target_types(1) := 'oracle_database';
  l_target_types(2) := 'rac_database';

  mgmt_ip.add_element_type (
    p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE',
    p_target_types => l_target_types);

  -- Group Type
  l_target_types := MGMT_IP_TARGET_TYPES();
  l_target_types.extend(1);
  l_target_types(1) := 'composite';

  mgmt_ip.add_element_type (
    p_element_type_nlsid => 'DBMSG_GROUP_TARGET_TYPE',
    p_target_types => l_target_types);

  -- ----------------------------------------
  -- Create Generic Target DB Elements
  -- ----------------------------------------

    -- Internal Element: target_user_table_from_sql
    -- Chart  Type:      Table
    -- Target Type:      database_target_type 
    -- Description:      Element that connects to the target directly

    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(2);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.SQLStatementParamController';
   
    mgmt_ip.add_element_definition
     ('target_user_table_from_sql',
        'IPMSG_DATABASE_TARGET_TYPE',
        'target_user_table_from_sql',
        'oracle.sysman.db.util.reports.TableTargetRenderController',
        1,
        l_param_classes,
        null);
        
    COMMIT;  

  -- ----------------------------------------
  -- Create Generic Table Elements
  -- ----------------------------------------

    -- User Element:     DBMSG_USER_TABLE_FROM_SQL_ELEM
    -- Chart  Type:      Table
    -- Target Type:      DBMSG_DBINSTANCE_RAC_TARGET_TYPE
    -- Description:      Basic table element, user can see sql

    mgmt_ip.add_table_from_sql_elem_def (
      p_element_name_nlsid => 'DBMSG_USER_TABLE_FROM_SQL_ELEM',
      p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE', 
      p_description_nlsid  => 'DBMSG_USER_TABLE_FROM_SQL_DESC',
      p_internal_use_only  => 1,
      p_query_views        => 1);

    -- User Element:     DBMSG_GROUP_USER_TABLE_FROM_SQL_ELEM
    -- Chart  Type:      Table
    -- Target Type:      DBMSG_GROUP_TARGET_TYPE
    -- Description:      Basic table element, user can see sql

    mgmt_ip.add_table_from_sql_elem_def (
      p_element_name_nlsid => 'DBMSG_GROUP_USER_TABLE_FROM_SQL_ELEM',
      p_element_type_nlsid => 'DBMSG_GROUP_TARGET_TYPE', 
      p_description_nlsid  => 'DBMSG_GROUP_USER_TABLE_FROM_SQL_DESC',
      p_internal_use_only  => 1,
      p_query_views        => 1);

    -- Internal Element: DBMSG_TABLE_FROM_SQL_ELEM
    -- Chart  Type:      Table
    -- Target Type:      DBMSG_DBINSTANCE_RAC_TARGET_TYPE
    -- Description:      Basic table element, sql is not visible

    mgmt_ip.add_table_from_sql_elem_def (
      p_element_name_nlsid => 'DBMSG_TABLE_FROM_SQL_ELEM',
      p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE',
      p_description_nlsid  => 'DBMSG_TABLE_FROM_SQL_DESC',
      p_internal_use_only  => 1,
      p_query_views        => 0);

  -- ----------------------------------------
  -- Create Generic Chart Elements
  -- ----------------------------------------

    -- User Element:     DBMSG_USER_CHART_FROM_SQL_ELEM
    -- Chart  Type:      Chart
    -- Target Type:      DBMSG_DBINSTANCE_RAC_TARGET_TYPE
    -- Description:      Basic chart element, user can see sql

    mgmt_ip.add_chart_from_sql_elem_def (
      p_element_name_nlsid => 'DBMSG_USER_CHART_FROM_SQL_ELEM',
      p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE', 
      p_description_nlsid  => 'DBMSG_USER_CHART_FROM_SQL_DESC',
      p_internal_use_only  => 1,
      p_query_views        => 1);
      
    -- User Element:     DBMSG_CHART_FROM_SQL_ELEM
    -- Chart  Type:      Chart
    -- Target Type:      DBMSG_DBINSTANCE_RAC_TARGET_TYPE
    -- Description:      Basic chart element, user can see sql

    mgmt_ip.add_chart_from_sql_elem_def (
      p_element_name_nlsid => 'DBMSG_CHART_FROM_SQL_ELEM',
      p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE', 
      p_description_nlsid  => 'DBMSG_CHART_FROM_SQL_DESC',
      p_internal_use_only  => 1,
      p_query_views        => 0);

    -- User Element:     DBMSG_GROUP_USER_CHART_FROM_SQL_ELEM
    -- Chart  Type:      Chart
    -- Target Type:      DBMSG_GROUP_TARGET_TYPE
    -- Description:      Basic chart element, user can see sql

    mgmt_ip.add_chart_from_sql_elem_def (
      p_element_name_nlsid => 'DBMSG_GROUP_USER_CHART_FROM_SQL_ELEM',
      p_element_type_nlsid => 'DBMSG_GROUP_TARGET_TYPE', 
      p_description_nlsid  => 'DBMSG_GROUP_USER_CHART_FROM_SQL_DESC',
      p_internal_use_only  => 1,
      p_query_views        => 1);
    
END;
/

SET DEFINE ON
