Rem drv: <migrate type="data_upgrade" version="11.1.0.7" condition="EM_REPOS_MODE=SYSAUX" />
Rem $Header: overview_data_upgrade.sql 14-may-2008.16:02:52 nachen   Exp $
Rem
Rem overview_data_upgrade.sql
Rem
Rem Copyright (c) 2008, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      overview_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nachen      05/14/08 - Created
Rem

DECLARE
  l_cnt NUMBER := 0;
  rep_owner VARCHAR2(32) := NULL;
BEGIN
 IF ('&EM_REPOS_MODE' = 'SYSAUX') THEN

   BEGIN
     select count(*) into l_cnt 
       from all_objects 
      where object_name = 'MGMT_IP' 
        and object_type = 'PACKAGE'
        and owner       = '&&EM_REPOS_USER';
   EXCEPTION WHEN OTHERS THEN NULL;
   END;   

   IF (l_cnt = 1) THEN
   BEGIN
      rep_owner := mgmt_user.get_repository_owner;
      mgmt_ip.delete_report_by_title(report_owner_in => rep_owner, 
                                     report_title_in => 'DB_DATABASE_INSTANCE_OVERVIEW',
                                     check_security => 0);
      EXCEPTION
      WHEN NO_DATA_FOUND THEN NULL;
   END;
   END IF;

 END IF;
END;
/


