Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/11.2.0.0/esm/upgrade_create_db_policies.sql /st_emdbsa_11.2/1 2009/03/28 20:00:56 sudvarma Exp $
Rem
Rem upgrade_create_db_policies.sql
Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      upgrade_create_db_policies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sudvarma    03/16/09 - Created
Rem

SET DEFINE OFF
SET ESCAPE '\' ;
SET ESCAPE ON ;


DECLARE
 -- Policy Variable
 l_ctxList    		  			   MGMT_VIOL_CTXT_DEF_ARRAY;
 l_defaultParamValList      			   MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList      			   MGMT_POLICY_KEY_VAL_ARRAY;
 l_auto_enable				           NUMBER ;	
 l_10gR1_db_meta_ver                   VARCHAR2(3) ; 
 l_10gR1_db_end_meta_ver                   VARCHAR2(4) ; 
 l_valid_if_list                       MGMT_VALIDIF_ARRAY ;
 l_rac_database                        CONSTANT VARCHAR2(12) := 'rac_database';
 l_paramDefList                           MGMT_POLICY_PARAM_DEF_ARRAY;
 
 -- New snapshot name for the instance specific oracle_security metrics is oracle_security_inst
 l_oracle_security_inst                CONSTANT VARCHAR2(20) := 'oracle_security_inst';
 pol_eval_func_10gR1  CONSTANT VARCHAR2(50) := 'ESM.EVAL_POLICY10GR1'  ;  
 
BEGIN

  l_10gR1_db_meta_ver := '3.0' ;
  l_10gR1_db_end_meta_ver := '3.99' ;


----------->> Execute_And_Other_Privleges_On_Dir_Obj <<<--------
   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify account setting for the db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'directory',
                p_url_link_template =>'database/security/dirObject?oname=^directory^\&event=edit\&otype=DIRECTORY_OBJECT\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
                        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                        p_metric_column => 'directorypath'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Execute_And_Other_Privleges_On_Dir_Obj',   --Policy name
  p_metric_name =>'esm_dirObjUsersWithExeAndOtherPrivsRep',      --Metric name
  p_policy_label_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_NAME',
  p_description =>'Checks for Execute and other privileges on Directory Objects',
  p_description_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_DESC',
  p_impact =>'A knowledgeable malicious user can take advantage of directory object which is provided with EXECUTE along with READ/WRITE privilege.',
  p_impact_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_IMPACT',
  p_recommendation =>'Oracle recommends that nobody should have READ/WRITE access to a directory that anyone has EXECUTE.',
  p_recommendation_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as users have READ/WRITE and EXECUTE privileges on %directory%(%directorypath%).',
  p_message_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Execute_And_Other_Privleges_On_Dir_Obj',   --Policy name
  p_metric_name =>'esm_dirObjUsersWithExeAndOtherPrivsRep',      --Metric name
  p_policy_label_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_NAME',
  p_description =>'Checks for Execute and other privileges on Directory Objects',
  p_description_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_DESC',
  p_impact =>'A knowledgeable malicious user can take advantage of directory object which is provided with EXECUTE along with READ/WRITE privilege.',
  p_impact_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_IMPACT',
  p_recommendation =>'Oracle recommends that nobody should have READ/WRITE access to a directory that anyone has EXECUTE.',
  p_recommendation_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as users have READ/WRITE and EXECUTE privileges on %directory%(%directorypath%).',
  p_message_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

----------->> Public_Having_Execute_Privleges_On_Dir_Obj <<<--------
   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify account setting for the db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'directory',
                p_url_link_template =>'database/security/dirObject?oname=^directory^\&event=edit\&otype=DIRECTORY_OBJECT\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
                        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                        p_metric_column => 'directorypath'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Public_Having_Execute_Privilege_On_Dir_Obj',   --Policy name
  p_metric_name =>'esm_publicHavingExePrivOnDirObjRep',      --Metric name
  p_policy_label_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_NAME',
  p_description =>'Checks for PUBLIC having execute privilege on Directory Objects',
  p_description_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_DESC',
  p_impact =>'A knowledgeable malicious user can take advantage of directory object which has granted EXECUTE privilege to PUBLIC.',
  p_impact_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_IMPACT',
  p_recommendation =>'Oracle recommends that PUBLIC be not granted with EXECUTE privilege on directory objects.',
  p_recommendation_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as PUBLIC has EXECUTE privileges on %directory%(%directorypath%).',
  p_message_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Public_Having_Execute_Privilege_On_Dir_Obj',   --Policy name
  p_metric_name =>'esm_publicHavingExePrivOnDirObjRep',      --Metric name
  p_policy_label_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_NAME',
  p_description =>'Checks for PUBLIC having execute privilege on Directory Objects',
  p_description_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_DESC',
  p_impact =>'A knowledgeable malicious user can take advantage of directory object which has granted EXECUTE privilege to PUBLIC.',
  p_impact_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_IMPACT',
  p_recommendation =>'Oracle recommends that PUBLIC be not granted with EXECUTE privilege on directory objects.',
  p_recommendation_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as PUBLIC has EXECUTE privileges on %directory%(%directorypath%).',
  p_message_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;


END;
/

SET DEFINE ON;
SET ESCAPE OFF ;

