Rem drv: <migrate type="schema_upgrade" version="11.2.0.0"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/11.2.0.0/ha/hapage_schema_upgrade.sql /st_emdbsa_11.2/1 2009/02/03 16:34:02 gallison Exp $
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      hapage_types.sql
Rem
Rem    DESCRIPTION
Rem      Types for the HA Page
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     gallison   01/18/08 - Add br status
Rem     gallison   11/29/07 - Add event list
Rem     ajdsouza   10/07/07 - added type creation directy here
Rem                            rather than invoking upgrade file
Rem                            as upgrade types file is mmerged with pre_upgrade
Rem     sjconnol   08/20/05 - Creation
Rem

-- the logic that stages the new schema
create or replace type MGMT_HAPAGE_BR_OBJ as OBJECT (
    BACKUP_START     DATE,
    BACKUP_END       DATE,
    BACKUP_TIME      VARCHAR2(4000),
    INPUT_SIZE       VARCHAR2(4000),
    OUPUT_SIZE       VARCHAR2(4000),
    BACKUP_RATE      VARCHAR2(4000),
    BACKUP_TYPE      VARCHAR2(13),
    FLASHBACK_END    DATE,
    EST_MTTR         NUMBER,
    NEXT_SCHED_BACKUP DATE,
    BACKUP_STATUS    VARCHAR2(30)
);

/

create or replace type MGMT_HAPAGE_ECM_OBJ as OBJECT (
    LOG_MODE             VARCHAR2(12),
    FLASHBACK_LOGGING    VARCHAR2(3),
    FLASHBACK_ON         VARCHAR2(18),
    SUPPLEMENTAL_LOGGING VARCHAR2(8)
);

/

create or replace type MGMT_HAPAGE_AVAIL_OBJ as OBJECT (
    LAST_UPDATED_TIME     DATE,
    CURRENT_STATUS        INTEGER,
    AVAIL_PCT             NUMBER,
    AVAIL_PCT_DAY         NUMBER,
    AVAIL_PCT_WEEK        NUMBER,
    AVAIL_PCT_MONTH       NUMBER,
    START_TIMESTAMP       DATE,
    INSTANCE_NAME         VARCHAR2(4000),
    INSTANCE_STARTTIME    DATE,
    MTTR                  NUMBER,
    INSTANCE_VERSION      VARCHAR2(4000),
    ORACLE_HOME           VARCHAR2(4000),
    CPU_COUNT             NUMBER,
    OPEN_MODE             VARCHAR2(64)
);

/

create or replace type MGMT_HAPAGE_PRMY_OBJ as OBJECT (
    DG_STATUS        VARCHAR2(1024),
    NAME             VARCHAR2(256),
    HOST             VARCHAR2(256),
    PROT_MODE        VARCHAR2(256),
    FSFO_STATUS      VARCHAR2(256),
    USING_BROKER     VARCHAR2(4),
    COLL_TIMESTAMP   DATE,
    TARGET_NAME      VARCHAR2(256),
    TARGET_TYPE      VARCHAR2(64),
    STBY_LIST        VARCHAR2(1024)
);

/

create or replace type MGMT_HAPAGE_STBY_OBJ as OBJECT (
    NAME             VARCHAR2(256),
    HOST             VARCHAR2(256),
    ROLE             VARCHAR2(64),
    STATUS           VARCHAR2(1024),
    TRANS_LAG        VARCHAR2(32),
    APPLY_LAG        VARCHAR2(32),
    CLUSTER_NAME     VARCHAR2(256),
    TARGET_NAME      VARCHAR2(256),
    TARGET_TYPE      VARCHAR2(64),
    COLL_TIMESTAMP   DATE,
    REAL_TIME_QUERY  VARCHAR2(64)
);

/

CREATE OR REPLACE TYPE MGMT_HAPAGE_STBY_LIST AS TABLE OF MGMT_HAPAGE_STBY_OBJ;
/

create or replace type MGMT_HAPAGE_EVENT_OBJ as OBJECT (
    TARGET_NAME      VARCHAR2(256),
    TARGET_TYPE      VARCHAR2(64),
    SEVERITY         NUMBER,
    MSG              VARCHAR2(4000),
    CREATION_DATE    DATE, 
    MSG_NLSID        VARCHAR2(256),
    MSG_NLSPARAMS    VARCHAR2(4000),
    ACKNOWLEDGED     NUMBER
);

/

CREATE OR REPLACE TYPE MGMT_HAPAGE_EVENT_LIST AS TABLE OF MGMT_HAPAGE_EVENT_OBJ;

/


