Rem drv: <create type="triggers" pos="eval/eval_triggers.sql+"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/changemgr/cm_triggers.sql /st_emdbsa_11.2/1 2009/02/02 12:13:29 abodge Exp $
Rem
Rem cm_triggers.sql
Rem
Rem Copyright (c) 2003, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      cm_triggers.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    abodge      01/14/09 - Move CM Synch to DB Control
Rem    abodge      10/10/07 - Add trigger for synch removal
Rem    abodge      05/13/08 - Migrate 11GC functionality
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    lhan        05/12/05 - trigger to remove annotation
Rem    lhan        09/14/04 - lhan_cm_0914
Rem    lhan        09/14/03 - Created
Rem

-- Baselines

-- Trigger to clean up a baseline's scope spec
CREATE OR REPLACE TRIGGER MGMT_CM_BL_CLEAN_SS 
  AFTER DELETE ON MGMT_CM_BASELINES
  FOR EACH ROW 
  BEGIN 
    DELETE FROM mgmt_CM_SCOPESPECS
           WHERE ss_guid = :old.baseline_ss; 
  END;
/

-- Comparisons

-- Trigger to clean up a comparison's scope spec
-- and schema map
CREATE OR REPLACE TRIGGER MGMT_CM_COMP_CLEAN_SS_SM 
  AFTER DELETE ON MGMT_CM_COMPARISONS
  FOR EACH ROW 
  BEGIN 
    DELETE FROM mgmt_CM_SCOPESPECS
           WHERE ss_guid = :old.comparison_ss; 
    DELETE FROM mgmt_cm_schema_maps
           WHERE owner_id = :old.comparison_ss;
  END;
/

-- Trigger to remove annotation
-- Delete all annotations for the comparison_objs
CREATE OR REPLACE TRIGGER MGMT_CM_COMP_CLEAN_ANT 
  AFTER DELETE ON MGMT_CM_COMPARISON_OBJECTS
  FOR EACH ROW 
  BEGIN 
        DELETE FROM MGMT_ANNOTATION
         WHERE source_obj_type = mgmt_global.G_ANNOTATION_SOURCE_CM
           AND :old.annotation_guid is not NULL
           AND source_obj_guid = :old.annotation_guid ;
  END;
/

-- Trigger to clean up a synchronization's scope spec,
-- schema map, and temporary baseline(s).
CREATE OR REPLACE TRIGGER MGMT_CM_SYNCH_CLEAN_SS_SM_TBL
  AFTER DELETE ON MGMT_CM_SYNCHRONIZATIONS
  FOR EACH ROW 
  BEGIN 
    DELETE FROM MGMT_CM_SCOPESPECS
           WHERE ss_guid = :old.synch_ss; 
    DELETE FROM MGMT_CM_SCHEMA_MAPS
           WHERE owner_id = :old.synch_ss;
    DELETE FROM MGMT_CM_BASELINES
           WHERE BASELINE_GUID = :old.TARGET_TEMP_BL_ID
             AND TEMP_BL = 2;
    IF :old.SOURCE_TEMP_BL_ID IS NOT NULL THEN
      DELETE FROM MGMT_CM_BASELINES
           WHERE BASELINE_GUID = :old.SOURCE_TEMP_BL_ID
             AND TEMP_BL = 2;
    END IF;
  end;
/

show errors;

