Rem
Rem $Header: cim_views.sql 29-dec-2004.19:30:09 gbhat Exp $
Rem
Rem cim_views.sql
Rem
Rem Copyright (c) 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      cim_views.sql - Views corresponding to Oracle CIM Database Model
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gbhat       12/29/04 - Disable all CIM views 
Rem    gbhat       09/17/04 - Changes to descriptions to align with doc 
Rem                           review. 
Rem    gbhat       09/03/04 - gbhat_dbasemofs
Rem    gbhat       09/01/04 - Created
Rem

Rem
Rem View definition for Oracle_Database
Rem

-- CREATE OR REPLACE VIEW Oracle_Database
--    (InstanceID, Name, ElementName, DatabaseVersion,
--     SizeAllocated, SizeUnits, EnabledState, OtherEnabledState,
--     RequestedState, EnabledDefault, OperationalStatus,
--     StatusDescriptions, LastBackup, InstallDate, Caption,
--     Description)
--  AS
--    SELECT DISTINCT t.target_guid as InstanceID,
--                t.target_name as Name,
--                t.display_name as ElementName,
--                prop.version as DatabaseVersion,
--                sz.database_size as SizeAllocated, 3,
--   DECODE(avail.current_status, 0, 3,
--           1, 2,
--           2, 1,
--           3, 1,
--           4, 1,
--           5, 1,
--           6, 0) as EnabledState,
--   DECODE(avail.current_status, 0, NULL,
--           1, NULL,
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, NULL) as OtherEnabledState,
--    5, 2,
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as OperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as StatusDescriptions,
--                bk.end_time as LastBackup,
--                'Unavailable',
--                inst.banner as Caption,
--                inst.banner as Description
--    FROM MGMT_TARGETS t,
--         MGMT_HA_BACKUP bk,
--        (SELECT DISTINCT targ.target_guid,
--                         p.property_value as version
--         FROM MGMT_TARGETS targ,
--              MGMT_TARGET_PROPERTIES p
--         WHERE p.target_guid=targ.target_guid AND
--               p.property_name='DBVersion' AND
--               (targ.target_type='oracle_database' OR
--                targ.target_type='rac_database')) prop,
--    (SELECT DISTINCT targ.target_guid,
--                         m.current_status,
--                         m.start_collection_timestamp,
--                         nvl(s.load_timestamp,m.start_collection_timestamp)
--                         load_timestamp
--     FROM MGMT_CURRENT_AVAILABILITY m,
--              MGMT_SEVERITY s,
--          MGMT_TARGETS targ
--     WHERE m.target_guid=targ.target_guid AND
--               m.target_guid=s.target_guid(+) AND
--               m.severity_guid=s.severity_guid(+) AND
--               (targ.target_type='oracle_database' OR
--               targ.target_type='rac_database')) avail,
--         (SELECT g.target_guid,
--                 i.instance_name,
--                 i.banner
--          FROM
--                MGMT_DB_DBNINSTANCEINFO_ECM i,
--                MGMT_TARGETS g,
--                MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst,
--         (SELECT (nvl(tb.tbsp_size,0)+
--                  nvl(re.redo_size,0)+
--                  nvl(ct.ctl_size,0))database_size,
--                   tb.target_guid
--          FROM (SELECT sum(tablespace_used_size/1024/1024) as tbsp_size,
--                       t.target_guid as target_guid
--               FROM MGMT_DB_TABLESPACES_ECM tbsp,
--                    MGMT_ECM_GEN_SNAPSHOT s,
--                    MGMT_TARGETS t
--               WHERE tbsp.ecm_snapshot_id = s.snapshot_guid AND
--                        s.target_guid = t.target_guid AND
--                     s.is_current = 'Y' group by t.target_guid)tb,
--               (SELECT sum(logsize/1024/1024) as redo_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_REDOLOGS_ECM redo,
--                     MGMT_ECM_GEN_SNAPSHOT s,
--                     MGMT_TARGETS t
--                WHERE redo.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)re,
--               (SELECT sum(cf_size) as ctl_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_CONTROLFILES_SIZE_ECM ctl,
--                     MGMT_ECM_GEN_SNAPSHOT s, MGMT_TARGETS t
--                WHERE ctl.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)ct
--          WHERE tb.target_guid = re.target_guid (+) AND
--                  re.target_guid = ct.target_guid (+))sz
--    WHERE t.target_guid=avail.target_guid AND
--          t.target_guid=inst.target_guid AND
--          t.target_guid=sz.target_guid AND
--          t.target_guid=prop.target_guid AND
--          t.target_guid=bk.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_Database IS 
-- 'Oracle_Database returns one entry for each database that is managed by Oracle
-- Enterprise Manager. View entries are created using the databases that are known
-- to the Enterprise Manager Management Repository. Note: A Real Application
-- Cluster is presented as a single entry in this view regardless of the number of
-- instances that manipulate it.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_Database.Caption IS 
-- 'The caption contains a short textual description  of the database.  This
-- property would typically be used from a management client to provide a little
-- more descriptive content for the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_Database.DatabaseVersion IS 
-- 'The version number for the Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_Database.Description IS 
-- 'The description provides detailed information about the database.';
-- 
-- COMMENT ON COLUMN Oracle_Database.ElementName IS 
-- 'A user-friendly name for the database for use in client applications.';
-- 
-- COMMENT ON COLUMN Oracle_Database.EnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_Database.EnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_Database.InstallDate IS 
-- 'A datetime value indicating when the database was created.';
-- 
-- COMMENT ON COLUMN Oracle_Database.InstanceID IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_Database.LastBackup IS 
-- 'The date and time when the latest complete or partial backup of the database
-- was performed.  If the database has never been backed up, then this property
-- has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_Database.OperationalStatus IS 
-- 'Indicates the current status of the database . A value of 10 indicates that the
-- database is down and a value of 2 indicates that the database is up.';
-- 
-- COMMENT ON COLUMN Oracle_Database.OtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database.
-- If the value of the EnabledState property is set to anything other than 1, this
-- property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_Database.RequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState, which is used to compare the last requested and current
-- enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_Database.SizeAllocated IS 
-- 'The estimated amount of disk space in megabytes that has been reserved for
-- database use.';
-- 
-- COMMENT ON COLUMN Oracle_Database.SizeUnits IS 
-- 'The units for the SizeAllocated property. Mapping is 1 - Bytes, 2 - Kilobytes,
-- 3 - Megabytes, 4 - Gigabytes and 5 - Terabytes.';
-- 
-- COMMENT ON COLUMN Oracle_Database.StatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- Rem
-- Rem View definition for Oracle_DatabaseInstance
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_DatabaseInstance
--    (CreationClassName, SystemCreationClassName, SystemName,
--     Name, ElementName, PrimaryOwnerName, PrimaryOwnerContact, Started,
--     EnabledState, OtherEnabledState, RequestedState, EnabledDefault,
--     InstallDate, OperationalStatus, StatusDescriptions, Caption,
--     Description, StartupTime, LastStatusChangeTime, ConnectionLimit)
--  AS
--    SELECT 'Oracle_DatabaseInstance',
--           'Oracle_ComputerSystem',
--           inst.host_name as SystemName,
--           t.display_name as Name,
--          inst.instance_name as ElementName,
--          'Unavailable',
--          'Unavailable',
--    DECODE(avail.current_status, 0, 'FALSE',
--           1, 'TRUE',
--           2, 'FALSE',
--           3, 'FALSE',
--           4, 'FALSE',
--           5, 'FALSE',
--           6, 'FALSE'
--           ) as Started,
--   DECODE(avail.current_status, 0, 3,
--           1, 2,
--           2, 1,
--           3, 1,
--           4, 1,
--           5, 1,
--           6, 0) as EnabledState,
--   DECODE(avail.current_status, 0, NULL,
--           1, NULL,
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, NULL) as OtherEnabledState,
--    5, 2, 'Unavailable',
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as OperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as StatusDescriptions,
--           inst.description as Caption,
--           inst.description as Description,
--           prop.StartTime as StartupTime,
--           avail.load_timestamp as LastStatusChangeTime,
--           lic.connection_limit as ConnectionLimit
--    FROM MGMT_TARGETS t,
--    (SELECT DISTINCT targ.target_guid,
--                         m.current_status,
--                         m.start_collection_timestamp,
--                         nvl(s.load_timestamp,m.start_collection_timestamp)
--                         load_timestamp
--     FROM MGMT_CURRENT_AVAILABILITY m,
--              MGMT_SEVERITY s,
--          MGMT_TARGETS targ
--     WHERE m.target_guid=targ.target_guid AND
--               m.severity_guid=s.severity_guid(+) AND
--               m.target_guid=s.target_guid(+) AND
--               targ.target_type='oracle_database') avail,
--        (SELECT DISTINCT targ.target_guid,
--                         p.property_value as StartTime
--         FROM MGMT_TARGETS targ,
--              MGMT_TARGET_PROPERTIES p
--         WHERE p.target_guid=targ.target_guid AND
--               p.property_name='StartTime' AND
--               targ.target_type='oracle_database') prop,
--         (SELECT i.instance_name,
--      i.host_name,
--                 g.target_guid,
--                 i.banner as description
--          FROM MGMT_DB_DBNINSTANCEINFO_ECM i,
--               MGMT_TARGETS g,
--               MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst,
--         (SELECT i.sessions_max as connection_limit,
--                 g.target_guid
--          FROM MGMT_DB_LICENSE_ECM i,
--               MGMT_TARGETS g,
--               MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') lic
--    WHERE t.target_guid=avail.target_guid AND
--          t.target_guid=inst.target_guid AND
--          t.target_guid=prop.target_guid AND
--          (t.target_guid=lic.target_guid OR
--           lic.target_guid in
--                   (SELECT DISTINCT composite_target_guid
--                 FROM MGMT_TARGET_MEMBERSHIPS
--                 WHERE member_target_guid = t.target_guid AND
--                        composite_target_type = 'rac_database'))
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_DatabaseInstance IS 
-- 'Oracle_DatabaseInstance contains one entry for each Oracle Instance that is
-- centrally managed.  A Real Application Cluster has one entry for each of the
-- instances that manipulate it.  Instances of Oracle_DatabaseInstance are created
-- using the database instances that are known to the Oracle Enterprise Manager
-- repository.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.Caption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database instance.  This property would typically be used from a management
-- client to provide a little more descriptive content for the ElementName.  The
-- caption should be constructed using the following format: Instance xxx, where
-- xxx is the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.ConnectionLimit IS 
-- 'The maximum number of active inbound connections that can be concurrently
-- opened on the instance.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.CreationClassName IS 
-- 'CreationClassName indicates the name of the class or the subclass used in the
-- creation of an instance. When used with the other key properties of this class,
-- this property allows all instances of this class and its subclasses to be
-- uniquely identified.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.Description IS 
-- 'The description provides detailed information about the database instance.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.ElementName IS 
-- 'A user-friendly name for the database instance.  This property defines a
-- user-friendly name that represents the database instance for use in client
-- applications.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.EnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.EnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.InstallDate IS 
-- 'A datetime value indicating when the database was created.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.LastStatusChangeTime IS 
-- 'The date and time when the operational status of the database instance last
-- changed.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.Name IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database instance.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.OperationalStatus IS 
-- 'This property contains the operational status of the database instance.  OK
-- means that the database instance is operational and available for general use. 
-- Stopped means that the instance is unavailable and cannot be used.  Service
-- implies an administrative state of unavailability.  Degraded means that the
-- database instance is operating at a less than optimal level.  Starting means
-- that the database instance is in the process of becoming operational.  These
-- status values map to the RFC1697 OperStatus values as follows: OK - UP, Stopped
-- - DOWN, In Service - HALTED, Stressed - CONGESTED, and Starting - RESTARTING. 
-- Any additional status variables that are defined are CIM specific.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.OtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database.
-- If the value of the EnabledState property is set to anything other than 1, this
-- property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.PrimaryOwnerContact IS 
-- 'A string that provides information on how the primary owner of the Service can
-- be reached. For example, a phone number or email address.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.PrimaryOwnerName IS 
-- 'The name of the primary owner for the service, if one is defined. The primary
-- owner is the initial support contact for the Service.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.RequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState. This property is provided to compare the last requested and
-- current enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.Started IS 
-- 'Started is a boolean indicating whether the database has been started - TRUE,
-- or stopped - FALSE.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.StartupTime IS 
-- 'The date and time when the database instance was last started.  If the database
-- instance has an OperationalStatus of Stopped or Starting, then this value is
-- not meaningful.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.StatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.SystemCreationClassName IS 
-- 'The CreationClassName of the computer system that this database instance is
-- hosted on.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseInstance.SystemName IS 
-- 'The scoping Host Name.';
-- 
-- Rem
-- Rem View definition for Oracle_DatabaseSystem
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_DatabaseSystem
--     (CreationClassName, Name, NameFormat, ElementName, PrimaryOwnerName,
--      PrimaryOwnerContact, EnabledState, OtherEnabledState,
--      RequestedState, EnabledDefault, InstallDate, OperationalStatus,
--      StatusDescriptions, Caption, Description, Roles)
--   AS
--     SELECT DISTINCT
--    'Oracle_DatabaseSystem',
--        inst.host_name as Name,
--     'hostname',
--     inst.instance_name as ElementName,
--     'Unavailable',
--     'Unavailable', 5, NULL, 5, 5,
--     'Unavailable',
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as OperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as StatusDescriptions,
--     inst.description as Caption,
--     inst.description as Description,
--     'Unavailable'
--     FROM MGMT_TARGETS t,
--    (SELECT DISTINCT targ.target_guid,
--                         m.current_status,
--                         m.start_collection_timestamp,
--                         nvl(s.load_timestamp,m.start_collection_timestamp)
--                         load_timestamp
--     FROM MGMT_CURRENT_AVAILABILITY m,
--              MGMT_SEVERITY s,
--          MGMT_TARGETS targ
--     WHERE m.target_guid=targ.target_guid AND
--               m.target_guid=s.target_guid(+) AND
--               m.severity_guid=s.severity_guid(+) AND
--               (targ.target_type='oracle_database' OR
--               targ.target_type='rac_database')) avail,
--         (SELECT i.instance_name,
--           i.host_name,
--                 g.target_guid,
--                 i.banner as description
--          FROM MGMT_DB_DBNINSTANCEINFO_ECM i,
--               MGMT_TARGETS g,
--               MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst
--     WHERE t.target_guid=avail.target_guid AND
--           t.target_guid=inst.target_guid
--     WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_DatabaseSystem IS 
-- 'An Oracle_DatabaseSystem represents the existence of an Oracle database
-- environment as a manageable entity.  Instances of Oracle_DatabaseSystem are
-- used to navigate to the software characteristics of the database environment
-- that are modeled within the application schema.  For example, each separately
-- deployed Oracle installation would have an Oracle_DatabaseSystem instance.Real
-- application clusters are modeled as one instance, independent of the number of
-- Oracle Homes in which the RAC as a logical entity resides.  A database
-- environment is composed of a database system, one or more database instances,
-- and one or more databases.  An instance is a logical representation of the
-- active set of processes that serve the database.  The database is a logical
-- representation of an Oracle database as an individual, physical entity as
-- created through the CREATE DATABASE statement.  See the descriptions of
-- Oracle_Instance and Oracle_Database to get more detailed descriptions of Oracle
-- instances and databases.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.Caption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database environment.  This property would typically be used from a
-- management client to provide a little more descriptive content for the
-- ElementName.  The caption should be constructed using the following format:
-- Database environment xxx, where xxx is the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.CreationClassName IS 
-- 'CreationClassName indicates the name of the CIM class or the subclass used in
-- the creation of an instance. When used with the other key properties of this
-- class, this property allows all instances of this class and its subclasses to
-- be uniquely identified.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.Description IS 
-- 'The description provides detailed information about the database environment.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.ElementName IS 
-- 'A user-friendly name for the database environment.  This property allows each
-- instance to define a user-friendly name that represents the database
-- environment for use in client applications.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.EnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.EnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.InstallDate IS 
-- 'A datetime value indicating when the database environment was first installed. 
-- If the database environment is deployed across multiple Oracle Homes, this
-- property contains the date time of the first installation.  A lack of a value
-- does not mean that the database environment has not been installed.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.Name IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database environment.  This is typically set to the hostname
-- of the system on which the database environment is installed.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.NameFormat IS 
-- 'The NameFormat property identifies how the System name was generated.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.OperationalStatus IS 
-- 'Indicates the current status of the database environment. A value of 10
-- indicates that the environment is down and a value of 2 indicates that the
-- environment is up.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.OtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database
-- environment. If the value of the EnabledState property is set to anything other
-- than 1, this property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.PrimaryOwnerContact IS 
-- 'A string that provides information on how the primary database owner can be
-- reached. For example, a phone number or email address.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.PrimaryOwnerName IS 
-- 'The name of the person who installed the database software.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.RequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState. This property is provided to compare the last requested and
-- current enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.Roles IS 
-- 'An array of strings that specify the administrator-defined roles this Database
-- plays in the managed environment.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseSystem.StatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- Rem
-- Rem View definition for Oracle_AssociatedDBSystem
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_AssociatedDBSystem
--    (DBSystemCreationClassName, DBSystemName, DBSystemNameFormat,
--     DBSystemElementName, DBSystemPrimaryOwnerName,
--     DBSystemPrimaryOwnerContact, DBSystemEnabledState,
--     DBSystemOtherEnabledState, DBSystemRequestedState,
--     DBSystemEnabledDefault, DBSystemInstallDate,
--     DBSystemOperationalStatus, DBSystemStatusDescriptions, DBSystemCaption,
--     DBSystemDescription, DBSystemRoles,
--     DBInstanceID, DBName, DBElementName, DBDatabaseVersion,
--     DBSizeAllocated, DBSizeUnits, DBEnabledState, DBOtherEnabledState,
--     DBRequestedState, DBEnabledDefault, DBOperationalStatus,
--     DBStatusDescriptions, DBLastBackup, DBInstallDate, DBCaption,
--     DBDescription)
--  AS
--    SELECT DISTINCT 'Oracle_DatabaseSystem',
--                inst.host_name as DBSystemName,
--                'hostname',
--                inst.instance_name as DBSystemElementName,
--                'Unavailable',
--                'Unavailable', 5, NULL, 5, 5,
--                'Unavailable',
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as DBSystemOperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as DBSystemStatusDescriptions,
--                inst.description as DBSystemCaption,
--                inst.description as DBSystemDescription,
--                'Unavailable',
--                t.target_guid as DBInstanceID,
--                t.target_name as DBName,
--                t.display_name as DBElementName,
--                prop.version as DBDatabaseVersion,
--                sz.database_size as DBSizeAllocated, 3,
--   DECODE(avail.current_status, 0, 3,
--           1, 2,
--           2, 1,
--           3, 1,
--           4, 1,
--           5, 1,
--           6, 0) as DBEnabledState,
--   DECODE(avail.current_status, 0, NULL,
--           1, NULL,
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, NULL) as DBOtherEnabledState,
--                5, 2,
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as DBOperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as DBStatusDescriptions,
--                bk.end_time as DBLastBackup,
--                'Unavailable',
--                inst.description as DBCaption,
--                inst.description as DBDescription
--    FROM MGMT_TARGETS t,
--         MGMT_HA_BACKUP bk,
--        (SELECT DISTINCT targ.target_guid,
--                         p.property_value as version
--         FROM MGMT_TARGETS targ,
--              MGMT_TARGET_PROPERTIES p
--         WHERE p.target_guid=targ.target_guid AND
--               p.property_name='DBVersion' AND
--               (targ.target_type='oracle_database' OR
--                targ.target_type='rac_database')) prop,
--         (SELECT i.instance_name,
--                  i.host_name,
--                 g.target_guid,
--                 i.banner as description
--          FROM MGMT_DB_DBNINSTANCEINFO_ECM i,
--               MGMT_TARGETS g,
--               MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst,
--    (SELECT DISTINCT targ.target_guid,
--                         m.current_status,
--                         m.start_collection_timestamp,
--                         nvl(s.load_timestamp,m.start_collection_timestamp)
--                         load_timestamp
--     FROM MGMT_CURRENT_AVAILABILITY m,
--              MGMT_SEVERITY s,
--          MGMT_TARGETS targ
--     WHERE m.target_guid=targ.target_guid AND
--               m.target_guid=s.target_guid(+) AND
--               m.severity_guid=s.severity_guid(+) AND
--               (targ.target_type='oracle_database' OR
--               targ.target_type='rac_database')) avail,
--         (SELECT (nvl(tb.tbsp_size,0)+
--                  nvl(re.redo_size,0)+
--                  nvl(ct.ctl_size,0))database_size,
--                   tb.target_guid
--          FROM (SELECT sum(tablespace_used_size/1024/1024) as tbsp_size,
--                       t.target_guid as target_guid
--               FROM MGMT_DB_TABLESPACES_ECM tbsp,
--                    MGMT_ECM_GEN_SNAPSHOT s,
--                    MGMT_TARGETS t
--               WHERE tbsp.ecm_snapshot_id = s.snapshot_guid AND
--                        s.target_guid = t.target_guid AND
--                     s.is_current = 'Y' group by t.target_guid)tb,
--               (SELECT sum(logsize/1024/1024) as redo_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_REDOLOGS_ECM redo,
--                     MGMT_ECM_GEN_SNAPSHOT s,
--                     MGMT_TARGETS t
--                WHERE redo.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)re,
--               (SELECT sum(cf_size) as ctl_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_CONTROLFILES_SIZE_ECM ctl,
--                     MGMT_ECM_GEN_SNAPSHOT s, MGMT_TARGETS t
--                WHERE ctl.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)ct
--          WHERE tb.target_guid = re.target_guid (+) AND
--                  re.target_guid = ct.target_guid (+))sz
--    WHERE t.target_guid=avail.target_guid AND
--          t.target_guid=inst.target_guid AND
--          t.target_guid=sz.target_guid AND
--          t.target_guid=prop.target_guid AND
--          t.target_guid=bk.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_AssociatedDBSystem IS 
-- 'The AssociatedDBSystem association identifies the database system that was used
-- to create the database.This association links an Oracle Database with
-- thedatabase system elements that are related.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemCaption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database environment.  This property would typically be used from a
-- management client to provide a little more descriptive content for the
-- ElementName.  The caption should be constructed using the following format:
-- Database environment xxx, where xxx is the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemCreationClassName IS 
-- 'CreationClassName indicates the name of the CIM class or the subclass used in
-- the creation of an instance. When used with the other key properties of this
-- class, this property allows all instances of this class and its subclasses to
-- be uniquely identified.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemDescription IS 
-- 'The description provides detailed information about the database environment.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemElementName IS 
-- 'A user-friendly name for the database environment.  This property allows each
-- instance to define a user-friendly name that represents the database
-- environment for use in client applications.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemEnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemEnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemInstallDate IS 
-- 'A datetime value indicating when the database environment was first installed. 
-- If the database environment is deployed across multiple Oracle Homes, this
-- property contains the date time of the first installation.  A lack of a value
-- does not mean that the database environment has not been installed.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemName IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database environment.  This is typically set to the hostname
-- of the system on which the database environment is installed.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemNameFormat IS 
-- 'The NameFormat property identifies how the System name was generated.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemOperationalStatus IS 
-- 'Indicates the current status of the database environment. A value of 10
-- indicates that the environment is down and a value of 2 indicates that the
-- environment is up.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemOtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database
-- environment. If the value of the EnabledState property is set to anything other
-- than 1, this property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemPrimaryOwnerContact IS 
-- 'A string that provides information on how the primary database owner can be
-- reached. For example, a phone number or email address.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemPrimaryOwnerName IS 
-- 'The name of the person who installed the database software.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemRequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState. This property is provided to compare the last requested and
-- current enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemRoles IS 
-- 'An array of strings that specify the administrator-defined roles this Database
-- plays in the managed environment.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSystemStatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBCaption IS 
-- 'The caption contains a short textual description  of the database.  This
-- property would typically be used from a management client to provide a little
-- more descriptive content for the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBDatabaseVersion IS 
-- 'The version number for the Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBDescription IS 
-- 'The description provides detailed information about the database.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBElementName IS 
-- 'A user-friendly name for the database for use in client applications.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBEnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBEnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBInstallDate IS 
-- 'A datetime value indicating when the database was created.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBInstanceID IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBLastBackup IS 
-- 'The date and time when the latest complete or partial backup of the database
-- was performed.  If the database has never been backed up, then this property
-- has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBOperationalStatus IS 
-- 'Indicates the current status of the database . A value of 10 indicates that the
-- database is down and a value of 2 indicates that the database is up.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBOtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database.
-- If the value of the EnabledState property is set to anything other than 1, this
-- property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBRequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState, which is used to compare the last requested and current
-- enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSizeAllocated IS 
-- 'The estimated amount of disk space in megabytes that has been reserved for
-- database use.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBSizeUnits IS 
-- 'The units for the SizeAllocated property. Mapping is 1 - Bytes, 2 - Kilobytes,
-- 3 - Megabytes, 4 - Gigabytes and 5 - Terabytes.';
-- 
-- COMMENT ON COLUMN Oracle_AssociatedDBSystem.DBStatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- Rem
-- Rem View definition for Oracle_InstanceAvailableToDB
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_InstanceAvailableToDB
--    (DBInstanceID, DBName, DBElementName, DBDatabaseVersion,
--     DBSizeAllocated, DBSizeUnits, DBEnabledState, DBOtherEnabledState,
--     DBRequestedState, DBEnabledDefault, DBOperationalStatus,
--     DBStatusDescriptions, DBLastBackup, DBInstallDate, DBCaption,
--     DBDescription, InstCreationClassName, InstSystemCreationClassName,
--     InstSystemName, InstName, InstElementName, InstPrimaryOwnerName,
--     InstPrimaryOwnerContact, InstStarted, InstEnabledState,
--     InstOtherEnabledState, InstRequestedState, InstEnabledDefault,
--     InstInstallDate, InstOperationalStatus, InstStatusDescriptions,
--     InstCaption, InstDescription, InstStartupTime,
--     InstLastStatusChangeTime, InstConnectionLimit)
--  AS
--    SELECT DISTINCT t.target_guid as DBInstanceID,
--                t.target_name as DBName,
--                t.display_name as DBElementName,
--                prop.version as DBDatabaseVersion,
--                sz.database_size as DBSizeAllocated, 3,
--   DECODE(avail.current_status, 0, 3,
--           1, 2,
--           2, 1,
--           3, 1,
--           4, 1,
--           5, 1,
--           6, 0) as DBEnabledState,
--   DECODE(avail.current_status, 0, NULL,
--           1, NULL,
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, NULL) as DBOtherEnabledState,
--                5, 2,
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as DBOperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as DBStatusDescriptions,
--                bk.end_time as DBLastBackup,
--                'Unavailable',
--                inst.description as DBCaption,
--                inst.description as DBDescription,
--                'Oracle_DatabaseInstance',
--                'Oracle_ComputerSystem',
--                inst.host_name as InstSystemName,
--                t.display_name as InstName,
--                inst.instance_name as InstElementName,
--                'Unavailable',
--                'Unavailable',
--    DECODE(avail.current_status, 0, 'FALSE',
--           1, 'TRUE',
--           2, 'FALSE',
--           3, 'FALSE',
--           4, 'FALSE',
--           5, 'FALSE',
--           6, 'FALSE'
--           ) as InstStarted,
--   DECODE(avail.current_status, 0, 3,
--           1, 2,
--           2, 1,
--           3, 1,
--           4, 1,
--           5, 1,
--           6, 0) as InstEnabledState,
--   DECODE(avail.current_status, 0, NULL,
--           1, NULL,
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, NULL) as InstOtherEnabledState,
--    5, 2, 'Unavailable',
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as InstOperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as InstStatusDescriptions,
--                inst.description as InstCaption,
--                inst.description as InstDescription,
--                prop1.StartTime as InstStartupTime,
--                avail.load_timestamp as InstLastStatusChangeTime,
--                lic.connection_limit as InstConnectionLimit
--    FROM MGMT_TARGETS t,
--         MGMT_HA_BACKUP bk,
--        (SELECT DISTINCT targ.target_guid,
--                         p.property_value as version
--         FROM MGMT_TARGETS targ,
--              MGMT_TARGET_PROPERTIES p
--         WHERE p.target_guid=targ.target_guid AND
--               p.property_name='DBVersion' AND
--               (targ.target_type='oracle_database' OR
--                targ.target_type='rac_database')) prop,
--        (SELECT DISTINCT targ.target_guid,
--                         p.property_value as StartTime
--         FROM MGMT_TARGETS targ,
--              MGMT_TARGET_PROPERTIES p
--         WHERE p.target_guid=targ.target_guid AND
--               p.property_name='StartTime' AND
--               (targ.target_type='oracle_database' OR
--                targ.target_type='rac_database')) prop1,
--         (SELECT g.target_guid,
--                 i.instance_name,
--                 i.host_name,
--                 i.banner as description
--          FROM
--                MGMT_DB_DBNINSTANCEINFO_ECM i,
--                MGMT_TARGETS g,
--                MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst,
--         (SELECT (nvl(tb.tbsp_size,0)+
--                  nvl(re.redo_size,0)+
--                  nvl(ct.ctl_size,0))database_size,
--                   tb.target_guid
--          FROM (SELECT sum(tablespace_used_size/1024/1024) as tbsp_size,
--                       t.target_guid as target_guid
--               FROM MGMT_DB_TABLESPACES_ECM tbsp,
--                    MGMT_ECM_GEN_SNAPSHOT s,
--                    MGMT_TARGETS t
--               WHERE tbsp.ecm_snapshot_id = s.snapshot_guid AND
--                        s.target_guid = t.target_guid AND
--                     s.is_current = 'Y' group by t.target_guid)tb,
--               (SELECT sum(logsize/1024/1024) as redo_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_REDOLOGS_ECM redo,
--                     MGMT_ECM_GEN_SNAPSHOT s,
--                     MGMT_TARGETS t
--                WHERE redo.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)re,
--               (SELECT sum(cf_size) as ctl_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_CONTROLFILES_SIZE_ECM ctl,
--                     MGMT_ECM_GEN_SNAPSHOT s, MGMT_TARGETS t
--                WHERE ctl.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)ct
--          WHERE tb.target_guid = re.target_guid (+) AND
--                  re.target_guid = ct.target_guid (+))sz,
--    (SELECT DISTINCT targ.target_guid,
--                         m.current_status,
--                         m.start_collection_timestamp,
--                         nvl(s.load_timestamp,m.start_collection_timestamp)
--                         load_timestamp
--     FROM MGMT_CURRENT_AVAILABILITY m,
--              MGMT_SEVERITY s,
--          MGMT_TARGETS targ
--     WHERE m.target_guid=targ.target_guid AND
--               m.target_guid=s.target_guid(+) AND
--               m.severity_guid=s.severity_guid(+) AND
--               (targ.target_type='oracle_database' OR
--               targ.target_type='rac_database')) avail,
--         (SELECT i.sessions_max as connection_limit,
--                 g.target_guid
--          FROM MGMT_DB_LICENSE_ECM i,
--               MGMT_TARGETS g,
--               MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') lic
--    WHERE t.target_guid=avail.target_guid AND
--          t.target_guid=inst.target_guid AND
--          t.target_guid=sz.target_guid AND
--          t.target_guid=lic.target_guid AND
--          t.target_guid=prop.target_guid AND
--          t.target_guid=prop1.target_guid AND
--          t.target_guid=bk.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_InstanceAvailableToDB IS 
-- 'The InstanceAvailableToDB association relates an Oracle database and its
-- instances.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBCaption IS 
-- 'The caption contains a short textual description  of the database.  This
-- property would typically be used from a management client to provide a little
-- more descriptive content for the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBDatabaseVersion IS 
-- 'The version number for the Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBDescription IS 
-- 'The description provides detailed information about the database.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBElementName IS 
-- 'A user-friendly name for the database for use in client applications.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBEnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBEnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBInstallDate IS 
-- 'A datetime value indicating when the database was created.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBInstanceID IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBLastBackup IS 
-- 'The date and time when the latest complete or partial backup of the database
-- was performed.  If the database has never been backed up, then this property
-- has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBOperationalStatus IS 
-- 'Indicates the current status of the database . A value of 10 indicates that the
-- database is down and a value of 2 indicates that the database is up.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBOtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database.
-- If the value of the EnabledState property is set to anything other than 1, this
-- property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBRequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState, which is used to compare the last requested and current
-- enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBSizeAllocated IS 
-- 'The estimated amount of disk space in megabytes that has been reserved for
-- database use.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBSizeUnits IS 
-- 'The units for the SizeAllocated property. Mapping is 1 - Bytes, 2 - Kilobytes,
-- 3 - Megabytes, 4 - Gigabytes and 5 - Terabytes.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.DBStatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstCaption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database instance.  This property would typically be used from a management
-- client to provide a little more descriptive content for the ElementName.  The
-- caption should be constructed using the following format: Instance xxx, where
-- xxx is the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstConnectionLimit IS 
-- 'The maximum number of active inbound connections that can be concurrently
-- opened on the instance.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstCreationClassName IS 
-- 'CreationClassName indicates the name of the class or the subclass used in the
-- creation of an instance. When used with the other key properties of this class,
-- this property allows all instances of this class and its subclasses to be
-- uniquely identified.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstDescription IS 
-- 'The description provides detailed information about the database instance.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstElementName IS 
-- 'A user-friendly name for the database instance.  This property defines a
-- user-friendly name that represents the database instance for use in client
-- applications.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstEnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstEnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstInstallDate IS 
-- 'A datetime value indicating when the database was created.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstLastStatusChangeTime IS 
-- 'The date and time when the operational status of the database instance last
-- changed.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstName IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database instance.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstOperationalStatus IS 
-- 'This property contains the operational status of the database instance.  OK
-- means that the database instance is operational and available for general use. 
-- Stopped means that the instance is unavailable and cannot be used.  Service
-- implies an administrative state of unavailability.  Degraded means that the
-- database instance is operating at a less than optimal level.  Starting means
-- that the database instance is in the process of becoming operational.  These
-- status values map to the RFC1697 OperStatus values as follows: OK - UP, Stopped
-- - DOWN, In Service - HALTED, Stressed - CONGESTED, and Starting - RESTARTING. 
-- Any additional status variables that are defined are CIM specific.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstOtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database.
-- If the value of the EnabledState property is set to anything other than 1, this
-- property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstPrimaryOwnerContact IS 
-- 'A string that provides information on how the primary owner of the Service can
-- be reached. For example, a phone number or email address.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstPrimaryOwnerName IS 
-- 'The name of the primary owner for the service, if one is defined. The primary
-- owner is the initial support contact for the Service.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstRequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState. This property is provided to compare the last requested and
-- current enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstStarted IS 
-- 'Started is a boolean indicating whether the database has been started - TRUE,
-- or stopped - FALSE.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstStartupTime IS 
-- 'The date and time when the database instance was last started.  If the database
-- instance has an OperationalStatus of Stopped or Starting, then this value is
-- not meaningful.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstStatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstSystemCreationClassName IS 
-- 'The CreationClassName of the computer system that this database instance is
-- hosted on.';
-- 
-- COMMENT ON COLUMN Oracle_InstanceAvailableToDB.InstSystemName IS 
-- 'The scoping Host Name.';
-- 
-- 
-- Rem
-- Rem View definition for Oracle_DBInstanceStatistics
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_DBInstanceStatistics
--    (InstanceID, ElementName, Caption, Description, SizeUsed,
--     PhysicalReadsPerSecond, PhysicalWritesPerSecond, PhysicalReadsPerTxn,
--     PhysicalWritesPerTxn, LogicalReadsPerSecond, LogicalReadsPerTxn,
--     HighwaterConnections, ActiveConnections, StartStatisticTime,
--     StatisticTime, SampleInterval, CompletedTxnPerSecond, CommitsPerSecond,
--     CommitsPerTxn, TableScansPerSecond, TableScansPerTxn,
--     RecursiveCallsPerSecond, RecursiveCallsPerTxn, UserCallsPerSecond,
--     UserCallsPerTxn, InstanceCPUPercentage)
--  AS
--    SELECT inst.instance_name as InstanceID,
--                inst.instance_name as ElementName,
--                inst.banner as Caption,
--                inst.banner as Description,
--                sz.database_size as SizeUsed,
--                phys.physreads_ps as PhysicalReadsPerSecond,
--                phys1.physwrites_ps as PhysicalWritesPerSecond,
--                phys2.physreads_pt as PhysicalReadsPerTxn,
--                phys3.physwrites_pt as PhysicalWritesPerTxn,
--                log.logreads_ps as LogicalReadsPerSecond,
--                log1.logreads_pt as LogicalReadsPerTxn,
--                lic.sessions_highwater as HighwaterConnections,
--                lic.sessions_current as ActiveConnections,
--                'Unavailable', inst.start_timestamp as StatisticTime,
--                'Unavailable', txn.transactions_ps as CompletedTxnPerSecond,
--                commit.commits_ps as CommitsPerSecond,
--                commit1.commits_pt as CommitsPerTxn,
--                tab.tabscans_ps as TableScansPerSecond,
--                tab1.tabscans_pt as TableScansPerTxn,
--                rec.recurscalls_ps as RecursiveCallsPerSecond,
--                rec1.recurscalls_pt as RecursiveCallsPerTxn,
--                usr.usercalls_ps as UserCallsPerSecond,
--                usr1.usercalls_pt as UserCallsPerTxn,
--                waitbottleneck.user_cpu_time_cnt as InstanceCPUPercentage
--    FROM MGMT_TARGETS t,
--         (SELECT DISTINCT g.target_guid,
--                 i.instance_name,
--                 i.banner,
--                 s.start_timestamp
--          FROM
--                MGMT_DB_DBNINSTANCEINFO_ECM i,
--                MGMT_TARGETS g,
--                MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst,
--         (SELECT (nvl(tb.tbsp_size,0)+
--                  nvl(re.redo_size,0)+
--                  nvl(ct.ctl_size,0))database_size,
--                   tb.target_guid
--          FROM (SELECT sum(tablespace_used_size/1024/1024) as tbsp_size,
--                       t.target_guid as target_guid
--               FROM MGMT_DB_TABLESPACES_ECM tbsp,
--                    MGMT_ECM_GEN_SNAPSHOT s,
--                    MGMT_TARGETS t
--               WHERE tbsp.ecm_snapshot_id = s.snapshot_guid AND
--                        s.target_guid = t.target_guid AND
--                     s.is_current = 'Y' group by t.target_guid)tb,
--               (SELECT sum(logsize/1024/1024) as redo_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_REDOLOGS_ECM redo,
--                     MGMT_ECM_GEN_SNAPSHOT s,
--                     MGMT_TARGETS t
--                WHERE redo.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)re,
--               (SELECT sum(cf_size) as ctl_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_CONTROLFILES_SIZE_ECM ctl,
--                     MGMT_ECM_GEN_SNAPSHOT s, MGMT_TARGETS t
--                WHERE ctl.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)ct
--          WHERE tb.target_guid = re.target_guid (+) AND
--                  re.target_guid = ct.target_guid (+))sz,
--        (SELECT DISTINCT i.sessions_highwater,
--                i.sessions_current,
--                 g.target_guid
--          FROM MGMT_DB_LICENSE_ECM i,
--               MGMT_TARGETS g,
--               MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') lic,
--        (SELECT DISTINCT nvl(m.value, -1) as physreads_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='physreads_ps')phys,
--        (SELECT DISTINCT nvl(m.value, -1) as physwrites_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='physwrites_ps')phys1,
--        (SELECT DISTINCT nvl(m.value, -1) as physreads_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='physreads_pt')phys2,
--        (SELECT DISTINCT nvl(m.value, -1) as physwrites_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='physwrites_pt')phys3,
--        (SELECT DISTINCT nvl(m.value, -1) as logreads_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='logreads_ps')log,
--        (SELECT DISTINCT nvl(m.value, -1) as logreads_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='logreads_pt')log1,
--        (SELECT DISTINCT nvl(m.value, -1) as transactions_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='transactions_ps')txn,
--        (SELECT DISTINCT nvl(m.value, -1) as commits_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='commits_ps')commit,
--        (SELECT DISTINCT nvl(m.value, -1) as commits_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='commits_pt')commit1,
--        (SELECT DISTINCT nvl(m.value, -1) as tabscans_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='tabscanstotal_ps')tab,
--        (SELECT DISTINCT nvl(m.value, -1) as tabscans_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='tabscanstotal_pt')tab1,
--        (SELECT DISTINCT nvl(m.value, -1) as recurscalls_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='recurscalls_ps')rec,
--        (SELECT DISTINCT nvl(m.value, -1) as recurscalls_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='recurscalls_pt')rec1,
--        (SELECT DISTINCT nvl(m.value, -1) as usercalls_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='usercalls_ps')usr,
--        (SELECT DISTINCT nvl(m.value, -1) as usercalls_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='usercalls_pt')usr1,
--        (SELECT DISTINCT nvl(m.value*100, -1) as user_cpu_time_cnt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='wait_bottlenecks' AND
--                m1.metric_column='user_cpu_time_cnt')waitbottleneck
--    WHERE t.target_guid=inst.target_guid AND
--          t.target_guid=sz.target_guid AND
--          t.target_guid=lic.target_guid AND
--          t.target_guid=phys.target_guid AND
--          t.target_guid=phys1.target_guid AND
--          t.target_guid=phys2.target_guid AND
--          t.target_guid=phys3.target_guid AND
--          t.target_guid=log.target_guid AND
--          t.target_guid=log1.target_guid AND
--          t.target_guid=txn.target_guid AND
--          t.target_guid=commit.target_guid AND
--          t.target_guid=commit1.target_guid AND
--          t.target_guid=tab.target_guid AND
--          t.target_guid=tab1.target_guid AND
--          t.target_guid=rec.target_guid AND
--          t.target_guid=rec1.target_guid AND
--          t.target_guid=usr.target_guid AND
--          t.target_guid=usr1.target_guid AND
--          t.target_guid=waitbottleneck.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_DBInstanceStatistics IS 
-- 'Oracle_DBInstanceStatistics contains statistics for a database instance.  These
-- are retrieved from the Oracle Managment Repository that is managing the
-- database upon request from a managment client.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.ActiveConnections IS 
-- 'The number of active inbound connections that are currently using the service.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.Caption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database instance.  This property would typically be used from a management
-- client to provide a little more descriptive content for the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.CommitsPerSecond IS 
-- 'The number of commit operations per second.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.CommitsPerTxn IS 
-- 'The average number of commit operations per transaction.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.CompletedTxnPerSecond IS 
-- 'The number of transactions per second that have been completed by a commit or
-- abort. Some database operations, such as read-only queries, may not create a
-- transaction.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.Description IS 
-- 'The description provides additional information about the database instance
-- statistics information.  For example, in addition to the ElementName contents,
-- the description might also include the date/time when the statistics were
-- collected or the name of the management agent that was used to collect the
-- data.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.ElementName IS 
-- 'A user-friendly name for the set of database instance statistics.  This
-- property defines a user-friendly name that provides the context between the
-- database instance and the associated statistics.  It should be constructed
-- using the following format :Current Statistics for Instance xxx where xxx is
-- the ElementName of the associated database instance.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.HighwaterConnections IS 
-- 'The maximum number of active inbound connections that have been concurrently
-- using the instance since it was started.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.InstanceCPUPercentage IS 
-- 'CPU utilization percentage of the Database Instance.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.InstanceID IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database instance statistic.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.LogicalReadsPerSecond IS 
-- 'The number of logical database file reads per second that were issued by the
-- instance.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.LogicalReadsPerTxn IS 
-- 'The average number of logical database file reads per transaction that were
-- issued by the instance.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.PhysicalReadsPerSecond IS 
-- 'The number of database file reads per second that were issued by the instance.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.PhysicalReadsPerTxn IS 
-- 'The number of database file reads per transaction that were issued by the
-- instance.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.PhysicalWritesPerSecond IS 
-- 'The number of database file writes per second that were issued by the instance.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.PhysicalWritesPerTxn IS 
-- 'The average number of database file writes per transaction that were issued by
-- the instance.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.RecursiveCallsPerSecond IS 
-- 'The total number of recursive calls per second.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.RecursiveCallsPerTxn IS 
-- 'The number of recursive calls per transaction.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.SampleInterval IS 
-- 'Some statistics are sampled at consistent time intervals.  This property
-- provides the sample interval so that client applications can determine the
-- minimum time that new statistics should be pulled.  If the statistics are not
-- sampled at consistent time intervals, this property must be set to a zero time
-- interval.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.StartStatisticTime IS 
-- 'The time, relative to managed element where the statistic was collected, when
-- the first measurement was taken.  If the statistic is reset, the
-- StartStatisticTime is the time when the reset was performed.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.StatisticTime IS 
-- 'The time the most recent measurement was taken, relative to the managed element
-- where the statistic was collected.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.TableScansPerSecond IS 
-- 'The total number of table scan operations per second.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.TableScansPerTxn IS 
-- 'The total number of table scan operations per transaction.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.UserCallsPerSecond IS 
-- 'The total number of user calls per second.';
-- 
-- COMMENT ON COLUMN Oracle_DBInstanceStatistics.UserCallsPerTxn IS 
-- 'The number of user calls per transaction.';
-- 
-- Rem
-- Rem View definition for Oracle_DatabaseStatistics
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_DatabaseStatistics
--    (InstanceID, ElementName, Caption, Description, SizeUsed, StatisticTime,
--     StartStatisticTime, SampleInterval)
--  AS
--    SELECT DISTINCT t.target_guid as InstanceID,
--                inst.instance_name as ElementName,
--                inst.banner as Caption,
--                inst.banner as Description,
--                sz.database_size as SizeUsed,
--                inst.start_timestamp as StatisticTime,
--                'Unavailable', 'Unavailable'
--    FROM MGMT_TARGETS t,
--         (SELECT g.target_guid,
--                 i.instance_name,
--                 i.banner,
--                 s.start_timestamp
--          FROM
--                MGMT_DB_DBNINSTANCEINFO_ECM i,
--                MGMT_TARGETS g,
--                MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst,
--         (SELECT (nvl(tb.tbsp_size,0)+
--                  nvl(re.redo_size,0)+
--                  nvl(ct.ctl_size,0))database_size,
--                   tb.target_guid
--          FROM (SELECT sum(tablespace_used_size/1024/1024) as tbsp_size,
--                       t.target_guid as target_guid
--               FROM MGMT_DB_TABLESPACES_ECM tbsp,
--                    MGMT_ECM_GEN_SNAPSHOT s,
--                    MGMT_TARGETS t
--               WHERE tbsp.ecm_snapshot_id = s.snapshot_guid AND
--                        s.target_guid = t.target_guid AND
--                     s.is_current = 'Y' group by t.target_guid)tb,
--               (SELECT sum(logsize/1024/1024) as redo_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_REDOLOGS_ECM redo,
--                     MGMT_ECM_GEN_SNAPSHOT s,
--                     MGMT_TARGETS t
--                WHERE redo.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)re,
--               (SELECT sum(cf_size) as ctl_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_CONTROLFILES_SIZE_ECM ctl,
--                     MGMT_ECM_GEN_SNAPSHOT s, MGMT_TARGETS t
--                WHERE ctl.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)ct
--          WHERE tb.target_guid = re.target_guid (+) AND
--                  re.target_guid = ct.target_guid (+))sz
--    WHERE t.target_guid=inst.target_guid AND
--          t.target_guid=sz.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_DatabaseStatistics IS 
-- 'Oracle_DatabaseStatistics provides current information about the statistics for
-- a database.  Database statistics pertain to the database and have the same
-- value regardless of the database instance that is used.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_DatabaseStatistics.Caption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database.  This property would typically be used from a management client
-- to provide a little more descriptive content for the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseStatistics.Description IS 
-- 'The description provides detailed information about the database environment.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseStatistics.ElementName IS 
-- 'The user friendly name for this database. In addition, the user friendly name
-- can be used as a index property for a search of query.  Note:  Name does not
-- have to be unique within a namespace.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseStatistics.InstanceID IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseStatistics.SampleInterval IS 
-- 'Some statistics are sampled at consistent time intervals.  This property
-- provides the sample interval so that client applications can determine the
-- minimum time that new statistics should be pulled.  If the statistics are not
-- sampled at consistent time intervals, this property must be set to a zero time
-- interval.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseStatistics.SizeUsed IS 
-- 'The estimated amount of disk space in units that is currently used by the
-- database.  The units is determined through the SizeUnits property in
-- Oracle_Database.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseStatistics.StartStatisticTime IS 
-- 'The time, relative to managed element where the statistic was collected, when
-- the first measurement was taken.  If the statistic is reset, the
-- StartStatisticTime is the time when the reset was performed.';
-- 
-- COMMENT ON COLUMN Oracle_DatabaseStatistics.StatisticTime IS 
-- 'The time the most recent measurement was taken, relative to the managed element
-- where the statistic was collected.';
-- 
-- Rem
-- Rem View definition for Oracle_CurrentDBInstanceStats
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_CurrentDBInstanceStats
--    (InstCreationClassName, InstSystemCreationClassName, InstSystemName,
--     InstName, InstElementName, InstPrimaryOwnerName,
--     InstPrimaryOwnerContact, InstStarted,
--     InstEnabledState, InstOtherEnabledState, InstRequestedState,
--     InstEnabledDefault, InstInstallDate, InstOperationalStatus,
--     InstStatusDescriptions, InstCaption,
--     InstDescription, InstStartupTime, InstLastStatusChangeTime,
--     InstConnectionLimit, StatsInstanceID, StatsElementName, StatsCaption,
--     StatsDescription, StatsSizeUsed, StatsPhysicalReadsPerSecond,
--     StatsPhysicalWritesPerSecond, StatsPhysicalReadsPerTxn,
--     StatsPhysicalWritesPerTxn, StatsLogicalReadsPerSecond,
--     StatsLogicalReadsPerTxn, StatsHighwaterConnections,
--     StatsActiveConnections,  StatsStartStatisticTime, StatsStatisticTime,
--     StatsSampleInterval, StatsCompletedTxnPerSecond, StatsCommitsPerSecond,
--     StatsCommitsPerTxn, StatsTableScansPerSecond, StatsTableScansPerTxn,
--     StatsRecursiveCallsPerSecond, StatsRecursiveCallsPerTxn,
--     StatsUserCallsPerSecond, StatsUserCallsPerTxn,
--     StatsInstanceCPUPercentage)
-- AS
--   SELECT 'Oracle_DatabaseInstance',
--       'Oracle_ComputerSystem',
--       inst.host_name as InstSystemName,
--       t.display_name as InstName,
--       inst.instance_name as InstElementName,
--       'Unavailable',
--       'Unavailable',
--    DECODE(avail.current_status, 0, 'FALSE',
--           1, 'TRUE',
--           2, 'FALSE',
--           3, 'FALSE',
--           4, 'FALSE',
--           5, 'FALSE',
--           6, 'FALSE'
--           ) as InstStarted,
--   DECODE(avail.current_status, 0, 3,
--           1, 2,
--           2, 1,
--           3, 1,
--           4, 1,
--           5, 1,
--           6, 0) as InstEnabledState,
--   DECODE(avail.current_status, 0, NULL,
--           1, NULL,
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, NULL) as InstOtherEnabledState,
--    5, 2, 'Unavailable',
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as InstOperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as InstStatusDescriptions,
--       inst.banner as InstCaption,
--       inst.banner as InstDescription,
--       prop.StartTime as InstStartupTime,
--       avail.load_timestamp as InstLastStatusChangeTime,
--       lic.connection_limit as InstConnectionLimit,
--       inst.instance_name as StatsInstanceID,
--                inst.instance_name as StatsElementName,
--                inst.banner as StatsCaption,
--                inst.banner as StatsDescription,
--                sz.database_size as StatsSizeUsed,
--                phys.physreads_ps as StatsPhysicalReadsPerSecond,
--                phys1.physwrites_ps as StatsPhysicalWritesPerSecond,
--                phys2.physreads_pt as StatsPhysicalReadsPerTxn,
--                phys3.physwrites_pt as StatsPhysicalWritesPerTxn,
--                log.logreads_ps as StatsLogicalReadsPerSecond,
--                log1.logreads_pt as StatsLogicalReadsPerTxn,
--                lic.sessions_highwater as StatsHighwaterConnections,
--                lic.sessions_current as StatsActiveConnections,
--                'Unavailable', inst.start_timestamp as StatsStatisticTime,
--                'Unavailable',
--                txn.transactions_ps as StatsCompletedTxnPerSecond,
--                commit.commits_ps as StatsCommitsPerSecond,
--                commit1.commits_pt as StatsCommitsPerTxn,
--                tab.tabscans_ps as StatsTableScansPerSecond,
--                tab1.tabscans_pt as StatsTableScansPerTxn,
--                rec.recurscalls_ps as StatsRecursiveCallsPerSecond,
--                rec1.recurscalls_pt as StatsRecursiveCallsPerTxn,
--                usr.usercalls_ps as StatsUserCallsPerSecond,
--                usr1.usercalls_pt as StatsUserCallsPerTxn,
--                waitbottleneck.user_cpu_time_cnt as StatsInstanceCPUPercentage
--   FROM MGMT_TARGETS t,
--         (SELECT DISTINCT g.target_guid,
--                 i.instance_name,
--                 i.banner,
--                 i.host_name,
--                 s.start_timestamp
--          FROM
--                MGMT_DB_DBNINSTANCEINFO_ECM i,
--                MGMT_TARGETS g,
--                MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst,
--    (SELECT DISTINCT targ.target_guid,
--                         m.current_status,
--                         m.start_collection_timestamp,
--                         nvl(s.load_timestamp,m.start_collection_timestamp)
--                         load_timestamp
--     FROM MGMT_CURRENT_AVAILABILITY m,
--              MGMT_SEVERITY s,
--          MGMT_TARGETS targ
--     WHERE m.target_guid=targ.target_guid AND
--               m.severity_guid=s.severity_guid(+) AND
--               m.target_guid=s.target_guid(+) AND
--               targ.target_type='oracle_database') avail,
--        (SELECT DISTINCT targ.target_guid,
--                         p.property_value as StartTime
--         FROM MGMT_TARGETS targ,
--              MGMT_TARGET_PROPERTIES p
--         WHERE p.target_guid=targ.target_guid AND
--               p.property_name='StartTime' AND
--               targ.target_type='oracle_database') prop,
--         (SELECT (nvl(tb.tbsp_size,0)+
--                  nvl(re.redo_size,0)+
--                  nvl(ct.ctl_size,0))database_size,
--                   tb.target_guid
--          FROM (SELECT sum(tablespace_used_size/1024/1024) as tbsp_size,
--                       t.target_guid as target_guid
--               FROM MGMT_DB_TABLESPACES_ECM tbsp,
--                    MGMT_ECM_GEN_SNAPSHOT s,
--                    MGMT_TARGETS t
--               WHERE tbsp.ecm_snapshot_id = s.snapshot_guid AND
--                        s.target_guid = t.target_guid AND
--                     s.is_current = 'Y' group by t.target_guid)tb,
--               (SELECT sum(logsize/1024/1024) as redo_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_REDOLOGS_ECM redo,
--                     MGMT_ECM_GEN_SNAPSHOT s,
--                     MGMT_TARGETS t
--                WHERE redo.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)re,
--               (SELECT sum(cf_size) as ctl_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_CONTROLFILES_SIZE_ECM ctl,
--                     MGMT_ECM_GEN_SNAPSHOT s, MGMT_TARGETS t
--                WHERE ctl.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)ct
--          WHERE tb.target_guid = re.target_guid (+) AND
--                  re.target_guid = ct.target_guid (+))sz,
--        (SELECT DISTINCT i.sessions_highwater,
--                i.sessions_current,
--                i.sessions_max as connection_limit,
--                g.target_guid
--          FROM MGMT_DB_LICENSE_ECM i,
--               MGMT_TARGETS g,
--               MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') lic,
--        (SELECT DISTINCT nvl(m.value, -1) as physreads_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='physreads_ps')phys,
--        (SELECT DISTINCT nvl(m.value, -1) as physwrites_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='physwrites_ps')phys1,
--        (SELECT DISTINCT nvl(m.value, -1) as physreads_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='physreads_pt')phys2,
--        (SELECT DISTINCT nvl(m.value, -1) as physwrites_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='physwrites_pt')phys3,
--        (SELECT DISTINCT nvl(m.value, -1) as logreads_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='logreads_ps')log,
--        (SELECT DISTINCT nvl(m.value, -1) as logreads_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='logreads_pt')log1,
--        (SELECT DISTINCT nvl(m.value, -1) as transactions_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='transactions_ps')txn,
--        (SELECT DISTINCT nvl(m.value, -1) as commits_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='commits_ps')commit,
--        (SELECT DISTINCT nvl(m.value, -1) as commits_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='commits_pt')commit1,
--        (SELECT DISTINCT nvl(m.value, -1) as tabscans_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='tabscanstotal_ps')tab,
--        (SELECT DISTINCT nvl(m.value, -1) as tabscans_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='tabscanstotal_ps')tab1,
--        (SELECT DISTINCT nvl(m.value, -1) as recurscalls_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='recurscalls_ps')rec,
--        (SELECT DISTINCT nvl(m.value, -1) as recurscalls_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='recurscalls_pt')rec1,
--        (SELECT DISTINCT nvl(m.value, -1) as usercalls_ps,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='usercalls_ps')usr,
--        (SELECT DISTINCT nvl(m.value, -1) as usercalls_pt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='instance_throughput' AND
--                m1.metric_column='usercalls_pt')usr1,
--        (SELECT DISTINCT nvl(m.value*100, -1) as user_cpu_time_cnt,
--                         targ.target_guid
--          FROM MGMT_CURRENT_METRICS m,
--               MGMT_METRICS m1,
--               MGMT_TARGETS targ
--          WHERE m1.metric_guid=m.metric_guid (+) AND
--                targ.target_guid=m.target_guid AND
--                m1.metric_name='wait_bottlenecks' AND
--                m1.metric_column='user_cpu_time_cnt')waitbottleneck
--   WHERE t.target_guid=inst.target_guid AND
--          t.target_guid=sz.target_guid AND
--          t.target_guid=avail.target_guid AND
--          t.target_guid=prop.target_guid AND
--          t.target_guid=lic.target_guid AND
--          t.target_guid=phys.target_guid AND
--          t.target_guid=phys1.target_guid AND
--          t.target_guid=phys2.target_guid AND
--          t.target_guid=phys3.target_guid AND
--          t.target_guid=log.target_guid AND
--          t.target_guid=log1.target_guid AND
--          t.target_guid=txn.target_guid AND
--          t.target_guid=commit.target_guid AND
--          t.target_guid=commit1.target_guid AND
--          t.target_guid=tab.target_guid AND
--          t.target_guid=tab1.target_guid AND
--          t.target_guid=rec.target_guid AND
--          t.target_guid=rec1.target_guid AND
--          t.target_guid=usr.target_guid AND
--          t.target_guid=usr1.target_guid AND
--          t.target_guid=waitbottleneck.target_guid
--   WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_CurrentDBInstanceStats IS 
-- 'Oracle_CurrentDBInstanceStats is an association that relates a Oracle database
-- instance to its current statistical information.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstCaption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database instance.  This property would typically be used from a management
-- client to provide a little more descriptive content for the ElementName.  The
-- caption should be constructed using the following format: Instance xxx, where
-- xxx is the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstConnectionLimit IS 
-- 'The maximum number of active inbound connections that can be concurrently
-- opened on the instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstCreationClassName IS 
-- 'CreationClassName indicates the name of the class or the subclass used in the
-- creation of an instance. When used with the other key properties of this class,
-- this property allows all instances of this class and its subclasses to be
-- uniquely identified.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstDescription IS 
-- 'The description provides detailed information about the database instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstElementName IS 
-- 'A user-friendly name for the database instance.  This property defines a
-- user-friendly name that represents the database instance for use in client
-- applications.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstEnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstEnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstInstallDate IS 
-- 'A datetime value indicating when the database was created.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstLastStatusChangeTime IS 
-- 'The date and time when the operational status of the database instance last
-- changed.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstName IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstOperationalStatus IS 
-- 'This property contains the operational status of the database instance.  OK
-- means that the database instance is operational and available for general use. 
-- Stopped means that the instance is unavailable and cannot be used.  Service
-- implies an administrative state of unavailability.  Degraded means that the
-- database instance is operating at a less than optimal level.  Starting means
-- that the database instance is in the process of becoming operational.  These
-- status values map to the RFC1697 OperStatus values as follows: OK - UP, Stopped
-- - DOWN, In Service - HALTED, Stressed - CONGESTED, and Starting - RESTARTING. 
-- Any additional status variables that are defined are CIM specific.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstOtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database.
-- If the value of the EnabledState property is set to anything other than 1, this
-- property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstPrimaryOwnerContact IS 
-- 'A string that provides information on how the primary owner of the Service can
-- be reached. For example, a phone number or email address.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstPrimaryOwnerName IS 
-- 'The name of the primary owner for the service, if one is defined. The primary
-- owner is the initial support contact for the Service.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstRequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState. This property is provided to compare the last requested and
-- current enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstStarted IS 
-- 'Started is a boolean indicating whether the database has been started - TRUE,
-- or stopped - FALSE.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstStartupTime IS 
-- 'The date and time when the database instance was last started.  If the database
-- instance has an OperationalStatus of Stopped or Starting, then this value is
-- not meaningful.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstStatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstSystemCreationClassName IS 
-- 'The CreationClassName of the computer system that this database instance is
-- hosted on.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.InstSystemName IS 
-- 'The scoping Host Name.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsActiveConnections IS 
-- 'The number of active inbound connections that are currently using the service.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsCaption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database instance.  This property would typically be used from a management
-- client to provide a little more descriptive content for the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsCommitsPerSecond IS 
-- 'The number of commit operations per second.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsCommitsPerTxn IS 
-- 'The average number of commit operations per transaction.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsCompletedTxnPerSecond IS 
-- 'The number of transactions per second that have been completed by a commit or
-- abort. Some database operations, such as read-only queries, may not create a
-- transaction.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsDescription IS 
-- 'The description provides additional information about the database instance
-- statistics information.  For example, in addition to the ElementName contents,
-- the description might also include the date/time when the statistics were
-- collected or the name of the management agent that was used to collect the
-- data.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsElementName IS 
-- 'A user-friendly name for the set of database instance statistics.  This
-- property defines a user-friendly name that provides the context between the
-- database instance and the associated statistics.  It should be constructed
-- using the following format :Current Statistics for Instance xxx where xxx is
-- the ElementName of the associated database instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsHighwaterConnections IS 
-- 'The maximum number of active inbound connections that have been concurrently
-- using the instance since it was started.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsInstanceCPUPercentage IS 
-- 'CPU utilization percentage of the Database Instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsInstanceID IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database instance statistic.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsLogicalReadsPerSecond IS 
-- 'The number of logical database file reads per second that were issued by the
-- instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsLogicalReadsPerTxn IS 
-- 'The average number of logical database file reads per transaction that were
-- issued by the instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsPhysicalReadsPerSecond IS 
-- 'The number of database file reads per second that were issued by the instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsPhysicalReadsPerTxn IS 
-- 'The number of database file reads per transaction that were issued by the
-- instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsPhysicalWritesPerSecond IS 
-- 'The number of database file writes per second that were issued by the instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsPhysicalWritesPerTxn IS 
-- 'The average number of database file writes per transaction that were issued by
-- the instance.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsRecursiveCallsPerSecond IS 
-- 'The total number of recursive calls per second.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsRecursiveCallsPerTxn IS 
-- 'The number of recursive calls per transaction.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsSampleInterval IS 
-- 'Some statistics are sampled at consistent time intervals.  This property
-- provides the sample interval so that client applications can determine the
-- minimum time that new statistics should be pulled.  If the statistics are not
-- sampled at consistent time intervals, this property must be set to a zero time
-- interval.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsStartStatisticTime IS 
-- 'The time, relative to managed element where the statistic was collected, when
-- the first measurement was taken.  If the statistic is reset, the
-- StartStatisticTime is the time when the reset was performed.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsStatisticTime IS 
-- 'The time the most recent measurement was taken, relative to the managed element
-- where the statistic was collected.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsTableScansPerSecond IS 
-- 'The total number of table scan operations per second.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsTableScansPerTxn IS 
-- 'The total number of table scan operations per transaction.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsUserCallsPerSecond IS 
-- 'The total number of user calls per second.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBInstanceStats.StatsUserCallsPerTxn IS 
-- 'The number of user calls per transaction.';
-- 
-- Rem
-- Rem View definition for Oracle_CurrentDBStatistics
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_CurrentDBStatistics
--    (DBInstanceID, DBName, DBElementName, DBDatabaseVersion,
--     DBSizeAllocated, DBSizeUnits, DBEnabledState, DBOtherEnabledState,
--     DBRequestedState, DBEnabledDefault, DBOperationalStatus,
--     DBStatusDescriptions, DBLastBackup, DBInstallDate, DBCaption,
--     DBDescription, DBStatsInstanceID, DBStatsElementName, DBStatsCaption,
--     DBStatsDescription, DBStatsSizeUsed, DBStatsStatisticTime,
--     DBStatsStartStatisticTime, DBStatsSampleInterval)
--  AS
--    SELECT DISTINCT t.target_guid as DBInstanceID,
--                t.target_name as DBName,
--                t.display_name as DBElementName,
--                prop.version as DBDatabaseVersion,
--                sz.database_size as DBSizeAllocated, 3,
--   DECODE(avail.current_status, 0, 3,
--           1, 2,
--           2, 1,
--           3, 1,
--           4, 1,
--           5, 1,
--           6, 0) as DBEnabledState,
--   DECODE(avail.current_status, 0, NULL,
--           1, NULL,
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, NULL) as DBOtherEnabledState,
--                5, 2,
--   DECODE(avail.current_status, 0, 10,
--           1, 2,
--           2, 6,
--           3, 16,
--           4, 12,
--           5, 7,
--           6, 0) as DBOperationalStatus,
--   DECODE(avail.current_status, 0, 'Database Target is DOWN',
--           1, 'Database Target is UP',
--           2, 'Database Target is in ERROR',
--           3, 'Management Agent is DOWN',
--           4, 'Database Target is UNREACHABLE',
--           5, 'Database Target is under a BLACKOUT',
--           6, 'Database Target status UNKNOWN')
--           as DBStatusDescriptions,
--                bk.end_time as DBLastBackup,
--                'Unavailable',
--                inst.banner as DBCaption,
--                inst.banner as DBDescription,
--                inst.instance_name as DBStatsInstanceID,
--                t.target_name as DBStatsElementName,
--                inst.banner as DBStatsCaption,
--                inst.banner as DBStatsDescription,
--                sz.database_size as DBStatsSizeUsed,
--                inst.start_timestamp as DBStatsStatisticTime,
--                'Unavailable', 'Unavailable'
--    FROM MGMT_TARGETS t,
--         MGMT_HA_BACKUP bk,
--        (SELECT DISTINCT targ.target_guid,
--                         p.property_value as version
--         FROM MGMT_TARGETS targ,
--              MGMT_TARGET_PROPERTIES p
--         WHERE p.target_guid=targ.target_guid AND
--               p.property_name='DBVersion' AND
--               (targ.target_type='oracle_database' OR
--                targ.target_type='rac_database')) prop,
--    (SELECT DISTINCT targ.target_guid,
--                         m.current_status,
--                         m.start_collection_timestamp,
--                         nvl(s.load_timestamp,m.start_collection_timestamp)
--                         load_timestamp
--     FROM MGMT_CURRENT_AVAILABILITY m,
--              MGMT_SEVERITY s,
--          MGMT_TARGETS targ
--     WHERE m.target_guid=targ.target_guid AND
--               m.target_guid=s.target_guid(+) AND
--               m.severity_guid=s.severity_guid(+) AND
--               (targ.target_type='oracle_database' OR
--               targ.target_type='rac_database')) avail,
--         (SELECT g.target_guid,
--                 i.instance_name,
--                 i.banner,
--                 s.start_timestamp
--          FROM
--                MGMT_DB_DBNINSTANCEINFO_ECM i,
--                MGMT_TARGETS g,
--                MGMT_ECM_GEN_SNAPSHOT s
--          WHERE s.snapshot_guid = i.ecm_snapshot_id AND
--                s.target_guid = g.target_guid AND
--                s.is_current = 'Y') inst,
--         (SELECT (nvl(tb.tbsp_size,0)+
--                  nvl(re.redo_size,0)+
--                  nvl(ct.ctl_size,0))database_size,
--                   tb.target_guid
--          FROM (SELECT sum(tablespace_used_size/1024/1024) as tbsp_size,
--                       t.target_guid as target_guid
--               FROM MGMT_DB_TABLESPACES_ECM tbsp,
--                    MGMT_ECM_GEN_SNAPSHOT s,
--                    MGMT_TARGETS t
--               WHERE tbsp.ecm_snapshot_id = s.snapshot_guid AND
--                        s.target_guid = t.target_guid AND
--                     s.is_current = 'Y' group by t.target_guid)tb,
--               (SELECT sum(logsize/1024/1024) as redo_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_REDOLOGS_ECM redo,
--                     MGMT_ECM_GEN_SNAPSHOT s,
--                     MGMT_TARGETS t
--                WHERE redo.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)re,
--               (SELECT sum(cf_size) as ctl_size,
--                          t.target_guid as target_guid
--                FROM MGMT_DB_CONTROLFILES_SIZE_ECM ctl,
--                     MGMT_ECM_GEN_SNAPSHOT s, MGMT_TARGETS t
--                WHERE ctl.ecm_snapshot_id = s.snapshot_guid AND
--                      s.target_guid = t.target_guid AND
--                      s.is_current = 'Y' group by t.target_guid)ct
--          WHERE tb.target_guid = re.target_guid (+) AND
--                  re.target_guid = ct.target_guid (+))sz
--    WHERE t.target_guid=avail.target_guid AND
--          t.target_guid=inst.target_guid AND
--          t.target_guid=sz.target_guid AND
--          t.target_guid=prop.target_guid AND
--          t.target_guid=bk.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_CurrentDBStatistics IS 
-- 'Oracle_CurrentDBStatistics is an association that relates a Oracle database to
-- its current statistical information.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBCaption IS 
-- 'The caption contains a short textual description  of the database.  This
-- property would typically be used from a management client to provide a little
-- more descriptive content for the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBDatabaseVersion IS 
-- 'The version number for the Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBDescription IS 
-- 'The description provides detailed information about the database.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBElementName IS 
-- 'A user-friendly name for the database for use in client applications.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBEnabledDefault IS 
-- 'An enumerated value indicating the administrator default/startup configuration
-- for the database EnabledState. By default, the element is \"Enabled\" value=2.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBEnabledState IS 
-- 'Integer enumeration indicating the enabled disabled states of the database. The
-- following text briefly summarizes the enabled/disabled states: Enabled 2
-- indicates that the database is/could be executing commands, will process any
-- queued commands, and queues new requests. Disabled 3 indicates that the
-- database will not execute commands and will drop any new requests. Shutting
-- Down 4 indicates that the database is in the process of going to a Disabled
-- state. Not Applicable 5 indicates the database does not support being
-- enabled/disabled. Enabled but Offline 6 indicates that the database may be
-- completing commands, and will drop any new requests. Test 7 indicates that the
-- database is in a test state. Deferred 8 indicates that the database may be
-- completing commands, but will queue any new requests. Quiesce 9 indicates that
-- the database is enabled but in a restricted mode. The behavior is similar to
-- the Enabled state, but it only processes a restricted set of commands. All
-- other requests are queued. Starting 10 indicates that the database is in the
-- process of going to an Enabled state.  New requests are queued. ';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBInstallDate IS 
-- 'A datetime value indicating when the database was created.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBInstanceID IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBLastBackup IS 
-- 'The date and time when the latest complete or partial backup of the database
-- was performed.  If the database has never been backed up, then this property
-- has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBOperationalStatus IS 
-- 'Indicates the current status of the database . A value of 10 indicates that the
-- database is down and a value of 2 indicates that the database is up.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBOtherEnabledState IS 
-- 'A string describing other relevant information on the status of the database.
-- If the value of the EnabledState property is set to anything other than 1, this
-- property MUST be set to NULL.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBRequestedState IS 
-- 'RequestedState is an integer enumeration indicating the last requested or
-- desired state for the database. The actual state of the element is represented
-- by EnabledState, which is used to compare the last requested and current
-- enabled/disabled states. Note that when EnabledState is set to 5 \"Not
-- Applicable\", then this property has no meaning.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBSizeAllocated IS 
-- 'The estimated amount of disk space in megabytes that has been reserved for
-- database use.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBSizeUnits IS 
-- 'The units for the SizeAllocated property. Mapping is 1 - Bytes, 2 - Kilobytes,
-- 3 - Megabytes, 4 - Gigabytes and 5 - Terabytes.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatusDescriptions IS 
-- 'String describing the OperationalStatus value.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatsCaption IS 
-- 'The caption contains a short textual description one-line string that describes
-- the database.  This property would typically be used from a management client
-- to provide a little more descriptive content for the ElementName.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatsDescription IS 
-- 'The description provides detailed information about the database environment.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatsElementName IS 
-- 'The user friendly name for this database. In addition, the user friendly name
-- can be used as a index property for a search of query.  Note:  Name does not
-- have to be unique within a namespace.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatsInstanceID IS 
-- 'The string representation of an internal GUID that uniquely identifies this
-- particular Oracle database.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatsSampleInterval IS 
-- 'Some statistics are sampled at consistent time intervals.  This property
-- provides the sample interval so that client applications can determine the
-- minimum time that new statistics should be pulled.  If the statistics are not
-- sampled at consistent time intervals, this property must be set to a zero time
-- interval.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatsSizeUsed IS 
-- 'The estimated amount of disk space in units that is currently used by the
-- database.  The units is determined through the SizeUnits property in
-- Oracle_Database.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatsStartStatisticTime IS 
-- 'The time, relative to managed element where the statistic was collected, when
-- the first measurement was taken.  If the statistic is reset, the
-- StartStatisticTime is the time when the reset was performed.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentDBStatistics.DBStatsStatisticTime IS 
-- 'The time the most recent measurement was taken, relative to the managed element
-- where the statistic was collected.';
