Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/esm/db_policies_ext1.sql /st_emdbsa_11.2/1 2009/03/28 20:00:56 sudvarma Exp $
Rem
Rem db_policies_ext1.sql
Rem
Rem Copyright (c) 2005, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      db_policies_ext1.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sudvarma    03/24/09 - To fix bug-8234380 : To include the following
Rem                           policies - dirObjUsersWithExeAndOtherPrivs,
Rem                           publicHavingExePrivOnDirObj
Rem    manosing    01/12/07 - XbranchMerge manosing_lastpols from main
Rem    dsukhwal    01/06/07 - XbranchMerge manosing_ntpol from main
Rem    manosing    01/08/07 - translation changes for 11DB policies
Rem    manosing    12/08/06 - add windows NT 11g policies
Rem    dsukhwal    10/16/06 - add Proxy User policy
Rem    dsukhwal    10/30/06 - add audit insert failure policy
Rem    rmadampa    08/01/06 - bug 5435113: follow internal sec team recomm
Rem    rmadampa    07/25/06 - ER 5259286: password complexity fn usage policy 
Rem    rmadampa    07/23/06 - bug 5242230: fix description of 'Excessive 
Rem                           Public Execute Privileges' to include UTL_TCP 
Rem    dsukhwal    01/20/06 - change end type meta version 
Rem    dkjain      11/14/05 - Fixing bug-4637345 
Rem    dkjain      08/23/05 - Disable unlim login attempt policy eval for 
Rem                           repos owner and repos targets 
Rem    dkjain      06/24/05 - Modifying snapshot object and cat_prop_3 for 
Rem                           rac_database policy 
Rem    dkjain      06/16/05 - Hide the rep metrics 
Rem    dsukhwal    05/23/05 - correct source query for ROLE_ROLE_PRIVS 
Rem    dsukhwal    05/17/05 - move sqlnet policies to listener 
Rem    dkjain      04/28/05 - Adding rac policies. 
Rem    dsukhwal    04/17/05 - dsukhwal_bug-4247709
Rem    dsukhwal    04/14/05 - Created
Rem


SET ESCAPE '\' ;
SET ESCAPE ON ;
DECLARE
 -- Metric Variable
 l_metric_column_list        	   	           MGMT_METRIC_COLUMN_ARRAY;
 l_metric_type				  	   NUMBER ;
 l_snapshot_list			           MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_rac			       MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_inst_10gR1		       MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_inst_10gR2		       MGMT_SNAPSHOT_ARRAY;
 -- Policy Variable
 l_ctxList    		  			   MGMT_VIOL_CTXT_DEF_ARRAY;
 l_defaultParamValList      			   MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList      			   MGMT_POLICY_KEY_VAL_ARRAY;
 l_auto_enable				           NUMBER ;	
 l_10gR1_db_meta_ver                   VARCHAR2(3) ; 
 l_10gR1_db_end_meta_ver                   VARCHAR2(4) ; 
 l_valid_if_list                       MGMT_VALIDIF_ARRAY ;
 l_rac_database                        CONSTANT VARCHAR2(12) := 'rac_database';
 l_paramDefList                           MGMT_POLICY_PARAM_DEF_ARRAY;
 
 -- New snapshot name for the instance specific oracle_security metrics is oracle_security_inst
 l_oracle_security_inst                CONSTANT VARCHAR2(20) := 'oracle_security_inst';
 pol_eval_func_10gR1  CONSTANT VARCHAR2(50) := 'ESM.EVAL_POLICY10GR1'  ;  
 
BEGIN

  l_10gR1_db_meta_ver := '3.0' ;
  l_10gR1_db_end_meta_ver := '3.99' ;
  l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE ;

  l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));
  
  l_snapshot_list_rac := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => l_rac_database,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));

 
  -- This snapshot list is prepared for all the db instance 
  -- security metrics which are applicable For both 10gR1 + 10gR2.
  -- In 10gR2 release oracle_security snapshot name has split up into two
  -- oracle_security + oracle_security_int(all db instance security metric used this)
  -- oracle_security_inst snapshot name is included in the snapshot list
  -- bcoz 10gR2 agent will upload the instance data with this snapshot name 
  -- Snapshot name used by 10gR1 agent remains same so included to support the 
  -- backward compatibility as 10gR1 agent uploads the data for 
  -- those metric with oracle_security snapshot name.


  l_snapshot_list_inst_10gR1 := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => l_oracle_security_inst),
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));
 
  -- for 10gR2 db instance specific metrics => this is oracle_security_inst
  l_snapshot_list_inst_10gR2 := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => l_oracle_security_inst));
 

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on USER_HISTORY$ Table',
                p_column_label_nlsid =>'HIST_TAB_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'userHistRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on USER_HISTORY$',
      p_metric_label_nlsid => 'USR_HIST_TAB_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_HISTORY$',
      p_description_nlsid => 'USR_HIST_TAB_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_history''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'userHistRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on USER_HISTORY$',
      p_metric_label_nlsid => 'USR_HIST_TAB_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_HISTORY$',
      p_description_nlsid => 'USR_HIST_TAB_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_history''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION

  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_USER_HISTORY_Table',   --Policy name
  p_metric_name =>'userHistRep',      --Metric name
  p_policy_label_nlsid =>'ACCESS_USER_HIST_NAME', 
  p_description =>'Ensures restricted access to SYS.USER_HISTORY$ table',
  p_description_nlsid =>'ACCESS_USER_HIST_DESC',
  p_impact => 'Username and password hash may be read from the SYS.USER_HISTORY$ table, enabling a hacker to launch a brute-force attack.',
  p_impact_nlsid =>'ACCESS_USER_HIST_IMPACT',
  p_recommendation =>'Revoke access to SYS.USER_HISTORY$ table from the non-DBA/SYS database users.',
  p_recommendation_nlsid =>'ACCESS_USER_HIST_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the SYS.USER_HISTORY$ table.',
  p_message_nlsid =>'ACCESS_USER_HIST_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_USER_HISTORY_Table',   --Policy name
  p_metric_name =>'userHistRep',      --Metric name
  p_policy_label_nlsid =>'ACCESS_USER_HIST_NAME', 
  p_description =>'Ensures restricted access to SYS.USER_HISTORY$ table',
  p_description_nlsid =>'ACCESS_USER_HIST_DESC',
  p_impact => 'Username and password hash may be read from the SYS.USER_HISTORY$ table, enabling a hacker to launch a brute-force attack.',
  p_impact_nlsid =>'ACCESS_USER_HIST_IMPACT',
  p_recommendation =>'Revoke access to SYS.USER_HISTORY$ table from the non-DBA/SYS database users.',
  p_recommendation_nlsid =>'ACCESS_USER_HIST_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the SYS.USER_HISTORY$ table.',
  p_message_nlsid =>'ACCESS_USER_HIST_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 
   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on SOURCE$ Table',
                p_column_label_nlsid =>'SRC_TAB_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sourceTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on SOURCE$',
      p_metric_label_nlsid => 'SRC_METRIC_LABEL',
      p_description  => 'Collect the database users having access on SOURCE$',
      p_description_nlsid => 'SRC_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_source_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'sourceTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on SOURCE$',
      p_metric_label_nlsid => 'SRC_METRIC_LABEL',
      p_description  => 'Collect the database users having access on SOURCE$',
      p_description_nlsid => 'SRC_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_source_table''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION

  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_SOURCE_Table',   --Policy name
  p_metric_name =>'sourceTabRep',      --Metric name
  p_policy_label_nlsid =>'ACSS_SRC_TAB_NAME', 
  p_description =>'Ensures restricted access to SYS.SOURCE$ table',
  p_description_nlsid =>'ACSS_SRC_TAB_DESC',
  p_impact => 'Contains source of all stored packages units in the database.',
  p_impact_nlsid =>'ACSS_SRC_TAB_IMPACT',
  p_recommendation =>'Revoke access to SYS.SOURCE$ table from the non-SYS/DBA database users.' ,
  p_recommendation_nlsid =>'ACSS_SRC_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the SOURCE$ table.',
  p_message_nlsid =>'ACSS_SRC_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_SOURCE_Table',   --Policy name
  p_metric_name =>'sourceTabRep',      --Metric name
  p_policy_label_nlsid =>'ACSS_SRC_TAB_NAME', 
  p_description =>'Ensures restricted access to SYS.SOURCE$ table',
  p_description_nlsid =>'ACSS_SRC_TAB_DESC',
  p_impact => 'Contains source of all stored packages units in the database.',
  p_impact_nlsid =>'ACSS_SRC_TAB_IMPACT',
  p_recommendation =>'Revoke access to SYS.SOURCE$ table from the non-SYS/DBA database users.' ,
  p_recommendation_nlsid =>'ACSS_SRC_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the SOURCE$ table.',
  p_message_nlsid =>'ACSS_SRC_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on LINK$ Table',
                p_column_label_nlsid =>'LINK_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'linkTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on LINK$',
      p_metric_label_nlsid => 'LINK_METRIC_LABEL',
      p_description  => 'Collect the database users having access on LINK$',
      p_description_nlsid => 'LINK_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_link_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'linkTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on LINK$',
      p_metric_label_nlsid => 'LINK_METRIC_LABEL',
      p_description  => 'Collect the database users having access on LINK$',
      p_description_nlsid => 'LINK_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_link_table''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_LINK_Table',   --Policy name
  p_metric_name =>'linkTabRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_LINK_TAB_NAME', 
  p_description =>'Ensures restricted access to LINK$ table',
  p_description_nlsid =>'ACCSS_LINK_TAB_DESC',
  p_impact => 'A knowlegeable and malicious user can gain access to user passwords from the SYS.LINK$ table.',
  p_impact_nlsid =>'ACCSS_LINK_TAB_IMPACT',
  p_recommendation =>'Restrict access to SYS.LINK$ table.' ,
  p_recommendation_nlsid =>'ACCSS_LINK_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the LINK$ table.',
  p_message_nlsid =>'ACCSS_LINK_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_LINK_Table',   --Policy name
  p_metric_name =>'linkTabRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_LINK_TAB_NAME', 
  p_description =>'Ensures restricted access to LINK$ table',
  p_description_nlsid =>'ACCSS_LINK_TAB_DESC',
  p_impact => 'A knowlegeable and malicious user can gain access to user passwords from the SYS.LINK$ table.',
  p_impact_nlsid =>'ACCSS_LINK_TAB_IMPACT',
  p_recommendation =>'Restrict access to SYS.LINK$ table.' ,
  p_recommendation_nlsid =>'ACCSS_LINK_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the LINK$ table.',
  p_message_nlsid =>'ACCSS_LINK_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on USER$ Table',
                p_column_label_nlsid =>'USR_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'userTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on USER$',
      p_metric_label_nlsid => 'USR_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER$',
      p_description_nlsid => 'USR_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'userTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on USER$',
      p_metric_label_nlsid => 'USR_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER$',
      p_description_nlsid => 'USR_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_table''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION

     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_USER_Table',   --Policy name
  p_metric_name =>'userTabRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_TAB_NAME', 
  p_description =>'Ensures restricted access to SYS.USER$ table',
  p_description_nlsid =>'ACCSS_USER_TAB_DESC',
  p_impact => 'Username and password hash may be read from the SYS.USER$ table, enabling a hacker to launch a brute-force attack.',
  p_impact_nlsid =>'ACCSS_USER_TAB_IMPACT',
  p_recommendation =>'Restrict access to SYS.USER$ table.' ,
  p_recommendation_nlsid =>'ACCSS_USER_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER$ table.',
  p_message_nlsid =>'ACCSS_USER_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_USER_Table',   --Policy name
  p_metric_name =>'userTabRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_TAB_NAME', 
  p_description =>'Ensures restricted access to SYS.USER$ table',
  p_description_nlsid =>'ACCSS_USER_TAB_DESC',
  p_impact => 'Username and password hash may be read from the SYS.USER$ table, enabling a hacker to launch a brute-force attack.',
  p_impact_nlsid =>'ACCSS_USER_TAB_IMPACT',
  p_recommendation =>'Restrict access to SYS.USER$ table.' ,
  p_recommendation_nlsid =>'ACCSS_USER_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER$ table.',
  p_message_nlsid =>'ACCSS_USER_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on STATS$SQL_TEXT Table',
                p_column_label_nlsid =>'SQLTEXT_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlTextRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on STATS$SQL_TEXT',
      p_metric_label_nlsid => 'SQL_TEXT_LABEL',
      p_description  => 'Collect the database users having access on STATS$SQL_TEXT',
      p_description_nlsid => 'SQL_TEXT_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_sql_text''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'sqlTextRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on STATS$SQL_TEXT',
      p_metric_label_nlsid => 'SQL_TEXT_LABEL',
      p_description  => 'Collect the database users having access on STATS$SQL_TEXT',
      p_description_nlsid => 'SQL_TEXT_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_sql_text''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION

  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_STATSSQLTEXT_Table',   --Policy name
  p_metric_name =>'sqlTextRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_SQLTEXT_TAB_NAME', 
  p_description =>'Ensures restricted access to STATS$SQLTEXT table',
  p_description_nlsid =>'ACCSS_SQLTEXT_TAB_DESC',
  p_impact => 'This table provides full text of the recently-executed SQL statements. The SQL statements can reveal sensitive information.',
  p_impact_nlsid =>'ACCSS_SQLTEXT_TAB_IMPACT',
  p_recommendation =>'Restrict access to STATS$SQLTEXT table.',
  p_recommendation_nlsid =>'ACCSS_SQLTEXT_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on STATS$SQLTEXT table.',
  p_message_nlsid =>'ACCSS_SQLTEXT_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_STATSSQLTEXT_Table',   --Policy name
  p_metric_name =>'sqlTextRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_SQLTEXT_TAB_NAME', 
  p_description =>'Ensures restricted access to STATS$SQLTEXT table',
  p_description_nlsid =>'ACCSS_SQLTEXT_TAB_DESC',
  p_impact => 'This table provides full text of the recently-executed SQL statements. The SQL statements can reveal sensitive information.',
  p_impact_nlsid =>'ACCSS_SQLTEXT_TAB_IMPACT',
  p_recommendation =>'Restrict access to STATS$SQLTEXT table.',
  p_recommendation_nlsid =>'ACCSS_SQLTEXT_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on STATS$SQLTEXT table.',
  p_message_nlsid =>'ACCSS_SQLTEXT_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
   
   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on STATS$SQL_SUMMARY Table',
                p_column_label_nlsid =>'SQL_SUMM_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlSummaryRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on STATS$SQL_SUMMARY',
      p_metric_label_nlsid => 'SQL_SUMM_METRIC_LABEL',
      p_description  => 'Collect the database users having access on STATS$SQL_SUMMARY',
      p_description_nlsid => 'SQL_SUMM_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_sql_summary''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'sqlSummaryRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on STATS$SQL_SUMMARY',
      p_metric_label_nlsid => 'SQL_SUMM_METRIC_LABEL',
      p_description  => 'Collect the database users having access on STATS$SQL_SUMMARY',
      p_description_nlsid => 'SQL_SUMM_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_sql_summary''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;

-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_STATSSQL_SUMMARY_Table',   --Policy name
  p_metric_name =>'sqlSummaryRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_SQLSUM_TAB_NAME', 
  p_description =>'Ensures restricted access to STATS$SQL_SUMMARY table',
  p_description_nlsid =>'ACCSS_SQLSUM_TAB_DESC',
  p_impact => 'Contains first few lines of SQL text of the most resource intensive commands given to the server. Sql statements executed without bind variables can show up here exposing privileged information.',
  p_impact_nlsid =>'ACCSS_SQLSUM_TAB_IMPACT',
  p_recommendation =>'Restrict access to STATS$SQL_SUMMARY table.',
  p_recommendation_nlsid =>'ACCSS_SQLSUM_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure. User %grantee% has %privilege%  privilege on the STATS$SQL_SUMMARY table.',
  p_message_nlsid =>'ACCSS_SQLSUM_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_STATSSQL_SUMMARY_Table',   --Policy name
  p_metric_name =>'sqlSummaryRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_SQLSUM_TAB_NAME', 
  p_description =>'Ensures restricted access to STATS$SQL_SUMMARY table',
  p_description_nlsid =>'ACCSS_SQLSUM_TAB_DESC',
  p_impact => 'Contains first few lines of SQL text of the most resource intensive commands given to the server. Sql statements executed without bind variables can show up here exposing privileged information.',
  p_impact_nlsid =>'ACCSS_SQLSUM_TAB_IMPACT',
  p_recommendation =>'Restrict access to STATS$SQL_SUMMARY table.',
  p_recommendation_nlsid =>'ACCSS_SQLSUM_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure. User %grantee% has %privilege%  privilege on the STATS$SQL_SUMMARY table.',
  p_message_nlsid =>'ACCSS_SQLSUM_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on ALL_SOURCE View',
                p_column_label_nlsid =>'ALL_SRC_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'allSourceRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on ALL_SOURCE',
      p_metric_label_nlsid => 'ALL_SRC_METRIC_LABEL',
      p_description  => 'Collect the database users having access on ALL_SOURCE',
      p_description_nlsid => 'ALL_SRC_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_all_source''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'allSourceRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on ALL_SOURCE',
      p_metric_label_nlsid => 'ALL_SRC_METRIC_LABEL',
      p_description  => 'Collect the database users having access on ALL_SOURCE',
      p_description_nlsid => 'ALL_SRC_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_all_source''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;

-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_ALL_SOURCE_View',   --Policy name
  p_metric_name =>'allSourceRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_ALL_SRC_NAME', 
  p_description =>'Ensures restricted access to ALL_SOURCE view',
  p_description_nlsid =>'ACCSS_ALL_SRC_DESC',
  p_impact => 'ALL_SOURCE view contains source of all stored packages in the database.',
  p_impact_nlsid =>'ACCSS_ALL_SRC_IMPACT',
  p_recommendation =>'Revoke access to ALL_SOURCE view from the non-SYS database users.',
  p_recommendation_nlsid =>'ACCSS_ALL_SRC_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege to the ALL_SOURCE view.',
  p_message_nlsid =>'ACCSS_ALL_SRC_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_ALL_SOURCE_View',   --Policy name
  p_metric_name =>'allSourceRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_ALL_SRC_NAME', 
  p_description =>'Ensures restricted access to ALL_SOURCE view',
  p_description_nlsid =>'ACCSS_ALL_SRC_DESC',
  p_impact => 'ALL_SOURCE view contains source of all stored packages in the database.',
  p_impact_nlsid =>'ACCSS_ALL_SRC_IMPACT',
  p_recommendation =>'Revoke access to ALL_SOURCE view from the non-SYS database users.',
  p_recommendation_nlsid =>'ACCSS_ALL_SRC_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege to the ALL_SOURCE view.',
  p_message_nlsid =>'ACCSS_ALL_SRC_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_ROLES View',
                p_column_label_nlsid =>'DBA_ROLE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaRoleRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_ROLES',
      p_metric_label_nlsid => 'DBA_ROLE_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_ROLES',
      p_description_nlsid => 'DBA_ROLE_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid,  '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roles''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaRoleRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_ROLES',
      p_metric_label_nlsid => 'DBA_ROLE_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_ROLES',
      p_description_nlsid => 'DBA_ROLE_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid,  '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roles''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_ROLES_View',   --Policy name
  p_metric_name =>'dbaRoleRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_ROLES_NAME', 
  p_description =>'Ensures restricted access to DBA_ROLES view',
  p_description_nlsid =>'ACCSS_DBA_ROLES_DESC',
  p_impact => 'DBA_ROLES view contains details of all roles in the database. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_ROLES_IMPACT',
  p_recommendation =>'Restrict access to DBA_ROLES view.',
  p_recommendation_nlsid =>'ACCSS_DBA_ROLES_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_ROLES view.',
  p_message_nlsid =>'ACCSS_DBA_ROLES_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_ROLES_View',   --Policy name
  p_metric_name =>'dbaRoleRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_ROLES_NAME', 
  p_description =>'Ensures restricted access to DBA_ROLES view',
  p_description_nlsid =>'ACCSS_DBA_ROLES_DESC',
  p_impact => 'DBA_ROLES view contains details of all roles in the database. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_ROLES_IMPACT',
  p_recommendation =>'Restrict access to DBA_ROLES view.',
  p_recommendation_nlsid =>'ACCSS_DBA_ROLES_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_ROLES view.',
  p_message_nlsid =>'ACCSS_DBA_ROLES_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_SYS_PRIVS View',
                p_column_label_nlsid =>'DBA_SYSPRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaSysPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_SYS_PRIVS',
      p_metric_label_nlsid => 'DBA_SYSPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_SYS_PRIVS',
      p_description_nlsid => 'DBA_SYSPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid,  '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_sysprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaSysPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_SYS_PRIVS',
      p_metric_label_nlsid => 'DBA_SYSPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_SYS_PRIVS',
      p_description_nlsid => 'DBA_SYSPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid,  '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_sysprivs''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_SYS_PRIVS_View',   --Policy name
  p_metric_name =>'dbaSysPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_SYSPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_SYS_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_SYSPRIVS_DESC',
  p_impact => 'DBA_SYS_PRIVS view can be queried to find system privileges granted to roles and users. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_SYSPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_SYS_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_SYSPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_SYS_PRIVS view.',
  p_message_nlsid =>'ACCSS_DBA_SYSPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_SYS_PRIVS_View',   --Policy name
  p_metric_name =>'dbaSysPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_SYSPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_SYS_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_SYSPRIVS_DESC',
  p_impact => 'DBA_SYS_PRIVS view can be queried to find system privileges granted to roles and users. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_SYSPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_SYS_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_SYSPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_SYS_PRIVS view.',
  p_message_nlsid =>'ACCSS_DBA_SYSPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_ROLE_PRIVS View',
                p_column_label_nlsid =>'DBA_ROLE_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaRolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_ROLE_PRIVS',
      p_metric_label_nlsid => 'DBA_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_ROLE_PRIVS',
      p_description_nlsid => 'DBA_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaRolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_ROLE_PRIVS',
      p_metric_label_nlsid => 'DBA_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_ROLE_PRIVS',
      p_description_nlsid => 'DBA_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roleprivs''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'dbaRolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_ROLEPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_ROLEPRIVS_DESC',
  p_impact => 'The DBA_ROLE_PRIVS view lists the roles granted to users and other roles. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_ROLEPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_ROLEPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_DBA_ROLEPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'dbaRolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_ROLEPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_ROLEPRIVS_DESC',
  p_impact => 'The DBA_ROLE_PRIVS view lists the roles granted to users and other roles. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_ROLEPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_ROLEPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_DBA_ROLEPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_TAB_PRIVS View',
                p_column_label_nlsid =>'DBA_TAB_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaTabPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_TAB_PRIVS',
      p_metric_label_nlsid => 'DBA_TABPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_TAB_PRIVS',
      p_description_nlsid => 'DBA_TABPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_tabprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaTabPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_TAB_PRIVS',
      p_metric_label_nlsid => 'DBA_TABPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_TAB_PRIVS',
      p_description_nlsid => 'DBA_TABPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_tabprivs''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_TAB_PRIVS_View',   --Policy name
  p_metric_name =>'dbaTabPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_TABPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_TAB_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_TABPRIVS_DESC',
  p_impact => 'Lists privileges granted to users or roles on objects in the database. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_TABPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_TAB_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_TABPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be insecure as user %grantee% has %privilege%  privilege to the DBA_TAB_PRIVS  view.',
  p_message_nlsid =>'ACCSS_DBA_TABPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_TAB_PRIVS_View',   --Policy name
  p_metric_name =>'dbaTabPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_TABPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_TAB_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_TABPRIVS_DESC',
  p_impact => 'Lists privileges granted to users or roles on objects in the database. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_TABPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_TAB_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_TABPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be insecure as user %grantee% has %privilege%  privilege to the DBA_TAB_PRIVS  view.',
  p_message_nlsid =>'ACCSS_DBA_TABPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_USERS View',
                p_column_label_nlsid =>'DBA_USR_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaUsersRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_USERS',
      p_metric_label_nlsid => 'DBA_USR_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_USERS',
      p_description_nlsid => 'DBA_USR_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_users''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaUsersRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on DBA_USERS',
      p_metric_label_nlsid => 'DBA_USR_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_USERS',
      p_description_nlsid => 'DBA_USR_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_users''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_USERS_View',   --Policy name
  p_metric_name =>'dbaUsersRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_USERS_NAME', 
  p_description =>'Ensures restricted access to DBA_USERS view',
  p_description_nlsid =>'ACCSS_DBA_USERS_DESC',
  p_impact => 'Contains user password hashes and other account information. Access to this information can be used to mount brute-force attacks.',
  p_impact_nlsid =>'ACCSS_DBA_USERS_IMPACT',
  p_recommendation =>'Restrict access to DBA_USERS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_USERS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_USERS  view.',
  p_message_nlsid =>'ACCSS_DBA_USERS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_USERS_View',   --Policy name
  p_metric_name =>'dbaUsersRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_USERS_NAME', 
  p_description =>'Ensures restricted access to DBA_USERS view',
  p_description_nlsid =>'ACCSS_DBA_USERS_DESC',
  p_impact => 'Contains user password hashes and other account information. Access to this information can be used to mount brute-force attacks.',
  p_impact_nlsid =>'ACCSS_DBA_USERS_IMPACT',
  p_recommendation =>'Restrict access to DBA_USERS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_USERS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_USERS  view.',
  p_message_nlsid =>'ACCSS_DBA_USERS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on ROLE_ROLE_PRIVS View',
                p_column_label_nlsid =>'ROLE_ROLE_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'rolerolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on ROLE_ROLE_PRIVS',
      p_metric_label_nlsid => 'ROLE_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on ROLE_ROLE_PRIVS',
      p_description_nlsid => 'ROLE_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_role_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'rolerolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on ROLE_ROLE_PRIVS',
      p_metric_label_nlsid => 'ROLE_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on ROLE_ROLE_PRIVS',
      p_description_nlsid => 'ROLE_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_role_roleprivs''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_ROLE_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'rolerolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_ROLE_ROLE_NAME', 
  p_description =>'Ensures restricted access to ROLE_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_ROLE_ROLE_DESC',
  p_impact => 'Lists roles granted to other roles. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_ROLE_ROLE_IMPACT',
  p_recommendation =>'Restrict access to ROLE_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_ROLE_ROLE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the ROLE_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_ROLE_ROLE_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_ROLE_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'rolerolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_ROLE_ROLE_NAME', 
  p_description =>'Ensures restricted access to ROLE_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_ROLE_ROLE_DESC',
  p_impact => 'Lists roles granted to other roles. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_ROLE_ROLE_IMPACT',
  p_recommendation =>'Restrict access to ROLE_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_ROLE_ROLE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the ROLE_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_ROLE_ROLE_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on USER_TAB_PRIVS View',
                p_column_label_nlsid =>'USR_TAB_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(

      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'userTabPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on USER_TAB_PRIVS',
      p_metric_label_nlsid => 'USR_TAB_PRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_TAB_PRIVS',
      p_description_nlsid => 'USR_TAB_PRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_tabprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(

      p_target_type => 'rac_database',
      p_metric_name => 'userTabPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on USER_TAB_PRIVS',
      p_metric_label_nlsid => 'USR_TAB_PRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_TAB_PRIVS',
      p_description_nlsid => 'USR_TAB_PRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_tabprivs''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
    -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_USER_TAB_PRIVS_View',   --Policy name
  p_metric_name =>'userTabPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_TAB_PRIVS_NAME', 
  p_description =>'Ensures restricted access to USER_TAB_PRIVS view',
  p_description_nlsid =>'ACCSS_USER_TAB_PRIVS_DESC',
  p_impact => 'Lists the grants on objects for which the user is the owner, grantor or grantee. Knowledge of the grants in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_USER_TAB_PRIVS_IMPACT',
  p_recommendation =>'Restrict access to USER_TAB_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_USER_TAB_PRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER_TAB_PRIVS  view.',
  p_message_nlsid =>'ACCSS_USER_TAB_PRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_USER_TAB_PRIVS_View',   --Policy name
  p_metric_name =>'userTabPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_TAB_PRIVS_NAME', 
  p_description =>'Ensures restricted access to USER_TAB_PRIVS view',
  p_description_nlsid =>'ACCSS_USER_TAB_PRIVS_DESC',
  p_impact => 'Lists the grants on objects for which the user is the owner, grantor or grantee. Knowledge of the grants in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_USER_TAB_PRIVS_IMPACT',
  p_recommendation =>'Restrict access to USER_TAB_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_USER_TAB_PRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER_TAB_PRIVS  view.',
  p_message_nlsid =>'ACCSS_USER_TAB_PRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on USER_ROLE_PRIVS View',
                p_column_label_nlsid =>'USR_ROLE_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'userRolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on USER_ROLE_PRIVS',
      p_metric_label_nlsid => 'USR_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_ROLE_PRIVS',
      p_description_nlsid => 'USR_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'userRolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Database Users with Access on USER_ROLE_PRIVS',
      p_metric_label_nlsid => 'USR_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_ROLE_PRIVS',
      p_description_nlsid => 'USR_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_roleprivs''',
     p_snapshot_name_list => l_snapshot_list_rac,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_USER_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'userRolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_ROLE_PRIV_NAME', 
  p_description =>'Ensures restricted access to USER_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_USER_ROLE_PRIV_DESC',
  p_impact => 'Lists the roles granted to the current user. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_USER_ROLE_PRIV_IMPACT',
  p_recommendation =>'Restrict access to USER_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_USER_ROLE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_USER_ROLE_PRIV_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_USER_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'userRolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_ROLE_PRIV_NAME', 
  p_description =>'Ensures restricted access to USER_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_USER_ROLE_PRIV_DESC',
  p_impact => 'Lists the roles granted to the current user. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_USER_ROLE_PRIV_IMPACT',
  p_recommendation =>'Restrict access to USER_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_USER_ROLE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_USER_ROLE_PRIV_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 
------------------------------------------------------------------------------------


---------------Metric secureOSAuditLevel starts-----------------------------

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'logLevel',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Audit Syslog Level',
                p_column_label_nlsid => 'SECURE_OS_AUDIT_LEVEL_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid => 'DUMMY_COL'));

   MGMT_METRIC.CREATE_METRIC(
       p_target_type => ESM.DB_TARGET_TYPE,
       p_metric_name => 'secureOSAuditLevelRep',
       p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
       p_valid_if_list => l_valid_if_list,
       p_metric_type => l_metric_type,
       p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
       p_metric_label => 'Secure Audit System Log Level',
       p_metric_label_nlsid => 'SECURE_OS_AUDIT_LEVEL_LABEL',
       p_description => 'On UNIX systems, ensures that AUDIT_SYSLOG_LEVEL is set to a non-default value when OS-level auditing is enabled.',
       p_description_nlsid => 'SECURE_OS_AUDIT_LEVEL_DESC',
       p_is_repository => MGMT_GLOBAL.G_TRUE,
       p_author => ESM.METRIC_AUTHOR,
       p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
       p_source => 'SELECT target_guid, value as logLevel, value as dummy '
                  ||'FROM esm_collection_latest '
                  ||'WHERE property = ''audit_syslog_level''',
       p_snapshot_name_list => l_snapshot_list_inst_10gR2,
       p_metric_column_list => l_metric_column_list
   );
   COMMIT ;

---------------Metric secureOSAuditLevel Ends---------------------------------

---------------Policy secureOSAuditLevel Starts-------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'logLevel'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Secure_OS_Audit_Level',   --Policy name
  p_metric_name =>'secureOSAuditLevelRep',      --Metric name
  p_policy_label_nlsid =>'SECURE_OS_AUDIT_LEVEL_NAME',
  p_description =>'On UNIX systems, ensures that AUDIT_SYSLOG_LEVEL is set to a non-default value when OS-level auditing is enabled.',
  p_description_nlsid =>'SECURE_OS_AUDIT_LEVEL_DESC',
  p_impact =>'Setting the AUDIT_SYSLOG_LEVEL initialization parameter to the default value (NONE) will result in DBAs gaining access to the OS audit records',
  p_impact_nlsid =>'SECURE_OS_AUDIT_LEVEL_IMPACT',
  p_recommendation =>'When operating system auditing is enabled, set the AUDIT_SYSLOG_LEVEL initialization parameter to a valid value and configure /etc/syslog.conf so that Oracle OS audit records are written to a seperate file.',
  p_recommendation_nlsid =>'SECURE_OS_AUDIT_LEVEL_RECOM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'UPPER(:logLevel) = ''NONE'' OR :logLevel = '' ''',
  p_message =>'Database is in an insecure state. The AUDIT_SYSLOG_LEVEL initialization parameter is set to %logLevel%.',
  p_message_nlsid =>'SECURE_OS_AUDIT_LEVEL_MESSAGE',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT;

--------------Policy ends here------------------------------------------------------------


-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbuser',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Database User',
                p_column_label_nlsid =>'DBUSER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'accountstatus',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Account Status',
                p_column_label_nlsid =>'ACCOUNT_STAT_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'installAndDemoAcccountsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as accountstatus,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default_user_account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'installAndDemoAcccountsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as accountstatus,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default_user_account''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify account setting for the db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'dbuser',
                p_url_link_template =>'database/security/user?oname=^dbuser^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
      	MGMT_VIOL_CTXT_DEF.NEW(
	        	p_metric_column => 'accountstatus'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Well_known_Accounts',   --Policy name
  p_metric_name =>'installAndDemoAcccountsRep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT2_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as %dbuser%''s account status is %accountstatus%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT2_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Well_known_Accounts',   --Policy name
  p_metric_name =>'installAndDemoAcccountsRep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT2_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as %dbuser%''s account status is %accountstatus%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT2_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


---Start 11.2 security policies 
----------->> Execute_And_Other_Privleges_On_Dir_Obj <<<--------
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')));
            
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'directory',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Directory Object',
                p_column_label_nlsid =>'DBDIRECTORY_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'directorypath',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Directory Object Path',
                p_column_label_nlsid =>'DBDIRECTORY_PATH_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'esm_dirObjUsersWithExeAndOtherPrivsRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
      p_metric_label => 'Execute and other privileges on Directory Objects',
      p_metric_label_nlsid => 'EXECUTE_OTHER_PRIV_DIROBJ_METRIC_LABEL',
      p_description  => 'Collect the information of execute and other privileges on Directory Objects',
      p_description_nlsid => 'EXECUTE_OTHER_PRIV_DIROBJ_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as directory,value2 as directorypath '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''esm_dirObjUsersWithExeAndOtherPrivs''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 );
COMMIT;

	MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'esm_dirObjUsersWithExeAndOtherPrivsRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
      p_metric_label => 'Execute and other privileges on Directory Objects',
      p_metric_label_nlsid => 'EXECUTE_OTHER_PRIV_DIROBJ_METRIC_LABEL',
      p_description  => 'Collect the information of execute and other privileges on Directory Objects',
      p_description_nlsid => 'EXECUTE_OTHER_PRIV_DIROBJ_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as directory,value2 as directorypath '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''esm_dirObjUsersWithExeAndOtherPrivs''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list
 );
COMMIT;


   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify account setting for the db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'directory',
                p_url_link_template =>'database/security/dirObject?oname=^directory^\&event=edit\&otype=DIRECTORY_OBJECT\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
                        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                        p_metric_column => 'directorypath'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Execute_And_Other_Privleges_On_Dir_Obj',   --Policy name
  p_metric_name =>'esm_dirObjUsersWithExeAndOtherPrivsRep',      --Metric name
  p_policy_label_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_NAME',
  p_description =>'Checks for Execute and other privileges on Directory Objects',
  p_description_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_DESC',
  p_impact =>'A knowledgeable malicious user can take advantage of directory object which is provided with EXECUTE along with READ/WRITE privilege.',
  p_impact_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_IMPACT',
  p_recommendation =>'Oracle recommends that nobody should have READ/WRITE access to a directory that anyone has EXECUTE.',
  p_recommendation_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as users have READ/WRITE and EXECUTE privileges on %directory%(%directorypath%).',
  p_message_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Execute_And_Other_Privleges_On_Dir_Obj',   --Policy name
  p_metric_name =>'esm_dirObjUsersWithExeAndOtherPrivsRep',      --Metric name
  p_policy_label_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_NAME',
  p_description =>'Checks for Execute and other privileges on Directory Objects',
  p_description_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_DESC',
  p_impact =>'A knowledgeable malicious user can take advantage of directory object which is provided with EXECUTE along with READ/WRITE privilege.',
  p_impact_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_IMPACT',
  p_recommendation =>'Oracle recommends that nobody should have READ/WRITE access to a directory that anyone has EXECUTE.',
  p_recommendation_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as users have READ/WRITE and EXECUTE privileges on %directory%(%directorypath%).',
  p_message_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

----------->> Public_Having_Execute_Privleges_On_Dir_Obj <<<--------
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')));
            
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'directory',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Directory Object',
                p_column_label_nlsid =>'DBDIRECTORY_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'directorypath',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Directory Object Path',
                p_column_label_nlsid =>'DBDIRECTORY_PATH_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'esm_publicHavingExePrivOnDirObjRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
      p_metric_label => 'PUBLIC Having EXECUTE privilege on Directory Objects',
      p_metric_label_nlsid => 'PUBLIC_EXECUTE_PRIV_DIROBJ_METRIC_LABEL',
      p_description  => 'Collect the information of Directory Objects with PUBLIC having EXECUTE privilege.',
      p_description_nlsid => 'PUBLIC_EXECUTE_PRIV_DIROBJ_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as directory,value2 as directorypath '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''esm_publicHavingExePrivOnDirObj''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 );
COMMIT;

	MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'esm_publicHavingExePrivOnDirObjRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
      p_metric_label => 'PUBLIC Having EXECUTE privilege on Directory Objects',
      p_metric_label_nlsid => 'PUBLIC_EXECUTE_PRIV_DIROBJ_METRIC_LABEL',
      p_description  => 'Collect the information of Directory Objects with PUBLIC having EXECUTE privilege.',
      p_description_nlsid => 'PUBLIC_EXECUTE_PRIV_DIROBJ_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as directory,value2 as directorypath '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''esm_publicHavingExePrivOnDirObj''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list
 );
COMMIT;


   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify account setting for the db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'directory',
                p_url_link_template =>'database/security/dirObject?oname=^directory^\&event=edit\&otype=DIRECTORY_OBJECT\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
                        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                        p_metric_column => 'directorypath'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Public_Having_Execute_Privilege_On_Dir_Obj',   --Policy name
  p_metric_name =>'esm_publicHavingExePrivOnDirObjRep',      --Metric name
  p_policy_label_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_NAME',
  p_description =>'Checks for PUBLIC having execute privilege on Directory Objects',
  p_description_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_DESC',
  p_impact =>'A knowledgeable malicious user can take advantage of directory object which has granted EXECUTE privilege to PUBLIC.',
  p_impact_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_IMPACT',
  p_recommendation =>'Oracle recommends that PUBLIC be not granted with EXECUTE privilege on directory objects.',
  p_recommendation_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as PUBLIC has EXECUTE privileges on %directory%(%directorypath%).',
  p_message_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Public_Having_Execute_Privilege_On_Dir_Obj',   --Policy name
  p_metric_name =>'esm_publicHavingExePrivOnDirObjRep',      --Metric name
  p_policy_label_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_NAME',
  p_description =>'Checks for PUBLIC having execute privilege on Directory Objects',
  p_description_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_DESC',
  p_impact =>'A knowledgeable malicious user can take advantage of directory object which has granted EXECUTE privilege to PUBLIC.',
  p_impact_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_IMPACT',
  p_recommendation =>'Oracle recommends that PUBLIC be not granted with EXECUTE privilege on directory objects.',
  p_recommendation_nlsid =>'PUBLIC_EXECUTE_PRIV_DIROBJ_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as PUBLIC has EXECUTE privileges on %directory%(%directorypath%).',
  p_message_nlsid =>'EXECUTE_AND_OTHER_PRIVLEGES_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

---End 11.2 security policies 

-- Atmost three rows
-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB','NO'))
 ); 
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'package',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Package',
                p_column_label_nlsid =>'PKG_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,--here?
      p_metric_name => 'executePrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,    -- No end meta version since it is applicable for 10gR1 + 10gR2
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Public Execute Privileges on Powerful Packages(UTL_TCP,UTL_HTTP)',
      p_metric_label_nlsid =>'PKG_METRIC_LABEL',
      p_description  => 'Collect information of the system packages on which '||
                        'PUBLIC execute privileges has been granted',
      p_description_nlsid => 'PKG_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as package,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC can execute'' AND value in (''UTL_HTTP'',''UTL_TCP'',''UTL_SMTP'')',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'executePrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,    -- No end meta version since it is applicable for 10gR1 + 10gR2
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Public Execute Privileges on Powerful Packages(UTL_TCP,UTL_HTTP)',
      p_metric_label_nlsid =>'PKG_METRIC_LABEL',
      p_description  => 'Collect information of the system packages on which '||
                        'PUBLIC execute privileges has been granted',
      p_description_nlsid => 'PKG_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as package,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC can execute'' AND value in (''UTL_HTTP'',''UTL_TCP'',''UTL_SMTP'')',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

/* 
 -- This Url will take user to USER EDIT SETTING PAGE
 -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE, --here1?
  p_policy_name =>'Excessive_PUBLIC_EXECUTE_privileges',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_EXE_PRIV_NAME',    
  p_description =>'Ensure PUBLIC does not have execute privileges on powerful packages (UTL_TCP, UTL_HTTP and UTL_SMTP)',
  p_description_nlsid =>'PUB_EXE_PRIV_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on powerful packages.',
  p_recommendation_nlsid =>'PUB_EXE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database', --here1?
  p_policy_name =>'Excessive_PUBLIC_EXECUTE_privileges',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_EXE_PRIV_NAME',    
  p_description =>'Ensure PUBLIC does not have execute privileges on powerful packages (UTL_TCP, UTL_HTTP and UTL_SMTP)',
  p_description_nlsid =>'PUB_EXE_PRIV_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on powerful packages.',
  p_recommendation_nlsid =>'PUB_EXE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
*/

-- Start Public Execute Privileges on UTL_TCP Package Policy

-- This Url will take user to USER EDIT SETTING PAGE
 -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE, 
  p_policy_name =>'Public_Exec_Priv_Utl_Tcp',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_TCP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_TCP package',
  p_description_nlsid =>'UTL_TCP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_TCP package.',
  p_recommendation_nlsid =>'UTL_TCP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_TCP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database', 
  p_policy_name =>'Public_Exec_Priv_Utl_Tcp',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_TCP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_TCP package',
  p_description_nlsid =>'UTL_TCP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_TCP package.',
  p_recommendation_nlsid =>'UTL_TCP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_TCP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

-- End of Public Execute Privileges on UTL_TCP Package Policy

-- Start Public Execute Privileges on UTL_HTTP Package Policy

-- This Url will take user to USER EDIT SETTING PAGE
 -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE, 
  p_policy_name =>'Public_Exec_Priv_Utl_Http',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_HTTP package',
  p_description_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_HTTP package.',
  p_recommendation_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_HTTP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database', 
  p_policy_name =>'Public_Exec_Priv_Utl_Http',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_HTTP package',
  p_description_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_HTTP package.',
  p_recommendation_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_HTTP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

-- End of Public Execute Privileges on UTL_HTTP Package Policy

-- Start Public Execute Privileges on UTL_SMTP Package Policy

-- This Url will take user to USER EDIT SETTING PAGE
 -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE, 
  p_policy_name =>'Public_Exec_Priv_Utl_Smtp',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_SMTP package',
  p_description_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_SMTP package.',
  p_recommendation_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_SMTP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database', 
  p_policy_name =>'Public_Exec_Priv_Utl_Smtp',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_SMTP package',
  p_description_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_SMTP package.',
  p_recommendation_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_SMTP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

-- End of Public Execute Privileges on UTL_SMTP Package Policy
-- Metric may collect atmost four row per database target
-- One row per policy
-- These are violation row
-- Each Policy may result in one violation row
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB','NO'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'package',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Package',
                p_column_label_nlsid =>'PKG_COL'),
           MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'pubexecutePrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Public Execute Privileges on UTL_FILE,DBMS_JOB,DBMS_LOB',
      p_metric_label_nlsid => 'DBMSPKG_METRIC_LABEL',
      p_description  => 'Collect information of the system packages on which '||
                        'PUBLIC execute privileges has been granted',
      p_description_nlsid => 'PKG_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as package,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC can execute'' AND value in (''UTL_FILE'',''DBMS_SYS_SQL'',''DBMS_JOB'',''DBMS_LOB'')',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'package',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Package',
                p_column_label_nlsid =>'PKG_COL'),
           MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'pubexecutePrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Public Execute Privileges on UTL_FILE,DBMS_JOB,DBMS_LOB',
      p_metric_label_nlsid => 'DBMSPKG_METRIC_LABEL',
      p_description  => 'Collect information of the system packages on which '||
                        'PUBLIC execute privileges has been granted',
      p_description_nlsid => 'PKG_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as package,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC can execute'' AND value in (''UTL_FILE'',''DBMS_SYS_SQL'',''DBMS_JOB'',''DBMS_LOB'')',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
 
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'EXECUTE_UTL_FILE_Privileges_To_PUBLIC',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_FILE_PKG_NAME',    
  p_description =>'Ensure PUBLIC does not have EXECUTE privilege on the UTL_FILE package',
  p_description_nlsid =>'UTL_FILE_PKG_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can read and write arbitrary files in the system when granted  the UTL_FILE privilege.',
  p_impact_nlsid =>'UTL_FILE_PKG_IMPACT',
  p_recommendation => 'Revoke EXECUTE privileges granted  to UTL_FILE package from  PUBLIC.',
  p_recommendation_nlsid =>'UTL_FILE_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_FILE''',
  p_message =>'Database is in an insecure state. EXECUTE privilege on UTL_FILE package is granted to PUBLIC.',
  p_message_nlsid =>'UTL_FILE_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'EXECUTE_UTL_FILE_Privileges_To_PUBLIC',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_FILE_PKG_NAME',    
  p_description =>'Ensure PUBLIC does not have EXECUTE privilege on the UTL_FILE package',
  p_description_nlsid =>'UTL_FILE_PKG_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can read and write arbitrary files in the system when granted  the UTL_FILE privilege.',
  p_impact_nlsid =>'UTL_FILE_PKG_IMPACT',
  p_recommendation => 'Revoke EXECUTE privileges granted  to UTL_FILE package from  PUBLIC.',
  p_recommendation_nlsid =>'UTL_FILE_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_FILE''',
  p_message =>'Database is in an insecure state. EXECUTE privilege on UTL_FILE package is granted to PUBLIC.',
  p_message_nlsid =>'UTL_FILE_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList	
);
COMMIT;


  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_JOB',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_JOB_PKG_NAME',    
  p_description =>'Ensures PUBLIC is not granted EXECUTE privileges on DBMS_JOB package',
  p_description_nlsid =>'DBMS_JOB_PKG_DESC',
  p_impact => 'Granting EXECUTE privilege to PUBLIC on DBMS_JOB package allows users to schedule jobs on the database.',
  p_impact_nlsid =>'DBMS_JOB_PKG_IMPACT',
  p_recommendation =>'PUBLIC must not be granted EXECUTE privileges on  DBMS_JOB package.',
  p_recommendation_nlsid =>'DBMS_JOB_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_JOB''',
  p_message =>'Database is in an insecure state. DBMS_JOB package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_JOB_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_JOB',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_JOB_PKG_NAME',    
  p_description =>'Ensures PUBLIC is not granted EXECUTE privileges on DBMS_JOB package',
  p_description_nlsid =>'DBMS_JOB_PKG_DESC',
  p_impact => 'Granting EXECUTE privilege to PUBLIC on DBMS_JOB package allows users to schedule jobs on the database.',
  p_impact_nlsid =>'DBMS_JOB_PKG_IMPACT',
  p_recommendation =>'PUBLIC must not be granted EXECUTE privileges on  DBMS_JOB package.',
  p_recommendation_nlsid =>'DBMS_JOB_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_JOB''',
  p_message =>'Database is in an insecure state. DBMS_JOB package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_JOB_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_SYS_SQL',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_SYS_SQL_PKG_NAME',
  p_description =>'Ensures PUBLIC is not granted EXECUTE privileges on DBMS_SYS_SQL package',
  p_description_nlsid =>'DBMS_SYS_SQL_PKG_DESC', 
  p_impact => 'The DBMS_SYS_SQL package can be used to run PL/SQL and SQL as the owner of the procedure rather than the caller.',
  p_impact_nlsid =>'DBMS_SYS_SQL_PKG_IMPACT',
  p_recommendation =>'Revoke the EXECUTE privileges on DBMS_SYS_SQL package from the PUBLIC group.',
  p_recommendation_nlsid =>'DBMS_SYS_SQL_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_SYS_SQL''',
  p_message =>'Database is in an insecure state. DBMS_SYS_SQL package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_SYS_SQL_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_SYS_SQL',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_SYS_SQL_PKG_NAME',
  p_description =>'Ensures PUBLIC is not granted EXECUTE privileges on DBMS_SYS_SQL package',
  p_description_nlsid =>'DBMS_SYS_SQL_PKG_DESC', 
  p_impact => 'The DBMS_SYS_SQL package can be used to run PL/SQL and SQL as the owner of the procedure rather than the caller.',
  p_impact_nlsid =>'DBMS_SYS_SQL_PKG_IMPACT',
  p_recommendation =>'Revoke the EXECUTE privileges on DBMS_SYS_SQL package from the PUBLIC group.',
  p_recommendation_nlsid =>'DBMS_SYS_SQL_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_SYS_SQL''',
  p_message =>'Database is in an insecure state. DBMS_SYS_SQL package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_SYS_SQL_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_LOB',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_LOB_PKG_NAME',    
  p_description =>'Ensures PUBLIC group is not granted EXECUTE privileges to the DBMS_LOB package',
  p_description_nlsid =>'DBMS_LOB_PKG_DESC', 
  p_impact => 'The DBMS_LOB package can be used to access any file on the system as the owner of the Oracle software installation.',
  p_impact_nlsid =>'DBMS_LOB_PKG_IMPACT',
  p_recommendation =>'Revoke the EXECUTE privileges on DBMS_LOB package from the PUBLIC group.',
  p_recommendation_nlsid =>'DBMS_LOB_PKG_RECOMM',
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type => MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_LOB''',
  p_message =>'Database is in an insecure state. DBMS_LOB package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_LOB_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_LOB',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_LOB_PKG_NAME',    
  p_description =>'Ensures PUBLIC group is not granted EXECUTE privileges to the DBMS_LOB package',
  p_description_nlsid =>'DBMS_LOB_PKG_DESC', 
  p_impact => 'The DBMS_LOB package can be used to access any file on the system as the owner of the Oracle software installation.',
  p_impact_nlsid =>'DBMS_LOB_PKG_IMPACT',
  p_recommendation =>'Revoke the EXECUTE privileges on DBMS_LOB package from the PUBLIC group.',
  p_recommendation_nlsid =>'DBMS_LOB_PKG_RECOMM',
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type => MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_LOB''',
  p_message =>'Database is in an insecure state. DBMS_LOB package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_LOB_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB','NO'))
 ); 
  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,  -- Assuming some system priv can be given to pub
                p_column_label => 'System Privilege',
                p_column_label_nlsid =>'PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'systemPrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver, -- Applicable for 10gR1 + 10gR2
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'System Privileges to Public',
      p_metric_label_nlsid => 'PRIV_METRIC_LABEL',
      p_description  => 'Collect the information of  system privileges which has been granted to PUBLIC',
      p_description_nlsid => 'PRIV_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as privilege,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC has SYSTEM privilege''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'systemPrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver, -- Applicable for 10gR1 + 10gR2
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'System Privileges to Public',
      p_metric_label_nlsid => 'PRIV_METRIC_LABEL',
      p_description  => 'Collect the information of  system privileges which has been granted to PUBLIC',
      p_description_nlsid => 'PRIV_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as privilege,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC has SYSTEM privilege''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;
   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can revoke SYSTEM privs from db-users .
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));

  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'System_Privileges_To_Public',   --Policy name
  p_metric_name =>'systemPrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_SYSPRIV_NAME',    
  p_description =>'Ensure system privileges are not granted to PUBLIC',
  p_description_nlsid =>'PUB_SYSPRIV_DESC',
  p_impact =>'Privileges granted to the public role automatically apply to all users. '||
             'There are security risks granting SYSTEM privileges to all users.',
  p_impact_nlsid =>'PUB_SYSPRIV_IMPACT',
  p_recommendation =>'Revoke SYSTEM privileges from public.',
  p_recommendation_nlsid =>'PUB_SYSPRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. System privilege %privilege% is assigned to PUBLIC.',
  p_message_nlsid =>'PUB_SYSPRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'System_Privileges_To_Public',   --Policy name
  p_metric_name =>'systemPrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_SYSPRIV_NAME',    
  p_description =>'Ensure system privileges are not granted to PUBLIC',
  p_description_nlsid =>'PUB_SYSPRIV_DESC',
  p_impact =>'Privileges granted to the public role automatically apply to all users. '||
             'There are security risks granting SYSTEM privileges to all users.',
  p_impact_nlsid =>'PUB_SYSPRIV_IMPACT',
  p_recommendation =>'Revoke SYSTEM privileges from public.',
  p_recommendation_nlsid =>'PUB_SYSPRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. System privilege %privilege% is assigned to PUBLIC.',
  p_message_nlsid =>'PUB_SYSPRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB','NO'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbaccount',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Database User',
                p_column_label_nlsid =>'DBUSER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'defaultAccountPasswordsRep',	
      p_type_meta_ver =>l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Default Accounts Password',
      p_metric_label_nlsid => 'DFLT_ACCT_PWD_METRIC_LABEL',
      p_description  => 'Collect the information of default users and passwords',
      p_description_nlsid => 'DFLT_ACCT_PWD_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, property, value as dbaccount,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''Default account uid/pwd''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'defaultAccountPasswordsRep',	
      p_type_meta_ver =>l_10gR1_db_meta_ver,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Default Accounts Password',
      p_metric_label_nlsid => 'DFLT_ACCT_PWD_METRIC_LABEL',
      p_description  => 'Collect the information of default users and passwords',
      p_description_nlsid => 'DFLT_ACCT_PWD_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, property, value as dbaccount,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''Default account uid/pwd''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

    -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify default account setting for the known db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'dbaccount',
                p_url_link_template =>'database/security/user?oname=^dbaccount^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Default_Passwords',   --Policy name
  p_metric_name =>'defaultAccountPasswordsRep',      --Metric name
  p_policy_label_nlsid =>'DFLT_ACT_PWD_NAME',   
  p_description =>'Ensure there are no default passwords for known accounts',
  p_description_nlsid =>'DFLT_ACT_PWD_DESC',
  p_impact =>'A malicious user can gain access to the database using default passwords.',
  p_impact_nlsid =>'DFLT_ACT_PWD_IMPACT',
  p_recommendation =>'All default passwords should be changed.',
  p_recommendation_nlsid =>'DFLT_ACT_PWD_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. Default password for the account %dbaccount% has not been changed.',
  p_message_nlsid =>'DFLT_ACT_PWD_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Default_Passwords',   --Policy name
  p_metric_name =>'defaultAccountPasswordsRep',      --Metric name
  p_policy_label_nlsid =>'DFLT_ACT_PWD_NAME',   
  p_description =>'Ensure there are no default passwords for known accounts',
  p_description_nlsid =>'DFLT_ACT_PWD_DESC',
  p_impact =>'A malicious user can gain access to the database using default passwords.',
  p_impact_nlsid =>'DFLT_ACT_PWD_IMPACT',
  p_recommendation =>'All default passwords should be changed.',
  p_recommendation_nlsid =>'DFLT_ACT_PWD_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. Default password for the account %dbaccount% has not been changed.',
  p_message_nlsid =>'DFLT_ACT_PWD_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;


-- ------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------


-- ------------------------------------------------------------------------------------------------
-- Metric may collect one row per database target
-- These may be non-violation or violation row
-- Policy may result in one violation row

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Remote Login Passwordfile',
                p_column_label_nlsid =>'RMT_LOGIN_PWDFILE_COL_'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'remoteLoginPasswordFileRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Remote Login Password File',
      p_metric_label_nlsid => 'RMT_LOGIN_PWDFILE_METRIC_LABEL',
      p_description  => 'Collect the information of remote login password file',
      p_description_nlsid => 'RMT_LOGIN_PWDFILE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''remote_login_passwordfile''',
      p_snapshot_name_list => l_snapshot_list_inst_10gR1,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
 -- This Url will direct to Initialization Parameters page
 -- From you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=remote_login_passwordfile\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Remote_Password_File',   --Policy name
  p_metric_name =>'remoteLoginPasswordFileRep',      --Metric name
  p_policy_label_nlsid =>'RMT_LGIN_NAME',   
  --p_description =>'Ensure REMOTE_LOGIN_PASSWORDFILE initialization parameter is set to NONE',
  p_description =>'Ensures privileged users are authenticated by the operating '||
                  'system; that is, Oracle ignores any password file',
  p_description_nlsid =>'RMT_LGIN_DESC',
  --p_impact =>'A malicious user can gain access to the database if remote '||
  --      'password files are allowed.',
  p_impact =>'The REMOTE_LOGIN_PASSWORDFILE parameter specifies whether or '||
             'not Oracle checks for a password file. Because password files '||
             'contain the passwords for users, including SYS, the most secure '||
             'way of preventing an attacker from connecting through brute-force '||
             'password-related attacks is to require privileged users be '||
             'authenticated by the operating system.',
  p_impact_nlsid =>'RMT_LGIN_IMPACT',
  --p_recommendation =>'For non-RAC configurations, Oracle recommends setting '||
  --      'REMOTE_LOGIN_PASSWORDFILE to ''NONE''.',
  p_recommendation =>'Remove the password file and to set REMOTE_LOGIN_PASSWORDFILE '||
                     'to NONE.',
  p_recommendation_nlsid =>'RMT_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  --p_condition =>'upper(:value)=''SHARED''',
  --Bug 5435113: REMOTE_LOGIN_PASSWORDFILE = 'NONE' is recommended
  p_condition =>'upper(:value) <> ''NONE''',
  p_message =>'Database is in an insecure state. REMOTE_LOGIN_PASSWORDFILE '||
        'initialization parameter is set to %value%.',
  p_message_nlsid =>'RMT_LGIN_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT; 



-- Metric may collect one row per database target
-- These may be non-violation or violation row
-- Policy may result in one violation row
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Remote Os Authentication',
                p_column_label_nlsid =>'RMT_OS_AUTH_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'remoteAuthenticationRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Remote Os Authentication',
      p_metric_label_nlsid => 'RMT_OS_AUTH_METRIC_LABEL',
      p_description  => 'Collect the information of REMOTE_OS_AUTHENTICATION parameter setting',
      p_description_nlsid => 'RMT_OS_AUTH_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''remote_os_authent''',
      p_snapshot_name_list => l_snapshot_list_inst_10gR1,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
  -- This Url will direct to Initialization Parameters page
 -- From you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=remote_os_authent\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Remote_OS_Authentication',   --Policy name
  p_metric_name =>'remoteAuthenticationRep',      --Metric name
  p_policy_label_nlsid =>'RMT_ROLE_AUTH_NAME',   
  p_description =>'Ensure REMOTE_OS_AUTHENT initialization parameter is set to FALSE',
  p_description_nlsid =>'RMT_ROLE_AUTH_DESC',
  p_impact =>'A malicious user can gain access to the database if remote OS authentication is allowed.',
  p_impact_nlsid =>'RMT_ROLE_AUTH_IMPACT',
  p_recommendation =>'Set the REMOTE_OS_AUTHENT initialization parameter to FALSE.',
  p_recommendation_nlsid =>'RMT_ROLE_AUTH_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'upper(:value) <> ''FALSE''',
  p_message =>'Database is in an insecure state. REMOTE_OS_AUTHENT initialization parameter is set to %value%.',
  p_message_nlsid =>'RMT_ROLE_AUTH_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver, 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;


-- Metric may collect one row per database target
-- These may be non-violation or violation row
-- Policy may result in one violation row
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
   MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Remote Os Roles',
                p_column_label_nlsid =>'RMT_OS_ROLES_COL'));
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'remoteRolesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Remote Os Roles',
      p_metric_label_nlsid => 'RMT_OS_ROLES_METRIC_LABEL',
      p_description  => 'Collect the information of REMOTE_OS_ROLES parameter setting',
      p_description_nlsid => 'RMT_OS_ROLES_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''remote_os_roles''',
      p_snapshot_name_list => l_snapshot_list_inst_10gR1,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
 -- This Url will direct to Initialization Parameters page
 -- From you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=remote_os_roles\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Remote_OS_Role',   --Policy name
  p_metric_name =>'remoteRolesRep',      --Metric name
  p_policy_label_nlsid =>'RMT_OS_ROLE_NAME',   
  p_description =>'Ensure REMOTE_OS_ROLES initialization parameter is set to FALSE',
  p_description_nlsid =>'RMT_OS_ROLE_DESC',
  p_impact =>'A malicious user can gain access to the database if remote users can be granted privileged roles.',
  p_impact_nlsid =>'RMT_OS_ROLE_IMPACT',
  p_recommendation =>'Set the REMOTE_OS_ROLES initialization parameter to FALSE.',
  p_recommendation_nlsid =>'RMT_OS_ROLE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'upper(:value) <> ''FALSE''',
  p_message =>'Database is in an insecure state. REMOTE_OS_ROLES initialization parameter is set to %value%.',
  p_message_nlsid =>'RMT_OS_ROLE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver, 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;


-- To support 10gR1 agent version we need to write one policy and one metric
--------------------------------------------------------------------------------------------------
-- This metric collect all the dbuser which has unlimited failed login attmpt assigned thru some profile
-- There may be many rows and all will be violation row only.
-- The followig code is 10gR1 agent metric(unlimitedFailedLoginAttempts) impl
-- SELECT 'Unlimited login attempts', u.username
-- FROM dba_users u, dba_profiles p
-- WHERE           p.resource_name = 'FAILED_LOGIN_ATTEMPTS'
--        AND     u.profile = p.profile
--        AND     p.limit = 'UNLIMITED'
--        AND  rownum < 200
--ORDER BY u.username

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('NO'))
 );
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbuser',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'DATABASE USER',
                p_column_label_nlsid =>'DBUSER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'unlimitedFailedLoginAttempts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- applicable upto 10gR1 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Db Users with Unlimited Login Attempts',
      p_metric_label_nlsid => 'USR_FAILED_LOGIN_ATTEMPTS_METRIC_LABEL',
      p_description  => 'Collect setting of FAILED_LOGIN_ATTEMPTS',
      p_description_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
      p_source => pol_eval_func_10gR1,
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list, 
      p_end_type_meta_ver => l_10gR1_db_end_meta_ver-- applicable upto 10gR1 
 );
COMMIT ;
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'unlimitedFailedLoginAttempts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- applicable upto 10gR1 
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Db Users with Unlimited Login Attempts',
      p_metric_label_nlsid => 'USR_FAILED_LOGIN_ATTEMPTS_METRIC_LABEL',
      p_description  => 'Collect setting of FAILED_LOGIN_ATTEMPTS',
      p_description_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
      p_source => pol_eval_func_10gR1,
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list, 
      p_end_type_meta_ver => l_10gR1_db_end_meta_ver-- applicable upto 10gR1 
 );
COMMIT ;
  
  -- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
	         p_metric_column => 'dbuser'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
        MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Database_User_With_Unlimited_login_attempts',   --Policy name
  p_metric_name =>'unlimitedFailedLoginAttempts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'UNLMT_FAILED_LGIN_NAME',    
  p_description =>'Ensure that the number of allowed failed login attempts is set to a reasonable number of login attempts for all users',
  p_description_nlsid =>'USR_UNLMT_FAILED_LGIN_DESC',
  p_impact =>'Permits manual and automated password guessing by a malicious user.',
  p_impact_nlsid =>'UNLMT_FAILED_LGIN_IMPACT',
  p_recommendation =>'Oracle strongly recommends changing the parameter FAILED_LOGIN_ATTEMPTS '||
              'in user profiles to no more than 10.',
  p_recommendation_nlsid =>'UNLMT_FAILED_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as the UNLIMITED FAILED_LOGIN_ATTEMPTS is assigned to user %dbuser%.',
  p_message_nlsid =>'UNLMT_FAILED_LGIN1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_end_type_meta_ver => l_10gR1_db_end_meta_ver,	
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Database_User_With_Unlimited_login_attempts',   --Policy name
  p_metric_name =>'unlimitedFailedLoginAttempts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'UNLMT_FAILED_LGIN_NAME',    
  p_description =>'Ensure that the number of allowed failed login attempts is set to a reasonable number of login attempts for all users',
  p_description_nlsid =>'USR_UNLMT_FAILED_LGIN_DESC',
  p_impact =>'Permits manual and automated password guessing by a malicious user.',
  p_impact_nlsid =>'UNLMT_FAILED_LGIN_IMPACT',
  p_recommendation =>'Oracle strongly recommends changing the parameter FAILED_LOGIN_ATTEMPTS '||
              'in user profiles to no more than 10.',
  p_recommendation_nlsid =>'UNLMT_FAILED_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as the UNLIMITED FAILED_LOGIN_ATTEMPTS is assigned to user %dbuser%.',
  p_message_nlsid =>'UNLMT_FAILED_LGIN1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_end_type_meta_ver => l_10gR1_db_end_meta_ver,	
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;


-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('NO'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbuser',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'DATABASE USER(STATUS)',
                p_column_label_nlsid =>'DBUSER_STATUS_COL'),
         MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'installAndDemoAcccounts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default user account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list,
      p_end_type_meta_ver => l_10gR1_db_end_meta_ver-- Applicable for 10gR1 only
 );
COMMIT;
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'installAndDemoAcccounts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default user account''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list,
      p_end_type_meta_ver => l_10gR1_db_end_meta_ver-- Applicable for 10gR1 only
 );
COMMIT;

   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify account setting for the db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'dbuser',
                p_url_link_template =>'database/security/user?oname=^dbuser^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Well_known_Accounts_Status',   --Policy name 
  p_metric_name =>'installAndDemoAcccounts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT1_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as password status for db user is:%dbuser%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
  p_end_type_meta_ver => l_10gR1_db_end_meta_ver,	 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Well_known_Accounts_Status',   --Policy name 
  p_metric_name =>'installAndDemoAcccounts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT1_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as password status for db user is:%dbuser%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
  p_end_type_meta_ver => l_10gR1_db_end_meta_ver,	 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

--------------------------------

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'profile',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Profile',
                p_column_label_nlsid =>'PROFILE_COL'),    
   MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'limit',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Password Complexity Verification Function',
                p_column_label_nlsid =>'PWD_CMPLX_FN_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'pwdComplexityFnRep',       
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
      p_metric_label => 'Password Complexity Verification Function',
      p_metric_label_nlsid => 'PWD_CMPLX_FN_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_VERIFY_FUNCTION',
      p_description_nlsid => 'PWD_CMPLX_FN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_complexity_fn''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'pwdComplexityFnRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Password Complexity Verification Function',
      p_metric_label_nlsid => 'PWD_CMPLX_FN_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_VERIFY_FUNCTION',
      p_description_nlsid => 'PWD_CMPLX_FN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_complexity_fn''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
--Policies


  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
	         p_metric_column => 'profile', 
    		 p_url_link_template =>'database/security/profile?oname=^profile^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
    		 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
      	MGMT_VIOL_CTXT_DEF.NEW(
		     p_metric_column => 'limit'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
                
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Password_Complexity_Fn_Usage',   --Policy name
  p_metric_name =>'pwdComplexityFnRep',      --Metric name
  p_policy_label_nlsid =>'PWD_CMPLX_FN_NAME',   --Password Complexity Verification Function 
  p_description =>'Ensures PASSWORD_VERIFY_FUNCTION resource for the profile is set',
  p_description_nlsid =>'PWD_CMPLX_FN_DESC',
  p_impact => 'Having passwords that do not meet minimum complexity requirements offer '||
              'substantially less protection than complex passwords.',
  p_impact_nlsid =>'PWD_CMPLX_FN_IMPACT',
  p_recommendation =>'Set the PASSWORD_VERIFY_FUNCTION resource of the profile.',
  p_recommendation_nlsid =>'PWD_CMPLX_FN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => ':limit = ''NULL''',
  p_message =>'Database is in an insecure state. PASSWORD_VERIFY_FUNCTION resource is not set for the profile %profile%.',
  p_message_nlsid =>'PWD_CMPLX_FN_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Password_Complexity_Fn_Usage',   --Policy name
  p_metric_name =>'pwdComplexityFnRep',      --Metric name
  p_policy_label_nlsid =>'PWD_CMPLX_FN_NAME',   --Password Complexity Verification Function 
  p_description =>'Ensures PASSWORD_VERIFY_FUNCTION resource for the profile is set',
  p_description_nlsid =>'PWD_CMPLX_FN_DESC',
  p_impact => 'Having passwords that do not meet minimum complexity requirements offer '||
              'substantially less protection than complex passwords.',
  p_impact_nlsid =>'PWD_CMPLX_FN_IMPACT',
  p_recommendation =>'Set the PASSWORD_VERIFY_FUNCTION resource of the profile.',
  p_recommendation_nlsid =>'PWD_CMPLX_FN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => ':limit = ''NULL''',
  p_message =>'Database is in an insecure state. PASSWORD_VERIFY_FUNCTION  resource is not set for the profile %profile%.',
  p_message_nlsid =>'PWD_CMPLX_FN_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'object',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object',
                p_column_label_nlsid =>'OBJECT_COL'),    
   MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'InsFailRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Audit of Insert Failures',
      p_metric_label_nlsid => 'INSERT_FAILURE_LABEL',
      p_description  => 'Collects objects for which insert failures are not audited',
      p_description_nlsid => 'INSERT_FAILURE_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      --p_source =>'SELECT target_guid, value as object, value2 as dummy '
      --p_source =>'SELECT target_guid, REGEXP_REPLACE(value, ''\$'', ''\$'') as object, value2 as dummy '
      p_source =>'SELECT target_guid, value as object, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''insert_failure''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'InsFailRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  
      p_metric_label => 'Audit of Insert Failures',
      p_metric_label_nlsid => 'INSERT_FAILURE_LABEL',
      p_description  => 'Collects objects for which insert failures are not audited',
      p_description_nlsid => 'INSERT_FAILURE_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as object, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''insert_failure''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;


  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
             p_metric_column => 'object',
             p_url_link_template =>'database/security/profile?oname=^object^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
             p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'CRITICAL_OBJECT_LIST',
                param_name_nlsid => 'CRITICAL_OBJECT_LIST_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_STRING));
  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'CRITICAL_OBJECT_LIST',
                p_warn_threshold => ''));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Audit_Insert_Failure',   --Policy name
  p_metric_name =>'InsFailRep',      --Metric name
  p_policy_label_nlsid =>'INSERT_FAILURE_NAME',    
  p_description =>'Ensures that insert failures are audited for critical data objects',
  p_description_nlsid =>'INSERT_FAILURE_DESC',
  p_impact => 'Not auditing insert failures for critical data objects may allow a malicious user to infiltrate system security..',
  p_impact_nlsid =>'INSERT_FAILURE_IMPACT',
  p_recommendation =>'Audit insert failures for critical data objects.',
  p_recommendation_nlsid =>'INSERT_FAILURE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  --p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||REGEXP_REPLACE(:object, '\\$', '\\$')||''( *)($|(,(.*)))'', ''i'' )',
  p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||REGEXP_REPLACE(REGEXP_REPLACE(:object, ''\\$'', ''\\$''), ''\\.'', ''\\.'')||''( *)($|(,(.*)))'', ''i'' )',
  p_message =>'System is in an insecure state. Insert failures for critical data objects are not audited.',
  p_message_nlsid =>'INSERT_FAILURE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Audit_Insert_Failure',   --Policy name
  p_metric_name =>'InsFailRep',      --Metric name
  p_policy_label_nlsid =>'INSERT_FAILURE_NAME',    
  p_description =>'Ensures that insert failures are audited for critical data objects',
  p_description_nlsid =>'INSERT_FAILURE_DESC',
  p_impact => 'Not auditing insert failures for critical data objects may allow a malicious user to infiltrate system security.',
  p_impact_nlsid =>'INSERT_FAILURE_IMPACT',
  p_recommendation =>'Audit insert failures for critical data objects.',
  p_recommendation_nlsid =>'INSERT_FAILURE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  --p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||REGEXP_REPLACE(:object, '\$', '\$')||''( *)($|(,(.*)))'', ''i'' )',
  --p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||:object||''( *)($|(,(.*)))'', ''i'' )',
  p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||REGEXP_REPLACE(REGEXP_REPLACE(:object, ''\\$'', ''\\$''), ''\\.'', ''\\.'')||''( *)($|(,(.*)))'', ''i'' )',
  --p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||:object||''( *)($|(,(.*)))'' ',
  p_message =>'System is in an insecure state. Insert failures for critical data objects are not audited.',
  p_message_nlsid =>'INSERT_FAILURE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;



l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'account',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Account',
                p_column_label_nlsid =>'ACCOUNT_COL'),    
   MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'proxyAcctRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,   			
      p_metric_label => 'proxy_account',
      p_metric_label_nlsid => 'PROXY_ACCOUNT_LABEL',
      p_description  => 'Collect proxy acounts with privilege other than CREATE SESSION',
      p_description_nlsid => 'PROXY_ACCOUNT_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as account, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''proxy_account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'proxyAcctRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,   			
      p_metric_label => 'proxy_account',
      p_metric_label_nlsid => 'PROXY_ACCOUNT_METRIC_DESC',
      p_description  => 'Collect proxy acounts with privilege other than CREATE SESSION',
      p_description_nlsid => 'PROXY_ACCOUNT_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as account, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''proxy_account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;


  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                 p_metric_column => 'account',
                 p_url_link_template =>'database/security/user?oname=^account^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
                 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'ACCOUNT_LIST',
                p_warn_threshold => ''));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));



                
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Proxy_Account',   --Policy name
  p_metric_name =>'proxyAcctRep',      --Metric name
  p_policy_label_nlsid =>'PROXY_ACCOUNT_NAME',    
  p_description =>'Ensures that the proxy accounts have limited privileges',
  p_description_nlsid =>'PROXY_ACCOUNT_DESC',
  p_impact => 'The proxy user only needs to connect to the database. Once connected it will use the privileges of the user it is connecting on behalf of. Granting any other privilege than the CREATE SESSION privilege to the proxy user is unnecessary and open to misuse.',
  p_impact_nlsid =>'PROXY_ACCOUNT_IMPACT',
  p_recommendation =>'Limit the privileges of the proxy accounts to CREATE SESSION.',
  p_recommendation_nlsid =>'PROXY_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'rownum > 0',
  p_message =>'The database may be in an insecure state as the proxy user %account% has privileges other than CREATE SESSION.',
  p_message_nlsid =>'PROXY_ACCOUNT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Proxy_Account',   --Policy name
  p_metric_name =>'proxyAcctRep',      --Metric name
  p_policy_label_nlsid =>'PROXY_ACCOUNT_NAME',    
  p_description =>'Ensures that the proxy accounts have limited privileges',
  p_description_nlsid =>'PROXY_ACCOUNT_DESC',
  p_impact => 'The proxy user only needs to connect to the database. Once connected it will use the privileges of the user it is connecting on behalf of. Granting any other privilege than the CREATE SESSION privilege to the proxy user is unnecessary and open to misuse.',
  p_impact_nlsid =>'PROXY_ACCOUNT_IMPACT',
  p_recommendation =>'Limit the privileges of the proxy accounts to CREATE SESSION.',
  p_recommendation_nlsid =>'PROXY_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'rownum > 0',
  p_message =>'The database may be in an insecure state as the proxy user %account% has privileges other than CREATE SESSION..',
  p_message_nlsid =>'PROXY_ACCOUNT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;





--------------->>WINDOWS_PLATFORM<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'domain',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Domain Controller',
                p_column_label_nlsid =>'DOMAIN_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'winPlatformNTRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,  --NT metrics use the same category prop as the UNIX ones
      p_metric_type => l_metric_type ,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Domain Controller',
      p_metric_label_nlsid => 'WIN_PLATFORM_METRIC_LABEL',
      p_description  => 'Collect if Oracle installed on a Domain Controller',
      p_description_nlsid => 'WIN_PLATFORM_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, value as domain '
       ||' FROM esm_collection_latest '
       ||'WHERE property =''win_plat''',
  p_snapshot_name_list => l_snapshot_list_inst_10gR2,
  p_metric_column_list => l_metric_column_list  
 ) ;

COMMIT ;
  

l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'domain')
  );
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'winPlatformNT',   --Policy name
  p_metric_name =>'winPlatformNTRep',      --Metric name
  p_policy_label_nlsid =>'WIN_PLATFORM_NAME', 
  p_description =>'Ensures that Oracle is not installed on a domain controller',
  p_description_nlsid =>'WIN_PLATFORM_DESC',
  p_impact => 'Installing Oracle on a domain controller can cause serious security issues.',
  p_impact_nlsid =>'WIN_PLATFORM_IMPACT',
  p_recommendation =>'Oracle must only be installed on a domain member server or a standalone server.',
  p_recommendation_nlsid =>'WIN_PLATFORM_RECOMM' ,
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Oracle installed on a domain controller.',
  p_message_nlsid =>'WIN_PLATFORM_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
---------------<<WINDOWS_PLATFORM>>-------------------------



--------------->>DRIVE_PERM<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'User',
                p_column_label_nlsid =>'USER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'drivePermNTRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,  --NT metrics use the same category prop as the UNIX ones
      p_metric_type => l_metric_type ,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  
      p_metric_label => 'Drive permissions',
      p_metric_label_nlsid => 'DRIVE_PERM_METRIC_LABEL',
      p_description  => 'Collect Oracle installed drive permissions',
      p_description_nlsid => 'DRIVE_PERM_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, value as users, '
       ||'value as dummy FROM esm_collection_latest '
       ||'WHERE property =''drive_perm''',
  p_snapshot_name_list => l_snapshot_list_inst_10gR2,
  p_metric_column_list => l_metric_column_list  
 ) ;

COMMIT ;
  

l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users')
  );
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'drivePermNT',   --Policy name
  p_metric_name =>'drivePermNTRep',      --Metric name
  p_policy_label_nlsid =>'DRIVE_PERM_NAME', 
  p_description =>'On Windows, ensures that the installed Oracle Home drive is not accessible to Everyone Group',
  p_description_nlsid =>'DRIVE_PERM_DESC',
  p_impact => 'Giving permission of Oracle installed drive to everyone can cause serious security issues.',
  p_impact_nlsid =>'DRIVE_PERM_IMPACT',
  p_recommendation =>'The installed Oracle Home drive should not be accessible to Everyone Group.',
  p_recommendation_nlsid =>'DRIVE_PERM_RECOMM' ,
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Oracle installed drive is accessible to Everyone Group.',
  p_message_nlsid =>'DRIVE_PERM_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
---------------<<DRIVE_PERM>>-------------------------


--------------->>DOMAIN_USERS<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'domainusers',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Domain Users',
                p_column_label_nlsid =>'DOMAIN_USERS_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'domainUserGrpNTRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,  --NT metrics use the same category prop as the UNIX ones
      p_metric_type => l_metric_type ,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  
      p_metric_label => 'Domain users group',
      p_metric_label_nlsid => 'DOMAIN_USERS_METRIC_LABEL',
      p_description  => 'Collect if local account has domain users group on a server',
      p_description_nlsid => 'DOMAIN_USERS_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, value as domainusers '
       ||' FROM esm_collection_latest '
       ||'WHERE property =''domain_user_grp''',
  p_snapshot_name_list => l_snapshot_list_inst_10gR2,
  p_metric_column_list => l_metric_column_list  
 ) ;

COMMIT ;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'domainusers')
  );
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'domainUserGrpNT',   --Policy name
  p_metric_name =>'domainUserGrpNTRep',      --Metric name
  p_policy_label_nlsid =>'DOMAIN_USERS_NAME', 
  p_description =>'Ensures domain server local Users group does not have Domain Users group',
  p_description_nlsid =>'DOMAIN_USERS_DESC',
  p_impact => 'Including Domain Users group in local Users group of a domain server can cause serious security issues.',
  p_impact_nlsid =>'DOMAIN_USERS_IMPACT',
  p_recommendation =>'Remove Domain Users group form local Users group.',
  p_recommendation_nlsid =>'DOMAIN_USERS_RECOMM' ,
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Domain servers local Users group has Domain Users group.',
  p_message_nlsid =>'DOMAIN_USERS_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
---------------<<DOMAIN_USERS>>-------------------------


--------------->>WIN_TOOLS<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'winToolsNTRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,  --NT metrics use the same category prop as the UNIX ones
      p_metric_type => l_metric_type ,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  
      p_metric_label => 'Windows Tools Permissions',
      p_metric_label_nlsid => 'WIN_TOOLS_METRIC_LABEL',
      p_description  => 'Collect if Oracle service have permission on windows tools',
      p_description_nlsid => 'WIN_TOOLS_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, value as filename, '
       ||'value as dummy FROM esm_collection_latest '
       ||'WHERE property =''win_tools''',
  p_snapshot_name_list => l_snapshot_list_inst_10gR2,
  p_metric_column_list => l_metric_column_list  
 ) ;

COMMIT ;
  

l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename')
  );
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'winToolsNT',   --Policy name
  p_metric_name =>'winToolsNTRep',      --Metric name
  p_policy_label_nlsid =>'WIN_TOOLS_NAME', 
  p_description =>'Ensures Oracle service does not have permissions on windows tools',
  p_description_nlsid =>'WIN_TOOLS_DESC',
  p_impact => 'Granting Oracle service the permissions of windows tools may cause serious securty issues.',
  p_impact_nlsid =>'WIN_TOOLS_IMPACT',
  p_recommendation =>'Remove Windows tools permission from Oracle service account.',
  p_recommendation_nlsid =>'WIN_TOOLS_RECOMM' ,
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Oracle service account has permissions of windows tool (%filename%).',
  p_message_nlsid =>'WIN_TOOLS_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
---------------<<WIN_TOOLS>>-------------------------

--------------->>windows specific policies<<-------------------------
 
--tkrpof
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'tkprofRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'tkprof  Permission', 
      p_metric_label_nlsid => 'TKPROF_METRIC_LABEL',
      p_description  => 'Collect permissions of  tkprof file',
      p_description_nlsid => 'TKPROF_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_tkprof_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'tkprofNT',   --Policy name
  p_metric_name =>'tkprofRepNT',      --Metric name
  p_policy_label_nlsid =>'TKPROF_NAME_NT', 
  p_description =>'Ensures tkprof executable file permissions are restricted to read and execute for the group, and inaccessible to public',
  p_description_nlsid =>'TKPROF_DESC',
  p_impact => 'Excessive permission for tkprof leaves information within, unprotected.',
  p_impact_nlsid =>'TKPROF_IMPACT',
  p_recommendation =>'Remove tkprof executable if not required. Otherwise, file permissions for tkprof executable should be restricted to read and execute for the group, and inaccessible to public.',
  p_recommendation_nlsid =>'TKPROF_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the tkprof executable file (%filename%).',
  p_message_nlsid =>'TKPROF_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;


--------------->>sqlplus perm<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))); 
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlplusRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'sqlplus  Permission', 
      p_metric_label_nlsid => 'SQLPLUS_METRIC_LABEL',
      p_description  => 'Collect permissions  sqlplus executable file',
      p_description_nlsid => 'SQLPLUS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest '
                 ||'WHERE property=''nt_sqlplus_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));


 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlplusNT',   --Policy name
  p_metric_name =>'sqlplusRepNT',      --Metric name
  p_policy_label_nlsid =>'SQLPLUS_NAME_NT', 
  p_description =>'Ensures that SQL*Plus executable file permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SQLPLUS_DESC',
  p_impact => 'SQL*Plus allows a user to execute any SQL on the database provided the user has an account with appropriate privileges. Public execute permissions on SQL*Plus can cause security issues by exposing sensitive data to malicious users.',
  p_impact_nlsid =>'SQLPLUS_IMPACT',
  p_recommendation =>'Restrict file permissions for SQL*Plus executable to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SQLPLUS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the SQL*Plus executable file (%filename%).',
  p_message_nlsid =>'SQLPLUS_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<sqlplus perm>>-------------------------




--------------->>WEBCACHE<<-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'Users_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'webcacheRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'webcache  Permission', 
      p_metric_label_nlsid => 'WEBCACHE_METRIC_LABEL',
      p_description  => 'Collect permissions of  webcache.xml file',
      p_description_nlsid => 'WEBCACHE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_webcache_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'WebcacheNT',   --Policy name
  p_metric_name =>'webcacheRepNT',      --Metric name
  p_policy_label_nlsid =>'WEBCACHE_NAME_NT', 
  p_description =>'Ensures the Webcache initialization file (webcache.xml) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'WEBCACHE_DESC',
  p_impact => 'Webcache stores sensitive information in the initialization file (webcache.xml). A publicly accessible Webcache initialization file can be used to extract sensitive data like the administrator password hash.',
  p_impact_nlsid =>'WEBCACHE_IMPACT',
  p_recommendation =>'Restrict Webcache initialization file (webcache.xml) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'WEBCACHE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have critical permissions on the Webcache initialization file (%filename%).',
  p_message_nlsid =>'WEBCACHE_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<WEBCACHE>>-------------------------


---------------<<SNMP_RO>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'snmp_roRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'snmp_ro Permission', 
      p_metric_label_nlsid => 'SNMP_RO_METRIC_LABEL',
      p_description  => 'Collect permissions of  snmp_ro.ora file',
      p_description_nlsid => 'SNMP_RO_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_snmp_ro_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Snmp_roNT',   --Policy name
  p_metric_name =>'snmp_roRepNT',      --Metric name
  p_policy_label_nlsid =>'SNMP_RO_NAME_NT', 
  p_description =>'Ensures Oracle Agent SNMP read-only configuration file (snmp_ro.ora) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SNMP_RO_DESC',
  p_impact => 'The Oracle Agent SNMP read-only configuration file (snmp_ro.ora) contains the listening address of the agent, the names of SQL*Net listener and Oracle database services it knows about, plus tracing parameters. A publicly accessible SNMP read-only configuration file can be used to extract sensitive data like the tracing directory location, dbsnmp address, etc.',
  p_impact_nlsid =>'SNMP_RO_IMPACT',
  p_recommendation =>'Restrict Oracle Agent SNMP read-only configuration file (snmp_ro.ora) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SNMP_RO_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle Agent SNMP read-only configuration file (%filename%).',
  p_message_nlsid =>'SNMP_RO_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<SNMP_RO>>-------------------------

---------------<<SNMP_RW>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'snmp_rwRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'snmp_rw  Permission', 
      p_metric_label_nlsid => 'SNMP_RW_METRIC_LABEL',
      p_description  => 'Collect permissions of snmp_rw.ora file',
      p_description_nlsid => 'SNMP_RW_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_snmp_rw_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Snmp_rwNT',   --Policy name
  p_metric_name =>'snmp_rwRepNT',      --Metric name
  p_policy_label_nlsid =>'SNMP_RW_NAME_NT', 
  p_description =>'Ensures Oracle Agent SNMP read-write configuration file (snmp_rw.ora) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SNMP_RW_DESC',
  p_impact => 'The Oracle Agent SNMP read-write configuration file (snmp_ro.ora) contains the listening address of the agent, the names of SQL*Net listener and Oracle database services it knows about, plus tracing parameters. A publicly accessible SNMP read-write configuration file can be used to extract sensitive data like the tracing directory location, dbsnmp address, etc.',
  p_impact_nlsid =>'SNMP_RW_IMPACT',
  p_recommendation =>'Restrict Oracle Agent SNMP read-write configuration file (snmp_rw.ora) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SNMP_RW_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle Agent SNMP read-write configuration file (%filename%).',
  p_message_nlsid =>'SNMP_RW_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<SNMP_RW>>-------------------------

---------------<<WDBSVR>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'wdbsvrRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'wdbsvr.app  Permission', 
      p_metric_label_nlsid => 'WDBSVR_METRIC_LABEL',
      p_description  => 'Collect permissions of  wdbsvr.app file',
      p_description_nlsid => 'WDBSVR_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_wdbsvr_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'WdbsvrNT',   --Policy name
  p_metric_name =>'wdbsvrRepNT',      --Metric name
  p_policy_label_nlsid =>'WDBSVR_NAME_NT', 
  p_description =>'Oracle HTTP Server mod_plsql Configuration file (wdbsvr.app) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'WDBSVR_DESC',
  p_impact => 'The Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) contains the Database Access Descriptors used for authentication. A publicly accessible mod_plsql configuration file can allow a malicious user to modify the Database Access Descriptor settings to gain access to PL/SQL applications or launch a Denial Of Service attack.',
  p_impact_nlsid =>'WDBSVR_IMPACT',
  p_recommendation =>'Restrict Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'WDBSVR_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle HTTP Server mod_plsql configuration file (%filename%).',
  p_message_nlsid =>'WDBSVR_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<WDBSVR>>-------------------------

--------------->>XSQL<<-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'xsqlRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'XSQLConfig.xml  Permission', 
      p_metric_label_nlsid => 'XSQL_METRIC_LABEL',
      p_description  => 'Collect permissions of  XSQLConfig.xml file',
      p_description_nlsid => 'XSQL_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_xsql_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'XsqlNT',   --Policy name
  p_metric_name =>'xsqlRepNT',      --Metric name
  p_policy_label_nlsid =>'XSQL_NAME_NT', 
  p_description =>'Ensures Oracle XSQL Configuration File  (XSQLConfig.xml) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'XSQL_DESC',
  p_impact => 'The Oracle XSQL configuration file (XSQLConfig.xml) contains sensitive database connection information. A publicly accessible XSQL configuration file can expose the database username and password that can be used access sensitive data or to launch further attacks.',
  p_impact_nlsid =>'XSQL_IMPACT',
  p_recommendation =>'Restrict Oracle XSQL Configuration file (XSQLConfig.xml) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'XSQL_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle XSQL Configuration file (%filename%).',
  p_message_nlsid =>'XSQL_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;
---------------<<XSQL>>-------------------------


---------------<<HTACCESS>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'htaccessRepNT',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,

      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => '.htaccess  Permission', 
      p_metric_label_nlsid => 'HTACCESS_METRIC_LABEL',
      p_description  => 'Collect permissions of  .htaccess file',
      p_description_nlsid => 'HTACCESS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_htperm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'HtaccessNT',   --Policy name
  p_metric_name =>'htaccessRepNT',      --Metric name
  p_policy_label_nlsid =>'HTACCESS_NAME_NT', 
  p_description =>'Ensures Oracle HTTP Server Distributed Configuration Files permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'HTACCESS_DESC',
  p_impact => 'The Oracle HTTP Server distributed configuration file (usually .htaccess) is used for access control and authentication of web folders. This file can be modified to gain access to pages containing sensitive information.',
  p_impact_nlsid =>'HTACCESS_IMPACT',
  p_recommendation =>'Restrict Oracle HTTP Server Distributed configuration files access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'HTACCESS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle HTTP Server distributed configuration file (%filename%).',
  p_message_nlsid =>'HTACCESS_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

---------------<<HTACCESS>>-------------------------


---------------<<windows specific policies>>-------------------------

END ;
/
show errors ;
SET ESCAPE OFF ;

