Rem
Rem $Header: lsnr_policies.sql 12-jan-2007.12:11:34 manosing Exp $
Rem
Rem lsnr_policies.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      lsnr_policies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    manosing    01/12/07 - XbranchMerge manosing_lastpols from main
Rem    manosing    01/10/07 - translation modifications
Rem    manosing    10/09/06 - 10.2.0.4 
Rem    dsukhwal    09/09/05 - change name of Windows policies 
Rem    dkjain      06/16/05 - Hide the rep metrics 
Rem    dsukhwal    06/08/05 - add policies for NT
Rem    dsukhwal    05/17/05 - move sqlnet policies to listener 
Rem    dkjain      02/18/05 - Fixed bug-4128312 
Rem    dkjain      01/30/05 - UI text modified. 
Rem    dsukhwal    01/12/05 - handle permissions in octal 
Rem    dsukhwal    12/31/04 - Split policies 
Rem    dsukhwal    12/14/04 - Handle listener.ora permissions in rwx 
Rem                           format(bug 4057002) 
Rem    dsukhwal    12/13/04 - severity of Lsnr_Host_Name 
Rem    dkjain      12/05/04 - Changing policy eval condition 
Rem    dsukhwal    11/22/04 - One metric per policy 
Rem    dkjain      11/07/04 - Changing property value for the bacward compataibility
Rem    dkjain      10/18/04 - Fix for evaluation error 
Rem    dkjain      10/14/04 - dkjain_esa_mv_db_policies
Rem    dkjain      10/14/04 - Created
Rem


DECLARE
 -- Metric Variable
 l_metric_column_list                           MGMT_METRIC_COLUMN_ARRAY;
 l_metric_type                    NUMBER ;
 l_snapshot_list                MGMT_SNAPSHOT_ARRAY; 
 -- Policy Variable
 l_ctxList                             MGMT_VIOL_CTXT_DEF_ARRAY; 
 l_paramDefList                            MGMT_POLICY_PARAM_DEF_ARRAY;
 l_defaultParamValList                    MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList                      MGMT_POLICY_KEY_VAL_ARRAY;
BEGIN
  l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE ;
  l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => ESM.LSNR_TARGET_TYPE,
                p_snapshot_name =>ESM.SECURITY_SNAPSHOT_TYPE));

---NEW metrics, one per policy START-----------------------------------
----lsnrDirectAdminMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. Which is also why we do not need a key column.
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'admin_status',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Direct Administration Status',
                p_column_label_nlsid =>'ADMIN_STATUS_COL'));
              
  MGMT_METRIC.CREATE_METRIC(--used by policy Listener_Direct_Administration
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrDirectAdminMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Direct Administration',
      p_metric_label_nlsid => 'LSNR_DIRECT_ADMIN_METRIC_LABEL',
      p_description  => 'Collect listener direct administration parameter',
      p_description_nlsid => 'LSNR_DIRECT_ADMIN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as admin_status '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''listenerAdmin''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----Listener_Direct_Administration POLICY START-----------------------
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'admin_status'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Listener_Direct_Administration',   --Policy name
  p_metric_name => 'lsnrDirectAdminMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_DIRECT_ADMIN_NAME',   --policylabelnlsid
  p_description  => 'Ensures that no runtime modifications to the listener configuration is allowed',
  p_description_nlsid =>'LSNR_DIRECT_ADMIN_DESC',    --Policy Decription NLSID
  p_impact =>'An attacker who has access to a running listener can perform runtime modifications (for example, SET operations) using the lsnrctl program.', 
  p_impact_nlsid =>'LSNR_DIRECT_ADMIN_IMPACT',  --Impact NLSID
  p_recommendation =>'All listeners must have direct administration disabled. Set ADMIN_RESTRICTIONS_listener_name to ON in listener.ora.', --Recommendation
  p_recommendation_nlsid =>'LSNR_DIRECT_ADMIN_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'UPPER(:admin_status)<>''ON'' AND UPPER(:admin_status)<>''TRUE''', --condition
  p_message =>'Listener is in an insecure state. Direct administration is enabled.',  --message
  p_message_nlsid =>'LSNR_DIRECT_ADMIN_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION, 
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --consider percentage
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----Listener_Direct_Administration POLICY END-----------------
----lsnrDirectAdminMetricRep METRIC END-----------------------


----lsnrHostNameMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. Uniqueness of hostname is being taken 
--care of at the agent side, and hence it can be a key column. This would enable the user to exclude a particular 
--hostname from being reported as a violation even if not specified as IP address. consider_percentage will give 
--the percentage of hostnames of that listener which are violating/non-violating(a listener can have a list of 
--addresses, each of which can have a hostname)
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required column(host_name) has to be a key column, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'host_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Host Name',
                p_column_label_nlsid =>'HOST_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy lsnr_Host_Name
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrHostNameMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Host Name',
      p_metric_label_nlsid => 'LSNR_HOST_NAME_METRIC_LABEL',
      p_description  => 'Collect listener hostname parameter',
      p_description_nlsid => 'LSNR_HOST_NAME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid ,value as host_name,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''host_name''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy lsnr_Host_Name Start ----------------------------
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'host_name'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Host_Name',   --Policy name
  p_metric_name => 'lsnrHostNameMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_HOST_NAME_NAME',   --policylabelnlsid
  p_description  => 'Ensures that the listener host is specified as IP address and not hostname in the listener.ora',
  p_description_nlsid =>'LSNR_HOST_NAME_DESC',    --Policy Decription NLSID
  p_impact =>'An insecure Domain Name System (DNS) Server can be taken advantage of for mounting a spoofing attack. Name server failure can result in the listener unable to resolved the host.', --Impact
  p_impact_nlsid =>'LSNR_HOST_NAME_IMPACT',  --Impact NLSID
  p_recommendation =>'Host should be specified as IP address in listener.ora.', --Recommendation
  p_recommendation_nlsid =>'LSNR_HOST_NAME_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'instr(translate(lower(:host_name), ''abcdefghijklmnopqrstuvwxyz'', ''aaaaaaaaaaaaaaaaaaaaaaaaaa''),''a'') > 0', --condition
  p_message =>'Host is not specified as IP address in listener.ora.',  --message
  p_message_nlsid =>'LSNR_HOST_NAME_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE, 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy lsnr_Host_Name End----------------------------
----lsnrHostNameMetricRep  METRIC END-----------------------


----lsnrLogFileOwnerMetricRep METRIC START-----------------------
--Only violating rows are pushed from the agent. So consider percentage is false. A listener can apparently have 
--only one logfile. Still, keeping 2 key columns to enable the user to exclude a pair of (owner_name,log_file_name) 
--from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required columns have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'File Owner',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Log File',
                p_column_label_nlsid =>'LOG_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy lsnr_Ora_Logfile_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrLogFileOwnerMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Log File Owner',
      p_metric_label_nlsid => 'LSNR_LOG_FILE_OWN_METRIC_LABEL',
      p_description  => 'listener logfile owner',
      p_description_nlsid => 'LSNR_LOG_FILE_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid ,value as file_name, value2 as file_owner,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''log_file_lsnr_own'' ',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Logfile_Own_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_owner'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Logfile_Own_Policy',   --Policy name
  p_metric_name => 'lsnrLogFileOwnerMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_LOG_FILE_OWN_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the listener log file is owned by the Oracle software owner',  
  p_description_nlsid =>'LSNR_LOG_FILE_OWN_DESC',    --Policy Decription NLSID
  p_impact =>'The information in the logfile can reveal important network and database connection details. Having a log file not owned by the Oracle software owner can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_LOG_FILE_OWN_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener logfile must be owned by Oracle software owner.', --Recommendation
  p_recommendation_nlsid =>'LSNR_LOG_FILE_OWN_RECOMM',  --Recommendation NLSID
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  --p_condition =>':property = ''log_file_listener''', --condition
  p_condition =>'rownum > 0', --condition
  p_message =>'The listener is in an insecure state. The listener log file %file_name% is owned by %file_owner%.', 
  p_message_nlsid =>'LSNR_LOG_FILE_OWN_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Logfile_Own_Policy End ----------------------------
----lsnrLogFileOwnerMetricRep  METRIC END-----------------------



----lsnrLogFilePermMetricRep METRIC UNIX START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. A listener can apparently have 
--only one logfile. Still, keeping 2 key columns to enable the user to exclude a pair of (permission,log_file_name) 
--from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required columns have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Log File Permission',
                p_column_label_nlsid =>'LOG_FILE_PER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Log File',
                p_column_label_nlsid =>'LOG_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Logfile_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrLogFilePermMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Lsnr Log File Permission',
      p_metric_label_nlsid => 'LSNR_LOG_FILE_PERM_METRIC_LABEL',
      p_description  => 'Listener logfile permission',
      p_description_nlsid => 'LSNR_LOG_FILE_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as file_name, value2 as file_permission,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''log_file_lsnr_perm'' ',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Logfile_Perm_Policy UNIX Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_permission'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Logfile_Perm_Policy',   --Policy name
  p_metric_name => 'lsnrLogFilePermMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_LOG_FILE_PERM_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the listener logfile cannot be read by  or written to by public',  
  p_description_nlsid =>'LSNR_LOG_FILE_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'The information in the logfile can reveal important network and database connection details. Allowing access to the log file can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_LOG_FILE_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener logfile must not allow public to read/write to it. Restrict the file permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_LOG_FILE_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  --p_condition =>':property = ''log_file_listener''', --condition
  p_condition =>'trunc(mod(:file_permission,10)/2,0) > 0', --condition
  p_message =>'The listener is in an insecure state. The listener log file %file_name% has permission %file_permission%.', 
  p_message_nlsid =>'LSNR_LOG_FILE_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Logfile_Perm_Policy UNIX End ----------------------------
----lsnrLogFilePermMetricRep  METRIC UNIX END-----------------------



----lsnrLogFilePermMetricNTRep METRIC START-----------------------
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Log File Users',
                p_column_label_nlsid =>'LOG_FILE_USERS_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Log File',
                p_column_label_nlsid =>'LOG_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Logfile_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrLogFilePermMetricNTRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Lsnr Log File Permission',
      p_metric_label_nlsid => 'LSNR_LOG_FILE_PERM_METRIC_LABEL',
      p_description  => 'Listener logfile permission',
      p_description_nlsid => 'LSNR_LOG_FILE_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as file_name, value2 as users,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''nt_log_file_lsnr_perm'' ',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Logfile_Perm_PolicyNT Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Logfile_Perm_PolicyNT',   --Policy name
  p_metric_name => 'lsnrLogFilePermMetricNTRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_LOG_FILE_PERM_NAME_NT', --policylabelnlsid
  p_description  => 'Ensures that the listener logfile cannot be read by  or written to by public',  
  p_description_nlsid =>'LSNR_LOG_FILE_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'The information in the logfile can reveal important network and database connection details. Allowing access to the log file can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_LOG_FILE_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener logfile must not allow public to read/write to it. Restrict the file permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_LOG_FILE_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'rownum > 0', --condition
  p_message =>'The listener is in an insecure state. Users %users% have critical permissions on the listener log file %file_name%.', 
  p_message_nlsid =>'LSNR_LOG_FILE_NT_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Logfile_Perm_PolicyNT End ----------------------------
----lsnrLogFilePermMetricNTRep METRIC END-----------------------



----lsnrTraceDirPermMetricRep METRIC UNIX START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. A listener can apparently have only one tracedir. Still, keeping 2 
--key columns to enable the user to exclude a pair of (permission,trace_dir_name) from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required columns have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory Permission',
                p_column_label_nlsid =>'TRC_DIR_PERM_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory',
                p_column_label_nlsid =>'TRC_DIR_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracedir_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceDirPermMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Trace Directory Permission',
      p_metric_label_nlsid => 'LSNR_TRACE_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect listener trace directory permission',
      p_description_nlsid => 'LSNR_TRACE_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as dir_name, value2 as dir_permission,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''trace_dir_lsnr_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracedir_Perm_Policy UNIX Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY( --show all the columns in violations list
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_permission'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracedir_Perm_Policy',   --Policy name
  p_metric_name => 'lsnrTraceDirPermMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_DIR_PERM_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the listener trace directory does not have public read/write permissions',
  p_description_nlsid =>'LSNR_TRACE_DIR_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'Allowing access to the trace directory can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_DIR_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace directory must not allow public to read/write to it. Restrict the directory permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_DIR_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  --(check for existence of row for violation)
  --p_condition =>':property = ''trace_directory_listener_name''', --condition 
  p_condition =>'mod(:dir_permission,10) > 0', --dir_permission comes in octal. Taking mod with 10 gives the permission for others, which should be 0 for directories
  p_message =>'The listener is in an insecure state. The listener trace directory %dir_name% has permission %dir_permission%.',  
  p_message_nlsid =>'LSNR_TRACE_DIR_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracedir_Perm_Policy UNIX End ----------------------------
----lsnrTraceDirPermMetricRep  METRIC UNIX END-----------------------



----lsnrTraceDirPermMetricNTRep METRIC START-----------------------
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory Users',
                p_column_label_nlsid =>'TRC_DIR_USERS_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory',
                p_column_label_nlsid =>'TRC_DIR_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracedir_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceDirPermMetricNTRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Listener Trace Directory Permission',
      p_metric_label_nlsid => 'LSNR_TRACE_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect listener trace directory permission',
      p_description_nlsid => 'LSNR_TRACE_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as dir_name, value2 as users,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''nt_trace_dir_lsnr_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracedir_Perm_PolicyNT Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY( --show all the columns in violations list
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracedir_Perm_PolicyNT',   --Policy name
  p_metric_name => 'lsnrTraceDirPermMetricNTRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_DIR_PERM_NAME_NT', --policylabelnlsid
  p_description  => 'Ensures that the listener trace directory does not have public read/write permissions',
  p_description_nlsid =>'LSNR_TRACE_DIR_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'Allowing access to the trace directory can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_DIR_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace directory must not allow public to read/write to it. Restrict the directory permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_DIR_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  --(check for existence of row for violation)
  p_condition =>'rownum > 0', 
  p_message =>'The listener is in an insecure state. Users %users% have crritical permissions on listener trace directory %dir_name%.',  
  p_message_nlsid =>'LSNR_TRACE_DIR_NT_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracedir_Perm_PolicyNT End ----------------------------
----lsnrTraceDirPermMetricNTRep METRIC END-----------------------



----lsnrTraceDirOwnMetricRep METRIC START-----------------------
--Only violating rows are pushed from the agent. So consider percentage is false. A listener can apparently have 
--only one trace directory. Still, keeping 2 key columns to enable the user to exclude a pair of 
--(owner_name,trace_dir_name) from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required column have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory Owner',
                p_column_label_nlsid =>'TRC_DIR_OWNER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory',
                p_column_label_nlsid =>'TRC_DIR_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracedir_Own_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceDirOwnMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Trace Directory Owner',
      p_metric_label_nlsid => 'LSNR_TRACE_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect listener trace directory owner',
      p_description_nlsid => 'LSNR_TRACE_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as dir_name, value2 as dir_owner,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''trace_dir_lsnr_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracedir_Own_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY( --show all the columns in violations list
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_owner'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracedir_Own_Policy',   --Policy name
  p_metric_name => 'lsnrTraceDirOwnMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_DIR_OWN_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the listener trace directory is a valid directory owned by Oracle software owner',
  p_description_nlsid =>'LSNR_TRACE_DIR_OWN_DESC',    --Policy Decription NLSID
  p_impact =>'Having a trace directory not owned by the Oracle software owner can expose the trace files to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_DIR_OWN_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace directory must be owned by the Oracle software owner.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_DIR_OWN_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'rownum > 0', --condition 
  p_message =>'The listener is in an insecure state. The listener trace directory %dir_name% is owned by %dir_owner%.',  
  p_message_nlsid =>'LSNR_TRACE_DIR_OWN_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracedir_Own_Policy End ----------------------------
----lsnrTraceDirOwnMetricRep  METRIC END-----------------------


----lsnrTraceFileOwnMetricRep METRIC START-----------------------
--Only violating rows are pushed from the agent. So consider percentage is false. A listener can apparently have 
--only one tracefile. Still, keeping 2 key columns to enable the user to exclude a pair of --(owner_name,trace_file_name) from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required column have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File Owner',
                p_column_label_nlsid =>'TRC_FILE_OWNER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File',
                p_column_label_nlsid =>'TRC_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracefile_Own_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceFileOwnMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Trace File Owner',
      p_metric_label_nlsid => 'LSNR_TRACE_FILE_OWN_METRIC_LABEL',
      p_description  => 'Collect listener trace file owner',
      p_description_nlsid => 'LSNR_TRACE_FILE_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as file_name, value2 as file_owner,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''trace_file_lsnr_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracefile_Own_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_owner'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL
                ));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracefile_Own_Policy',   --Policy name
  p_metric_name => 'lsnrTraceFileOwnMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_FILE_OWN_NAME',   --policylabelnlsid
  p_description  => 'Ensures that the listener trace file owner is same as the Oracle software owner',
  p_description_nlsid =>'LSNR_TRACE_FILE_OWN_DESC',    --Policy Decription NLSID
  p_impact =>'Having trace files not owned by the Oracle software owner can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_FILE_OWN_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace file must be owned by Oracle software owner.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_FILE_OWN_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
 -- p_condition =>':property = ''trace_file_listener_name'' ', --condition
  p_condition =>'rownum > 0',
  p_message =>'The listener is in an insecure state. The listener trace file %file_name% is owned by %file_owner%.',  --message
  p_message_nlsid =>'LSNR_TRACE_FILE_OWN_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracefile_Own_Policy End----------------------------
----lsnrTraceFileOwnMetricRep  METRIC END-----------------------



----lsnrTraceFilePermMetricRep METRIC UNIX START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. A listener can apparently have only one tracefile. Still, keeping 
--2 key columns to enable the user to exclude a pair of (owner_name,trace_file_name) from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required columns have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File Permission',
                p_column_label_nlsid =>'TRC_FILE_PERM_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File',
                p_column_label_nlsid =>'TRC_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracefile_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceFilePermMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Trace File Permissions',
      p_metric_label_nlsid => 'LSNR_TRACE_FILE_PERM_METRIC_LABEL',
      p_description  => 'Collect listener trace file permission',
      p_description_nlsid => 'LSNR_TRACE_FILE_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as file_name, value2 as file_permission,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''trace_file_lsnr_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracefile_Perm_Policy UNIX Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_permission'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL
                ));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracefile_Perm_Policy',   --Policy name
  p_metric_name => 'lsnrTraceFilePermMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_FILE_PERM_NAME',   --policylabelnlsid
  p_description  => 'Ensures that the listener trace file is not accessible to public',
  p_description_nlsid =>'LSNR_TRACE_FILE_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'Allowing access to the trace files can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_FILE_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace file must not allow public to read/write to it. Restrict the file permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_FILE_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
 -- p_condition =>':property = ''trace_file_listener_name'' ', --condition
  p_condition =>'trunc(mod(:file_permission,10)/2,0) > 0',--file_permission value comes in octal. Taking mod with 
  --10 gives the permission for others. Truncating this after dividing by 2 makes the execute bit a don't care bit.
  --All other bits(r  and   
  p_message =>'The listener is in an insecure state. The listener trace file %file_name% has permission %file_permission%.',  --message
  p_message_nlsid =>'LSNR_TRACE_FILE_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracefile_Perm_Policy UNIX End----------------------------
----lsnrTraceFilePermMetricRep  METRIC UNIX END-----------------------



----lsnrTraceFilePermMetricNTRep METRIC START-----------------------
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File Users',
                p_column_label_nlsid =>'TRC_FILE_USERS_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File',
                p_column_label_nlsid =>'TRC_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracefile_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceFilePermMetricNTRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Listener Trace File Permissions',
      p_metric_label_nlsid => 'LSNR_TRACE_FILE_PERM_METRIC_LABEL',
      p_description  => 'Collect listener trace file permission',
      p_description_nlsid => 'LSNR_TRACE_FILE_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as file_name, value2 as users,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''nt_trace_file_lsnr_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracefile_Perm_PolicyNT Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL
                ));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracefile_Perm_PolicyNT',   --Policy name
  p_metric_name => 'lsnrTraceFilePermMetricNTRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_FILE_PERM_NAME_NT',   --policylabelnlsid
  p_description  => 'Ensures that the listener trace file is not accessible to public',
  p_description_nlsid =>'LSNR_TRACE_FILE_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'Allowing access to the trace files can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_FILE_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace file must not allow public to read/write to it. Restrict the file permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_FILE_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'rownum > 0',--file_permission value comes in octal. Taking mod with 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on listener trace file %file_name%.',  --message
  p_message_nlsid =>'LSNR_TRACE_FILE_NT_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracefile_Perm_PolicyNT End----------------------------
----lsnrTraceFilePermMetricNTRep  METRIC END-----------------------



----lsnrPasswdMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. Hence do not need key columns.
--AGENT METRIC : lsnrCmdStatus, perl fetchlet lsnrCmdStatus.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'pwd_status',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Listener Password Status',
                p_column_label_nlsid =>'LSNR_PWD_STATUS_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Listener_Password
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrPasswdMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Password',
      p_metric_label_nlsid => 'LSNR_PASSWD_METRIC_LABEL',
      p_description  => 'Collect listener password parameter',
      p_description_nlsid => 'LSNR_PASSWD_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as pwd_status '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''listenerPwd''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
---Listener_Password POLICY START-----------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'pwd_status'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Listener_Password',   --Policy name
  p_metric_name =>'lsnrPasswdMetricRep',      --Metric name
  p_policy_label_nlsid =>'LSNR_PASSWD_NAME',    
  p_description =>'Ensures that access to listener is password protected',
  p_description_nlsid =>'LSNR_PASSWD_DESC',
  p_impact =>'Without password protection, a user can gain access to the listener. Once someone has access to the listener, he/she can stop the listener. He/she can also set a password and prevent others from managing the listener.',
  p_impact_nlsid =>'LSNR_PASSWD_IMPACT',
  p_recommendation =>'All listeners should be protected by a non-trivial password using the CHANGE_PASSWORD command.',
  p_recommendation_nlsid =>'LSNR_PASSWD_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'UPPER(:pwd_status) <> ''ON''',
  p_message =>'Listener is in an insecure state. It is running without password protection.',
  p_message_nlsid => 'LSNR_PASSWD_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage => MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list => l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList    
);
COMMIT ;
---Listener_Password POLICY END--------------------------
----lsnrPasswdMetricRep  METRIC END-----------------------


----lsnrLogStatusMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. Hence do not need key columns.
--AGENT METRIC : lsnrCmdStatus, perl fetchlet lsnrCmdStatus.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'log_status',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Logging Status',
                p_column_label_nlsid =>'LSNR_LOG_STATUS_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Listener_Logging_Status
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrLogStatusMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Log Status',
      p_metric_label_nlsid => 'LSNR_LOG_STATUS_METRIC_LABEL',
      p_description  => 'Collect listener log status parameter',
      p_description_nlsid => 'LSNR_LOG_STATUS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as log_status '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''loggingStatus''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----POLICY Listener_Logging_Status START----------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'log_status'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Listener_Logging_Status',   --Policy name
  p_metric_name =>'lsnrLogStatusMetricRep',      --Metric name
  p_policy_label_nlsid =>'LSNR_LOG_STATUS_NAME',    
  p_description =>'Ensures that listener logging is enabled',
  p_description_nlsid =>'LSNR_LOG_STATUS_DESC',
  p_impact =>'Without listener logging attacks on the listener can go unnoticed.',
  p_impact_nlsid =>'LSNR_LOG_STATUS_IMPACT',
  p_recommendation =>'Enable listener logging by setting the LOG_STATUS parameter to ON.',
  p_recommendation_nlsid =>'LSNR_LOG_STATUS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'UPPER(:log_status) <> ''ON''',
  p_message =>'Listener is in an insecure state. Logging is not enabled.',
  p_message_nlsid => 'LSNR_LOG_STATUS_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage => MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list => l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList    
);
COMMIT ;
----POLICY Listener_Logging_Status END------------------
----lsnrLogStatusMetricRep METRIC END-----------------------


----lsnrDefaultNameMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. One listener will have only one row, so 
--consider percentage is false. Exclusion of any name as violation also does not make sense here, 
--hence keeping no key columns
--AGENT METRIC : lsnrCmdStatus, perl fetchlet lsnrCmdStatus.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'lsnr_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Listener Name',
                p_column_label_nlsid =>'LSNR_NAME_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Listener_Default_Name
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrDefaultNameMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener Default Name',
      p_metric_label_nlsid => 'LSNR_DFLT_NAME_METRIC_LABEL',
      p_description  => 'Collect listener default name parameter',
      p_description_nlsid => 'LSNR_DFLT_NAME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as lsnr_name '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''lsnr_default_name''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----POLICY Listener_Default_Name START-------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'lsnr_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Listener_Default_Name',   --Policy name
  p_metric_name =>'lsnrDefaultNameMetricRep',      --Metric name
  p_policy_label_nlsid =>'LSNR_DFLT_NAME_NAME',    
  p_description =>'Ensures that the default name of the listener is not used',
  p_description_nlsid =>'LSNR_DFLT_NAME_DESC',
  p_impact =>'Having a listener with the default name increases the risk of unauthorized access and denial of service attacks.',
  p_impact_nlsid =>'LSNR_DFLT_NAME_IMPACT',
  p_recommendation =>'Avoid having a listener with the default name (LISTENER).',
  p_recommendation_nlsid =>'LSNR_DFLT_NAME_RECOM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'UPPER(:lsnr_name) = ''LISTENER''',
  p_message =>'Listener is in an insecure state. The listener is addressed by the default name.',
  p_message_nlsid =>'LSNR_DFLT_NAME_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;
----POLICY Listener_Default_Name START-------------------------
----lsnrDefaultNameMetricRep METRIC END-----------------------
---NEW metrics, one per policy END-------------------------------



---------------OLD METRICS, ALREADY ONE METRIC PER POLICY-----------------------------------------
--Violating as well as non-violating rows are pushed from the agent side. One listener will have only one row, so consider_percentage is false. Still keeping 2 key columns to enable the user to exclude some permission, filename
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required column have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
------Metric  lsnrOraPermRep UNIX Start----------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Listener.ora File Permission',
                p_column_label_nlsid =>'LSNRORA_PERM_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_path',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Listener.ora File',
                p_column_label_nlsid =>'LSNR_ORA_FILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used only by policy lsnr_Ora_Restrict_Perms
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrOraPermRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --it is table here
      p_metric_label => 'Listener.ora File Permissions',
      p_metric_label_nlsid => 'LSNR_ORA_PERM_METRIC_LABEL',
      p_description  => 'Collect listener.ora file permission',
      p_description_nlsid => 'LSNR_ORA_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid ,value as file_path, value2 as file_permission,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''lsnrora_permission''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
------Metric  lsnrOraPermRep UNIX End----------------
----------Policy lsnr_Ora_Restrict_Perms UNIX Start ----------------------------
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_permission'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_path'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Ora_Restrict_Perms',   --Policy name
  p_metric_name => 'lsnrOraPermRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_ORA_PERM_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the file permissions for listener.ora are restricted to the owner of Oracle software',
  p_description_nlsid =>'LSNR_ORA_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'If the listener.ora file is public readable, passwords may be extracted from this file. This can also lead to exposure of detailed information on the Listener, database, and application configuration. Also, if public has write permissions, a malicious user can remove any password that has been set on the listener.', --Impact
  p_impact_nlsid =>'LSNR_ORA_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'Listener.ora permissions should be restricted to the owner of Oracle software installation and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_ORA_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'trunc(mod(:file_permission,10)/2,0) > 0',--'substr(:file_permission,-3,2) <> ''--'' ',
  p_message =>'Listener is in an insecure state. Permissions of listener.ora are not restricted to the Oracle set',
  p_message_nlsid =>'LSNR_ORA_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --consider percentage
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy lsnr_Ora_Restrict_Perms UNIX End----------------------------



------Metric  lsnrOraPermNTRep Start----------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_path',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Listener.ora File',
                p_column_label_nlsid =>'LSNR_ORA_FILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used only by policy lsnr_Ora_Restrict_PermsNT
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrOraPermNTRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Listener.ora File Permissions',
      p_metric_label_nlsid => 'LSNR_ORA_PERM_METRIC_LABEL',
      p_description  => 'Collect listener.ora file permission',
      p_description_nlsid => 'LSNR_ORA_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid ,value as file_path, value2 as users,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''nt_lsnrora_permission''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
------Metric  lsnrOraPermNTRep End----------------
----------Policy lsnr_Ora_Restrict_PermsNT Start ----------------------------
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_path'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Ora_Restrict_PermsNT',   --Policy name
  p_metric_name => 'lsnrOraPermNTRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_ORA_PERM_NAME_NT',            --policylabelnlsid
  p_description  => 'Ensures that the file permissions for listener.ora are restricted to the owner of Oracle software',
  p_description_nlsid =>'LSNR_ORA_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'If the listener.ora file is public readable, passwords may be extracted from this file. This can also lead to exposure of detailed information on the Listener, database, and application configuration. Also, if public has write permissions, a malicious user can remove any password that has been set on the listener.', --Impact
  p_impact_nlsid =>'LSNR_ORA_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'Listener.ora permissions should be restricted to the owner of Oracle software installation and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_ORA_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'rownum > 0',--'substr(:file_permission,-3,2) <> ''--'' ',
  p_message =>'Listener is in an insecure state. Permissions of listener.ora are not restricted to the Oracle set',
  p_message_nlsid =>'LSNR_ORA_NT_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --consider percentage
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy lsnr_Ora_Restrict_PermsNT End----------------------------



----------Metric sqlnetAllowedLogonVersionRep Start-----------------
--sqlnet.allowed_logon_version parameter in sqlnet.ora
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
              p_column_name => 'version',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Allowed Client Logon Version',
                p_column_label_nlsid => 'ALLOWED_LOGON_VERSION_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbversion',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Database Version',
                p_column_label_nlsid => 'ALLOWED_LOGON_DBVERSION_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid => 'DUMMY_COL'));

   MGMT_METRIC.CREATE_METRIC(
       p_target_type => ESM.LSNR_TARGET_TYPE,
       p_metric_name => 'sqlnetAllowedLogonVersionRep',
       p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
       p_valid_if_list => NULL,
       p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
       p_metric_label => 'Allowed Client Logon Version',
       p_metric_label_nlsid => 'ALLOWED_LOGON_VERSION_LABEL',
       p_description => 'Ensures that the server allows logon from clients with a matching version or higher only.',
       p_description_nlsid => 'ALLOWED_LOGON_VERSION_DESC',
       p_is_repository => MGMT_GLOBAL.G_TRUE,
       p_author => 'ORACLE',
       p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
       p_source => 'SELECT target_guid, value as version, value2 as dbversion, value2 as dummy '
                  ||'FROM esm_collection_latest '
                  ||'WHERE property = ''allowed_logon_version''',
       p_snapshot_name_list => l_snapshot_list,
       p_metric_column_list => l_metric_column_list
   );
   COMMIT ;
----------Metric sqlnetAllowedLogonVersionRep End-----------------
---------------Policy Sqlnet_Allowed_Logon_Version starts here--------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'version'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dbversion'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Sqlnet_Allowed_Logon_Version',   --Policy name
  p_metric_name =>'sqlnetAllowedLogonVersionRep',      --Metric name
  p_policy_label_nlsid =>'ALLOWED_LOGON_VERSION_NAME',
  p_description =>'Ensures that the server allows logon from clients with a matching version or higher only.',
  p_description_nlsid =>'ALLOWED_LOGON_VERSION_DESC',
  p_impact =>'Setting the parameter SQLNET.ALLOWED_LOGON_VERSION in sqlnet.ora to a version lower than the server version will force the server to use a less secure authentication protocol',
  p_impact_nlsid =>'ALLOWED_LOGON_VERSION_IMPACT',
  p_recommendation =>'Set the parameter SQLNET.ALLOWED_LOGON_VERSION in sqlnet.ora to the server''s major version. Setting this value to older versions could expose vulnerabilities that may have existed in the authentication protocols.',
  p_recommendation_nlsid =>'ALLOWED_LOGON_VERSION_RECOM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  ':version <> :dbversion',
  p_message =>'Database is in an insecure state. The SQLNET.ALLOWED_LOGON_VERSION parameter is set to %version%.',
  p_message_nlsid =>'ALLOWED_LOGON_VERSION_MESSAGE',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT;
---------------Policy Sqlnet_Allowed_Logon_Version ends here--------



-- ---------Metric clientLogDirRep UNIX Start--------------------------
  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Log Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_LOG_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'clientLogDirRep',   
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'Client Log Directory Permissions', 
      p_metric_label_nlsid => 'CLIENT_LOG_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect the permission of client log directories',
      p_description_nlsid => 'CLIENT_LOG_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as permission, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''client_log_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric clientLogDirRep UNIX End----------------------------------
----------------Policy sqlnet_Client_Log_Dir UNIX Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
 
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Log_Dir',   --Policy name
  p_metric_name =>'clientLogDirRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_LOG_DIR_PERM_NAME',   
  p_description =>'Ensures that the client log directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'CLIENT_LOG_DIR_PERM_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_LOG_DIR_PERM_IMPACT',
  p_recommendation =>'The client log directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'CLIENT_LOG_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'trunc(mod(:permission,10),0) > 0', 
  p_message =>'The listener is in an insecure state. The client log directory %dir_name%  has permission %permission%.',
  p_message_nlsid =>'CLIENT_LOG_DIR_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Client_Log_Dir UNIX End----------------------------------



-- ---------Metric clientLogDirNTRep Start--------------------------
  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Log Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_LOG_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'clientLogDirNTRep',   
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type ,   --table   
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,          
      p_metric_label => 'Client Log Directory Permissions', 
      p_metric_label_nlsid => 'CLIENT_LOG_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect the permission of client log directories',
      p_description_nlsid => 'CLIENT_LOG_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as users, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''nt_client_log_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric clientLogDirNTRep End----------------------------------



----------------Policy sqlnet_Client_Log_DirNT Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
 
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Log_DirNT',   --Policy name
  p_metric_name =>'clientLogDirNTRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_LOG_DIR_PERM_NAME_NT',   
  p_description =>'Ensures that the client log directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'CLIENT_LOG_DIR_PERM_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_LOG_DIR_PERM_IMPACT',
  p_recommendation =>'The client log directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'CLIENT_LOG_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on the client log directory %dir_name%.',
  p_message_nlsid =>'CLIENT_LOG_DIR_NT_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Client_Log_DirNT End----------------------------------



------------Metric clientLogDirOwnerRep Start--------------
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Owner',
                p_column_label_nlsid =>'OWNER_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Log Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_LOG_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'clientLogDirOwnerRep',  
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'Client Log Directory Owner', 
      p_metric_label_nlsid => 'CLIENT_LOG_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect owner of client log directory',
      p_description_nlsid => 'CLIENT_LOG_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value2 as owner, '
                 ||'value as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''client_log_directory_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
------------Metric clientLogDirOwnerRep End--------------
----------------Policy sqlnet_Client_Log_Dir_Owner Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'owner'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
 
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Log_Dir_Owner',   --Policy name
  p_metric_name =>'clientLogDirOwnerRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_LOG_DIR_OWN_NAME',   
  p_description =>'Ensures that the client log directory is a valid directory owned by Oracle set',
  p_description_nlsid =>'CLIENT_LOG_DIR_OWN_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_LOG_DIR_OWN_IMPACT',
  p_recommendation =>'The client log directory must be a valid directory owned by the Oracle set.',
  p_recommendation_nlsid =>'CLIENT_LOG_DIR_OWN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The client log directory %dir_name% is owned by %owner%.',
  p_message_nlsid =>'CLIENT_LOG_DIR_OWN_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Client_Log_Dir_Owner End----------------------------------



----------------Metric svrLogDirRep UNIX Start----------------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Log Directory (Absolute Path)',
                p_column_label_nlsid =>'SERV_LOG_DIR_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'svrLogDirRep',  
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'Server Log Directory Permissions', 
      p_metric_label_nlsid => 'SERV_LOG_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permissions of server log directory',
      p_description_nlsid => 'SERV_LOG_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as permission, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''server_log_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric svrLogDirRep UNIX End----------------------------------
----------------Policy sqlnet_Server_Log_Dir UNIX Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Log_Dir',   --Policy name
  p_metric_name =>'svrLogDirRep',      --Metric name
  p_policy_label_nlsid =>'SERV_LOG_DIR_PERM_NAME',   
  p_description =>'Ensures that the server log directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'SERV_LOG_DIR_PERM_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_LOG_DIR_PERM_IMPACT',
  p_recommendation =>'The server log directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'SERV_LOG_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'trunc(mod(:permission,10),0) > 0', 
  p_message =>'The listener is in an insecure state. The server log directory %dir_name%  has permission %permission%.',
  p_message_nlsid =>'SERV_LOG_DIR_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Server_Log_Dir UNIX End----------------------------------



----------------Metric svrLogDirNTRep Start----------------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Log Directory (Absolute Path)',
                p_column_label_nlsid =>'SERV_LOG_DIR_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'svrLogDirNTRep',  
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type ,   --table    
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,         
      p_metric_label => 'Server Log Directory Permissions', 
      p_metric_label_nlsid => 'SERV_LOG_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permissions of server log directory',
      p_description_nlsid => 'SERV_LOG_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as users, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''nt_server_log_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric svrLogDirNTRep End----------------------------------
----------------Policy sqlnet_Server_Log_DirNT Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Log_DirNT',   --Policy name
  p_metric_name =>'svrLogDirNTRep',      --Metric name
  p_policy_label_nlsid =>'SERV_LOG_DIR_PERM_NAME_NT',   
  p_description =>'Ensures that the server log directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'SERV_LOG_DIR_PERM_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_LOG_DIR_PERM_IMPACT',
  p_recommendation =>'The server log directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'SERV_LOG_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on the server log directory %dir_name%.',
  p_message_nlsid =>'SERV_LOG_DIR_NT_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Server_Log_DirNT End----------------------------------



------------Metric svrLogDirOwnerRep UNIX Start-----------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Owner',
                p_column_label_nlsid =>'OWNER_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Log Directory (Absolute Path)',
                p_column_label_nlsid =>'SERV_LOG_DIR_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'svrLogDirOwnerRep', 
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'Server Log Directory Owner', 
      p_metric_label_nlsid => 'SERV_LOG_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect owner of server log directory',
      p_description_nlsid => 'SERV_LOG_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value2 as owner, '
                 ||'value as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''server_log_directory_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
------------Metric svrLogDirOwnerRep UNIX End-----------------
----------------Policy sqlnet_Server_Log_Dir_Owner Start-----------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'owner'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Log_Dir_Owner',   --Policy name
  p_metric_name =>'svrLogDirOwnerRep',      --Metric name
  p_policy_label_nlsid =>'SERV_LOG_DIR_OWN_NAME',   
  p_description =>'Ensures that the server log directory is a valid directory owned by Oracle set',
  p_description_nlsid =>'SERV_LOG_DIR_OWN_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_LOG_DIR_OWN_IMPACT',
  p_recommendation =>'The server log directory must be a valid directory owned by the Oracle set.',
  p_recommendation_nlsid =>'SERV_LOG_DIR_OWN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The server log directory %dir_name% is owner by %owner%.',
  p_message_nlsid =>'SERV_LOG_DIR_OWN_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Server_Log_Dir_Owner End-----------------



------Metric clientTrcDirRep UNIX Start-------------------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Trace Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'clientTrcDirRep',   
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'Client Trace Directory Permissions', 
      p_metric_label_nlsid => 'CLIENT_TRC_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permission of client trace directory',
      p_description_nlsid => 'CLIENT_TRC_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as permission, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''client_trace_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
------Metric clientTrcDirRep UNIX End-------------------------------------
----------------Policy sqlnet_Client_Trace_Dir UNIX Start-----------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Trace_Dir',   --Policy name
  p_metric_name =>'clientTrcDirRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_TRC_DIR_PERM_NAME',   
  p_description =>'Ensures that the client trace directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'CLIENT_TRC_DIR_PERM_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_TRC_DIR_PERM_IMPACT',
  p_recommendation =>'The client trace directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'CLIENT_TRC_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'trunc(mod(:permission,10),0) > 0', 
  p_message =>'The listener is in an insecure state. The client trace directory %dir_name% has permission %permission%.',
  p_message_nlsid =>'CLIENT_TRC_DIR_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Client_Trace_Dir UNIX End----------------------------------



------Metric clientTrcDirNTRep Start-------------------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Trace Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'clientTrcDirNTRep',   
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type ,   --table    
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,         
      p_metric_label => 'Client Trace Directory Permissions', 
      p_metric_label_nlsid => 'CLIENT_TRC_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permission of client trace directory',
      p_description_nlsid => 'CLIENT_TRC_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as users, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''nt_client_trace_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
------Metric clientTrcDirNTRep End-------------------------------------
----------------Policy sqlnet_Client_Trace_DirNT Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Trace_DirNT',   --Policy name
  p_metric_name =>'clientTrcDirNTRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_TRC_DIR_PERM_NAME_NT',   
  p_description =>'Ensures that the client trace directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'CLIENT_TRC_DIR_PERM_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_TRC_DIR_PERM_IMPACT',
  p_recommendation =>'The client trace directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'CLIENT_TRC_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on the client trace directory %dir_name%.',
  p_message_nlsid =>'CLIENT_TRC_DIR_NT_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Client_Trace_DirNT End----------------------------------



----------Metric clientTrcDirOwnerRep Start-----------------------------
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Owner',
                p_column_label_nlsid =>'OWNER_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Trace Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'clientTrcDirOwnerRep',  
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'Client Trace Directory Owner', 
      p_metric_label_nlsid => 'CLIENT_TRC_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect owner of client trace directories',
      p_description_nlsid => 'CLIENT_TRC_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value2 as owner, '
                 ||'value as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''client_trace_directory_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------Metric clientTrcDirOwnerRep End-----------------------------
----------------Policy sqlnet_Client_Trace_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'owner'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Trace_Dir_Owner',   --Policy name
  p_metric_name =>'clientTrcDirOwnerRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_TRC_DIR_OWN_NAME',   
  p_description =>'Ensures that the client trace directory is a valid directory owned by Oracle set',
  p_description_nlsid =>'CLIENT_TRC_DIR_OWN_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_TRC_DIR_OWN_IMPACT',
  p_recommendation =>'The client trace directory must be a valid directory owned by the Oracle set.',
  p_recommendation_nlsid =>'CLIENT_TRC_DIR_OWN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The client trace directory %dir_name% is owned by %owner%.',
  p_message_nlsid =>'CLIENT_TRC_DIR_OWN_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Client_Trace_Dir Start----------------------------------



------------Metric svrTrcDirRep UNIX Start---------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Trace Direcotry (Absolute Path)',
                p_column_label_nlsid =>'SERV_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'svrTrcDirRep',  
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'Server Trace Directory Permissions', 
      p_metric_label_nlsid => 'SERV_TRC_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permissions of server trace directories',
      p_description_nlsid => 'SERV_TRC_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as permission, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''server_trace_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric svrTrcDirRep UNIX End----------------------------------
----------------Policy sqlnet_Server_Trace_Dir UNIX Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Trace_Dir',   --Policy name
  p_metric_name =>'svrTrcDirRep',      --Metric name
  p_policy_label_nlsid =>'SERV_TRC_DIR_PERM_NAME',   
  p_description =>'Ensures that the server trace directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'SERV_TRC_DIR_PERM_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_TRC_DIR_PERM_IMPACT',
  p_recommendation =>'The server trace directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'SERV_TRC_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'trunc(mod(:permission,10),0) > 0', 
  p_message =>'The listener is in an insecure state. The server trace directory %dir_name% has permission %permission%.',
  p_message_nlsid =>'SERV_TRC_DIR_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Server_Trace_Dir UNIX Start----------------------------------



------------Metric svrTrcDirNTRep Start---------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Trace Direcotry (Absolute Path)',
                p_column_label_nlsid =>'SERV_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'svrTrcDirNTRep',  
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type ,   --table
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Server Trace Directory Permissions', 
      p_metric_label_nlsid => 'SERV_TRC_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permissions of server trace directories',
      p_description_nlsid => 'SERV_TRC_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as users, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''nt_server_trace_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric svrTrcDirNTRep End----------------------------------
----------------Policy sqlnet_Server_Trace_DirNT Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Trace_DirNT',   --Policy name
  p_metric_name =>'svrTrcDirNTRep',      --Metric name
  p_policy_label_nlsid =>'SERV_TRC_DIR_PERM_NAME_NT',   
  p_description =>'Ensures that the server trace directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'SERV_TRC_DIR_PERM_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_TRC_DIR_PERM_IMPACT',
  p_recommendation =>'The server trace directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'SERV_TRC_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on the server trace directory %dir_name%.',
  p_message_nlsid =>'SERV_TRC_DIR_NT_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Server_Trace_DirNT End----------------------------------



------------Metric svrTrcDirOwnerRep Start----------------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Owner',
                p_column_label_nlsid =>'OWNER_COL'),
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Trace Direcotry (Absolute Path)',
                p_column_label_nlsid =>'SERV_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'svrTrcDirOwnerRep', 
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'Server Trace Directory Owner', 
      p_metric_label_nlsid => 'SERV_TRC_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect owner of server trace directories',
      p_description_nlsid => 'SERV_TRC_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value2 as owner, '
                 ||'value as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''server_trace_directory_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
------------Metric svrTrcDirOwnerRep End----------------------------------
----------------Policy sqlnet_Server_Trace_Dir_Owner Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'owner'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Trace_Dir_Owner',   --Policy name
  p_metric_name =>'svrTrcDirOwnerRep',      --Metric name
  p_policy_label_nlsid =>'SERV_TRC_DIR_OWN_NAME',   
  p_description =>'Ensures that the server trace directory is a valid directory owned by Oracle set',
  p_description_nlsid =>'SERV_TRC_DIR_OWN_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_TRC_DIR_OWN_IMPACT',
  p_recommendation =>'The server trace directory must be a valid directory owned by the Oracle set.',
  p_recommendation_nlsid =>'SERV_TRC_DIR_OWN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The server trace directory %dir_name% is owned by %owner%.',
  p_message_nlsid =>'SERV_TRC_DIR_OWN_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Server_Trace_Dir_Owner End----------------------------------



----------------Metric sqlnetOraPermRep UNIX Start----------------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'sqlnetOraPermRep',  
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    --table            
      p_metric_label => 'SqlnetOra Permissions', 
      p_metric_label_nlsid => 'SQLNET_PERM_METRIC_LABEL',
      p_description  => 'Collect the permission information of sqlnet.ora file',
      p_description_nlsid => 'SQLNET_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT property, target_guid, value as permission '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property =''sqlnetora_permission''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetOraPermRep UNIX End----------------------------------
----------------Policy sqlnet_Ora_Restrict_Perms UNIX Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Sqlnet_Ora_Restrict_Perms',   --Policy name
  p_metric_name =>'sqlnetOraPermRep',      --Metric name
  p_policy_label_nlsid =>'SQLNET_PERM_NAME',   
  p_description =>'Ensures that the sqlnet.ora file is not accessible to public',
  p_description_nlsid =>'SQLNET_PERM_DESC',
  p_impact =>'If sqlnet.ora is public readable a malicious user may attempt to read this hence could lead to sensitive information getting exposed .For example, log and trace destination information of the client and server.',
  p_impact_nlsid =>'SQLNET_PERM_IMPACT',
  p_recommendation =>'Public should not be given any  permissions on the sqlnet.ora file.',
  p_recommendation_nlsid =>'SQLNET_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'trunc(mod(:permission,10)/2,0) > 0',
  p_message =>'Listener is in insecure state. The sqlnet.ora file has permission %permission%.',
  p_message_nlsid =>'SQLNET_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Ora_Restrict_Perms UNIX End----------------------------------



----------------Metric sqlnetOraPermNTRep Start----------------------------------
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'property',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Property',
                p_column_label_nlsid =>'PROP_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'sqlnetOraPermNTRep',  
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  --table            
      p_metric_label => 'SqlnetOra Permissions', 
      p_metric_label_nlsid => 'SQLNET_PERM_METRIC_LABEL',
      p_description  => 'Collect the permission information of sqlnet.ora file',
      p_description_nlsid => 'SQLNET_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT property, target_guid, value as users '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property =''nt_sqlnetora_permission''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetOraPermNTRep End----------------------------------
----------------Policy sqlnet_Ora_Restrict_PermsNT Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Sqlnet_Ora_Restrict_PermsNT',   --Policy name
  p_metric_name =>'sqlnetOraPermNTRep',      --Metric name
  p_policy_label_nlsid =>'SQLNET_PERM_NAME_NT',   
  p_description =>'Ensures that the sqlnet.ora file is not accessible to public',
  p_description_nlsid =>'SQLNET_PERM_DESC',
  p_impact =>'If sqlnet.ora is public readable a malicious user may attempt to read this hence could lead to sensitive information getting exposed .For example, log and trace destination information of the client and server.',
  p_impact_nlsid =>'SQLNET_PERM_IMPACT',
  p_recommendation =>'Public should not be given any  permissions on the sqlnet.ora file.',
  p_recommendation_nlsid =>'SQLNET_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'rownum > 0',
  --p_condition => '(property = ''sqlnetora_permission'' and trunc(mod(:permission,10)/2,0) > 0) or (property = ''nt_sqlnetora_permission'')',
  --p_condition => '(:property = ''sqlnetora_permission'' and trunc(mod(:permission,10)/2,0) > 0) or (:property = ''nt_sqlnetora_permission'')',
  p_message =>'Listener is in insecure state. The following users have critical privileges on the sqlnet.ora file : %users%.',
  p_message_nlsid =>'SQLNET_PERM_NT_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;
----------------Policy sqlnet_Ora_Restrict_PermsNT End----------------------------------


---------->>Sqlnet_Inbound_Connect_Timeout<<-------------------------
    l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'sqlnet_ora_inbound_connect_timeout',
                p_column_label_nlsid =>'SQLNET_ORA_INBOUND_TIMEOUT_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'Sqlnet_Inbound_Connect_Timeout_Rep',     
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'sqlnet ora inbound connect timeout',
      p_metric_label_nlsid => 'SQLNETORA_INBOUND_CONNECT_TIMEOUT_LABEL',
      p_description  => 'Collect Sqlnetora inbound connect timeout parameter',
      p_description_nlsid => 'SQLNETORA_INBOUND_CONNECT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value, value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''inbound_connect_timeout''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;

l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'value'));
    l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'DFLT_VAL',
                param_name_nlsid => 'DFLT_VAL_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_NUMBER));
    l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'DFLT_VAL',
                p_warn_threshold => '30'));
    l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Sqlnet_Inbound_Connect_Timeout',--Policy Name
  p_metric_name =>'Sqlnet_Inbound_Connect_Timeout_Rep',      --Metric name
  p_policy_label_nlsid =>'Sqlnetora_Inbound_Connect_Timeout_NAME',    
  p_description =>'Ensures that all incomplete inbound connections to Oracle Net has a limited lifetime',
  p_description_nlsid =>'Sqlnetora_Inbound_Connect_Timeout_DESC',
  p_impact => 'Without this parameter or assigning it  with a higher value , a client connection to the database server can stay open indefinitely  or for the specified duration without authentication. Connections without authentication can introduce possible denial-of-service attacks, whereby malicious clients attempt to flood database servers with connect requests that consume resources. ',
  p_impact_nlsid =>'Sqlnetora_Inbound_Connect_Timeout_IMPACT',
  p_recommendation =>'Set the lowest possible value for the SQLNET.INBOUND_CONNECT_TIMEOUT parameter in sqlnet.ora. Ensure that the value of this parameter is higher than the value of  INBOUND_CONNECT_TIMEOUT_listener_name parameter in the listener.ora file.',
  p_recommendation_nlsid =>'Sqlnetora_Inbound_Cconnect_Timeout_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'to_number(:value) > :DFLT_VAL' ,
  p_message =>'Database is in an insecure state. sqlnet.inbound_connect_timeout parameter is set to %value%.',
  p_message_nlsid =>'Sqlnetora_Inbound_Connect_Timeout_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT;

----------<<Sqlnet_Inbound_Connect_Timeout>>-------------------------

---------->>Lsnr_Inbound_Connect_Timeout<<-------------------------
    l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'lsnr_ora_inbound_connect_timeout',
                p_column_label_nlsid =>'LSNR_ORA_INBOUND_TIMEOUT_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'Lsnr_Inbound_Connect_Timeout_Rep',     
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'lsnr ora inbound connect timeout',
      p_metric_label_nlsid => 'LSNRORA_INBOUND_CONNECT_TIMEOUT_LABEL',
      p_description  => 'Collect Lsnrora inbound connect timeout parameter',
      p_description_nlsid => 'LSNRORA_INBOUND_CONNECT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value , value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''lsnr_inbound_connect_timeout''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'value'));
    l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'DFLT_VAL',
                param_name_nlsid => 'DFLT_VAL_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_NUMBER));
    l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'DFLT_VAL',
                p_warn_threshold => '20'));
    l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Lsnr_Inbound_Connect_Timeout',--Policy Name
  p_metric_name =>'Lsnr_Inbound_Connect_Timeout_Rep',      --Metric name
  p_policy_label_nlsid =>'Lsnrora_Inbound_Connect_Timeout_NAME',    
  p_description =>'Ensures that all incomplete inbound connections to Oracle Listener has a limited lifetime',
  p_description_nlsid =>'Lsnrora_Inbound_Connect_Timeout_DESC',
  p_impact => 'This limit protects the listener from consuming and holding resources for client connection requests that do not complete. A malicious user could use this to flood the listener with requests that result in a denial of service to authorized users.',
  p_impact_nlsid =>'Lsnrora_Inbound_Connect_Timeout_IMPACT',
  p_recommendation =>'Set the lowest possible value for the INBOUND_CONNECT_TIMEOUT_listener_name parameter in listener.ora. Ensure that the value of this parameter is lower than the value of SQLNET.INBOUND_CONNECT_TIMEOUT parameter in the sqlnet.ora file.',
  p_recommendation_nlsid =>'Lsnrora_Inbound_Cconnect_Timeout_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'to_number(:value) > :DFLT_VAL' ,
  p_message =>'Database is in an insecure state.  lsnr.inbound_connect_timeout parameter is set to %value%.',
  p_message_nlsid =>'Lsnrora_Inbound_Cconnect_Timeout_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

----------<<Lsnr_Inbound_Connect_Timeout>>-------------------------


---------->>Sqlnet_Ssl_Server_DN_Match<<-------------------------
    l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Ssl_Server_DN_Match',
                p_column_label_nlsid =>'SSL_SERVER_DN_MATCH_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'Ssl_Server_DN_Match_Rep',     
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'sqlnet ora ssl_server_dn_match',
      p_metric_label_nlsid => 'SSL_SERVER_DN_MATCH_LABEL',
      p_description  => 'Collect Sqlnetora ssl_server_dn_match parameter',
      p_description_nlsid => 'SSL_SERVER_DN_MATCH_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value, value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''ssl_server_dn_match''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'value'));
    l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Ssl_Server_DN_Match',--Policy Name
  p_metric_name =>'Ssl_Server_DN_Match_Rep',      --Metric name
  p_policy_label_nlsid =>'Ssl_Server_DN_Match_NAME',    
  p_description =>'Ensures ssl_server_dn_match is enabled in sqlnet.ora and in turn SSL ensures that the certificate is from the server',
  p_description_nlsid =>'Ssl_Server_DN_Match_DESC',
  p_impact => 'If ssl_server_dn_match parameter is disabled, then SSL performs the check but allows the connection, regardless if there is a match. Not enforcing the match allows the server to potentially fake its identity.',
  p_impact_nlsid =>'Ssl_Server_DN_Match_IMPACT',
  p_recommendation =>'Enable ssl_server_dn_match parameter in the sqlnet.ora file.',
  p_recommendation_nlsid =>'Ssl_Server_DN_Match_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'lower(:value) != ''true'' and lower(:value) != ''yes'' and  lower(:value) != ''on''' ,
  p_message =>'Database is in an insecure state. ssl_server_dn_match parameter is set to %value%.',
  p_message_nlsid =>'Ssl_Server_DN_Match_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT;

----------<<Sqlnet_Ssl_Server_DN_Match>>-------------------------

END ;
/
show errors ;

