Rem drv: <create type="pkgdefs"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/ha/hapage_pkgdefs.sql /st_emdbsa_11.2/1 2009/02/02 13:16:15 gallison Exp $
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      hapage_pkgdefs.sql
Rem
Rem    DESCRIPTION
Rem      PL/SQL procedures for the HA Page
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     gallison   11/21/07 - Add events
Rem     gallison   11/08/07 - Add get_events
Rem     sjconnol   05/01/07 - Add get_ecm_values
Rem     sjconnol   03/15/07 - Add availability obj
Rem     sjconnol   08/20/06 - Creation
Rem

CREATE OR REPLACE PACKAGE hapage_database AS

k_metric_status_inaccessible CONSTANT NUMBER := -1;

procedure get_br_values(
        targetName      IN VARCHAR2,
        targetType      IN VARCHAR2,
        brSummary       OUT MGMT_HAPAGE_BR_OBJ);

procedure get_ecm_values(
        targetName      IN VARCHAR2,
        targetType      IN VARCHAR2,
        ecmSummary      OUT MGMT_HAPAGE_ECM_OBJ);

procedure get_dg_prmy_values(
        targetName      IN VARCHAR2,
        targetType      IN VARCHAR2,
        dgPrmySummary   OUT MGMT_HAPAGE_PRMY_OBJ
        ) ;
        
procedure get_dg_stby_values(
        targetName      IN VARCHAR2,
        targetType      IN VARCHAR2,
        dgStbySummary   OUT MGMT_HAPAGE_STBY_LIST
        );
        

procedure get_avail_info(targetName    IN  VARCHAR2,
                         targetType    IN  VARCHAR2,
                         availInfo OUT MGMT_HAPAGE_AVAIL_OBJ);

procedure getDbStringValues(
        targetGuid        IN VARCHAR2,
        instanceName      OUT VARCHAR2,
        instanceStartTime OUT DATE,
        instanceVersion   OUT VARCHAR2,
        oracleHome        OUT VARCHAR2,
        cpuCount          OUT NUMBER,
        openMode          OUT VARCHAR2);

function getDate(targetName    IN  VARCHAR2,
                 targetType    IN  VARCHAR2,
                 datestr       IN VARCHAR2) return DATE;
procedure get_ha_events_guids(
        mgmt_guids   IN MGMT_USER_GUID_ARRAY,
        critical_sev IN NUMBER DEFAULT NULL,
        warning_sev  IN NUMBER DEFAULT NULL,
        info_sev     IN NUMBER DEFAULT NULL,
        days         IN NUMBER DEFAULT NULL,
        ha_mgmt_events  OUT MGMT_HAPAGE_EVENT_LIST
        );
procedure get_ha_events_targets(
        targetName    IN  VARCHAR2,
        targetType    IN  VARCHAR2,
        critical_sev   IN NUMBER DEFAULT NULL,
        warn_sev       IN NUMBER DEFAULT NULL,
        info_sev       IN NUMBER DEFAULT NULL,
        days           IN NUMBER DEFAULT NULL,
        haguids_out    OUT MGMT_USER_GUID_ARRAY,
        ha_mgmt_events OUT MGMT_HAPAGE_EVENT_LIST
        );
procedure get_ha_events(
        targetName     IN  VARCHAR2,
        targetType     IN  VARCHAR2,
        haguids_out    OUT MGMT_USER_GUID_ARRAY,
        ha_mgmt_events OUT MGMT_HAPAGE_EVENT_LIST
        );

procedure dump_ha_info(
                haguids MGMT_USER_GUID_ARRAY,
                events mgmt_hapage_event_list
                );


end hapage_database;
/
show errors;
