Rem drv: <create type="tables"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/job/job_tables.sql /st_emdbsa_11.2/1 2009/01/27 16:16:43 mmootha Exp $
Rem
Rem job_tables.sql
Rem
Rem Copyright (c) 2002, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      job_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pbantis     09/23/08 - 10.2.0.5GC to 11.2DBC code slap.
Rem    pbantis     08/26/08 - Bug 7355213 emuser col.
Rem    xshi        11/02/06 - vpc
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    pbantis     01/05/05 - Expand tape_parms column to 1024. 
Rem    pbantis     10/05/04 - Change tables to MGMT_RCVCAT_CONFIG and 
Rem                           MGMT_RCVCAT_REPOS. 
Rem    pbantis     08/17/04 - Revise MGMT_RCVCAT_CRED. 
Rem    pbantis     07/19/04 - Add MGMT_RCVCATS 
Rem    pbantis     06/02/03 - Remove set_size_unit and max_set_size
Rem    hying       11/21/02 - Add rcvcat_guid column
Rem    hying       09/16/02 - Change column names
Rem    hying       09/12/02 - Change unique key
Rem    hying       08/19/02 - format to location
Rem    hying       06/11/02 - reorg backup configuration
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    hying       04/17/02 - Add BackupConfiguration
Rem    hying       04/16/02 - hying_db_job
Rem    hying       04/16/02 - Created
Rem

-- Sequence for generating unique job ID for DB jobs
-- Referenced from emo/util/DBJobObject
CREATE SEQUENCE DB_JOB_SEQUENCE;

-- Referenced from emo/util/rman/BackupObject, RecoverObject and MaintenanceObject
CREATE TABLE MGMT_BACKUP_CONFIGURATION (
  TARGET_GUID            RAW(16) NOT NULL,
  DBID                   NUMBER,
  AUTOBACKUPLOCATION     VARCHAR(128),
  USE_DISK               VARCHAR(4),
  DISK_PARALLELISM       NUMBER,
  DISK_LOCATION          VARCHAR2(128),
  USE_TAPE               VARCHAR(4),
  TAPE_PARALLELISM       NUMBER,
  TAPE_PARMS             VARCHAR(1024),
  PIECE_SIZE_UNIT        VARCHAR(4),
  MAX_PIECE_SIZE         NUMBER,
  TAPE_DF_COPIES         NUMBER,
  TAPE_AL_COPIES         NUMBER,
  UNIQUE(TARGET_GUID)
) MONITORING;

-- Table for storing list of configured recovery catalogs.
CREATE TABLE MGMT_RCVCAT_CONFIG (
  RCVCAT_GUID            RAW(16) DEFAULT SYS_GUID(),
  RCVCAT_VERSION         VARCHAR(15),
  RCVCAT_CONNECT_STR     VARCHAR(1024),
  RCVCAT_USERNAME        VARCHAR(128),
  RCVCAT_PASSWORD        RAW(128),
  TARGET_GUID            RAW(16),
  VPCBASE_GUID           RAW(16),
  EM_USER                VARCHAR2(256),
  CONSTRAINT MGMT_RCVCAT_CONFIG_UQ 
    UNIQUE(RCVCAT_GUID, EM_USER)
) MONITORING;

-- Table for storing list of RMAN repositories for database targets.
CREATE TABLE MGMT_RCVCAT_REPOS (
  TARGET_GUID            RAW(16) NOT NULL,
  USE_RCVCAT             VARCHAR(4),
  RCVCAT_GUID            RAW(16),
  EM_USER                VARCHAR2(256),
  CONSTRAINT MGMT_RCVCAT_REPOS_UQ 
    UNIQUE(TARGET_GUID, EM_USER)
) MONITORING;

