REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: Backup
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'Backup';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(3);
    l_commands(1) := 'remoteOp';
    l_commands(2) := 'preRman';
    l_commands(3) := 'postRman';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 1, 1, 1, null, 1, 1, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

INSERT INTO MGMT_JOB_SINGLE_TARGET_TYPES(job_type_id, single_target_type)  VALUES
	( l_job_type_id, 'oracle_database' );

MGMT_JOB_ENGINE.insert_cluster_target_types(l_job_type_id);

-- ENTRIES FOR STEPSET main
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'main', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, 'backup', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET blackout
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'blackout', 2, null, null, 1, 'main', 2, null, null, null, null, null, 1, 'main', null, null, 2, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP PreBackup
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(5);
    l_param_names(1) := 'db_connect_string';
    l_param_names(2) := 'is_cold_backup';
    l_param_names(3) := 'do_blackout';
    l_param_names(4) := 'db_10_or_higher';
    l_param_names(5) := 'backup_strategy';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'PreBackup', 1, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(3);
    l_param_names(1) := 'use_rcvcat';
    l_param_names(2) := 'rcvcat_connect_string';
    l_param_names(3) := 'rcvcat_username';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'PreBackup', 1, 'user', 2, ' 
    ', 0, 0, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type properties
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(3);
    l_param_names(1) := 'p_oracle_home';
    l_param_names(2) := 'p_oracle_sid';
    l_param_names(3) := 'p_db_version';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'PreBackup', 1, 'properties', 3, '
    ', 1, 0, 0, l_param_names );


END;
END;


-- PROPERTIES PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_prop_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_prop_columns.trim(l_prop_columns.count);

    l_prop_columns.extend(3);
    l_prop_columns(1) := 'OracleHome';
    l_prop_columns(2) := 'SID';
    l_prop_columns(3) := 'DBVersion';
    INSERT INTO MGMT_JOB_PROP_PARAMS(source_id, 
                         property_names, 
                         property_names_param, 
                         target_names, 
                         target_types, 
                         target_names_param, 
                         target_types_param) 
   SELECT source_id, l_prop_columns, null, null, null, 'job_target_names', 'job_target_types'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id          AND source_index=3;
END;
END;


-- PARAM SOURCE: source type credentials
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'host_username';
    l_param_names(2) := 'host_password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'PreBackup', 1, 'credentials', 4, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- CREDENTIAL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_cred_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_container_paths MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_cred_type_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_cred_columns.trim(l_cred_columns.count);

    l_cred_columns.extend(2);
    l_cred_columns(1) := 'HostUsername';
    l_cred_columns(2) := 'HostPassword';
    INSERT INTO MGMT_JOB_CRED_PARAMS(source_id, 
                         credential_set_name, 
                         credential_set_target_type, 
                         base_cred_type_name, 
                         base_cred_type_target_type, 
                         base_cred_type_columns, 
                         credential_columns, 
                         credential_columns_param, 
                         target_names, 
                         target_types, 
                         container_paths, 
                         target_names_param, 
                         target_types_param, 
                         container_paths_param, 
                         set_override) 
       SELECT source_id, 'DBHostCreds', 'oracle_database', null, null, null, l_cred_columns, null, null, null, null, 'job_target_names', 'job_target_types', null, 0         FROM   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id            AND source_index=4;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'db_credential_set_name';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'PreBackup', 1, 'inline', 5, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'db_credential_set_name';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := 'DBCredsNormal';
    l_params(1).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=5;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'db_credential_columns';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'PreBackup', 1, 'inline', 6, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);

    l_vector_vals.trim(l_vector_vals.count);

    l_vector_vals.extend(3);
    l_vector_vals(1) := 'username';
    l_vector_vals(2) := 'password';
    l_vector_vals(3) := 'role';
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'db_credential_columns';
    l_params(1).param_type := 0;
    l_params(1).scalar_value := null;
    l_params(1).vector_value := l_vector_vals;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=6;
END;
END;


-- PARAM SOURCE: source type credentials
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(3);
    l_param_names(1) := 'db_username';
    l_param_names(2) := 'db_password';
    l_param_names(3) := 'db_role';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'PreBackup', 1, 'credentials', 7, '

    ', 0, 0, 0, l_param_names );


END;
END;


-- CREDENTIAL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_cred_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_container_paths MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_cred_type_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_cred_type_columns.trim(l_cred_type_columns.count);

    l_cred_type_columns.extend(3);
    l_cred_type_columns(1) := 'DBUserName';
    l_cred_type_columns(2) := 'DBPassword';
    l_cred_type_columns(3) := 'DBRole';
    INSERT INTO MGMT_JOB_CRED_PARAMS(source_id, 
                         credential_set_name, 
                         credential_set_target_type, 
                         base_cred_type_name, 
                         base_cred_type_target_type, 
                         base_cred_type_columns, 
                         credential_columns, 
                         credential_columns_param, 
                         target_names, 
                         target_types, 
                         container_paths, 
                         target_names_param, 
                         target_types_param, 
                         container_paths_param, 
                         set_override) 
       SELECT source_id, '%db_credential_set_name%', 'oracle_database', 'DBCreds', 'oracle_database', l_cred_type_columns, null, 'db_credential_columns', null, null, null, 'job_target_names', 'job_target_types', null, 0         FROM   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id            AND source_index=7;
END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'host_username';
    l_param_names(2) := 'host_password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'PreBackup', 1, 'user', 8, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(3);
    l_param_names(1) := 'host_password';
    l_param_names(2) := 'db_password';
    l_param_names(3) := 'rcvcat_password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'PreBackup', 1, 'user', 9, null, 0, 0, 1, l_param_names );


END;
END;


-- PARAM SOURCE: source type sql
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'curr_date';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 1, 'PreBackup', 1, 'sql', 10, '
          select ''curr_date'', TO_CHAR(SYSDATE, ''MMDDYYHHMISS'') FROM DUAL
    ', 0, 0, 0, l_param_names );


END;
END;


-- SQL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_vector_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_SQL_PARAMS(source_id, 
                      vector_params, 
                      out_proc, 
                      out_param_type) 
  SELECT source_id, l_vector_params, 0, null     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=10;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'encrypt_passwords';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'PreBackup', 1, 'inline', 11, '
    ', 0, 0, 1, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'encrypt_passwords';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := 'NULL';
    l_params(1).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=11;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'encrypt_mode';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'PreBackup', 1, 'inline', 12, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'encrypt_mode';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := 'n/a';
    l_params(1).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=12;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'exec_rman_perl_script';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'PreBackup', 1, 'inline', 13, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'exec_rman_perl_script';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := 'rman_perl_script';
    l_params(1).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=13;
END;
END;


-- ENTRIES FOR STEP PreBackup
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'PreBackup', 1, null, null, 1, 'blackout', 2, null, null, null, null, null, 0, 'blackout', null, 'preRman', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP PreBackup
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'do_blackout', 1, 0, '%do_blackout%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'blackout_target_name', 1, 0, '%blackout_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'blackout_target_type', 1, 0, '%blackout_target_type%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'job_name', 1, 0, '%job_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'job_id', 1, 0, '%job_id%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'job_execution_id', 1, 0, '%job_execution_id%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'curr_date', 1, 0, '%curr_date%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'job_type', 1, 0, 'Backup', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'originalScript', 1, 0, '%exec_rman_perl_script%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'modifiedScript', 1, 0, 'modified_rman_perl_script', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'db_username', 1, 0, '%db_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'db_password', 1, 0, '%db_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'db_role', 1, 0, '%db_role%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PreBackup', 'db_connect_string', 1, 0, '%db_connect_string%', null, null );


END;
END;


-- ENTRIES FOR STEPSET backup
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'backup', 2, null, null, 2, 'blackout', 2, null, null, null, null, null, 1, 'main', 'BackupOp', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP BackupOp
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'BackupOp', 1, null, null, 1, 'backup', 2, null, null, null, null, null, 0, 'backup', null, 'remoteOp', 1, 0, 0, 0, null, null, 1 );

--  STEP PARAMETERS FOR STEP BackupOp
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'input', 1, 0, '
                    
                    $daily_backup_script="%daily_backup_script%";
                    $weekly_backup_script="%weekly_backup_script%";
                    $weekly_backup_day=q''%weekly_backup_day%'';
                    $device_type=q''%device_type%'';
                    $rcvcat_username=q''%rcvcat_username%'';
                    $rcvcat_password=q''%rcvcat_password%'';
                    $rcvcat_connect_string=q''%rcvcat_connect_string%'';
                    $blackout_target_type=q''%blackout_target_type%'';
                    $db_username=q''%db_username%'';
                    $db_password=q''%db_password%'';
                    $db_role=q''%db_role%'';
                    $job_name = q''%job_name%'';
                    $curr_date = q''%curr_date%'';
                    $skip_noarchivelog_check = q''%skip_noarchivelog_check%'';
                    $target_home = q''%p_oracle_home%[1]'';
                    $target_sid = q''%p_oracle_sid%[1]'';
                    $target_version = q''%p_db_version%[1]'';
                    $db_name = q''%db_name%'';
                    $job_name_blen = q''%job_name_blen%'';
                    $encrypt_passwords = q''%encrypt_passwords%'';
                    my $l_db_connect_string = q''%db_connect_string%'';
                    my $l_is_cold_backup = %is_cold_backup%;
                    my $l_use_rcvcat = %use_rcvcat%;
                    my $l_db_10_or_higher = %db_10_or_higher%;
                    my $l_backup_strategy = %backup_strategy%;
                    
                ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'largeInputParam', 1, 0, 'modified_rman_perl_script', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'username', 1, 0, '%host_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'password', 1, 0, '%host_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'executeSynchronous', 1, 0, 'false', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'BackupOp', 'successStatus', 1, 0, '0,1,4', null, null );


END;
END;


-- ENTRIES FOR STEPSET stopBlackout
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stopBlackout', 2, null, null, 2, 'BackupOp', 1, null, null, null, null, null, 1, 'backup', null, null, 2, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP PostBackup
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'PostBackup', 1, null, null, 1, 'stopBlackout', 2, null, null, null, null, null, 0, 'stopBlackout', null, 'postRman', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP PostBackup
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PostBackup', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PostBackup', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PostBackup', 'do_blackout', 1, 0, '%do_blackout%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PostBackup', 'blackout_guid', 1, 0, '%blackout_guid%', null, null );


END;
END;


-- ENTRIES FOR STEPSET stopBlackoutOnAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stopBlackoutOnAbort', 2, null, null, 9, 'backup', 2, null, null, null, null, null, 1, 'main', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP PostBackupOnAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'PostBackupOnAbort', 1, null, null, 1, 'stopBlackoutOnAbort', 2, null, null, null, null, null, 0, 'stopBlackoutOnAbort', null, 'postRman', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP PostBackupOnAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PostBackupOnAbort', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PostBackupOnAbort', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PostBackupOnAbort', 'do_blackout', 1, 0, '%do_blackout%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PostBackupOnAbort', 'blackout_guid', 1, 0, '%blackout_guid%', null, null );


END;
END;


-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'host_username', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_connect_string', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_username', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_role', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'p_oracle_home', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'p_oracle_sid', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_10_or_higher', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'backup_strategy', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'device_type', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'is_cold_backup', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'do_blackout', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_name', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'rcvcat_connect_string', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'rcvcat_username', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'rman_perl_script', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'retry_rman_perl_script', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'daily_backup_script', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'weekly_backup_script', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'weekly_backup_day', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'encrypt_mode', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- DISPLAYINFO ENTRIES
INSERT INTO MGMT_JOB_TYPE_DISPLAY_INFO(job_type_id, nls_bundle,use_default_create_ui)  VALUES
	( l_job_type_id, 'oracle.sysman.db.rsc.rec.BackupJobMsg', 0 );

insert into MGMT_JOB_DISPLAY_ERROR_CODES(job_type_id, id, nlsid, default_value)  VALUES
	( l_job_type_id, '4', 'SUCCEEDED_WITH_WARNINGS', 'Succeeded with warnings' );

insert into MGMT_JOB_DISPLAY_ERROR_CODES(job_type_id, id, nlsid, default_value)  VALUES
	( l_job_type_id, '5', 'SUCCEEDED_WITH_ERRORS', 'Completed with errors' );

-- Callbacks for jobtype Backup
MGMT_JOB_ENGINE.add_job_callback(l_job_type_id, 6, 'mgmt_rec.retry_backup_job');
-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

