REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: Config
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'Config';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(5);
    l_commands(1) := 'preConfigCommand';
    l_commands(2) := 'fileTransfer';
    l_commands(3) := 'postConfigCommand';
    l_commands(4) := 'undoConfigCommand';
    l_commands(5) := 'configCommand';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 0, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET main
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'main', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET preConfigSet
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'preConfigSet', 2, null, null, 1, 'main', 2, null, null, null, null, null, 1, 'main', 'preConfig', null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP preConfig
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(5);
    l_param_names(1) := 'configType';
    l_param_names(2) := 'targetOracleHome';
    l_param_names(3) := 'targetHost';
    l_param_names(4) := 'targetHostUser';
    l_param_names(5) := 'needFileCopy';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'preConfig', 1, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(6);
    l_param_names(1) := 'sourceTargetName';
    l_param_names(2) := 'sourceTargetType';
    l_param_names(3) := 'sourceHostUser';
    l_param_names(4) := 'metafileFullname';
    l_param_names(5) := 'metafileName';
    l_param_names(6) := 'destWorkDir';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'preConfig', 1, 'user', 2, null, 0, 0, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'targetHostPassword';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'preConfig', 1, 'user', 3, null, 0, 1, 1, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'sourceHostPassword';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'preConfig', 1, 'user', 4, null, 0, 0, 1, l_param_names );


END;
END;


-- ENTRIES FOR STEP preConfig
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'preConfig', 1, null, null, 1, 'preConfigSet', 2, null, null, null, null, null, 0, 'preConfigSet', null, 'preConfigCommand', 1, 1, 0, 0, null, null, 1 );

-- ENTRIES FOR STEP undoPreConfig
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'undoPreConfig', 1, null, null, 8, 'preConfig', 1, null, null, null, null, null, 0, 'preConfigSet', null, 'undoConfigCommand', 2, 1, 0, 0, null, null, 1 );

-- ENTRIES FOR STEPSET optionalFileCopy
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'optionalFileCopy', 3, null, null, 7, 'preConfigSet', 2, 'needFileCopy', null, null, null, null, 1, 'main', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP FilesTransfer
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'FilesTransfer', 1, null, null, 3, 'optionalFileCopy', 3, null, null, 'Y', null, null, 0, 'optionalFileCopy', null, 'fileTransfer', 1, 0, 0, 0, null, null, 1 );

--  STEP PARAMETERS FOR STEP FilesTransfer
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'sourceTargetName', 1, 0, '%sourceTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'sourceTargetType', 1, 0, '%sourceTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'destTargetName', 1, 0, '%targetHost%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'destTargetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'sourceCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'sourceArgs', 1, 0, '%emd_root%/sysman/admin/scripts/createJarStream_v2.pl,%emd_root%/jdk/bin/jar,%metafileFullname%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'destCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'destArgs', 1, 0, '%emd_root%/sysman/admin/scripts/readJarStream_v2.pl,%emd_root%/jdk/bin/jar,%metafileName%,YES,NO,%destWorkDir%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'sourceUsername', 1, 0, '%sourceHostUser%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'sourcePassword', 1, 0, '%sourceHostPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'destUsername', 1, 0, '%targetHostUser%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FilesTransfer', 'destPassword', 1, 0, '%targetHostPassword%', null, null );


END;
END;


-- ENTRIES FOR STEPSET mainConfigSet
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'mainConfigSet', 2, null, null, 7, 'optionalFileCopy', 3, null, null, null, null, null, 1, 'main', 'mainConfig', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP mainConfig
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'mainConfig', 1, null, null, 1, 'mainConfigSet', 2, null, null, null, null, null, 0, 'mainConfigSet', null, 'configCommand', 1, 1, 0, 0, null, null, 1 );

-- ENTRIES FOR STEP undoMainConfig
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'undoMainConfig', 1, null, null, 8, 'mainConfig', 1, null, null, null, null, null, 0, 'mainConfigSet', null, 'undoConfigCommand', 2, 1, 0, 0, null, null, 1 );

-- ENTRIES FOR STEPSET postConfigSet
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postConfigSet', 2, null, null, 7, 'mainConfigSet', 2, null, null, null, null, null, 1, 'main', 'postConfig', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP postConfig
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postConfig', 1, null, null, 1, 'postConfigSet', 2, null, null, null, null, null, 0, 'postConfigSet', null, 'postConfigCommand', 1, 1, 0, 0, null, null, 1 );

-- ENTRIES FOR STEP undoPostConfig
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'undoPostConfig', 1, null, null, 8, 'postConfig', 1, null, null, null, null, null, 0, 'postConfigSet', null, 'undoConfigCommand', 2, 1, 0, 0, null, null, 1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'configType', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'targetHost', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'targetHostUser', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'targetOracleHome', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'jobName', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'jobOwner', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- DISPLAYINFO ENTRIES
INSERT INTO MGMT_JOB_TYPE_DISPLAY_INFO(job_type_id, nls_bundle,use_default_create_ui)  VALUES
	( l_job_type_id, 'oracle.sysman.db.rsc.config.ConfigJobMsg', 0 );

-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

