REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: DGBackup
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'DGBackup';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(1);
    l_commands(1) := 'remoteOp';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 0, 1, -1, 'DGBackup_DGBackup', 'Data Guard Primary Database Backup', null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET Main
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'Main', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP sourceCloningPreparation
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(19);
    l_param_names(1) := 'clonePurpose';
    l_param_names(2) := 'sourceOracleHome';
    l_param_names(3) := 'sourceOracleSide';
    l_param_names(4) := 'sourceDBUsername';
    l_param_names(5) := 'sourceUsername';
    l_param_names(6) := 'sourceTempDir';
    l_param_names(7) := 'sourcePasswdFile';
    l_param_names(8) := 'sourcePasswdFileUsage';
    l_param_names(9) := 'srcTempPasswdFile';
    l_param_names(10) := 'sourceInitFile';
    l_param_names(11) := 'sourceCtlFile';
    l_param_names(12) := 'srcBackupPieceNames';
    l_param_names(13) := 'srcBackupArchName';
    l_param_names(14) := 'srcTNSAddr';
    l_param_names(15) := 'initMaxLogSeqNum';
    l_param_names(16) := 'retainBackupSet';
    l_param_names(17) := 'datafile_num_array';
    l_param_names(18) := 'compressBackupFiles';
    l_param_names(19) := 'dbVer';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'sourceCloningPreparation', 1, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'sourcePassword';
    l_param_names(2) := 'sourceDBPassword';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'sourceCloningPreparation', 1, 'user', 2, null, 0, 1, 1, l_param_names );


END;
END;


-- ENTRIES FOR STEP sourceCloningPreparation
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'sourceCloningPreparation', 1, null, null, 1, 'Main', 2, null, null, null, null, null, 0, 'Main', null, 'remoteOp', 1, 0, 0, 0, 'DBClone_sourceCloningPreparation', 'Souce Cloning Preparation', 1 );

--  STEP PARAMETERS FOR STEP sourceCloningPreparation
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'input', 1, 0, '
                

                    my $useExistingBackupSet = ''%useExistingBackupSet%'';
                    my $useRMANBackup = ''%useRMANBackup%'';
                    my $sourceDBUsername = ''%sourceDBUsername%'';
                    my $sourceDBPassword = ''%sourceDBPassword%'';
                    my $srcTNSAddr = ''%srcTNSAddr%'';
                    my $coldCloneFlag = ''N'';
                    my $passwordFileUsage = ''%sourcePasswdFileUsage%'';
                    my $sourceOracleSid = ''%sourceOracleSide%'';
                    my $sourceInitFile = ''%sourceInitFile%''; 
                    my $sourceCtlFile = ''%sourceCtlFile%''; 
                    my $sourcePasswdFile = ''%sourcePasswdFile%'';
                    my $srcTempPasswdFile = ''%srcTempPasswdFile%'';
                    my $useRMANBackup = ''N'';

                    require "$ENV{EMDROOT}/sysman/admin/scripts/db/dbclone/db_clone.pl";
                    set_env(''%sourceOracleHome%'', $sourceOracleSid);
                    setSrcDBCredential($sourceDBUsername, $sourceDBPassword, $srcTNSAddr);
                    setClonePurpose($ARGV[0]);
                    mkDir(''%sourceTempDir%'');
                
            ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'args', 1, 0, '-, %clonePurpose%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'largeInputParam', 1, 0, 'sourcePrepareInput', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'username', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'password', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'sourceCloningPreparation', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- ENTRIES FOR STEPSET backupDatafiles
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'backupDatafiles', 5, null, null, 7, 'sourceCloningPreparation', 1, null, null, null, 'datafile_num_array', null, 1, 'Main', null, null, 1, 0, 0, 1, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'backupDatafiles', 2, null, null, 5, 'backupDatafiles', 5, null, null, null, 'datafile_num_array', null, 1, 'backupDatafiles', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP backupOneDatafile
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'backupOneDatafile', 1, null, null, 1, 'backupDatafiles', 2, null, null, null, null, null, 0, 'backupDatafiles', null, 'remoteOp', 1, 0, 0, 0, 'DBClone_backupOneDatafile', 'Backup One Datafile', 1 );

--  STEP PARAMETERS FOR STEP backupOneDatafile
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'backupOneDatafile', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'backupOneDatafile', 'input', 1, 0, '
                    
                        require "$ENV{EMDROOT}/sysman/admin/scripts/db/dbclone/db_clone.pl";
                        set_env(''%sourceOracleHome%'', ''%sourceOracleSide%'');
                        setSrcDBCredential(''%sourceDBUsername%'', ''%sourceDBPassword%'', ''%srcTNSAddr%'');
                        my $datafileBackupPiece = ''%srcBackupPieceNames%[%job_iterate_index%]'';
                        my $datafileNumber = ''%datafile_num_array%[%job_iterate_index%]'';
                        my $compressBackupPiece = ''%compressBackupFiles%'';
                    
                ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'backupOneDatafile', 'largeInputParam', 1, 0, 'backupOneDatafileInput', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'backupOneDatafile', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'backupOneDatafile', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'backupOneDatafile', 'username', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'backupOneDatafile', 'password', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'backupOneDatafile', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- ENTRIES FOR STEP createControlFile
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'createControlFile', 1, null, null, 7, 'backupDatafiles', 5, null, null, null, null, null, 0, 'Main', null, 'remoteOp', 1, 0, 0, 0, 'DBClone_createControlFile', 'Create Control File', 1 );

--  STEP PARAMETERS FOR STEP createControlFile
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createControlFile', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createControlFile', 'input', 1, 0, '
                
                    require "$ENV{EMDROOT}/sysman/admin/scripts/db/dbclone/db_clone.pl";
                    require "$ENV{EMDROOT}/sysman/admin/scripts/db/dg/dgutil.pl";
                    set_env(''%sourceOracleHome%'', ''%sourceOracleSide%'');
                    setSrcDBCredential(''%sourceDBUsername%'', ''%sourceDBPassword%'', ''%srcTNSAddr%'');
                    my $cfile = ''%sourceCtlFile%'';
                    setClonePurpose(''STANDBY_NO_RECOVERY'');
                    $cfile =~ s/$ARGV[0]/STANDBY_NO_RECOVERY/;
                    createStandbyCtlFile($cfile);
                    my $db_version = ''%dbVer%'';
                    if ($db_version =~ /92/){
                      print("Creating controlfile for 9iR2 logical standby\n");
                      setClonePurpose(''LOGICAL_STANDBY'');
                      $cfile =~ s/STANDBY_NO_RECOVERY/LOGICAL_STANDBY/;
                    }
                    else{
                      print("Creating controlfile for 10g logical standby\n");
                      setClonePurpose(''LOGICAL_STANDBY_10i'');
                      $cfile =~ s/STANDBY_NO_RECOVERY/LOGICAL_STANDBY_10i/;
                    }
                    createStandbyCtlFile($cfile);
                    exit 0; 
                
            ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createControlFile', 'args', 1, 0, '-, %clonePurpose%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createControlFile', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createControlFile', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createControlFile', 'username', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createControlFile', 'password', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createControlFile', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- ENTRIES FOR STEP archiveCurrentLogs
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'archiveCurrentLogs', 1, null, null, 7, 'createControlFile', 1, null, null, null, null, null, 0, 'Main', null, 'remoteOp', 1, 0, 0, 0, 'DBClone_archiveCurrentLogs', 'Archive Current Logs', 1 );

--  STEP PARAMETERS FOR STEP archiveCurrentLogs
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'archiveCurrentLogs', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'archiveCurrentLogs', 'input', 1, 0, '
        
          require "$ENV{EMDROOT}/sysman/admin/scripts/db/dbclone/db_clone.pl";
          set_env(''%sourceOracleHome%'', ''%sourceOracleSide%'');
          setSrcDBCredential(''%sourceDBUsername%'', ''%sourceDBPassword%'', ''%srcTNSAddr%'');
          setClonePurpose(%clonePurpose%);
          backupLog(''%srcBackupArchName%'', ''%initMaxLogSeqNum%''); 
          exit 0; 
          
        ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'archiveCurrentLogs', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'archiveCurrentLogs', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'archiveCurrentLogs', 'username', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'archiveCurrentLogs', 'password', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'archiveCurrentLogs', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- SECURITY INFO ENTRIES
BEGIN
DECLARE
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_target_names.trim(l_target_names.count);

    l_target_names.extend(1);
    l_target_names(1) := '%job_target_names%[1]';

    l_target_types.trim(l_target_types.count);

    l_target_types.extend(1);
    l_target_types(1) := '%job_target_types%[1]';
    
	INSERT INTO MGMT_JOB_SEC_INFO(job_type_id,  apply_at_submission, privilege_name, privilege_type,  target_names, target_types, target_names_param,  target_types_param)  VALUES
	(     l_job_type_id, 1, 'MAINTAIN_TARGET', 1, l_target_names, l_target_types, null, null );


END;
END;


-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'em_target_name', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'sourceOracleHome', 1, 1, 'DBClone_sourceOracleHome', 'Source Oracle Home', null, null, 3, null, null, null, 0 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'compressBackupFiles', 1, 1, 'DBClone_compressBackupFiles', 'Compress the backup datafiles in the working directory', null, null, 3, null, null, null, 1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'sourceOracleSide', 1, 1, 'DBClone_sourceOracleSide', 'Source Oracle SID', null, null, 3, null, null, null, 2 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'destOracleHome', 1, 1, 'DBClone_destOracleHome', 'Destination Oracle Home', null, null, 3, null, null, null, 3 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'destOracleSid', 1, 1, 'DBClone_destOracleSid', 'Destination Oracle SID', null, null, 3, null, null, null, 4 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'destDbName', 1, 1, 'DBClone_destDbName', 'Destination DB Name', null, null, 3, null, null, null, 5 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'sourceUsername', 1, 1, 'DBClone_sourceUsername', 'Source User Name', null, null, 3, null, null, null, 6 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'destUsername', 1, 1, 'DBClone_destUsername', 'Destination User Name', null, null, 3, null, null, null, 7 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'sourceTempDir', 1, 1, 'DBClone_sourceTempDir', 'Source Temp Directory', null, null, 3, null, null, null, 8 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'destTempDir', 1, 1, 'DBClone_destTempDir', 'Destination Temp Directory', null, null, 3, null, null, null, 9 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'destListenerName', 1, 1, 'DBClone_destListenerName', 'Destination Listener Name', null, null, 3, null, null, null, 10 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'destListenerFile', 1, 1, 'DBClone_destListenerFile', 'Destination Listener File', null, null, 3, null, null, null, 11 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'retainBackupSet', 1, 1, 'DBClone_retainBackupSet', 'Retain Backup Set', null, null, 3, null, null, null, 12 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'useExistingBackupSet', 1, 1, 'DBClone_useExistingBackupSet', 'Use Existing Backup Set', null, null, 3, null, null, null, 13 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'ftpHttp', 1, 1, 'DBClone_ftpHttp', null, null, null, 3, null, null, null, 14 );

-- DISPLAYINFO ENTRIES
INSERT INTO MGMT_JOB_TYPE_DISPLAY_INFO(job_type_id, nls_bundle,use_default_create_ui)  VALUES
	( l_job_type_id, 'oracle.sysman.db.rsc.DBCloneJobMsg', 0 );

-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

