REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: IntegrateTTS
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'IntegrateTTS';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(2);
    l_commands(1) := 'remoteOp';
    l_commands(2) := 'echoParams';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 0, 0, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET main
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'main', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP target_copy_or_convert
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(24);
    l_param_names(1) := 'oracle_home';
    l_param_names(2) := 'oracle_sid';
    l_param_names(3) := 'tns_connect';
    l_param_names(4) := 'host_username';
    l_param_names(5) := 'db_username';
    l_param_names(6) := 'db_role_suffix';
    l_param_names(7) := 'is_rac';
    l_param_names(8) := 'job_name';
    l_param_names(9) := 'db_10_or_higher';
    l_param_names(10) := 'copy_or_convert';
    l_param_names(11) := 'from_platform';
    l_param_names(12) := 'to_platform';
    l_param_names(13) := 'parallelism';
    l_param_names(14) := 'generate_log';
    l_param_names(15) := 'log_file_name';
    l_param_names(16) := 'parse_errors';
    l_param_names(17) := 'smp_ignore';
    l_param_names(18) := 'make_ts_rw';
    l_param_names(19) := 'ts_list';
    l_param_names(20) := 'df_list';
    l_param_names(21) := 'directory_object_name';
    l_param_names(22) := 'directory_path';
    l_param_names(23) := 'create_df_dirs';
    l_param_names(24) := 'dmpfile_format10g';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'target_copy_or_convert', 3, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'host_password';
    l_param_names(2) := 'db_password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'target_copy_or_convert', 3, 'user', 2, null, 0, 0, 1, l_param_names );


END;
END;


-- ENTRIES FOR STEPSET target_copy_or_convert
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'target_copy_or_convert', 3, null, null, 1, 'main', 2, 'copy_or_convert', null, null, null, null, 1, 'main', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP Convert_Datafile
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'Convert_Datafile', 1, null, null, 3, 'target_copy_or_convert', 3, null, null, 'convertDatafile', null, null, 0, 'target_copy_or_convert', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP Convert_Datafile
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Convert_Datafile', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Convert_Datafile', 'input', 1, 0, '
            
            require "$ENV{EMDROOT}/sysman/admin/scripts/db/dataUtilities/tts.pl";
            $oracle_home = ''%oracle_home%'';
            $oracle_sid = ''%oracle_sid%'';     
            $tns_connect = ''%tns_connect%'';
            $db_username = ''%db_username%'';
            $db_passwd = ''%db_password%'';
            $db_role = ''%db_role_suffix%'';  
            $job_name =''%job_name%'';                
            $db_10_or_higher =''%db_10_or_higher%'';
            $dmpfile_format10g =''%dmpfile_format10g%'';
            $ts_df_list =''%df_list%'';
            create_dirs(''%directory_object_name%'', ''%directory_path%'', ''%create_df_dirs%'');
            my $from_platform = ''%from_platform%'';
            my $to_platform = ''%to_platform%'';
            my $parallelism = ''%parallelism%'';
            my $log_file_name = ''%log_file_name%'';
          
        ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Convert_Datafile', 'largeInputParam', 1, 0, 'rman_script', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Convert_Datafile', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Convert_Datafile', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Convert_Datafile', 'username', 1, 0, '%host_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Convert_Datafile', 'password', 1, 0, '%host_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Convert_Datafile', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- ENTRIES FOR STEP Copy_Datafile
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'Copy_Datafile', 1, null, null, 3, 'target_copy_or_convert', 3, null, null, 'copyDatafile', null, null, 0, 'target_copy_or_convert', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP Copy_Datafile
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Copy_Datafile', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Copy_Datafile', 'input', 1, 0, '
            
              require "$ENV{EMDROOT}/sysman/admin/scripts/db/dataUtilities/tts.pl";
              $oracle_home = ''%oracle_home%'';
              $oracle_sid = ''%oracle_sid%'';     
              $tns_connect = ''%tns_connect%'';
              $db_username = ''%db_username%'';
              $db_passwd = ''%db_password%'';
              $db_role = ''%db_role_suffix%''; 
              $job_name =''%job_name%'';
              create_dirs(''%directory_object_name%'', ''%directory_path%'', ''%create_df_dirs%'');
            
            ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Copy_Datafile', 'largeInputParam', 1, 0, 'rman_script', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Copy_Datafile', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Copy_Datafile', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Copy_Datafile', 'username', 1, 0, '%host_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Copy_Datafile', 'password', 1, 0, '%host_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Copy_Datafile', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- ENTRIES FOR STEP No_Copy_or_Convert
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'No_Copy_or_Convert', 1, null, null, 3, 'target_copy_or_convert', 3, null, null, 'none', null, null, 0, 'target_copy_or_convert', null, 'echoParams', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP No_Copy_or_Convert
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'No_Copy_or_Convert', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'No_Copy_or_Convert', 'targetType', 1, 0, '%job_target_types%[1]', null, null );


END;
END;


-- ENTRIES FOR STEP Import
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'Import', 1, null, null, 7, 'target_copy_or_convert', 3, null, null, null, null, null, 0, 'main', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP Import
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Import', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Import', 'input', 1, 0, '
              
                require "$ENV{EMDROOT}/sysman/admin/scripts/db/dataUtilities/tts.pl";                      
                $oracle_home = ''%oracle_home%'';
                $oracle_sid = ''%oracle_sid%'';     
                $tns_connect = ''%tns_connect%'';
                $db_username = ''%db_username%'';
                $db_passwd = ''%db_password%'';
                $db_role = ''%db_role_suffix%''; 
                $job_name =''%job_name%'';
                $db_10_or_higher =''%db_10_or_higher%'';                
                $dmpfile_format10g =''%dmpfile_format10g%'';
                $ts_rw = ''%make_ts_rw%'';

                my $smp_ignore = ''%smp_ignore%'';
                my $generate_log = ''%generate_log%'';
                my $parse_errors = ''%parse_errors%'';
                my $log_file_name = ''%log_file_name%'';
                my $ts_list = ''%ts_list%'';
              
          ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Import', 'largeInputParam', 1, 0, 'tts_import_script', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Import', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Import', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Import', 'username', 1, 0, '%host_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Import', 'password', 1, 0, '%host_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Import', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'df_list', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'ts_list', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_username', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_role_suffix', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_host_username', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'from_platform', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'to_platform', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'is_rac', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'oracle_home', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'oracle_sid', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'tns_connect', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'job_name', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- DISPLAYINFO ENTRIES
INSERT INTO MGMT_JOB_TYPE_DISPLAY_INFO(job_type_id, nls_bundle,use_default_create_ui)  VALUES
	( l_job_type_id, 'oracle.sysman.db.rsc.impexp.TransportMsg', 0 );

-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

