REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: StartupDB
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'StartupDB';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(1);
    l_commands(1) := 'remoteOp';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 1, 1, 1, null, 1, 1, 0, -1, 'StartupDB_StartupDB', 'Startup Database', null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

INSERT INTO MGMT_JOB_SINGLE_TARGET_TYPES(job_type_id, single_target_type)  VALUES
	( l_job_type_id, 'oracle_database' );

MGMT_JOB_ENGINE.insert_cluster_target_types(l_job_type_id);

-- ENTRIES FOR STEPSET main
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'main', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP Command
-- PARAM SOURCE: source type properties
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(8);
    l_param_names(1) := 'MachineName';
    l_param_names(2) := 'Port';
    l_param_names(3) := 'SID';
    l_param_names(4) := 'OracleHome';
    l_param_names(5) := 'InstanceName';
    l_param_names(6) := 'DBVersion';
    l_param_names(7) := 'RACOption';
    l_param_names(8) := 'Database';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'Command', 1, 'properties', 1, '
    ', 1, 0, 0, l_param_names );


END;
END;


-- PROPERTIES PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_prop_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_prop_columns.trim(l_prop_columns.count);

    l_prop_columns.extend(8);
    l_prop_columns(1) := 'MachineName';
    l_prop_columns(2) := 'Port';
    l_prop_columns(3) := 'SID';
    l_prop_columns(4) := 'OracleHome';
    l_prop_columns(5) := 'InstanceName';
    l_prop_columns(6) := 'DBVersion';
    l_prop_columns(7) := 'RACOption';
    l_prop_columns(8) := 'DBName';
    INSERT INTO MGMT_JOB_PROP_PARAMS(source_id, 
                         property_names, 
                         property_names_param, 
                         target_names, 
                         target_types, 
                         target_names_param, 
                         target_types_param) 
   SELECT source_id, l_prop_columns, null, null, null, 'job_target_names', 'job_target_types'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id          AND source_index=1;
END;
END;


-- PARAM SOURCE: source type credentials
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'host_username';
    l_param_names(2) := 'host_password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'Command', 1, 'credentials', 2, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- CREDENTIAL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_cred_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_container_paths MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_cred_type_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_cred_columns.trim(l_cred_columns.count);

    l_cred_columns.extend(2);
    l_cred_columns(1) := 'HostUsername';
    l_cred_columns(2) := 'HostPassword';
    INSERT INTO MGMT_JOB_CRED_PARAMS(source_id, 
                         credential_set_name, 
                         credential_set_target_type, 
                         base_cred_type_name, 
                         base_cred_type_target_type, 
                         base_cred_type_columns, 
                         credential_columns, 
                         credential_columns_param, 
                         target_names, 
                         target_types, 
                         container_paths, 
                         target_names_param, 
                         target_types_param, 
                         container_paths_param, 
                         set_override) 
       SELECT source_id, 'DBHostCreds', 'oracle_database', null, null, null, l_cred_columns, null, null, null, null, 'job_target_names', 'job_target_types', null, 0         FROM   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id            AND source_index=2;
END;
END;


-- PARAM SOURCE: source type credentials
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(3);
    l_param_names(1) := 'db_username';
    l_param_names(2) := 'db_password';
    l_param_names(3) := 'db_role';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'Command', 1, 'credentials', 3, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- CREDENTIAL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_cred_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_container_paths MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_cred_type_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_cred_columns.trim(l_cred_columns.count);

    l_cred_columns.extend(3);
    l_cred_columns(1) := 'sysDBAUserName';
    l_cred_columns(2) := 'sysDBAPassword';
    l_cred_columns(3) := 'sysDBARole';
    INSERT INTO MGMT_JOB_CRED_PARAMS(source_id, 
                         credential_set_name, 
                         credential_set_target_type, 
                         base_cred_type_name, 
                         base_cred_type_target_type, 
                         base_cred_type_columns, 
                         credential_columns, 
                         credential_columns_param, 
                         target_names, 
                         target_types, 
                         container_paths, 
                         target_names_param, 
                         target_types_param, 
                         container_paths_param, 
                         set_override) 
       SELECT source_id, 'DBCredsSYSDBA', 'oracle_database', null, null, null, l_cred_columns, null, null, null, null, 'job_target_names', 'job_target_types', null, 0         FROM   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id            AND source_index=3;
END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'host_password';
    l_param_names(2) := 'db_password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'Command', 1, 'user', 4, null, 0, 0, 1, l_param_names );


END;
END;


-- PARAM SOURCE: source type sql
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'db_role_suffix';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'Command', 1, 'sql', 5, '
        SELECT ''db_role_suffix'', decode(UPPER(''%db_role%''), ''SYSDBA'', ''SYSDBA'', decode(UPPER(''%db_role%''), ''SYSOPER'', ''SYSOPER'','''')) FROM DUAL
    ', 0, 0, 0, l_param_names );


END;
END;


-- SQL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_vector_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_SQL_PARAMS(source_id, 
                      vector_params, 
                      out_proc, 
                      out_param_type) 
  SELECT source_id, l_vector_params, 0, null     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=5;
END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'startupOptions';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'Command', 1, 'user', 6, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'TargetName';
    l_param_names(2) := 'TargetType';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'Command', 1, 'inline', 7, '
    ', 1, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(2);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'TargetName';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := '%job_target_names%[1]';
    l_params(1).vector_value := null;
    l_params(2) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(2).param_name := 'TargetType';
    l_params(2).param_type := 1;
    l_params(2).scalar_value := '%job_target_types%[1]';
    l_params(2).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=7;
END;
END;


-- PARAM SOURCE: source type substValues
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'startupOptions';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'Command', 1, 'substValues', 8, '
    ', 1, 0, 0, l_param_names );


END;
END;


-- SUBSTVALUES PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_source_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_source_params.trim(l_source_params.count);

    l_source_params.extend(1);
    l_source_params(1) := 'startupOptions';
    INSERT INTO MGMT_JOB_SUBST_PARAMS(source_id, 
                      source_params) 
 SELECT source_id, l_source_params     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=8;
END;
END;


-- ENTRIES FOR STEP Command
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'Command', 1, null, null, 1, 'main', 2, null, null, null, null, null, 0, 'main', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP Command
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'input', 1, 0, '
                
                $oracle_home=q''%OracleHome%[1]'';
                $oracle_sid=q''%SID%[1]'';
                $db_name="%Database%";
		$username=q''%db_username%'';
                $password=q''%db_password%'';
                $role=q''%db_role_suffix%'';
                $target_name=q''%job_target_names%[1]'';
                $target_type=q''%job_target_types%[1]'';
		$startupMode="%mode%";
		$readOnly="%readOnly%";
                $useDefaultConfiguration="%useDefaultConfiguration%";
		$pfile="%pfile%";
		$restricted="%restricted%";
		$force="%force%";
#               print "oracleHome:$oracle_home\n";
#               print "dbName: $db_name\n";
#		print "startupMode:$startupMode\n";
#		print "readOnly:$readOnly\n";
#		print "useDefaultConfiguration:$useDefaultConfiguration\n";
#		print "pfile:$pfile\n";
#		print "restricted:$restricted\n";
#		print "force:$force\n";
                $arrayElem="Startup %startupOptions%;\n";
                ' || CHR(ASCII('@')) || 'sqlListParseError=(' || CHR(ASCII('@')) || 'sqlListParseError,$arrayElem);
		if($target_type eq "rac_database")
                {
                  require "$ENV{EMDROOT}/sysman/admin/scripts/rac/rac_srvctl.pl";
                  $version="10";  # 10.1 compatibility
                  $ENV{ORACLE_HOME}=$oracle_home;
                  delete $ENV{JAVA_HOME};
                  delete $ENV{LD_LIBRARY_PATH};

                  if ($startupMode eq "start") {
                      $startupMode = "nomount";
                  }
                  $startupOption="\"$startupMode";
                  if ($readOnly eq "true") {
                     $startupOption = "$startupOption read only";
                  }
                  if ($restricted eq "true") {
                     $startupOption = "$startupOption restrict";
                  }
                  if ($force eq "true") {
                     $startupOption = "$startupOption force";
                  }
                  $startupOption = "$startupOption \"";
#                  print ("startupoption = $startupOption\n");

                  $exitCode=startup_rac($db_name, $startupOption, "", "", ''true'', $oracle_home, $oracle_sid);
                  exit($exitCode);
                }
                else
                {
                   if($target_type eq "oracle_database")
                   {
                     require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_instance.pl";
	             change_db_state();
                   }
		}
                
            ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'username', 1, 0, '%host_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'password', 1, 0, '%host_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'executeSynchronous', 1, 0, 'false', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'successStatus', 1, 0, '0,1', null, null );


END;
END;


-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_username', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_password', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'db_role_suffix', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'host_username', 0, 1, null, null, null, null, 3, null, null, null, -1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'host_password', 0, 1, null, null, null, null, 3, null, null, null, -1 );

INSERT INTO MGMT_JOB_TYPE_PARAM_URI_INFO(job_type_id, uri, class,help_topic,task_help_topic,show_target_properties)   VALUES
	( l_job_type_id, 'database/instance/changeState/startupDBJobParam.jsp', 'oracle.sysman.db.adm.jobintg.StartupDBJobParamController', 'my_Custom_Online_Help_Topic', null, 1 );

-- PARAMETERDISPLAYINFO ENTRIES 
INSERT INTO  MGMT_JOB_TYPE_PARAM_DSPLY_INFO (job_type_id   , parameter_name ,show_in_create ,    show_in_results ,label_nlsid ,    label_default , hint_nlsid  ,    hint_default ,    display_mode ,    num_lines ,    default_text , default_nlsid , param_order)  VALUES
	( l_job_type_id, 'startupOptions', 0, 1, 'StartupDB_startupOptions', 'Startup Options', null, null, 3, null, null, null, 0 );

-- DISPLAYINFO ENTRIES
INSERT INTO MGMT_JOB_TYPE_DISPLAY_INFO(job_type_id, nls_bundle,use_default_create_ui)  VALUES
	( l_job_type_id, 'oracle.sysman.db.rsc.inst.ChangeStateMsg', 1 );

INSERT INTO MGMT_JOB_TYPE_URI_INFO(job_type_id, uri_use, uri, is_jsp, class)  VALUES
	( l_job_type_id, 0, 'jobs/sqlParameters.jsp', 0, null );

-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

