Rem drv: <create type="pkgdefs"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/masking/dm_pkgdef.sql /st_emdbsa_11.2/1 2009/01/29 14:28:58 kmckeen Exp $
Rem
Rem dm_pkgdef.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dm_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpattabh    06/12/08 - Compound Masking Changes
Rem    xshen       02/19/08 - eliminate dynamic sql for security
Rem    xshen       02/04/08 - continue conditional masking
Rem    xshen       11/27/07 - conditional masking
Rem    xshen       03/27/07 - priv checks
Rem    xshen       03/15/07 - consts
Rem    xshen       12/03/06 - masking job api
Rem    xshen       09/20/06 - array list
Rem    xshen       08/07/06 - add get_masking_definitions call
Rem    xshen       07/26/06 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_DM AS 
  
  -- rule types
  rule_type_arraylist    CONSTANT VARCHAR2(2) := 'AL';
  rule_type_tablecolumn  CONSTANT VARCHAR2(2) := 'CC';
  rule_type_randomdate   CONSTANT VARCHAR2(2) := 'DT';
  rule_type_randomdigit  CONSTANT VARCHAR2(2) := 'RD';
  rule_type_randomnumber CONSTANT VARCHAR2(2) := 'RN';
  rule_type_randomstring CONSTANT VARCHAR2(2) := 'RS';
  rule_type_fixednumber  CONSTANT VARCHAR2(2) := 'FN';
  rule_type_fixedstring  CONSTANT VARCHAR2(2) := 'FS';
  rule_type_userdefined  CONSTANT VARCHAR2(2) := 'UF';
  rule_type_postudf      CONSTANT VARCHAR2(2) := 'UT';
  rule_type_shuffle      CONSTANT VARCHAR2(2) := 'SH';
  rule_type_substr       CONSTANT VARCHAR2(2) := 'SS';
  rule_type_droprow      CONSTANT VARCHAR2(2) := 'DR';
  rule_type_preserve     CONSTANT VARCHAR2(2) := 'PR';

  -- rule output types
  output_type_source     CONSTANT INTEGER := 0; 
  output_type_string     CONSTANT INTEGER := 1;
  output_type_number     CONSTANT INTEGER := 2;
  output_type_date       CONSTANT INTEGER := 3;

  -- masking metadata object type
  masking_definition_t   CONSTANT INTEGER := 0;
  masking_format_t       CONSTANT INTEGER := 1;

  TYPE weak_cur_typ IS REF CURSOR;

  -- Create a masking definition, return ss guid
  function create_masking_definition(
        p_owner in varchar2,
        p_name in varchar2,
        p_source_name in varchar2,
        p_source_type in varchar2,
        p_description in varchar2 default null)
  return raw;

  -- Create a masking rule, depending on is_library, either an internal rule or library template, return rule guid
  function create_masking_rule(
        p_owner in varchar2,
        p_name in varchar2,
        p_description in varchar2 default null,
        p_data_type in number default 0,
        p_is_library in number default 0,
	p_rule_order in number default 1,
	p_rule_condition in varchar2 default null,
	p_ss_guid in raw default null,
	p_masked_schema in varchar2 default null,
	p_masked_table in varchar2 default null,
	p_masked_column in varchar2 default null)
  return raw;

  -- TBD: Priv checks for remove, update.
  procedure remove_masking_rule(p_rule_guid in raw);

  procedure remove_rule_entries(p_rule_guid in raw);

  procedure update_masking_rule(
        p_rule_guid in raw,
        p_name in varchar2,
        p_description in varchar2 default null,
        p_data_type in number default 0,
        p_is_library in number default 0);

  procedure add_rule_entry(
        p_rule_guid in raw,
        p_entry_order in number,
        p_rule_type in varchar2, 
        p_rule_option in varchar2,
        p_rule_low in number,
        p_rule_high in number,
        p_start_date in date,
        p_end_date in date,
        p_fixed_string in varchar2,
        p_fixed_number in number,
        p_table_schema in varchar2,
        p_table_name in varchar2,
        p_column_name in varchar2,
        p_udf_name in varchar2,
        p_arr_list in mgmt_dm_array_list default null);

  procedure add_ss_column(
        p_ss_guid in raw,
        p_table_schema in varchar2, 
        p_table_name in varchar2,
        p_column_name in varchar2,
        p_column_group in varchar2);

  procedure add_infcons_column(
        p_ss_guid in raw,
        p_table_schema in varchar2, 
        p_table_name in varchar2,
        p_column_name in varchar2,
        p_parent_schema in varchar2, 
        p_parent_table in varchar2,
        p_parent_column in varchar2);

  procedure get_masking_rule_arraylist(
        p_rule_guid   in raw,
        p_entry_order in number,
        p_array_list  out mgmt_dm_array_list);

  procedure remove_masking_definition(
        p_ss_guid in raw);

  procedure add_masking_job(
        p_ss_guid in raw,
        p_execution_id in raw);

  function has_remove_priv(
        p_guid in raw, 
        p_type in number) 
  return number;

END;
/

show errors;

