Rem drv: <create type="pkgdefs"/>
Rem
Rem $Header: net_pkgdefs.sql 12-sep-2005.04:41:33 vivsharm Exp $
Rem
Rem net_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      net_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vivsharm    09/12/05 - perf fix 
Rem    jpegu       07/08/05 - Performance Bug: 4470041 add get_lsnr_home_page_data
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    hasriniv    10/16/03 - Moving proc get_lsnr_homepage_info here 
Rem    hasriniv    09/03/03 - Fix for bug 312259 
Rem    dkapoor     02/05/03 - dkapoor_impl_net_srvc
Rem    dkapoor     11/08/02 - implement
Rem    dkapoor     11/04/02 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_DBNET AS

-- Package level Type Definition
   TYPE cursorType IS REF CURSOR;

/*
Get the oracle homes and tns_admin locations for a Host Target.
The values returned as OUT parameters are used for Oracle Net Services Administration
*/
procedure getNetAdminInfo(
	hostName IN VARCHAR2,
        hostType IN VARCHAR2,
        netAdmin_cur_out OUT cursorType);

/*
Return a cursor for the chart data based on the value for RANGE
*/
procedure getLsnrPerfChartData(
      	l_lsnrtargetName	IN	VARCHAR2,
        l_range			IN	VARCHAR2,
        l_lsnrData_cur_out	OUT	cursorType);


/*
Updates MGMT_DBNET_TNS_ADMINS
with the oracle homes and tns_admin locations for the specified Host Target.
*/
procedure updateNetAdminInfo(
      	hostName IN VARCHAR2,
        hostType IN VARCHAR2,
        fileSeparator IN VARCHAR2) ;


/*
Update MGMT_DBNET_TNS_ADMINS
with the oracle home and tns_admin location for the specified Host Target.
*/
procedure updateTNS_ADMIN(
      	hostName IN VARCHAR2,
        hostType IN VARCHAR2,
        oracleHome IN VARCHAR2, 
        tnsadmin  IN VARCHAR2) ;

/*
Update MGMT_DBNET_TNS_ADMINS
with the oracle home and tns_admin location for the specified Host Target.
*/
procedure updateTNS_ADMIN_FOR_SA(
      	hostName IN VARCHAR2,
        hostType IN VARCHAR2,
        oracleHome IN VARCHAR2, 
        tnsadmin  IN VARCHAR2) ;

/*
Gets a target property
given the target name , target type and the property
*/
procedure getPropertyValue(
      	targetName IN VARCHAR2,
        targetType IN VARCHAR2,
        propertyName IN VARCHAR2,
        propertyValue OUT VARCHAR2);

/*
Get the oracle homes and tns_admin locations for a Host Target after updating
Oracle Homes not yet present.
The values returned as OUT parameters are used for Oracle Net Services Administration
*/
procedure getNetAdminInfoWithUpdate(
	hostName IN VARCHAR2,
        hostType IN VARCHAR2,
        fileSeparator IN VARCHAR2,
        netAdmin_cur_out OUT cursorType);
/*
Get the oracle homes and tns_admin locations for a Host Target after updating
Oracle Homes not yet present.
The values returned as OUT parameters are used for Oracle Net Services Administration
*/
procedure getNetAdminInfoWithUpdateForSA(
	hostTargetName IN VARCHAR2,
        hostTargetType IN VARCHAR2,
        fileSeparator IN VARCHAR2,
        netAdmin_cur_out OUT cursorType);

--
-- PROCEDURE: get_lsnr_homepage_info
--
-- PURPOSE:
--   This procedure returns all the relevant information for a given listener
--   target name and target type.
--
-- IN Parameters:
--   target_name_in: The target name of the listener
--   target_type_in: The target type of the listener
--
-- OUT Parameters:
--   type_display_name_out: The type display name
--      last_load_time_out: The timestamp of last load time
--      current_status_out: The current status
--           avail_pct_out: The availability percentage
--       severity_code_out: The max severities
--        num_severity_out: The number of severities
--           host_name_out: The host name which the listener is on
--   host_display_name_out: The host display name
--    tnsping_severity_out: The severity of TNS ping
--     start_timestamp_out: The start timestamp of current status
--         metrics_cur_out: The cursor containing all metric values
--       databases_cur_out: The cursor containing all databases info

PROCEDURE get_lsnr_homepage_info(target_name_in IN VARCHAR2,
                                 target_type_in IN VARCHAR2,
                                 type_display_name_out OUT VARCHAR2,
                                 last_load_time_out OUT VARCHAR2,
                                 current_status_out OUT INTEGER,
                                 avail_pct_out OUT NUMBER,
                                 severity_code_out OUT INTEGER,
                                 num_severity_out OUT INTEGER,
                                 host_name_out OUT VARCHAR2,
                                 host_display_name_out OUT VARCHAR2,
                                 tnsping_severity_out OUT INTEGER,
                                 start_timestamp_out OUT Date,
                                 metrics_cur_out OUT cursorType,
				 databases_cur_out OUT cursorType);
                             

--
-- PROCEDURE: get_lsnr_homepage_info
--
-- PURPOSE:
--   This procedure returns all the relevant information for a given listener home page
--   target name and target type. Added for performance.
--
-- IN Parameters:
--   target_name_in: The target name of the listener
--   target_type_in: The target type of the listener
--
-- OUT Parameters:
--   type_display_name_out: The type display name
--      last_load_time_out: The timestamp of last load time
--      current_status_out: The current status
--           avail_pct_out: The availability percentage
--       severity_code_out: The max severities
--        num_severity_out: The number of severities
--           host_name_out: The host name which the listener is on
--   host_display_name_out: The host display name
--    tnsping_severity_out: The severity of TNS ping
--     start_timestamp_out: The start timestamp of current status
--         metrics_cur_out: The cursor containing all metric values

PROCEDURE get_lsnr_home_page_data(target_name_in IN VARCHAR2,
                                 target_type_in IN VARCHAR2,
                                 type_display_name_out OUT VARCHAR2,
                                 last_load_time_out OUT VARCHAR2,
                                 current_status_out OUT INTEGER,
                                 avail_pct_out OUT NUMBER,
                                 severity_code_out OUT INTEGER,
                                 num_severity_out OUT INTEGER,
                                 host_name_out OUT VARCHAR2,
                                 host_display_name_out OUT VARCHAR2,
                                 tnsping_severity_out OUT INTEGER,
                                 start_timestamp_out OUT Date,
                                 metrics_cur_out OUT cursorType);

--
-- PROCEDURE: get_databases_info
--
-- PURPOSE:
--   This procedure returns a cursor containing all databases information
--   for the given listener.
--
-- IN Parameters:
--   target_name_in: The target name of the listener
--   target_type_in: The target type of the listener
--
-- OUT Parameters:
--   databases_cur_out: a curor containing all databases information
--
PROCEDURE get_databases_info(target_name_in IN VARCHAR2,
                             target_type_in IN VARCHAR2,
                             databases_cur_out OUT cursorType);


end MGMT_DBNET;
/
show errors;

