Rem drv: <create type="out_of_box" pos="-"/>
Rem
Rem $Header: default_notification_rules_setup.sql 11-jul-2005.18:47:23 gsbhatia Exp $
Rem
Rem default_notification_rules_setup.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      default_notification_rules_setup.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/11/05 - New repmgr header impl 
Rem    yaofeng     12/04/03 - fix default value problem 
Rem    yaofeng     08/20/03 - plsql api change 
Rem    tjaiswal    10/03/02 - tjaiswal_outofbox_notification_rules_3
Rem    tjaiswal    10/02/02 - Created
Rem

Rem
Rem Do the rule emails setup for default notification rules for 
Rem types - database, listener
Rem

BEGIN
 
 DECLARE 
 
         current_em_user VARCHAR2(128);
         
         -- variables for default notification rules
         rule_name VARCHAR2(64);
         rule_owner VARCHAR2(128);
         user_email VARCHAR2(128);
         send_email NUMBER(1);
         rule_emails SMP_EMD_STRING_ARRAY;
         rule_device_names SMP_EMD_STRING_ARRAY;
         rule_device_types SMP_EMD_INTEGER_ARRAY;
         device_not_avail_list SMP_EMD_STRING_ARRAY;
         email_gateway_setup NUMBER;
         mail_gateway_hosts SMP_EMD_STRING_ARRAY;
         mail_server_name VARCHAR2(128);
         mail_server_sender_name VARCHAR2(64);
         mail_server_sender_addr VARCHAR2(128);

    BEGIN

        -- First get the currently logged in user. the default notification
        -- rules will be owned by this user
        current_em_user := mgmt_user.get_current_em_user();
        dbms_output.put_line( 'current em user: ' || current_em_user );
        rule_owner := current_em_user;
        
        -- get the user email address if available
        -- this will be the same for all the rules
        user_email := '&EMAIL_ADDRESS';
        dbms_output.put_line( 'user email as obtained from setup: ' || user_email );

        IF( user_email IS NULL OR 
            length(trim(user_email)) = 0 OR
            UPPER(user_email) = '_NOT_AVAILABLE_' OR
            UPPER(user_email) = '%EMAIL_ADDRESS%' )
        THEN
            dbms_output.put_line( 'email address of user is not specified' );
            send_email := 0;
            rule_emails := SMP_EMD_STRING_ARRAY();
        ELSE            
            dbms_output.put_line( 'email address of user is specified and is: ' || user_email );
            send_email := 1;
            rule_emails := SMP_EMD_STRING_ARRAY();
            rule_emails.extend( 1 );
            rule_emails( 1 ) := user_email;
        END IF;
            
        -- no devices to be assigned with the rules ...  
        rule_device_names := SMP_EMD_STRING_ARRAY();
        rule_device_types := SMP_EMD_INTEGER_ARRAY();

        -- now setup the emails for each of the rules of 
        -- type - database, listener

        -- Assign email to the database targets rule 
        rule_name := 'Database Availability and Critical States';

        BEGIN
          dbms_output.put_line( 'Assign email: ' || user_email || ' of ' || current_em_user || ' to rule: ' || rule_name || ' of: ' || rule_owner  );
          mgmt_preferences.update_rule_devices_data( rule_name, 
                                                     rule_owner, 
                                                     send_email,  
                                                     rule_device_names,  
                                                     rule_device_types, 
                                                     device_not_avail_list, 
                                                     email_gateway_setup ); 
          dbms_output.put_line( 'email_gateway_setup: ' || email_gateway_setup );
          COMMIT;

          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'UNHANDLED EXCEPTION while assigning email: ' || user_email || ' to rule: ' || rule_name );
                      
        END;
        
        -- Assign email to the listener targets rule 
        rule_name := 'Listener Availability';

        BEGIN
          dbms_output.put_line( 'Assign email: ' || user_email || ' of ' || current_em_user || ' to rule: ' || rule_name || ' of: ' || rule_owner  );
          mgmt_preferences.update_rule_devices_data( rule_name, 
                                                     rule_owner, 
                                                     send_email,  
                                                     rule_device_names,  
                                                     rule_device_types, 
                                                     device_not_avail_list, 
                                                     email_gateway_setup ); 
          dbms_output.put_line( 'email_gateway_setup: ' || email_gateway_setup );
          COMMIT;

          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'UNHANDLED EXCEPTION while assigning email: ' || user_email || ' to rule: ' || rule_name );
                      
        END;

    END;

END;
/
