Rem drv: <create type="pkgdefs"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/osm/osm_pkgdefs.sql /st_emdbsa_11.2/2 2009/02/19 11:38:42 chanchan Exp $
Rem
Rem osm_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      osm_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chanchan    02/09/09 - Add space used by snapshot
Rem    asubba      09/25/07 - XbranchMerge asubba_ui_improvements from main
Rem    qsong       05/15/07 - remove block size from GETOFSSPACEINFO
Rem    qsong       04/02/07 - add volume device as input param to getOFSSummary
Rem                           proc
Rem    gmahaney    02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
Rem    qsong       01/03/07 - add corrupt param to getOFSSummary
Rem    qsong       12/15/06 - add getDiskGroupUsageInfo
Rem    qsong       04/11/06 - add OFS related procedures 
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    jochen      07/15/04 - Use getDbAlertLogSeverity 
Rem    jochen      06/16/04 - Add mirror_free_mb
Rem    jochen      05/13/04 - Make alertLogTimestamp, instanceStartTime dates
Rem    spanchum    10/14/02 - spanchum_osm_homepage
Rem    spanchum    10/07/02 - Created
Rem

CREATE OR REPLACE PACKAGE emd_osm AS

-- Package level Type Definition
   TYPE cursorType IS REF CURSOR;

/*
Get the OSM site map related info. This procedure returns all the relevant
information for a given osm target name and target type.
The values returned as OUT parameters are used for display in the
osmsitemap page
*/
procedure getOsmSiteMapInfo(
        targetName IN VARCHAR2,
        targetType IN VARCHAR2,
        osmSitemapInfo OUT SMP_EMD_OSMSITEMAP_OBJ);

procedure getDatabasesInfo(target_guid_in                   IN VARCHAR2,
                           metaVer_in                       IN VARCHAR2,
                           catProp1_in                      IN VARCHAR2,
                           catProp2_in                      IN VARCHAR2,
                           catProp3_in                      IN VARCHAR2,
                           catProp4_in                      IN VARCHAR2,
                           catProp5_in                      IN VARCHAR2,
                           databases_cur_out                OUT cursorType,
                           diskgroups_cur_out               OUT cursorType,
                           dgusage_cur_out                  OUT cursorType);

procedure getDiskGroupUsageInfo(target_guid_in                   IN VARCHAR2,
                                metaVer_in                       IN VARCHAR2,
                                catProp1_in                      IN VARCHAR2,
                                catProp2_in                      IN VARCHAR2,
                                catProp3_in                      IN VARCHAR2,
                                catProp4_in                      IN VARCHAR2,
                                catProp5_in                      IN VARCHAR2,
                                databases_cur_out                OUT cursorType,
                                diskgroups_cur_out               OUT cursorType,
                                dgusage_cur_out                  OUT cursorType,
                                ofsusage_cur_out                 OUT cursorType,
                                none_ofs_volumes_usage_cur_out   OUT cursorType);

PROCEDURE getSingleInstanceOFSSummary(targetName           IN VARCHAR2,          
		                                  targetType           IN VARCHAR2,         
		                                  servicedOFSInfoArray OUT SMP_EMD_ASM_SERVED_OFS_ARRAY);

PROCEDURE getClusteredOFSInfo(clusterName           IN VARCHAR2,         
	                            smpClusterOfsObjArray OUT SMP_EMD_CLUSTER_OFS_OBJ_ARRAY);

PROCEDURE getOFSSummary(volume_device_in          IN VARCHAR2,       
                        ofs_name_in               IN VARCHAR2,   
                        hostName_in               IN VARCHAR2,   
                        clusterName_in            IN VARCHAR2,   
                        lastUpdatedTime           OUT VARCHAR2,     
                        current_status_out        OUT NUMBER,         
                        avail_on_hosts_out        OUT NUMBER,       
                        none_avail_on_hosts_out   OUT NUMBER,         
                        corrupt_out               OUT VARCHAR2,         
                        volume_name_out           OUT VARCHAR2,         
                        servicedHostsArray        OUT SMP_EMD_OFSHOSTS_INFO_ARRAY,     
                        ofsusage_cur_out          OUT cursorType);

PROCEDURE getNoneOFSVolumesInfo(targetName        IN VARCHAR2,          
	                            targetType          IN VARCHAR2,         
	                            nonOFSVolumesArray  OUT SMP_EMD_NONEOFS_VOL_ARRAY);


PROCEDURE getOFSSpaceInfo(host_in            IN VARCHAR2,          
	                      cluster_in           IN VARCHAR2,          
	                      volume_device_in     IN VARCHAR2,         
	                      ofs_in               IN VARCHAR2,         
	                      dg_alloc_size_GB_out OUT NUMBER,         
	                      size_GB_out          OUT NUMBER,         
	                      used_GB_out          OUT NUMBER,         
	                      free_GB_out          OUT NUMBER,         
	                      used_pct_out         OUT NUMBER,         
	                      snap_used_MB_out     OUT NUMBER);
PROCEDURE getFailgroupInfo(target_guid_in       IN VARCHAR2,
                           metaVer_in           IN VARCHAR2,
                           catProp1_in          IN VARCHAR2,
                           catProp2_in          IN VARCHAR2,
                           catProp3_in          IN VARCHAR2,
                           catProp4_in          IN VARCHAR2,
                           catProp5_in          IN VARCHAR2,
                           failgroup_cur_out    OUT cursorType);                              
PROCEDURE getDatabasesFGInfo(target_guid_in     IN VARCHAR2,
                           metaVer_in           IN VARCHAR2,
                           catProp1_in          IN VARCHAR2,
                           catProp2_in          IN VARCHAR2,
                           catProp3_in          IN VARCHAR2,
                           catProp4_in          IN VARCHAR2,
                           catProp5_in          IN VARCHAR2,
                           databases_cur_out    OUT cursorType,
                           diskgroups_cur_out   OUT cursorType,
                           dgusage_cur_out      OUT cursorType,
                           ofsusage_cur_out     OUT cursorType,
                           none_ofs_volumes_usage_cur_out      OUT cursorType,
                           failgroup_cur_out    OUT cursorType);                              
end emd_osm;
/
show errors;

