Rem drv: <create type="tables" pos="ob/ob_tables.sql+"/>
Rem
Rem $Header: osm_tables.sql 14-dec-2005.08:51:59 rreilly Exp $
Rem
Rem osm_tables.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      osm_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      ASM (formerly OSM) repository tables.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rreilly     12/13/05 - remove osm registration 
Rem    gsbhatia    07/11/05 - Fix repmgr header 
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    jochen      06/15/04 - Move osm messages to emdb 
Rem    rreilly     06/10/04 - rreilly_asm_040604_policies
Rem    rreilly     06/09/04 - register the osm_instance type 
Rem    rreilly     06/04/04 - register osm metadata 
Rem    rreilly     06/03/04 - Created
Rem


-- -----------------------------------------------
-- Uncomment as desired for debugging
-- -----------------------------------------------

-- Uncomment to see the commands during the script execution
-- SET ECHO ON

-- Uncomment to drop tables each time the script is executed
-- DROP TABLE "MGMT_OSM_DISK_GROUP_ECM";

-- -----------------------------------------------
-- Setup
-- -----------------------------------------------

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-- -----------------------------------------------
-- Create Tables
-- NOTE: ECM metadata registration is done in 
--       osm_post_creation.sql
-- -----------------------------------------------

-- OSM Disk Group Policy Table
CREATE TABLE "MGMT_OSM_DISK_GROUP_ECM" 
  (
    "ECM_SNAPSHOT_ID" RAW(16) 
         NOT NULL CONSTRAINT "MGMT_OSM_DISK_GROUP_ECM0" 
         REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
    "DISK_GROUP"   VARCHAR2(30),
    "PROBLEM_CODE" NUMBER(2),
    "VALUE1_N"     NUMBER(10),
    "VALUE2_N"     NUMBER(10),
    "VALUE3_S"     VARCHAR2(100),
    "VALUE4_S"     VARCHAR2(100),
    CONSTRAINT "MGMT_OSM_DISK_GROUP_ECM_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID",
                                                         "DISK_GROUP",
                                                         "PROBLEM_CODE")
  ) MONITORING;



