Rem drv: <create type="pkgbodys"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/policy/config_util_pkgbody.sql /st_emdbsa_11.2/2 2009/06/17 07:44:10 mnihalan Exp $
Rem
Rem config_util_pkgbody.sql
Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      config_util_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mnihalan    06/11/09 - Fix bug 8591989
Rem    mnihalan    05/07/08 - Utils for config policies
Rem    mnihalan    05/07/08 - Created
Rem

CREATE OR REPLACE PACKAGE BODY CONFIG_UTIL
IS

  -- Function to return a concatenated list (space delimited by default) a the
  -- given table and column, restricted by given predicate.
  -- If the max varchar2 length is exceeded (VALUE_ERROR) a truncated
  -- result is returned.
  --  COL      The name of the column, from the tab passed int.
  --  TAB      The table (or query in parens) from which to select the column.
  --  PREDICATE - Used in a where clause to restrict the selection.
  --  BIND_VAR    Bind variable to be used in the predicate
  --  DELIMETER   Used to separate the column values in the returned string.
  --  COL_LIMIT   Used to limit the number of COL values to return. If more then
  --              this limit exists the return string has an ellipsis added at
  --              the end
  FUNCTION CONCAT_FILE_NAME ( COL VARCHAR2,
                        TAB VARCHAR2,
                        PREDICATE VARCHAR2,
                        BIND_VAR  VARCHAR2,
                        DELIMETER VARCHAR2 := ' ',
                        COL_LIMIT NUMBER := -1)
  RETURN VARCHAR2
  IS
 TYPE C1Type IS REF CURSOR;  -- define weak REF CURSOR type
    c1 C1Type;
    result VARCHAR2(4000);
    col_val VARCHAR2(1000);
    sqlStmt VARCHAR2(2000);
    tmpDel VARCHAR2(10) := '';
    ellipsis VARCHAR2(3) := '...';
          cnt NUMBER := 0;
  BEGIN
    sqlStmt := 'SELECT ' || EM_CHECK.SIMPLE_SQL_NAME(COL) ||
                ' FROM ' || EM_CHECK.SIMPLE_SQL_NAME(TAB) ||
               ' WHERE ' || (PREDICATE);
    result := '';
    OPEN c1 FOR sqlStmt using BIND_VAR;
    LOOP
      FETCH c1 INTO col_val;
      EXIT WHEN c1%NOTFOUND;
            cnt := cnt + 1;
            IF (COL_LIMIT != -1 AND cnt > COL_LIMIT)
            THEN
                    result := result || tmpDel || ellipsis;
                    EXIT;
            END IF;
      result := result || tmpDel || col_val;
      tmpDel := DELIMETER;
    END LOOP;
    IF result IS NULL THEN
      result := ' ';
    END IF;
    RETURN result;
  EXCEPTION
    WHEN VALUE_ERROR THEN RETURN result; -- Truncated to value prior to value 
  END;

END CONFIG_UTIL;
/
show errors;

