Rem drv: <create type="post_creation" pos="eml/eml_post_creation.sql+"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/rac/rac_post_creation.sql /st_emdbsa_11.2/8 2009/07/02 23:46:12 shasingh Exp $
Rem
Rem rac_post_creation.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      rac_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shasingh    06/22/09 - removed redundant 'relocateRacTarget' job command
Rem                           registration
Rem    shasingh    04/17/09 - added host add callback for clearing add node
Rem                           alert
Rem    pardutta    03/18/09 - mgmt_rac_services.server_group column size
Rem                           changed to 1024
Rem    ajdsouza    02/17/09 - Big fix For Bug#7160826
Rem    ngade       08/12/08 - Code slap 10.2.0.5GC -> 112SA
Rem    sadattaw    05/05/08 - 
Rem    dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
Rem                           st_emdbsa_11.1
Rem    shasingh    12/06/07 - CRS event job command registration
Rem    ajdsouza    11/30/07 - 
Rem    shasingh    11/27/07 - event based target processing
Rem    sadattaw    11/26/07 - adding server groups, cardinality columns to
Rem                           mgmt_rac_services table
Rem    ajdsouza    06/29/07 - remove end meta ver from cluster response
Rem                            repository metric
Rem    shasingh    08/09/07 - XbranchMerge
Rem                           shasingh_11g_19509a_targets_discovery from main
Rem    ajdsouza    06/29/07 - remove end meta ver from cluster response
Rem                            repository metric
Rem    ajdsouza    02/19/07 - bug fix 5848019
Rem    mnihalan    02/07/07 - Fix bug 5696024, register oracle_storage and
Rem                           oracle_objects snapshots for rac_database
Rem    mnihalan    02/14/07 - XbranchMerge mnihalan_bug-5696024 from main
Rem    sadattaw    01/17/07 - XbranchMerge sadattaw_fix from main
Rem    sadattaw    01/16/07 - adding UI on for mgmt_rac_services snapshot
Rem    shasingh    12/14/06 - 
Rem    sadattaw    11/22/06 - renaming db name to db_unique name for
Rem                           mgmt_rac_services table
Rem    sadattaw    10/04/06 - adding commands for rac_services metric
Rem    pbantis     08/31/05 - Change FLASHBACK_ON size from 3 to 18. 
Rem    xuliu       08/10/05 - 4536783
Rem    pbantis     08/15/05 - oracle_racconfig history changes. 
Rem    gsbhatia    07/11/05 - Fix repmgr header 
Rem    ysun        06/23/05 - add metric version
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    pbantis     06/13/05 - Update racconfig_ecm to version 2. 
Rem    ysun        02/25/05 - remove health_check in 10.2SA
Rem    rreilly     02/21/05 - add cols to tablespaces_ecm 
Rem    xshen       01/17/05 - 
Rem    xuliu       12/28/04 - move table & view creation out 
Rem    xuliu       11/30/04 - register cluster-host deletion job command 
Rem    ysun        10/27/04 - roll up health check metrics
Rem    ysun        10/20/04 - register 4.0
Rem    xuliu       10/06/04 - change MGMTINTERFACE_STATS 
Rem    xuliu       09/14/04 - review chg 
Rem    xuliu       08/05/04 - intr chg 
Rem    xuliu       07/02/04 - cluster interconn ecm tables / view
Rem    rpinnama    06/12/04 - Remove SET ECHO 
Rem    ajdsouza    05/10/04 - add column os_storage_entity
Rem    ysun        04/12/04 - add UpdateRacTargets
Rem    ysun        11/17/03 - register call back
Rem    xshen       11/12/03 - change ecm snapshot metadata 
Rem    pbantis     10/24/03 - Add log_mode column to ha_info table 
Rem    ysun        10/15/03 - add rac callback
Rem    ysun        10/13/03 - register 3.0
Rem    xshen       10/03/03 - oracle_dbconfig and oracle_racconfig 
Rem    xshen       10/02/03 - rename snapshot type name 
Rem    streddy     09/25/03 - Always add r/s metric 
Rem    ysun        09/22/03 - back out the multi-version registration
Rem    ysun        09/16/03 - register response metric for all versions
Rem    ysun        08/06/03 - 
Rem    pbantis     07/21/03 - Update MGMT_HA_INFO_ECM
Rem    xshen       06/16/03 - add next_extent column to ecm metadata
Rem    xshen       05/21/03 - no sga metadata for rac
Rem    xshen       05/19/03 - 
Rem    xshen       05/19/03 - cutover to ecm config snapshot framework
Rem    ysun        04/15/03 - register metrics
Rem    rpinnama    02/25/03 - Disable echoing
Rem    ysun        12/04/02 - 
Rem    ysun        11/01/02 - ysun_rac_delete_handling
Rem    ysun        10/21/02 - Created
Rem

BEGIN

    DECLARE
      l_metric_column_list  METRIC_COLUMN_ARRAY;

    BEGIN
  --
  -- target type properties for 'rac_database' target type
  --
  -- is_composite = '1'
  INSERT INTO MGMT_TYPE_PROPERTIES
      (target_type, property_name, property_value)
    VALUES
      (MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE,
       MGMT_GLOBAL.G_IS_COMPOSITE_PROP,
       '1');


  INSERT INTO MGMT_TYPE_PROPERTIES
      (target_type, property_name, property_value)
    VALUES
      (MGMT_GLOBAL.G_CLUSTER_TARGET_TYPE,
       MGMT_GLOBAL.G_IS_COMPOSITE_PROP,
       '1');

    mgmt_jobs.register_command('updateRacTargets',
                         'oracle.sysman.emo.rac.commands.UpdateRacTargets');


    -- job command to remove host from cluster
    mgmt_jobs.register_command('removeHostFromCluster', 'oracle.sysman.emo.rac.clscfg.RemoveHostFromCluster');

   -- add call back to update properties
   em_master_agent.add_master_changed_callback( NULL, 'rac_database', 'emd_rac.update_master_properties');
 
  -- register availability for cluster
  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '1.0');

  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '2.1');

  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '2.2');

  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '3.0');

  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '4.0');

  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '4.1');

  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '4.2');

  EMD_RAC.REGISTER_AVAILABILITY( 'cluster', 'Response', 'Status', 'host', '5.0');



  -- register availability for rac database

  EMD_RAC.REGISTER_AVAILABILITY( 'rac_database', 'Response', 'Status', 'oracle_database','1.0');

   EM_METRIC.add_metric_version_row(
              p_target_type         => 'rac_database',
              p_metric_name         => 'Response');

  EMD_RAC.REGISTER_AVAILABILITY( 'rac_database', 'Response', 'Status', 'oracle_database','2.0');

  EMD_RAC.REGISTER_AVAILABILITY( 'rac_database', 'Response', 'Status', 'oracle_database','2.1');

  EMD_RAC.REGISTER_AVAILABILITY( 'rac_database', 'Response', 'Status', 'oracle_database','2.2');

  EMD_RAC.REGISTER_AVAILABILITY( 'rac_database', 'Response', 'Status', 'oracle_database','3.0');

  EMD_RAC.REGISTER_AVAILABILITY( 'rac_database', 'Response', 'Status', 'oracle_database','4.0');

COMMIT;

END;

END;
/

-- -------------------------------------------------
-- GENERATED FROM: racconfig_ecm_metadata.xml
-- START
-- -------------------------------------------------

-- Uncomment the following line to see the commands during the script execution
-- SET ECHO ON 

-- Do not use substitution variables in this script so that there is no
-- additional restrictions on the string values that are being inserted (such as ampersand 
-- being interpreted specially by SQLPlus).
SET DEFINE OFF 

--------------------------------------------
-- Registering metadata RAC Database Configuration for target type rac_database and snapshot type oracle_racconfig
--------------------------------------------

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_racconfig');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_racconfig';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_racconfig', 'rac_database', 'L', metadata_id, 'RAC Database Configuration', 'N', 'Y', 'Y', 'Y', 'Y', NULL, NULL, NULL, '2.0', 'ORACLE_DATABASE_ORACLE_DBCONFIG_VIEW_PAGE', NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_racconfig', 'rac_database', 'P', metadata_id, 'RAC Database Configuration', 'N', 'Y', 'Y', 'Y', 'Y', NULL, NULL, NULL, '2.0', 'ORACLE_DATABASE_ORACLE_DBCONFIG_VIEW_PAGE', NULL, NULL, 'H');

  -- Register metadata for table MGMT_DB_DBNINSTANCEINFO_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'Instance Information', 'N', 'Y', 'Y', 'Y', 'Y', NULL, 'Y', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'DATABASE_NAME', 'Database Name', 'S', '9', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'GLOBAL_NAME', 'Global Name', 'S', '4000', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'BANNER', 'Version', 'S', '64', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'HOST_NAME', 'Host', 'S', '64', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'INSTANCE_NAME', 'Instance Name', 'S', '16', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'STARTUP_TIME', 'Instance Startup Time', 'D', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'LOGINS', 'Restricted Mode', 'S', '10', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'LOG_MODE', 'Archive Log Mode', 'S', '12', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 7);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'OPEN_MODE', 'Read Only Mode', 'S', '10', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 8);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'DEFAULT_TEMP_TABLESPACE', 'Default Temporary Tablespace', 'S', '30', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 9);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'CHARACTERSET', 'Database Character Set', 'S', '64', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 10);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DBNINSTANCEINFO_ECM', 'NATIONAL_CHARACTERSET', 'National Character Set', 'S', '64', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 11);

  -- Register metadata for table MGMT_DB_CONTROLFILES_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_CONTROLFILES_ECM', 'Control files', 'N', 'Y', 'Y', 'Y', 'Y', NULL, 'N', 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_CONTROLFILES_ECM', 'FILE_NAME', 'File Name', 'S', '512', 'N', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_CONTROLFILES_ECM', 'STATUS', 'Status', 'S', '10', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_CONTROLFILES_ECM', 'CREATION_DATE', 'Creation Date', 'D', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_CONTROLFILES_ECM', 'SEQUENCE_NUM', 'Sequence Num', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_CONTROLFILES_ECM', 'CHANGE_NUM', 'Change Num', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_CONTROLFILES_ECM', 'MOD_DATE', 'Modification Date', 'D', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_CONTROLFILES_ECM', 'OS_STORAGE_ENTITY', 'OS Storage', 'S', '512', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 6);

  -- Register metadata for table MGMT_DB_REDOLOGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'Redologs', 'N', 'Y', 'Y', 'Y', 'Y', NULL, 'N', 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'GROUP_NUM', 'Group Num', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'STATUS', 'Status', 'S', '16', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'MEMBERS', 'Members', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'FILE_NAME', 'File Name', 'S', '512', 'N', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'ARCHIVED', 'Archived', 'S', '3', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'LOGSIZE', 'Log Size', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'SEQUENCE_NUM', 'Sequence Num', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'FIRST_CHANGE_SCN', 'First Change SCN', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 7);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'OS_STORAGE_ENTITY', 'OS Storage', 'S', '512', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 8);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_REDOLOGS_ECM', 'THREAD_NUM', 'Thread Num', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 9);

  -- Register metadata for table MGMT_DB_ROLLBACK_SEGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'Rollback Segments', 'N', 'Y', 'Y', 'Y', 'Y', NULL, 'N', 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'ROLLNAME', 'Name', 'S', '64', 'N', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'STATUS', 'Status', 'S', '10', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'TABLESPACE_NAME', 'Tablespace Name', 'S', '30', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'EXTENTS', 'Extents', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'ROLLSIZE', 'Size', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'INITIAL_SIZE', 'Initial Size', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'NEXT_SIZE', 'Next Size', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'MAXIMUM_EXTENTS', 'Maximum Extents', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 7);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'MINIMUM_EXTENTS', 'Minimum Extents', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 8);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'PCT_INCREASE', 'Pct Increase', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 9);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'OPTSIZE', 'Optimal Size', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 10);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'AVEACTIVE', 'Average Active', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 11);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'WRAPS', 'Wraps', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 12);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'SHRINKS', 'Shrinks', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 13);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'AVESHRINK', 'Average Shrink', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 14);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_ROLLBACK_SEGS_ECM', 'HWMSIZE', 'Hight Water Mark Size', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 15);

  -- Register metadata for table MGMT_DB_LICENSE_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_LICENSE_ECM', 'License', 'N', 'Y', 'Y', 'N', 'Y', NULL, 'N', 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_LICENSE_ECM', 'SESSIONS_MAX', 'Session Max', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_LICENSE_ECM', 'SESSIONS_WARNING', 'Sessions Warning', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_LICENSE_ECM', 'SESSIONS_CURRENT', 'Session Current', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_LICENSE_ECM', 'SESSIONS_HIGHWATER', 'Sessions Highwater', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_LICENSE_ECM', 'USERS_MAX', 'Users Max', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 4);

  -- Register metadata for table MGMT_DB_OPTIONS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_OPTIONS_ECM', 'Database Options', 'N', 'Y', 'Y', 'Y', 'Y', NULL, 'N', 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_OPTIONS_ECM', 'NAME', 'Name', 'S', '30', 'N', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_OPTIONS_ECM', 'SELECTED', 'Selected', 'S', '5', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 1);

  -- Register metadata for table MGMT_DB_TABLESPACES_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'Tablespaces', 'N', 'Y', 'Y', 'Y', 'Y', NULL, 'N', 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'TABLESPACE_NAME', 'Tablespace Name', 'S', '30', 'N', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'CONTENTS', 'Contents', 'S', '9', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'STATUS', 'Status', 'S', '10', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'EXTENT_MANAGEMENT', 'Extent Management', 'S', '10', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'ALLOCATION_TYPE', 'Allocation Type', 'S', '10', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'LOGGING', 'Logging', 'S', '10', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'TABLESPACE_SIZE', 'Size', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'INITIAL_EXT_SIZE', 'Initial Extent', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 7);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'NEXT_EXTENT', 'Next Extent', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 8);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'INCREMENT_BY', 'Increment', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 9);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'MAX_EXTENTS', 'Maximum Extents', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 10);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'TABLESPACE_USED_SIZE', 'Tablespace Used Size', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 11);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'SEGMENT_SPACE_MANAGEMENT', 'Segment Space Management', 'S', '6', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 12);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'BLOCK_SIZE', 'Block Size', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 13);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'MIN_EXTENTS', 'Minimum Extents', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 14);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'MIN_EXTLEN', 'Minimum Extent Size', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 15);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_TABLESPACES_ECM', 'BIGFILE', 'Big File', 'S', '3', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 16);

  -- Register metadata for table MGMT_DB_DATAFILES_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DATAFILES_ECM', 'Datafiles', 'N', 'Y', 'Y', 'Y', 'Y', 'MGMT_DB_TABLESPACES_ECM', 'N', 7);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DATAFILES_ECM', 'FILE_NAME', 'File Name', 'S', '512', 'N', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DATAFILES_ECM', 'STATUS', 'Status', 'S', '9', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DATAFILES_ECM', 'FILE_SIZE', 'Size', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DATAFILES_ECM', 'AUTOEXTENSIBLE', 'Autoextensible', 'S', '3', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DATAFILES_ECM', 'INCREMENT_BY', 'Increment', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DATAFILES_ECM', 'MAX_FILE_SIZE', 'Max File Size', 'N', NULL, 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_DATAFILES_ECM', 'OS_STORAGE_ENTITY', 'OS Storage', 'S', '512', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 6);

  -- Register metadata for table MGMT_HA_INFO_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INFO_ECM', 'High Availability - General Information', 'N', 'Y', 'Y', 'Y', 'Y', NULL, 'Y', 8);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INFO_ECM', 'DBID', 'Dbid', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INFO_ECM', 'LOG_MODE', 'Log Mode', 'S', '12', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INFO_ECM', 'FORCE_LOGGING', 'Force Logging', 'S', '3', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INFO_ECM', 'DATABASE_ROLE', 'Database Role', 'S', '16', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INFO_ECM', 'FLASHBACK_ON', 'Flashback On', 'S', '18', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INFO_ECM', 'SUPPLEMENTAL_LOGGING', 'Supplmental Logging', 'S', '8', 'N', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 5);

  -- Register metadata for table MGMT_HA_INIT_PARAMS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INIT_PARAMS_ECM', 'High Availability - Initialization Parameters', 'N', 'Y', 'Y', 'N', 'Y', NULL, 'N', 9);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INIT_PARAMS_ECM', 'NAME', 'Name', 'S', '64', 'N', 'Y', 'Y', 'N', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_INIT_PARAMS_ECM', 'VALUE', 'Value', 'S', '512', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 1);

  -- Register metadata for table MGMT_HA_FILES_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_FILES_ECM', 'High Availability - Database Files', 'N', 'Y', 'Y', 'N', 'Y', NULL, 'N', 10);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_FILES_ECM', 'NAME', 'Name', 'S', '64', 'N', 'Y', 'Y', 'N', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_FILES_ECM', 'TOTALSIZE', 'Total Size', 'N', NULL, 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 1);

  -- Register metadata for table MGMT_HA_RMAN_CONFIG_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RMAN_CONFIG_ECM', 'High Availability - RMAN Configuration', 'N', 'Y', 'Y', 'N', 'Y', NULL, 'N', 11);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RMAN_CONFIG_ECM', 'NAME', 'Name', 'S', '65', 'N', 'Y', 'Y', 'N', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RMAN_CONFIG_ECM', 'VALUE', 'Value', 'S', '1025', 'N', 'Y', 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', NULL, 1);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

-- End of metadata registration for metadata RAC Database Configuration

SET DEFINE ON 

-- Update derived materialized views
BEGIN ECM_UTIL.UPDATE_ECM_METADATA; END;
/

-- -------------------------------------------------
-- GENERATED FROM: racconfig_ecm_metadata.xml
-- END
-- ------------------------------------------------


--------------------------------------------
-- Registering cluster and rac interconnect ECM metadata 
--------------------------------------------

--------------------------------------------
-- Registering metadata Cluster Interconnects for target type cluster and snapshot type ha_cls_intrconn
--------------------------------------------
SET DEFINE OFF 

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'cluster' AND SNAPSHOT_TYPE = 'ha_cls_intrconn');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'cluster' AND SNAPSHOT_TYPE = 'ha_cls_intrconn';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('ha_cls_intrconn', 'cluster', 'L', metadata_id, 'Cluster Interconnects', 'N', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('ha_cls_intrconn', 'cluster', 'P', metadata_id, 'Cluster Interconnects', 'N', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_HA_CLS_INTR_CONN
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', NULL, 'N', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_NAME', 'Interface Name', 'S', '50', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_NODE', 'Node Name', 'S', '100', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_SUBNET', 'Subnet', 'S', '16', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_IP', 'IP Address', 'S', '16', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_PUBLIC', 'Is Public', 'S', '10', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 4);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

-- End of metadata registration for metadata Cluster Interconnects

SET DEFINE ON 


------------------------
-- Rac Instance Interconnects
-----------------------

--------------------------------------------
-- Registering metadata Rac Instance Interconnects for target type oracle_database and snapshot type ha_rac_intrconn
--------------------------------------------

SET DEFINE OFF 

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'ha_rac_intrconn');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'ha_rac_intrconn';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('ha_rac_intrconn', 'oracle_database', 'L', metadata_id, 'Rac Instance Interconnects', 'N', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('ha_rac_intrconn', 'oracle_database', 'P', metadata_id, 'Rac Instance Interconnects', 'N', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_HA_RAC_INTR_CONN
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', NULL, 'N', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', 'IC_NAME', 'Interface Name', 'S', '50', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', 'IC_IP', 'IP Address', 'S', '16', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', 'IC_PUBLIC', 'Is Public', 'S', '10', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', 'IC_SOURCE', 'Source', 'S', '100', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 3);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

-- End of metadata registration for metadata Rac Instance Interconnects

SET DEFINE ON 

-- Update derived materialized views
BEGIN ECM_UTIL.UPDATE_ECM_METADATA; END;
/



--------------------------------------------------------------------------------------------------------
-- generated from   cls_services_ecm_metadata.xml


-- Uncomment the following line to see the commands during the script execution
-- SET ECHO ON 

-- Do not use substitution variables in this script so that there is no
-- additional restrictions on the string values that are being inserted (such as ampersand 
-- being interpreted specially by SQLPlus).
SET DEFINE OFF 

-------------------------------------------------------------------------
-- Registering metadata Cluster Managaged Services for target type cluster and snapshot type mgmt_rac_services
-------------------------------------------------------------------------
-------------------------------------------------------------------------

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'cluster' AND SNAPSHOT_TYPE = 'mgmt_rac_services');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'cluster' AND SNAPSHOT_TYPE = 'mgmt_rac_services';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('mgmt_rac_services', 'cluster', 'L', metadata_id, 'Cluster Managaged Services', 'Y', 'Y', 'Y', 'Y', 'Y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('mgmt_rac_services', 'cluster', 'P', metadata_id, 'Cluster Managaged Services', 'Y', 'Y', 'Y', 'Y', 'Y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_RAC_SERVICES
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'Rac_Services', 'Y', 'Y', 'Y', 'Y', 'Y', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'DATABASE_UNIQUE_NAME', 'Database Unique Name', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'SERVICE_NAME', 'Service Name', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'SERVICE_TYPE', 'Service Type', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'ENABLED', 'Enabled', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'TAFPOLICY', 'TAF Policy', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'PREFERRED_INSTANCES', 'Preferred Instances', 'S', '1024', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'AVAILABLE_INSTANCES', 'Available Instances', 'S', '1024', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'RUNNING_INSTANCES', 'Running Instances', 'S', '1024', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 7);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'CLUSTER_NAME', 'Cluster Name', 'S', '64', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 8);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'SERVER_GROUP', 'Server Group', 'S', '1024', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 9);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'RESOURCE_NAME', 'Resource Name', 'S', '64', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 10);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'SERVICE_CENTRIC_TYPE', 'Service Centric Type', 'S', '30', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 11);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_RAC_SERVICES', 'SERVICE_CARDINALITY', 'Service Cardinality', 'N', NULL, 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', NULL, 12);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

-- End of metadata registration for metadata Cluster Managaged Services

SET DEFINE ON 

-- Update derived materialized views
BEGIN ECM_UTIL.UPDATE_ECM_METADATA; END;
/
-------------------------------------------------------------------------

-------------------------------------------------------------------------

-------------------------------------------------------------------------
--   Create Repository Metric for Cluster Private Interconnect Traffic
------------------------------------------------------------------------
DECLARE
  l_metric_column_list MGMT_METRIC_COLUMN_ARRAY;
  METRIC_GUID_HOST_NETWORK_RDWR VARCHAR2(32) := ' ';
BEGIN

  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY();
  l_metric_column_list.extend(1) ;
  l_metric_column_list(1) := MGMT_METRIC_COLUMN_OBJ.NEW(
         p_column_name => 'privTransferRate',
         p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
         p_column_label => 'Private Interconnect Transfer Rate (MB/Sec)',
         p_column_label_nlsid => 'privTransferRate_NLSID',
         p_is_key => 0);

  METRIC_GUID_HOST_NETWORK_RDWR := mgmt_metric.get_metric_guid( P_TARGET_TYPE =>'host',
                                                                 P_METRIC_NAME => 'Network',
                                                                 P_METRIC_COLUMN =>'readRate');

  mgmt_metric.create_metric(
      p_target_type => 'cluster',
      p_metric_name => 'priv_intrcon',
      p_metric_label => 'Private Interconnect',
      p_metric_label_nlsid => 'priv_intrcon_NLSID',
      p_type_meta_ver => '4.0',
      p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
      p_source =>' SELECT ta.source_target_guid target_guid, SUM(c.value) privTransferRate 
                     FROM   mgmt_current_metrics c, mgmt_current_availability a, 
                            mgmt_targets t2, 
                            mgmt_target_assocs ta, mgmt_target_assoc_defs td, 
                            mgmt_ha_cls_intr_conn i, mgmt_ecm_gen_snapshot s 
                     WHERE  c.metric_guid   =  HEXTORAW('''||METRIC_GUID_HOST_NETWORK_RDWR||''')
                     AND  c.target_guid   = t2.target_guid 
                     AND  a.target_guid        = t2.target_guid 
                     AND  a.current_status     > 0 
                     AND  t2.target_guid       = ta.assoc_target_guid 
                     AND  ta.assoc_guid        = td.assoc_guid 
                     AND  td.assoc_def_name    = ''contains'' 
                     AND  td.scope_target_type = '' '' 
                     AND  (i.ic_node = ''global'' or i.ic_node = t2.target_name) 
                     AND  i.ic_public          = ''NO'' 
                     AND  i.ecm_snapshot_id    = s.snapshot_guid 
                     AND  s.snapshot_type      = ''ha_cls_intrconn'' 
                     AND  s.is_current         = ''Y'' 
                     AND  s.target_guid        = ta.source_target_guid 
                     AND  i.ic_name            = c.key_value 
                     AND  t2.target_type       = ''host''
                    GROUP BY ta.source_target_guid ' ,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_metric_column_list => l_metric_column_list);
END;
/

---------------------------------
-- Create schedule for the metric
---------------------------------
DECLARE
l_schedule mgmt_coll_schedule_obj ;

CURSOR c1 IS SELECT DISTINCT m.type_meta_ver
              FROM  mgmt_metrics m
              WHERE m.target_type = 'cluster'
               AND  m.metric_name = 'priv_intrcon'
               AND  m.metric_column = ' '
               AND  m.type_meta_ver != '4.0'
               AND NOT EXISTS
                (
                   SELECT 1
                    FROM  mgmt_coll_items c
                    WHERE c.target_type     = 'cluster' 
                     AND  c.type_meta_ver   = m.type_meta_ver 
                     AND  c.coll_name      = 'priv_intrcon_collection' 
                );
BEGIN

-- Define schedule
l_schedule := mgmt_coll_schedule_obj.interval_schedule(5,sysdate,null) ;

--Create default collection item
mgmt_collection.add_default_collection
          (p_target_type=>'cluster' ,
           p_type_meta_ver=>'4.0',
           p_coll_name=>'priv_intrcon_collection',
           p_metrics_list=>mgmt_short_string_array('priv_intrcon'),
           p_coll_schedule=>l_schedule) ;
   
 FOR x in C1 LOOP

   mgmt_collection.add_default_collection
          (p_target_type=>'cluster' ,
           p_type_meta_ver=> x.type_meta_ver,
           p_coll_name=>'priv_intrcon_collection',
           p_metrics_list=>mgmt_short_string_array('priv_intrcon'),
           p_coll_schedule=>l_schedule) ;

  END LOOP;

END ;
/

COMMIT;


BEGIN  
  -- register callbac to enable collections for newer metvers that are added 
  -- Register a target type addition callback
  mgmt_target.add_tgttype_addition_callback(
    p_callback_name => 'mgmt_rac.handle_cluster_tgttype_add');
  COMMIT;
END;
/



--------------------------------------------
-- Registering metadata for target type rac_database 
-- and snapshot type oracle_racstorage
--------------------------------------------
SET DEFINE OFF

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_storage');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_storage';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE)
    VALUES ('oracle_storage', 'rac_database', 'L', metadata_id, 'RecommendedSettings Problems', 'Y', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

 -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE)
    VALUES ('oracle_storage', 'rac_database', 'P', metadata_id, 'RecommendedSettings Problems', 'Y', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

-- Register metadata for table MGMT_DB_RECUSERSETTINGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'User Recommended Settings Problems', 'Y', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'USER_NAME', 'User Name', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'PROBLEM_CODE', 'Object', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);

-- Register metadata for table MGMT_DB_RECTSSETTINGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'Tablespace Recommended Settings Problems', 'Y', 'N', 'N', NULL, 'N', 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'PROBLEM_CODE', 'Object','N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'VALUE1', 'Value 1', 'N','10', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'VALUE2', 'Value 2', 'N','10', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 3);

-- Register metadata for table MGMT_DB_RECSEGMENTSETTINGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'Segment RecommendedSettings Problems', 'Y', 'N', 'N', NULL, 'N', 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_TYPE', 'Object Type', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_OWNER', 'Owner', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_NAME', 'Name', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_PARTITION', 'Partition', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_LOB_COL', 'LOB Column', 'S', '4000', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'SEGMENT_TYPE', 'Segment Type', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 6);
INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'PROBLEM_CODE', 'Problem', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 7);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;

-- End of metadata registration for

SET DEFINE ON 
COMMIT;


--------------------------------------------
-- Registering metadata for target type rac_database 
-- and snapshot type oracle_racobject
--------------------------------------------
SET DEFINE OFF

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_object');

  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'rac_database' AND SNAPSHOT_TYPE = 'oracle_object';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE)
    VALUES ('oracle_object', 'rac_database', 'L', metadata_id, 'Object Problems', 'N', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

-- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE)
    VALUES ('oracle_object', 'rac_database', 'P', metadata_id, 'Object Problems', 'N', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

-- Register metadata for table MGMT_DB_INVOBJS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'Invalid Objects', 'N', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_TYPE', 'Object Type', 'N', '2', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_OWNER', 'Object Owner','S', '30', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_NAME', 'Object Name', 'S', '1000', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 2);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;

-- End of metadata registration 

BEGIN
  -- Register the event based callback procedure.
  mgmt_loader.register_cluster_crs_event_cbk('emd_rac.rac_crs_callback_proc');

  --Register Host target type add callback
  mgmt_admin.add_target_addition_callback('emd_rac.host_add_callback', mgmt_global.g_host_target_type);
  
  -- Register event based processing job command
  mgmt_jobs.register_command('proccessCRSEvent',
                         'oracle.sysman.emo.rac.commands.EventBasedProcessing');                       
END;
/

SET DEFINE ON
COMMIT;
