Rem drv: <create type="types" />
Rem
Rem $Header: rac_types.sql 12-dec-2007.12:59:42 sadattaw Exp $
Rem
Rem rac_types.sql
Rem
Rem Copyright (c) 2006, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rac_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
Rem                           st_emdbsa_11.1
Rem    sadattaw    03/23/07 - include keyvalue in the service alert info rec
Rem    ajdsouza    11/20/06 - bug fix 5647975, 5848019
Rem    rsamaved    02/02/07 - 
Rem    ajdsouza    08/30/06 - Created
Rem

Rem SET ECHO ON
Rem SET FEEDBACK 1
Rem SET NUMWIDTH 10
Rem SET LINESIZE 80
Rem SET TRIMSPOOL ON
Rem SET TAB OFF
Rem SET PAGESIZE 100

CREATE OR REPLACE TYPE mgmt_cls_member AS OBJECT
(
 composite_target_guid  RAW(16),
 composite_target_name  VARCHAR2(256),
 composite_target_type  VARCHAR2(256),
 member_target_guid     RAW(16),
 member_target_name     VARCHAR2(256),
 member_target_type     VARCHAR2(256)
)
/

CREATE OR REPLACE TYPE mgmt_cls_member_table AS TABLE OF mgmt_cls_member
/

CREATE OR REPLACE TYPE mgmt_cls_host_ic AS OBJECT
(
 composite_target_guid  RAW(16),
 composite_target_name  VARCHAR2(256),
 composite_target_type  VARCHAR2(256),
 member_target_guid     RAW(16),
 member_target_name     VARCHAR2(256),
 member_target_type     VARCHAR2(256),
 ic_name                VARCHAR2(256),
 totrate                NUMBER,
 toterr                 NUMBER,
 inrate                 NUMBER,
 collection_timestamp   DATE
)
/

CREATE OR REPLACE TYPE mgmt_cls_host_ic_table AS TABLE OF mgmt_cls_host_ic
/

CREATE OR REPLACE TYPE mgmt_cls_ic AS OBJECT
(
 CLUSTER_NAME                          VARCHAR2(256),
 HOST_NAME                             VARCHAR2(256),
 HOST_STATUS                           NUMBER,
 IF_NAME                               VARCHAR2(256),
 IF_SUBNET                             VARCHAR2(16),
 IF_PUBLIC                             VARCHAR2(10),
 TOTRATE_5MIN                          NUMBER,
 TOTERR_5MIN                           NUMBER,
 INRATE_5MIN                           NUMBER,
 CURR_WARNING                          NUMBER,
 CURR_CRITICAL                         NUMBER,
 LATEST_COLLECTION_TIMESTAMP           DATE
)
/

CREATE OR REPLACE TYPE mgmt_cls_ic_table AS TABLE OF mgmt_cls_ic
/


CREATE OR REPLACE TYPE mgmt_racdb_ic AS OBJECT
(
 ic_name          VARCHAR2(256), 
 host_name        VARCHAR2(256), 
 db_target_guid   RAW(16), 
 sid              VARCHAR2(256), 
 ic_ip            VARCHAR2(256), 
 ic_public        VARCHAR2(256), 
 ic_source        VARCHAR2(256), 
 db_tgt_name      VARCHAR2(256), 
 inst_tgt_name    VARCHAR2(256), 
 racdb_guid       RAW(16)
)
/

CREATE OR REPLACE TYPE mgmt_racdb_ic_table AS TABLE OF mgmt_racdb_ic
/

CREATE OR REPLACE TYPE mgmt_racdb_icstat AS OBJECT
(
 CLUSTER_NAME                                       VARCHAR2(1024),
 DB_TARGET                                          VARCHAR2(256),
 INSTANCE_TARGET                                    VARCHAR2(256),
 INSTANCE_STATUS                                    NUMBER,
 DB_NAME                                            VARCHAR2(1024),
 SID                                                VARCHAR2(1024),
 IF_NAME                                            VARCHAR2(256),
 HOST_NAME                                          VARCHAR2(256),
 IF_IP                                              VARCHAR2(256),
 IF_PUBLIC                                          VARCHAR2(256),
 IF_SOURCE                                          VARCHAR2(256),
 XFERRATE_5MIN                                      NUMBER,
 CURR_WARNING                                       NUMBER,
 CURR_CRITICAL                                      NUMBER,
 LATEST_COLLECTION_TIMESTAMP                        DATE
)
/

CREATE OR REPLACE TYPE mgmt_racdb_icstat_table AS TABLE OF mgmt_racdb_icstat
/

CREATE OR REPLACE TYPE MGMT_SERV_ALERT_INFO_TYPE IS OBJECT
        (srvnm         VARCHAR2(64),
         severityCode  NUMBER,
         metricnm      VARCHAR2(64),
         metriccol     VARCHAR2(64),
         alerttime     DATE,
         target_name   VARCHAR2(64),
         target_type   VARCHAR2(64),
         metricval     VARCHAR2(256),
	 keyval	       VARCHAR2(256)
        );
/
CREATE OR REPLACE TYPE MGMT_SERV_ALERT_ARRAY_TYPE IS TABLE
      OF MGMT_SERV_ALERT_INFO_TYPE;
/

CREATE OR REPLACE TYPE MGMT_PROBLEM_SERV_INFO_TYPE IS OBJECT
        (srvnm         VARCHAR2(64),
         srvstat       VARCHAR2(32),
         preflist      VARCHAR2(1024),
         runlist       VARCHAR2(1024),
         alertstatval  VARCHAR2(64),
         severityCode  NUMBER,
         metricnm      VARCHAR2(64),
         metriccol     VARCHAR2(64),
         alerttime     DATE,
         target_name   VARCHAR2(64),
         target_type   VARCHAR2(64),
         metricval     VARCHAR2(256),
	 keyval	       VARCHAR2(256)
        );
/
CREATE OR REPLACE TYPE MGMT_PROBLEM_SERV_ARRAY_TYPE IS TABLE
      OF MGMT_PROBLEM_SERV_INFO_TYPE;
/

CREATE OR REPLACE TYPE MGMT_SERV_PERF_INFO_TYPE IS object
   (dbname          VARCHAR2(64),
    srvnm         VARCHAR2(64),
    colltime      VARCHAR2(64),
    respval       VARCHAR2(64),
    cpuload        VARCHAR2(64),
    statval       VARCHAR2(64),
    runval        VARCHAR2(256),
    minresp       VARCHAR2(64),
    mininst       VARCHAR2(64),
    maxresp       VARCHAR2(64),
    maxinst       VARCHAR2(64),
    compkey       VARCHAR2(64)
   );
/

CREATE OR REPLACE TYPE MGMT_SERV_PERF_INFO_ARRAY_TYPE IS TABLE
    OF MGMT_SERV_PERF_INFO_TYPE;
/

Rem
Rem  Interface Stats types
Rem

CREATE OR REPLACE TYPE mgmt_racdb_tb_metric AS OBJECT
(
  target_guid           RAW(16),
  key_value             VARCHAR2(256),
  value                 NUMBER,
  collection_timestamp  DATE
)
/
	
CREATE OR REPLACE TYPE mgmt_racdb_tb_metric_table AS TABLE OF mgmt_racdb_tb_metric
/

CREATE OR REPLACE TYPE mgmt_racdb_interface_stats AS OBJECT
(
 tguid          RAW(16),
 hostname       VARCHAR2(256),
 targetname     VARCHAR2(256),
 ifname         VARCHAR2(256),
 totrate        NUMBER,
 toterr         NUMBER,
 inrate         NUMBER,
 collection_timestamp   DATE
)
/

CREATE OR REPLACE TYPE mgmt_racdb_iface_stats_table AS TABLE OF mgmt_racdb_interface_stats
/



--  added types for getting cluster status
CREATE OR REPLACE TYPE mgmt_cluster_collection_object AS OBJECT
(
  target_guid   RAW(16), 
  target_name   VARCHAR2(256),
  target_type   VARCHAR2(256),
  key_value     VARCHAR2(256), 
  value         NUMBER, 
  collection_timestamp DATE
)
/

CREATE OR REPLACE TYPE mgmt_cluster_collection_table AS TABLE OF mgmt_cluster_collection_object
/

CREATE OR REPLACE TYPE mgmt_cluster_status_object AS OBJECT
(
  target_guid   RAW(16), 
  target_name   VARCHAR2(256),
  target_type   VARCHAR2(256),
  key_value     VARCHAR2(256), 
  collection_timestamp DATE,
  status        NUMBER, 
  failed_count  NUMBER
)
/

CREATE OR REPLACE TYPE mgmt_cluster_status_table AS TABLE OF mgmt_cluster_status_object
/
