Rem drv: <create type="pkgdefs"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/rec/rec_pkgdefs.sql /st_emdbsa_11.2/1 2009/02/26 12:19:48 nzhao Exp $
Rem
Rem rec_pkgdefs.sql
Rem
Rem Copyright (c) 2003, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      rec_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pbantis     12/07/08 - Bug 7344865 add getStartTimeOfFirstInChain().
Rem    pbantis     08/30/05 - Add retry_backup_job(). 
Rem    pbantis     08/29/05 - More default param values. 
Rem    pbantis     08/19/05 - Default param values for update_mgmt_ha_backup(). 
Rem    pbantis     07/25/05 - Add update_mgmt_ha_* procedures. 
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    hying       02/09/05 - add db_name 
Rem    hying       08/07/03 - Fix bug 3086483 
Rem    hying       07/07/03 - Fix schema 0706
Rem    hying       07/03/03 - Change package name
Rem    hying       06/05/03 - hying_oss
Rem    hying       06/05/03 - Created
Rem

CREATE OR REPLACE  PACKAGE MGMT_REC AS 

-- Name used for logging (sysman.emdw_trace_data).
LOG_NAME CONSTANT VARCHAR2(11) := 'EM.MGMT_REC';

PROCEDURE submit_out_of_box_backup(
    p_host_username IN VARCHAR2,
    p_host_password IN VARCHAR2,
    p_db_username IN VARCHAR2,
    p_db_password IN VARCHAR2,
    p_db_role IN VARCHAR2,
    p_db_connect_string IN VARCHAR2,
    p_db_name IN VARCHAR2,
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2,
    p_job_name IN VARCHAR2,
    p_job_desc IN VARCHAR2,
    p_execution_hours IN NUMBER,
    p_execution_minutes IN NUMBER,
    p_noarchivelog_mode IN VARCHAR2);

-- PL/SQL Procedure used by loader to handle table inserts for mgmt_ha_backup.
PROCEDURE update_mgmt_ha_backup(
    p_target_guid IN RAW,
    p_collection_timestamp IN DATE DEFAULT SYSDATE,
    p_end_time IN DATE DEFAULT NULL,
    p_status IN VARCHAR2 DEFAULT NULL,
    p_session_key IN NUMBER DEFAULT NULL,
    p_session_recid IN NUMBER DEFAULT NULL,
    p_session_stamp IN NUMBER DEFAULT NULL,
    p_command_id IN VARCHAR2 DEFAULT NULL,
    p_start_time in DATE DEFAULT NULL,
    p_time_taken_display IN VARCHAR2 DEFAULT NULL,
    p_input_type IN VARCHAR2 DEFAULT NULL,
    p_output_device_type IN VARCHAR2 DEFAULT NULL,
    p_input_bytes_display IN VARCHAR2 DEFAULT NULL,    
    p_output_bytes_display IN VARCHAR2 DEFAULT NULL,
    p_output_bytes_per_sec_display IN VARCHAR2 DEFAULT NULL);

-- PL/SQL Procedure used by loader to handle table inserts for mgmt_ha_mttr.
PROCEDURE update_mgmt_ha_mttr(
    p_target_guid IN RAW,
    p_collection_timestamp IN DATE DEFAULT SYSDATE,
    p_estimated_mttr IN NUMBER DEFAULT NULL);

-- Restartable backup jobs.
PROCEDURE retry_backup_job(
    p_reason IN NUMBER,
    p_status IN NUMBER,
    p_job_id IN RAW,
    p_execution_id IN RAW);

-- Restartable backup jobs helper function.
FUNCTION getStartTimeOfFirstInChain(
    p_job_id IN RAW,
    p_execution_id IN RAW) RETURN DATE;

END MGMT_REC;
/

show errors;


