Rem drv: <create type="post_creation" pos="changemgr/cm_post_creation.sql+"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/rec/rec_post_creation.sql /st_emdbsa_11.2/1 2009/01/27 16:16:43 mmootha Exp $
Rem
Rem rec_post_creation.sql
Rem
Rem Copyright (c) 2002, 2008, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      rec_post_creation.sql - Register job commands for backup/recovery.
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    hasriniv    08/12/08 - 
Rem    pbantis     07/25/05 - Register Loader ROWSET handlers. 
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    pbantis     06/19/04 - pbantis_br_rmanjob_040618
Rem    pbantis     06/18/04 - Created from rac_post_creation.
Rem


BEGIN

    mgmt_jobs.register_command('preRman',
                         'oracle.sysman.emo.util.rec.commands.PreRman',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('postRman',
                         'oracle.sysman.emo.util.rec.commands.PostRman',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('configCommand',
                        'oracle.sysman.emo.config.command.ConfigCommand',
                        MGMT_JOBS.LONG_RUNNING_COMMAND,
                         MGMT_JOBS.TRUSTABLE_COMMAND);
    mgmt_jobs.register_command('preConfigCommand',
                        'oracle.sysman.emo.config.command.PreConfigCommand',
                        MGMT_JOBS.LONG_RUNNING_COMMAND,
                         MGMT_JOBS.TRUSTABLE_COMMAND);
    mgmt_jobs.register_command('postConfigCommand',
                        'oracle.sysman.emo.config.command.PostConfigCommand',
                        MGMT_JOBS.LONG_RUNNING_COMMAND,
                         MGMT_JOBS.TRUSTABLE_COMMAND);
    mgmt_jobs.register_command('undoConfigCommand',
                        'oracle.sysman.emo.config.command.UndoConfigCommand',
                        MGMT_JOBS.LONG_RUNNING_COMMAND,
                         MGMT_JOBS.TRUSTABLE_COMMAND);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

-- PL/SQL Procedure used by loader to handle table inserts for mgmt_ha_backup.
BEGIN
    emd_loader.add_plsql_handler_for_rowset(
        p_rowset_name => 'MGMT_HA_BACKUP',
        p_proc_name => 'mgmt_rec.update_mgmt_ha_backup');
    COMMIT;
END;
/   
-- PL/SQL Procedure used by loader to handle table inserts for mgmt_ha_mttr.
BEGIN
    emd_loader.add_plsql_handler_for_rowset(
        p_rowset_name => 'MGMT_HA_MTTR',
        p_proc_name => 'mgmt_rec.update_mgmt_ha_mttr');
    COMMIT;
END;
/   

SET DEFINE ON 
