Rem drv: <create type="pkgbodys" condition="EM_REPOS_MODE=CENTRAL"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/reports/overview/overview_pkgbodys.sql /st_emdbsa_11.2/3 2008/12/12 12:05:22 mvajapey Exp $
Rem
Rem overview_pkgbodys.sql
Rem
Rem Copyright (c) 2004, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      overview_pkgbodys.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mvajapey    12/03/08 - bug 7612821: replace dbms_assert with EM_CHECK
Rem    mvajapey    11/25/08 - bug 7341591
Rem    nachen      05/29/08 - XbranchMerge nachen_bug-7010907 from
Rem                           st_emdbsa_11.1
Rem    nachen      05/15/08 - XbranchMerge nachen_bug-6315707 from main
Rem    nachen      03/04/08 - fix bug 5968994
Rem    rtakeish    01/21/08 - bug6731462, ORA-06502 occurs in
Rem                           get_database_and_instance_info()
Rem    nachen      12/19/05 - fix instance name and version bug 4891592 
Rem    nachen      12/19/05 - this pkg is for grid control only
Rem    nachen      09/06/05 - fix bug 4592888 -- layout problem 
Rem    nachen      08/31/05 - bug 4585653 
Rem    nachen      07/29/05 - fix bug 4524571 
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    lgloyd      05/10/05 - fix param type 
Rem    nachen      04/11/05 - add instruction text 
Rem    nachen      04/01/05 - meet checklist 
Rem    rreilly     02/24/05 - make total size sum of tbsp sizes 
Rem    nachen      01/25/05 - use views not tables 
Rem    nachen      12/13/04 - fix error 
Rem    nachen      11/24/04 - 
Rem    nachen      10/27/04 - nls Unavailable string 
Rem    nachen      10/18/04 - remove comment out
Rem    nachen      10/14/04 - nachen_db_overview_report_1
Rem    nachen      10/13/04 - Created
Rem
Rem SET ECHO ON
Rem SET FEEDBACK 1
Rem SET NUMWIDTH 10
Rem SET LINESIZE 80
Rem SET TRIMSPOOL ON
Rem SET TAB OFF
Rem SET PAGESIZE 100

create or replace package body mgmt_database_overview
as

procedure add_instruction_text(l_report_guid IN RAW, l_element_row IN NUMBER) is
  l_param_values MGMT_IP_PARAM_VALUE_LIST;
  l_element_guid RAW(16);
BEGIN
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(3);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName',
      'oracle.sysman.db.rsc.inst.DBMsg');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage',
      'DB_REPORT_INSTRUCTION');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle',
      'OraInstructionText');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid => l_report_guid, 
      p_element_name_nlsid => 'IPMSG_STYLED_TEXT',
      p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlsid => '',
      p_element_order => l_element_row,
      p_element_row => l_element_row, 
      p_parameters => l_param_values,
      p_targets => NULL);

end add_instruction_text;

function escape_and_enquote_literal(input IN varchar2) return varchar2 is
  singleQuote constant varchar2(1) := '''';
  doubleQuote constant varchar2(2) := '''''';
  inputEscaped constant varchar2(4000) := replace(input, singleQuote, doubleQuote);
  inputSafe constant varchar2(4000) := em_check.enquote_literal(inputEscaped);  
BEGIN
  if input is NULL then
    return 'NULL';
  else  
    return inputSafe;
  end if;
EXCEPTION
  WHEN OTHERS THEN
    return 'NULL';
END escape_and_enquote_literal;

function escape_and_enquote_number(input IN number) return varchar2 is
  singleQuote constant varchar2(1) := ''''; 
  doubleQuote constant varchar2(2) := '''''';
  defaultNlsFormat constant varchar2(20) := '999999D999';
  defaultNlsChars constant varchar2(50) := 'NLS_Numeric_Characters = ''.,''';
  defaultNlsFormatLiteral constant varchar2(40) := em_check.enquote_literal(defaultNlsFormat);
  defaultNlsCharsLiteral constant varchar2(50) :=
    em_check.enquote_literal(replace(defaultNlsChars, singleQuote, doubleQuote)); 

  inputSafe constant varchar2(20) := To_Char(input, defaultNlsFormat, defaultNlsChars); 
  inputSafeLiteral constant varchar2(20) := em_check.enquote_literal(inputSafe);
BEGIN
  if input is NULL then
    return 'NULL';
  else  
    return 'to_number(' || inputSafeLiteral || ', ' || defaultNlsFormatLiteral || ', ' || defaultNlsCharsLiteral || ') '; 
  end if;
EXCEPTION
  WHEN OTHERS THEN
    return 'NULL';
END escape_and_enquote_number;

function escape_and_enquote_timestamp(timestamp IN Date, timezone IN varchar2) return varchar2 is 
  dateFormat constant varchar2(30) := 'MM/DD/YYYY HH24:MI:SS'; 
  timestampStr constant varchar2(50) := to_char(timestamp, dateFormat); 
  timestampTzLiteralSafe constant varchar2(50) := em_check.enquote_literal(timestampStr || ' ' || timezone);
  dateFormatTz constant varchar2(30) := dateFormat || ' TZD'; 
  dateFormatTzLiteral constant varchar2(30) := em_check.enquote_literal(dateFormatTz); 
BEGIN
  if timestamp IS NULL or timezone IS NULL then 
    return NULL;
  else
    return 'to_timestamp_tz(' || timestampTzLiteralSafe || ', ' || dateFormatTzLiteral || ') ';
  end if;
EXCEPTION
  WHEN OTHERS THEN
    return NULL;
END escape_and_enquote_timestamp;


procedure get_database_and_instance_info (
                result_cursor_out        OUT CURSOR_TYPE,
                tgt_guid_in              IN  MGMT_IP_TGT_GUID_ARRAY,
                start_date_in            IN DATE DEFAULT NULL,
                end_date_in              IN DATE DEFAULT NULL
                ) is 
  targetName VARCHAR2(256);
  targetType VARCHAR2(64);
  sitemapInfo SMP_EMD_DBSITEMAP_OBJ;
  dbSize VARCHAR2(20);
  databaseName VARCHAR2(15);
  globalName VARCHAR2(4000);
  dbVersion VARCHAR2(64);
  openMode VARCHAR2(18);
  listenerName VARCHAR2(256);
  oracleHome VARCHAR2(1024);
  logMode VARCHAR2(18);
  restrictedMode VARCHAR2(18);
  flashbackOn VARCHAR2(18);
  query_string   VARCHAR2(32767);
BEGIN
  BEGIN
    select target_name into targetName from mgmt$target where target_guid = hextoraw(tgt_guid_in(1)) and rownum=1;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      targetName := NULL;
  END;
  
  targetType := 'oracle_database';

  BEGIN  
    select i.database_name, i.global_name, i.banner, 
           decode(i.open_mode, 'NO', 'DB_REPORT_DISABLED', 'DB_REPORT_ENABLED'),
	   decode(i.logins, 'NO', 'DB_REPORT_DISABLED', 'DB_REPORT_ENABLED')
    into databaseName, globalName, dbVersion, openMode, restrictedMode
    from mgmt$db_dbninstanceinfo_all i, mgmt$ecm_visible_snapshots s
    where i.snapshot_guid = s.ecm_snapshot_id and s.target_guid=hextoraw(tgt_guid_in(1)) and rownum = 1;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      databaseName := NULL;
      globalName := NULL;
      dbVersion := NULL;
      openMode := NULL;
      restrictedMode := NULL;
  END;
  
  emd_database.getDBSiteMapInfo(targetName, targetType, sitemapInfo);
  
  BEGIN
    select to_char(nvl(sum(tablespace_size)/1024/1024/1024,0),'9999999.0000000') into dbSize from MGMT$DB_TABLESPACES where target_guid = HEXTORAW(tgt_guid_in(1));
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      dbSize := NULL;
  END;
  
  BEGIN
    select target_name into listenerName from mgmt$target   
    where target_type = 'oracle_listener' 
          and host_name = (select host_name from mgmt$target where target_guid = hextoraw(tgt_guid_in(1)))
          and target_guid in 
            (select target_guid from mgmt$target_properties where property_name='Machine' and property_value= 
              (select property_value from mgmt$target_properties where target_guid=hextoraw(tgt_guid_in(1)) and property_name='MachineName')) 
          and target_guid in 
            (select target_guid from mgmt$target_properties where property_name='Port' and property_value= 
              (select property_value from mgmt$target_properties where target_guid=hextoraw(tgt_guid_in(1)) and property_name='Port'))
          and rownum=1;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      listenerName := NULL;
  END;
  
  BEGIN
    select p.property_value into oracleHome from mgmt$target_properties p 
    where p.target_guid = hextoraw(tgt_guid_in(1)) and p.property_name='OracleHome' and rownum=1;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      oracleHome := NULL;
  END;
  
  BEGIN
    select decode(log_mode, 'NOARCHIVELOG', 'DB_REPORT_DISABLED', 'DB_REPORT_ENABLED') , 
           decode(flashback_on, 'NO', 'DB_REPORT_DISABLED', 'DB_REPORT_ENABLED')  
    into logMode, flashbackOn 
    from MGMT$HA_INFO 
    where target_guid = hextoraw(tgt_guid_in(1)) and rownum=1;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      logMode := NULL;
      flashbackOn := NULL;
  END; 
  
  query_string := 'select ';
  query_string := query_string || escape_and_enquote_literal(databaseName) || ' DB_REPORT_DB_NAME, ';
  query_string := query_string || escape_and_enquote_literal(globalName) || ' DB_REPORT_GLOBAL_NAME, ';
  query_string := query_string || escape_and_enquote_literal(dbVersion) || ' DB_REPORT_DB_VERSION, ';
  query_string := query_string || escape_and_enquote_literal(sitemapInfo.host_name) || ' DB_REPORT_HOST_NAME, ';
  if sitemapInfo.avail_pct < 0 then
    query_string := query_string || 'NULL DB_REPORT_AVAIL_PCT, ';
  else
    query_string := query_string || escape_and_enquote_number(sitemapInfo.avail_pct) || ' DB_REPORT_AVAIL_PCT, ';
  end if;
  query_string := query_string || escape_and_enquote_literal(oracleHome) || ' DB_REPORT_ORACLE_HOME, ';
  query_string := query_string || escape_and_enquote_literal(listenerName) || ' DB_REPORT_LISTENER, ';

  if sitemapInfo.start_timestamp IS NOT NULL then
    query_string := query_string || escape_and_enquote_timestamp(sitemapInfo.start_timestamp, sitemapInfo.timezone) || ' DB_REPORT_DB_START_TIME, ';
  else
    query_string := query_string || ' NULL DB_REPORT_DB_START_TIME, ';
  end if;

  if (sitemapInfo.instance_name IS NULL or sitemapInfo.instance_name = ' ')
  then
    query_string := query_string || ' NULL DB_REPORT_INSTANCE_NAME, ';
  else
    query_string := query_string || escape_and_enquote_literal(sitemapInfo.instance_name) || ' DB_REPORT_INSTANCE_NAME, ';
  end if ;

  if sitemapInfo.instance_starttime IS NOT NULL then
    query_string := query_string || escape_and_enquote_timestamp(sitemapInfo.instance_starttime, sitemapInfo.timezone) || ' DB_REPORT_INSTANCE_START_TIME, ';
  else
    query_string := query_string || ' NULL DB_REPORT_INSTANCE_START_TIME, ';
  end if;

  query_string := query_string || escape_and_enquote_literal(sitemapInfo.timezone) || ' DB_REPORT_TIME_ZONE, ';
  if (sitemapInfo.instance_version IS NULL or sitemapInfo.instance_version = ' ') 
  then
    query_string := query_string || 'NULL DB_REPORT_INSTANCE_VERSION, ';
  else
    query_string := query_string || escape_and_enquote_literal(sitemapInfo.instance_version) || ' DB_REPORT_INSTANCE_VERSION, ';
  end if;

  query_string := query_string || escape_and_enquote_literal(openMode) || ' DB_REPORT_READ_ONLY_MODE, ';
  query_string := query_string || escape_and_enquote_literal(restrictedMode) || ' DB_REPORT_RESTRICTED_MODE, ';
  query_string := query_string || escape_and_enquote_literal(logMode) || ' DB_REPORT_ARCHIVE_LOG_MODE, ';
  query_string := query_string || escape_and_enquote_literal(flashbackOn) || ' DB_REPORT_FLASHBACK_LOGGING, ';

  if dbSize IS NOT NULL and dbSize != 0 then 
    query_string := query_string || escape_and_enquote_number(dbSize) || ' DB_REPORT_DATABASE_SIZE ';  
  else
    query_string := query_string || 'NULL DB_REPORT_DATABASE_SIZE ';  
  end if;

  query_string := query_string || 'from dual';

  OPEN result_cursor_out for query_string;
 
end get_database_and_instance_info;

procedure add_database_and_instance_info(l_report_guid IN RAW, l_element_row IN NUMBER, l_owner IN VARCHAR2) IS

  l_param_values  MGMT_IP_PARAM_VALUE_LIST;
  l_element_guid  RAW(16);
BEGIN
 
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(7);

    BEGIN
      mgmt_ip.deregister_sql_statement(
        p_name => 'oracle.sysman.db.overview.report.DB_INSTANCE_INFO_SQL');
      EXCEPTION
      WHEN NO_DATA_FOUND
          THEN
          l_element_guid := NULL;
    END;

    mgmt_ip.register_sql_statement( 
      p_name => 'oracle.sysman.db.overview.report.DB_INSTANCE_INFO_SQL',
      p_sql_statement => 
      'begin ' || l_owner ||
         '.mgmt_database_overview.get_database_and_instance_info(
         result_cursor_out => ??EMIP_BIND_RESULTS_CURSOR??,
         tgt_guid_in => ??EMIP_BIND_TARGET_GUID_ARRAY??); end;');

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(7);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.NamedSqlStatement',
      'oracle.sysman.db.overview.report.DB_INSTANCE_INFO_SQL');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.translateColumnValueColumns',
      'DB_REPORT_READ_ONLY_MODE,DB_REPORT_RESTRICTED_MODE,DB_REPORT_ARCHIVE_LOG_MODE,DB_REPORT_FLASHBACK_LOGGING'); 
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle',
      'oracle.sysman.db.rsc.inst.DBMsg');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatementIsPlSql',
      'true');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.nameValueDisplay',
      '2');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.nullDataStringSubstitue',
      'UNAVAILABLE');
    l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.adjustTimes',
      'true');
     
    mgmt_ip.add_table_from_sql_elem_def(
      p_element_name_nlsid => 'DBMSG_DATABASE_TABLE_FROM_SQL',
      p_element_type_nlsid => 'IPMSG_DATABASE_TARGET_TYPE',
      p_description_nlsid => 'DBMSG_DATABASE_TABLE_FROM_SQL',
      p_internal_use_only => 1,
      p_query_views => 0
      );

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid => l_report_guid,
      p_element_name_nlsid => 'DBMSG_DATABASE_TABLE_FROM_SQL',
      p_element_type_nlsid => 'IPMSG_DATABASE_TARGET_TYPE',
      p_header_nlsid => 'DB_DATABASE_AND_INSTANCE_INFO',
      p_element_order => l_element_row,
      p_element_row => l_element_row, 
      p_parameters => l_param_values,
      p_targets => NULL);

END add_database_and_instance_info;

procedure add_sga_info(l_report_guid IN RAW, l_element_row IN NUMBER) IS
  l_param_values  MGMT_IP_PARAM_VALUE_LIST;
  l_element_guid  RAW(16);
BEGIN
    BEGIN
      mgmt_ip.deregister_sql_statement( 
        p_name => 'oracle.sysman.db.overview.report.SGA_INFO_SQL');
      EXCEPTION
      WHEN NO_DATA_FOUND
          THEN
          l_element_guid := NULL;
    END;

    mgmt_ip.register_sql_statement( 
      p_name => 'oracle.sysman.db.overview.report.SGA_INFO_SQL',
      p_sql_statement => 
        'select e.sganame DB_REPORT_NAME, e.sgasize DB_REPORT_SIZE 
        from mgmt$db_sga_all e, mgmt$ecm_visible_snapshots s 
        where e.snapshot_guid = s.ecm_snapshot_id and s.target_guid = ??EMIP_BIND_TARGET_GUID??');
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(3);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.NamedSqlStatement',
      'oracle.sysman.db.overview.report.SGA_INFO_SQL');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle',
      'oracle.sysman.db.rsc.inst.DBMsg');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.adjustTimes',
      'true');

    mgmt_ip.add_table_from_sql_elem_def(
      p_element_name_nlsid => 'DBMSG_DATABASE_USER_TABLE_FROM_SQL',
      p_element_type_nlsid => 'IPMSG_DATABASE_TARGET_TYPE',
      p_description_nlsid => 'DBMSG_DATABASE_USER_TABLE_FROM_SQL',
      p_internal_use_only => 1,
      p_query_views => 1
      );

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid => l_report_guid,
      p_element_name_nlsid => 'DBMSG_DATABASE_USER_TABLE_FROM_SQL',
      p_element_type_nlsid => 'IPMSG_DATABASE_TARGET_TYPE',
      p_header_nlsid => 'DB_SGA_INFO',
      p_element_order => l_element_row,
      p_element_row => l_element_row, 
      p_parameters => l_param_values,
      p_targets => NULL);

END add_sga_info;

procedure add_non_default_init_params(l_report_guid IN RAW, l_element_row IN NUMBER) IS
  l_param_values  MGMT_IP_PARAM_VALUE_LIST;
  l_element_guid  RAW(16);
BEGIN

    BEGIN
      mgmt_ip.deregister_sql_statement (
        p_name => 'oracle.sysman.db.overview.report.NON_DEFAULT_INIT_PARAMS_SQL');
      EXCEPTION
      WHEN NO_DATA_FOUND
          THEN
          l_element_guid := NULL;
    END;

    mgmt_ip.register_sql_statement (
      p_name => 'oracle.sysman.db.overview.report.NON_DEFAULT_INIT_PARAMS_SQL',
      p_sql_statement => 'select i.name DB_REPORT_PARAMETER_NAME, i.value DB_REPORT_VALUE 
        from mgmt$db_init_params_all i, mgmt$ecm_visible_snapshots s 
        where i.isdefault = ''FALSE'' and i.snapshot_guid = s.ecm_snapshot_id and 
        s.target_guid = ??EMIP_BIND_TARGET_GUID??');
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(3);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.NamedSqlStatement',
      'oracle.sysman.db.overview.report.NON_DEFAULT_INIT_PARAMS_SQL');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle',
      'oracle.sysman.db.rsc.inst.DBMsg');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.adjustTimes',
      'true');

    mgmt_ip.add_table_from_sql_elem_def(
      p_element_name_nlsid => 'DBMSG_DATABASE_USER_TABLE_FROM_SQL',
      p_element_type_nlsid => 'IPMSG_DATABASE_TARGET_TYPE',
      p_description_nlsid => 'DBMSG_DATABASE_USER_TABLE_FROM_SQL',
      p_internal_use_only => 1,
      p_query_views => 1
      );

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid => l_report_guid,
      p_element_name_nlsid => 'DBMSG_DATABASE_USER_TABLE_FROM_SQL',
      p_element_type_nlsid => 'IPMSG_DATABASE_TARGET_TYPE',
      p_header_nlsid => 'DB_NONE_DEFAULT_INIT_PARAMS',
      p_element_order => l_element_row,
      p_element_row => l_element_row, 
      p_parameters => l_param_values,
      p_targets => NULL);
      
END add_non_default_init_params;

procedure create_report_definition(l_title_nlsid IN VARCHAR2, l_description_nlsid IN VARCHAR2, l_owner IN VARCHAR2, l_category_nlsid IN VARCHAR2, l_sub_category_nlsid IN VARCHAR2) is
  l_report_guid   RAW(16);
  l_target_types   MGMT_IP_TARGET_TYPES;
BEGIN
    BEGIN
      mgmt_ip.delete_report_by_title(report_owner_in => l_owner, 
                                     report_title_in => l_title_nlsid,
                                     check_security => 0);
      EXCEPTION
      WHEN NO_DATA_FOUND
          THEN
          l_report_guid := NULL;  
    END;

    -- targets types
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(1);
    l_target_types(1) := 'oracle_database';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid => l_title_nlsid,
      p_description_nlsid => l_description_nlsid,
      p_owner => l_owner,
      p_category_nlsid => l_category_nlsid, 
      p_sub_category_nlsid => l_sub_category_nlsid,
      p_late_binding_target_types => l_target_types,
      p_system_report => 1);

    add_instruction_text(l_report_guid, 1);
    add_database_and_instance_info(l_report_guid, 2, l_owner);
    add_sga_info(l_report_guid, 3);
    add_non_default_init_params(l_report_guid, 4);

END create_report_definition;

END mgmt_database_overview;
/

show errors;

