Rem drv: <create type="tables" pos="hdm/hdm_tables.sql+"/>
Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/db/latest/stgAdv/stgAdv_tables.sql /st_emdbsa_11.2/1 2008/09/30 08:01:51 mnihalan Exp $
Rem
Rem stgAdv_tables.sql
Rem
Rem Copyright (c) 2003, 2008, Oracle. All rights reserved.
Rem
Rem    NAME
Rem      stgAdv_tables.sql - Storage Advisor table(s)
Rem
Rem    DESCRIPTION
Rem      Creates the table(s) used by Storage Advisor 
Rem      a/k/a Space Advisor
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mnihalan    07/31/08 - Fix metadata for recSegmentSetting
Rem    mnihalan    03/16/07 - Fix bug 5937135
Rem    rreilly     08/30/05 - bug 4571494 lob column should be 4000 varchar2 
Rem    chyu        06/28/05 - New repmgr header impl 
Rem    scgrover    02/02/05 - compress indexes 
Rem    abodge      09/30/03 - Enhance mixed-segment-types check 
Rem    abodge      09/25/03 - Rework storage policy rule 
Rem    abodge      09/17/03 - Increase size of inv obj col for Java classes 
Rem    abodge      09/12/03 - Fix break due to large key value 
Rem    abodge      09/10/03 - Add tablesapce col to recuser table 
Rem    abodge      09/09/03 - Mod inv objects table 
Rem    abodge      09/07/03 - Add inv objects config table 
Rem    abodge      08/20/03 - More rework 
Rem    abodge      08/14/03 - Rework rec seg table 
Rem    abodge      05/22/03 - Add ecm tables
Rem    jochen      05/23/03 - Add recommendation column
Rem    abodge      04/29/03 - abodge_add_settings_metrics
Rem    abodge      04/17/03 - Created
Rem

Rem MGMT_SPACE_METRICS holds data collected by Space Advisor raw
Rem metrics.

Rem COLUMNS:
Rem     TARGET_GUID     The target on which the metric was collected.
Rem     METRIC_NAME     The name of the metric that collected this row.
Rem     COLLECTION_TIMESTAMP     When the row was collected.
Rem     OBJECT          Name of the object (user, tablespace, schema
Rem                     object) upon which the metric collected this row.
Rem                     For a schema object, this is in the form:
Rem                       type:schema:name:partition:column
Rem                     where type ::= {TABLE|INDEX|CLUSTER}
Rem                     and partition and/or column may be empty
Rem     TABLESPACE      Name of the tablespace occupied by the schema
Rem                     object segment, or the same as OBJECT for a
Rem                     Tablespace metric; NULL for a User metric.
Rem     SEGMENT_TYPE    A numeric code designating the type of segment
Rem                     found by the metric for a schema object:
Rem                       1: Entire object
Rem                       2: Partition
Rem                       3: IOT Overflow segment
Rem                       4: LOB Column index (not currently used)
Rem                       5: LOB Column
Rem                       6: Subpartition
Rem                     For other types of metrics, set to 0.
Rem     PROBLEM_CODE    Number indicating the problem found with
Rem                     the object (specific to the metric).
Rem     RECOMMENDATIONS Bitset indicating possible recommendations
Rem                     See oracle.sysman.emo.util.stgAdv.StgAdvConstants
Rem     VALUE1..3       Metric-specific values.
 
CREATE TABLE mgmt_space_metrics (
  target_guid RAW(16) NOT NULL, 
  metric_name VARCHAR2(64 byte) NOT NULL, 
  collection_timestamp DATE NOT NULL, 
  object VARCHAR2(150) NOT NULL, 
  tablespace VARCHAR2(30) DEFAULT NULL, 
  segment_type NUMBER DEFAULT 0 NOT NULL, 
  problem_code NUMBER(10) DEFAULT 0 NOT NULL, 
  recommendations NUMBER(10) DEFAULT 0 NOT NULL,
  value1 VARCHAR2(100), 
  CONSTRAINT space_metrics_pk PRIMARY KEY(
    target_guid, 
    collection_timestamp, 
    object, 
    segment_type, 
    metric_name, 
    problem_code))
  MONITORING;

Rem Tables for recommended settings collected by Configuration Snapshot system
Rem These CREATE TABLE statements were generated by 
Rem oracle.sysman.eml.ecm.snap.MetadataRegistry

CREATE TABLE "MGMT_DB_RECUSERSETTINGS_ECM" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_DB_RECUSERSETTINGS_ECM0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "USER_NAME" VARCHAR2(30),
  "PROBLEM_CODE" NUMBER(2),
  "TABLESPACE" VARCHAR2(30),
  CONSTRAINT "MGMT_DB_RECUSERSETTINGS_ECM_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID", "USER_NAME", "PROBLEM_CODE") USING INDEX
    (CREATE UNIQUE INDEX "MGMT_DB_RECUSERSETTINGS_ECM_PK" ON "MGMT_DB_RECUSERSETTINGS_ECM" ("ECM_SNAPSHOT_ID", "USER_NAME", "PROBLEM_CODE") COMPRESS 1)
) MONITORING;

CREATE TABLE "MGMT_DB_RECTSSETTINGS_ECM" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_DB_RECTSSETTINGS_ECM0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "TABLESPACE" VARCHAR2(30),
  "PROBLEM_CODE" NUMBER(2),
  "VALUE1"       NUMBER(10),
  "VALUE2"       NUMBER(10),
  CONSTRAINT "MGMT_DB_RECTSSETTINGS_ECM_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID", "TABLESPACE", "PROBLEM_CODE")
) MONITORING;

CREATE TABLE "MGMT_DB_RECSEGMENTSETTINGS_ECM" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_DB_RECSEGMENTSETTINGS_0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "OBJ_TYPE" NUMBER(2),
  "OBJ_OWNER" VARCHAR2(30),
  "OBJ_NAME" VARCHAR2(30),
  "OBJ_PARTITION" VARCHAR2(30),
  "OBJ_LOB_COL" VARCHAR2(500),
  "TABLESPACE" VARCHAR2(30),
  "SEGMENT_TYPE" NUMBER(2),
  "PROBLEM_CODE" NUMBER(2),
  CONSTRAINT "MGMT_DB_RECSEGMENTSETTINGS_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID", "OBJ_TYPE", "OBJ_OWNER", "OBJ_NAME", "OBJ_PARTITION", "OBJ_LOB_COL", "SEGMENT_TYPE", "PROBLEM_CODE") USING INDEX
    (CREATE UNIQUE INDEX "MGMT_DB_RECSEGMENTSETTINGS_PK" ON "MGMT_DB_RECSEGMENTSETTINGS_ECM" ("ECM_SNAPSHOT_ID", "OBJ_TYPE", "OBJ_OWNER", "OBJ_NAME", "OBJ_PARTITION", "OBJ_LOB_COL", "SEGMENT_TYPE", "PROBLEM_CODE") COMPRESS 1)
) MONITORING;

Rem Register metadata for configuration snapshots

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'oracle_storage');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'oracle_storage';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_storage', 'oracle_database', 'L', metadata_id, 'Recommended Settings Problems', 'Y', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_storage', 'oracle_database', 'P', metadata_id, 'Recommended Settings Problems', 'Y', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_DB_RECUSERSETTINGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'User Recommended Settings Problems', 'Y', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'USER_NAME', 'User Name', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'PROBLEM_CODE', 'Object', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECUSERSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);


  -- Register metadata for table MGMT_DB_RECTSSETTINGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'Tablespace Recommended Settings Problems', 'Y', 'N', 'N', NULL, 'N', 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'PROBLEM_CODE', 'Object', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'VALUE1', 'Value 1', 'N', '10', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECTSSETTINGS_ECM', 'VALUE2', 'Value 2', 'N', '10', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 3);

  -- Register metadata for table MGMT_DB_RECSEGMENTSETTINGS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'Segment Recommended Settings Problems', 'Y', 'N', 'N', NULL, 'N', 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_TYPE', 'Object Type', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_OWNER', 'Owner', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_NAME', 'Name', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_PARTITION', 'Partition', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'OBJ_LOB_COL', 'LOB Column', 'S', '500', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'TABLESPACE', 'Tablespace', 'S', '30', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 5);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'SEGMENT_TYPE', 'Segment Type', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 6);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_RECSEGMENTSETTINGS_ECM', 'PROBLEM_CODE', 'Problem', 'N', '2', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 7);
END;
/


-- Metadata for Objects policy (not strictly storage stuff, but sneaking it in here
-- to minimize number of files affected).

CREATE TABLE "MGMT_DB_INVOBJS_ECM" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_DB_INVOBJS_ECM0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "OBJECT_TYPE" NUMBER(2),
  "OBJECT_OWNER" VARCHAR2(30),
  "OBJECT_NAME" VARCHAR2(1000),
  CONSTRAINT "MGMT_DB_INVOBJS_ECM_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID", "OBJECT_TYPE", "OBJECT_OWNER", "OBJECT_NAME") USING INDEX
    (CREATE UNIQUE INDEX "MGMT_DB_INVOBJS_ECM_PK" ON "MGMT_DB_INVOBJS_ECM" ("ECM_SNAPSHOT_ID", "OBJECT_TYPE", "OBJECT_OWNER", "OBJECT_NAME") COMPRESS 1)
) MONITORING;

-- End of table (re)creation for metadata Object Problems

--------------------------------------------
-- Registering metadata Object Problems for target type oracle_database and snapshot type object
--------------------------------------------

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'oracle_object');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'oracle_object';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_object', 'oracle_database', 'L', metadata_id, 'Object Problems', 'N', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_object', 'oracle_database', 'P', metadata_id, 'Object Problems', 'N', 'N', 'N', NULL, NULL, NULL, '1.0', NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_DB_INVOBJS_ECM
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'Invalid Objects', 'N', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_TYPE', 'Object Type', 'N', '2', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_OWNER', 'Object Owner', 'S', '30', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_DB_INVOBJS_ECM', 'OBJECT_NAME', 'Object Name', 'S', '1000', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 2);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

