rem handle target type cluster

BEGIN 
mgmt_target.register_target_type(
    p_target_type_in => 'cluster',
    p_type_meta_ver_in => '5.1',
    p_type_display_name_in => 'Cluster',
    p_type_display_nlsid_in => 'cluster_name',
    p_type_resource_bundle_in => 'oracle.sysman.db.rsc');
END;
/

BEGIN 
emd_loader.end_metadata_set('cluster','5.1','MGMT_TARGET_TYPE_VERSIONS');
END;
/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Interconnect Name',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_node',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Host',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_node',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_subnet',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Subnet',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_subnet',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_ip',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'IP Address',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_ip',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_public',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Public',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_public',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'ha_cls_intrconn',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_ha_cls_intrconn',
    p_metric_label_nlsid => 'ha_cls_intrconn',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'alertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterwareErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Clusterware Service Alert Log Error',
        p_column_label_nlsid => 'alertLog_clusterwareErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ocrErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OCR Alert Log Error',
        p_column_label_nlsid => 'alertLog_ocrErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'nodeErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Node Configuration Alert Log Error',
        p_column_label_nlsid => 'alertLog_nodeErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'votingErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Voting Disk Alert Log Error',
        p_column_label_nlsid => 'alertLog_votingErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'alertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'CRSAlert',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Clusterware Alert Log',
    p_metric_label_nlsid => 'cluster_crs_alert_log',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'crs_olsnodes',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'CRS OLSNODES',
    p_metric_label_nlsid => 'crs_olsnodes',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hostName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => ' Cluster Node Name',
        p_column_label_nlsid => 'cluster_load_hostName',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'hostName',
        p_short_name_nlsid => 'cluster_load_hostName_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad_1min',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (1 minute average)',
        p_column_label_nlsid => 'cluster_load_cpuLoad_1min',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (1min)',
        p_short_name_nlsid => 'cluster_load_cpuLoad_1min_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (5 minute average)',
        p_column_label_nlsid => 'cluster_load_cpuLoad',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (5min)',
        p_short_name_nlsid => 'cluster_load_cpuLoad_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad_15min',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (15 minute average)',
        p_column_label_nlsid => 'cluster_load_cpuLoad_15min',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (15min)',
        p_short_name_nlsid => 'cluster_load_cpuLoad_15min_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'noOfProcs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Processes',
        p_column_label_nlsid => 'cluster_load_noOfProcs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'noOfUsers',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Users',
        p_column_label_nlsid => 'cluster_load_noOfUsers',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'activeMem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Memory, Kilobytes',
        p_column_label_nlsid => 'host_load_activeMem',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'buffers',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffers, Kilobytes',
        p_column_label_nlsid => 'host_load_buffers',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pagesCache',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Pages Cached, Kilobytes',
        p_column_label_nlsid => 'host_load_page_cache',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mountPoint',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Mount Point',
        p_column_label_nlsid => 'host_filesys_mountPoint',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fileSystem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Filesystem',
        p_column_label_nlsid => 'host_filesys_fileSystem',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Filesystem Size (MB)',
        p_column_label_nlsid => 'host_filesys_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pctAvailable',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Filesystem Space Available (%)',
        p_column_label_nlsid => 'host_filesys_pctAvailable',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'ClusterGeneric',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'ClusterGeneric',
    p_metric_label_nlsid => 'cluster_generic',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'osName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Operating System',
        p_column_label_nlsid => 'host_osConfig_osName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => '_OSConfig',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => '_OSConfig',
    p_metric_label_nlsid => 'host_osConfig',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'CRS_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Clusterware Status',
        p_column_label_nlsid => 'crs_metric_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'CRS_failed_node_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Node(s) with Clusterware Problem',
        p_column_label_nlsid => 'crs_metric_failed_node_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'CRS_output',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Cluster Verification Output',
        p_column_label_nlsid => 'crs_metric_output',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'CRSStatus',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Clusterware Status',
    p_metric_label_nlsid => 'crs_metric',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ecm_data_version',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'ECM Data Version',
        p_column_label_nlsid => 'mgmt_rac_services_ecm_data_version',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'database_unique_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Database Unique Name',
        p_column_label_nlsid => 'mgmt_rac_services_database_unique_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'service_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Service Name',
        p_column_label_nlsid => 'mgmt_rac_services_service_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'service_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Servie Type',
        p_column_label_nlsid => 'mgmt_rac_services_service_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enabled',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Enabled',
        p_column_label_nlsid => 'mgmt_rac_services_enabled',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tafpolicy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'TAF Policy',
        p_column_label_nlsid => 'mgmt_rac_services_tafpolicy',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'preferred_instances',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Preferred Instances',
        p_column_label_nlsid => 'mgmt_rac_services_preferred_instances',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'available_instances',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Available Instances',
        p_column_label_nlsid => 'mgmt_rac_services_available_instances',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'running_instances',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Running Instances',
        p_column_label_nlsid => 'mgmt_rac_services_running_instances',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cluster_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Cluster Name',
        p_column_label_nlsid => 'mgmt_rac_services_cluster_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'server_group',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Server Group',
        p_column_label_nlsid => 'mgmt_rac_services_server_group',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Resource Name',
        p_column_label_nlsid => 'mgmt_rac_services_resource_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'service_centric_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Service Centric Type',
        p_column_label_nlsid => 'mgmt_rac_services_service_centric_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'service_cardinality',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Service Cardinality',
        p_column_label_nlsid => 'mgmt_rac_services_service_cardinality',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'mgmt_rac_services',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_rac_services',
    p_metric_label_nlsid => 'mgmt_rac_services',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'appqos_oc4j_server',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'appqos oc4j server',
    p_metric_label_nlsid => 'appqos_oc4j_server',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'appqos_oc4j_port',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'appqos oc4j port',
    p_metric_label_nlsid => 'appqos_oc4j_port',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_event_key',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Key',
        p_column_label_nlsid => 'crs_event_key',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_source',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Metric Source',
        p_column_label_nlsid => 'metric_source',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ons_event_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Clusterware Event',
        p_column_label_nlsid => 'ons_event_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ons_event_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Event Time',
        p_column_label_nlsid => 'ons_event_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_entity_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Type',
        p_column_label_nlsid => 'crs_entity_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_entity_subtype',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Resource Type',
        p_column_label_nlsid => 'resource_instance_resource_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_entity_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'crs_entity_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_entity_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Resource Instance ID',
        p_column_label_nlsid => 'resource_instance_id',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_event_value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Event Value',
        p_column_label_nlsid => 'crs_event_value',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'State',
        p_column_label_nlsid => 'Status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_event_composite_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Composite State',
        p_column_label_nlsid => 'crs_event_composite_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_event_node_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Node Name',
        p_column_label_nlsid => 'crs_event_node_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_event_body',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Event Body',
        p_column_label_nlsid => 'crs_event_body',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_event_body1',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Event Body Part 1',
        p_column_label_nlsid => 'crs_event_body1',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_event_body2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Event Body Part 2',
        p_column_label_nlsid => 'crs_event_body2',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'crs_event',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Clusterware Event',
    p_metric_label_nlsid => 'crs_event',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_key',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Key',
        p_column_label_nlsid => 'resource_instance_key',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_source',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Metric Source',
        p_column_label_nlsid => 'metric_source',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ons_event_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Clusterware Event',
        p_column_label_nlsid => 'ons_event_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ons_event_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Event Time',
        p_column_label_nlsid => 'ons_event_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_entity_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Type',
        p_column_label_nlsid => 'crs_entity_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_entity_subtype',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Resource Type',
        p_column_label_nlsid => 'resource_instance_resource_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_entity_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Resource Name',
        p_column_label_nlsid => 'resource_instance_resource_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crs_event_composite_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'State Change',
        p_column_label_nlsid => 'resource_instance_composite_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_cardinality',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Cardinality',
        p_column_label_nlsid => 'resource_status_cardinality',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_degree',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Degree',
        p_column_label_nlsid => 'resource_status_degree',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_total_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Configured Instance Count',
        p_column_label_nlsid => 'resource_status_total_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_online_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Online Instance Count',
        p_column_label_nlsid => 'resource_status_online_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_offline_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Offline Instance Count',
        p_column_label_nlsid => 'resource_status_offline_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_unknown_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Unknown Instance Count',
        p_column_label_nlsid => 'resource_status_unknown_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_intermediate_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Intermediate Instance Count',
        p_column_label_nlsid => 'resource_status_intermediate_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_alert_state',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'State Triggering Alert',
        p_column_label_nlsid => 'resource_status_alert_state',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_alert_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Count of Instances in alert state',
        p_column_label_nlsid => 'resource_status_alert_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_status_additional_mesg',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Additional State Information',
        p_column_label_nlsid => 'resource_status_additional_mesg',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'resource_status',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Resource State',
    p_metric_label_nlsid => 'resource_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 1,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cluster_health_check_key',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Key',
        p_column_label_nlsid => 'cluster_health_check_key',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cluster_health_check_component',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Component Name',
        p_column_label_nlsid => 'cluster_health_check_component',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cluster_health_check_comp_description',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Component Description',
        p_column_label_nlsid => 'cluster_health_check_comp_description',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cluster_health_check_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Component State',
        p_column_label_nlsid => 'cluster_health_check_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cluster_health_check_status_mesg',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Component State Description',
        p_column_label_nlsid => 'cluster_health_check_status_mesg',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cluster_health_check_node',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Scope',
        p_column_label_nlsid => 'cluster_health_check_node',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cluster_health_check_message',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Error Message',
        p_column_label_nlsid => 'cluster_health_check_message',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'cluster',
    p_metric_name => 'cluster_health_check',
    p_type_meta_ver => '5.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Clusterware Component Health Check',
    p_metric_label_nlsid => 'cluster_health_check',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
emd_loader.end_metadata_set('cluster','5.1','MGMT_METRICS');
END;
/

BEGIN 
MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'cluster',
              v_type_meta_ver => '5.1',
              v_property_name => 'OracleHome',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'CRS Home',
              v_property_display_nlsid => 'cluster_crshome_iprop',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'cluster',
              v_type_meta_ver => '5.1',
              v_property_name => 'eonsPort',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'eONS Port',
              v_property_display_nlsid => 'cluster_eonsport_iprop',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'cluster',
              v_type_meta_ver => '5.1',
              v_property_name => 'scanName',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Scan Name',
              v_property_display_nlsid => 'cluster_scanName_iprop',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'cluster',
              v_type_meta_ver => '5.1',
              v_property_name => 'scanPort',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Scan Port',
              v_property_display_nlsid => 'cluster_scanport_iprop',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

END;
/

BEGIN 
emd_loader.end_metadata_set('cluster','5.1','MGMT_TARGET_PROP_DEFS');
END;
/
DECLARE
  l_ref MGMT_CRED_TYPE_REF;
  l_ref_list MGMT_CRED_TYPE_REF_ARRAY;
  l_type_column MGMT_CRED_TYPE_COL_RECORD;
  l_type_column_list MGMT_CRED_TYPE_COL_ARRAY;
  l_type_col_val MGMT_CRED_TYPE_COL_VAL;
  l_type_col_val_list MGMT_CRED_TYPE_COL_VAL_ARRAY; 
  l_ref_type_meta_ver MGMT_METRICS.TYPE_META_VER%TYPE; 
  col_count INTEGER;
  ref_count INTEGER;
  l_type_column_display_name MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NAME%TYPE;
  l_type_column_display_nlsid MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NLSID%TYPE;
  l_key MGMT_CREDENTIAL_TYPE_COLUMNS.KEY%TYPE;
BEGIN 

l_ref_list := MGMT_CRED_TYPE_REF_ARRAY();
l_type_column_list := MGMT_CRED_TYPE_COL_ARRAY();

emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_TYPE_REF');
select MAX(target_type_meta_ver) into l_ref_type_meta_ver from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host';
l_ref := MGMT_CRED_TYPE_REF(
           ref_name => 'HostRef',
           type_name => 'HostCreds',
           target_type => 'host',
           ref_type_meta_ver =>  l_ref_type_meta_ver,
            association => 'host');
l_ref_list.extend(1);
ref_count := l_ref_list.count;
l_ref_list(ref_count) :=  l_ref;

emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_TYPE_COLUMNS');
select unique type_column_display_name into l_type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1;
select unique type_column_display_nlsid into l_type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1;
select unique key into l_key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1;
l_type_column := MGMT_CRED_TYPE_COL_RECORD(
    type_column_name => 'HostUserName',
    ref_name => 'HostRef',
    ref_column_name => 'HostUserName',
    type_column_display_name => l_type_column_display_name,
    type_column_display_nlsid => l_type_column_display_nlsid,
      key => l_key,
    col_values => NULL 
    );
l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_TYPE_COLUMNS');
select unique type_column_display_name into l_type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1;
select unique type_column_display_nlsid into l_type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1;
select unique key into l_key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1;
l_type_column := MGMT_CRED_TYPE_COL_RECORD(
    type_column_name => 'HostPassword',
    ref_name => 'HostRef',
    ref_column_name => 'HostPassword',
    type_column_display_name => l_type_column_display_name,
    type_column_display_nlsid => l_type_column_display_nlsid,
      key => l_key,
    col_values => NULL 
    );
l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
mgmt_credential.create_credential_type( 
       p_target_type => 'cluster',
       p_type_name => 'HostCreds',
       p_target_type_meta_ver => '5.1',
       p_type_display_name => 'Host Credentials',
       p_type_display_nlsid => 'CREDS_HOST_HOSTCREDS',
       p_description => '' ,
       p_refs => l_ref_list,
       p_type_columns => l_type_column_list
        );
EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  BEGIN 
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPES ( target_type, target_type_meta_ver, type_name, type_display_name, type_display_nlsid, description ) values ( 'cluster','5.1','HostCreds','Host Credentials','CREDS_HOST_HOSTCREDS','' );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
      update MGMT_CREDENTIAL_TYPES set 
         target_type = 'cluster',
         target_type_meta_ver = '5.1',
         type_name = 'HostCreds',
         type_display_name = 'Host Credentials',
         type_display_nlsid = 'CREDS_HOST_HOSTCREDS',
         description = ''
      WHERE
         target_type = 'cluster' AND 
         target_type_meta_ver = '5.1' AND 
         type_name = 'HostCreds';
    END;
     BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_REF ( target_type, target_type_meta_ver, type_name, ref_name, ref_type_name, ref_target_type, ref_type_meta_ver, association ) values ( 'cluster','5.1','HostCreds','HostRef','HostCreds','host',    (select MAX(target_type_meta_ver) from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host'),'host' );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_REF SET 
        target_type = 'cluster',
        target_type_meta_ver = '5.1',
        type_name = 'HostCreds',
        ref_name = 'HostRef',
        ref_type_name = 'HostCreds',
        ref_target_type = 'host',
        ref_type_meta_ver = (select MAX(target_type_meta_ver) from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host'),
        association = 'host'
    WHERE 
        target_type = 'cluster' AND 
        target_type_meta_ver = '5.1' AND 
        type_name = 'HostCreds' AND 
        ref_name = 'HostRef' AND 
        ref_type_name = 'HostCreds' AND 
        ref_target_type = 'host';
    END; 
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 
                                          'cluster','5.1','HostCreds','HostUserName','HostRef','HostUserName',
(select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1),
(select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1),
(select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host' and type_name = 'HostCreds' and target_type_meta_ver = l_ref_type_meta_ver and type_column_name = 'HostUserName' and rownum = 1)
 );
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_COLUMNS set 
      target_type = 'cluster',
      target_type_meta_ver = '5.1',
      type_name = 'HostCreds',
      type_column_name = 'HostUserName',
      ref_name = 'HostRef',
      ref_column_name = 'HostUserName',
      type_column_display_name = (select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1),
      type_column_display_nlsid = (select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1),
      key = (select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1)
    WHERE 
      TARGET_TYPE = 'cluster' AND 
      TARGET_TYPE_META_VER = '5.1' AND 
      TYPE_NAME = 'HostCreds' AND 
      TYPE_COLUMN_NAME = 'HostUserName';
    END;
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 
                                          'cluster','5.1','HostCreds','HostPassword','HostRef','HostPassword',
(select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1),
(select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1),
(select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host' and type_name = 'HostCreds' and target_type_meta_ver = l_ref_type_meta_ver and type_column_name = 'HostPassword' and rownum = 1)
 );
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_COLUMNS set 
      target_type = 'cluster',
      target_type_meta_ver = '5.1',
      type_name = 'HostCreds',
      type_column_name = 'HostPassword',
      ref_name = 'HostRef',
      ref_column_name = 'HostPassword',
      type_column_display_name = (select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1),
      type_column_display_nlsid = (select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1),
      key = (select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1)
    WHERE 
      TARGET_TYPE = 'cluster' AND 
      TARGET_TYPE_META_VER = '5.1' AND 
      TYPE_NAME = 'HostCreds' AND 
      TYPE_COLUMN_NAME = 'HostPassword';
    END;
  END;
 END;
/
BEGIN 
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_TYPES');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostUserName',
            set_column_name => 'username',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'UserName',
          set_column_display_nlsid => 'CREDS_NORMAL_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostPassword',
            set_column_name => 'password',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Password',
          set_column_display_nlsid => 'CREDS_NORMAL_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'cluster',
         p_set_name => 'HostCredsNormal',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'TARGET',
         p_set_context => NULL,
         p_set_display_name => 'Normal Host Credentials',
         p_set_display_nlsid => 'CREDS_HOST_HOSTCREDS_NORMAL',
         p_type_name => 'HostCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '5.1');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'cluster','5.1','HostCredsNormal','Normal Host Credentials','CREDS_HOST_HOSTCREDS_NORMAL','HostCreds','PREFERRED_CRED','TARGET',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'HostCredsNormal',
    set_display_name = 'Normal Host Credentials',
    set_display_nlsid = 'CREDS_HOST_HOSTCREDS_NORMAL',
    credential_type_name = 'HostCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'TARGET',
    set_context = ' '
  WHERE 
    target_type = 'cluster' AND 
    target_type_meta_ver = '5.1' AND 
    set_name = 'HostCredsNormal';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'cluster','5.1','HostCredsNormal','username','UserName','CREDS_NORMAL_USER','HostUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'HostCredsNormal',
    set_column_name = 'username',
    set_column_display_name = 'UserName',
    set_column_display_nlsid = 'CREDS_NORMAL_USER',
    type_column_name = 'HostUserName'
   WHERE
     target_type = 'cluster' AND 
     target_type_meta_ver = '5.1' AND 
     set_name = 'HostCredsNormal' AND 
     set_column_name = 'username';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'cluster','5.1','HostCredsNormal','password','Password','CREDS_NORMAL_PASSWORD','HostPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'HostCredsNormal',
    set_column_name = 'password',
    set_column_display_name = 'Password',
    set_column_display_nlsid = 'CREDS_NORMAL_PASSWORD',
    type_column_name = 'HostPassword'
   WHERE
     target_type = 'cluster' AND 
     target_type_meta_ver = '5.1' AND 
     set_name = 'HostCredsNormal' AND 
     set_column_name = 'password';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostUserName',
            set_column_name => 'username',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Privileged UserName',
          set_column_display_nlsid => 'CREDS_PRIV_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostPassword',
            set_column_name => 'password',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Privileged Password',
          set_column_display_nlsid => 'CREDS_PRIV_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'cluster',
         p_set_name => 'HostCredsPriv',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'TARGET',
         p_set_context => NULL,
         p_set_display_name => 'Privileged Host Credentials',
         p_set_display_nlsid => 'CREDS_HOST_HOSTCREDS_PRIVILEGED',
         p_type_name => 'HostCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '5.1');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'cluster','5.1','HostCredsPriv','Privileged Host Credentials','CREDS_HOST_HOSTCREDS_PRIVILEGED','HostCreds','PREFERRED_CRED','TARGET',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'HostCredsPriv',
    set_display_name = 'Privileged Host Credentials',
    set_display_nlsid = 'CREDS_HOST_HOSTCREDS_PRIVILEGED',
    credential_type_name = 'HostCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'TARGET',
    set_context = ' '
  WHERE 
    target_type = 'cluster' AND 
    target_type_meta_ver = '5.1' AND 
    set_name = 'HostCredsPriv';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'cluster','5.1','HostCredsPriv','username','Privileged UserName','CREDS_PRIV_USER','HostUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'HostCredsPriv',
    set_column_name = 'username',
    set_column_display_name = 'Privileged UserName',
    set_column_display_nlsid = 'CREDS_PRIV_USER',
    type_column_name = 'HostUserName'
   WHERE
     target_type = 'cluster' AND 
     target_type_meta_ver = '5.1' AND 
     set_name = 'HostCredsPriv' AND 
     set_column_name = 'username';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'cluster','5.1','HostCredsPriv','password','Privileged Password','CREDS_PRIV_PASSWORD','HostPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'HostCredsPriv',
    set_column_name = 'password',
    set_column_display_name = 'Privileged Password',
    set_column_display_nlsid = 'CREDS_PRIV_PASSWORD',
    type_column_name = 'HostPassword'
   WHERE
     target_type = 'cluster' AND 
     target_type_meta_ver = '5.1' AND 
     set_name = 'HostCredsPriv' AND 
     set_column_name = 'password';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostUserName',
            set_column_name => 'OHUsername',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Oracle Home UserName',
          set_column_display_nlsid => 'CREDS_OH_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostPassword',
            set_column_name => 'OHPassword',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Oracle Home Password',
          set_column_display_nlsid => 'CREDS_OH_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'cluster',
         p_set_name => 'OHCreds',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'CONTAINER',
         p_set_context => NULL,
         p_set_display_name => NULL,
         p_set_display_nlsid => NULL,
         p_type_name => 'HostCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '5.1');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'cluster','5.1','OHCreds',NULL,NULL,'HostCreds','PREFERRED_CRED','CONTAINER',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'OHCreds',
    set_display_name = NULL,
    set_display_nlsid = NULL,
    credential_type_name = 'HostCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'CONTAINER',
    set_context = ' '
  WHERE 
    target_type = 'cluster' AND 
    target_type_meta_ver = '5.1' AND 
    set_name = 'OHCreds';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'cluster','5.1','OHCreds','OHUsername','Oracle Home UserName','CREDS_OH_USER','HostUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'OHCreds',
    set_column_name = 'OHUsername',
    set_column_display_name = 'Oracle Home UserName',
    set_column_display_nlsid = 'CREDS_OH_USER',
    type_column_name = 'HostUserName'
   WHERE
     target_type = 'cluster' AND 
     target_type_meta_ver = '5.1' AND 
     set_name = 'OHCreds' AND 
     set_column_name = 'OHUsername';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'cluster','5.1','OHCreds','OHPassword','Oracle Home Password','CREDS_OH_PASSWORD','HostPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'cluster',
    target_type_meta_ver = '5.1',
    set_name = 'OHCreds',
    set_column_name = 'OHPassword',
    set_column_display_name = 'Oracle Home Password',
    set_column_display_nlsid = 'CREDS_OH_PASSWORD',
    type_column_name = 'HostPassword'
   WHERE
     target_type = 'cluster' AND 
     target_type_meta_ver = '5.1' AND 
     set_name = 'OHCreds' AND 
     set_column_name = 'OHPassword';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('cluster','5.1','MGMT_CREDENTIAL_SETS');
END;
/
commit;
