rem handle target type oracle_database

BEGIN 
mgmt_target.register_target_type(
    p_target_type_in => 'oracle_database',
    p_type_meta_ver_in => '5.3',
    p_type_display_name_in => 'Database Instance',
    p_type_display_nlsid_in => 'name',
    p_type_resource_bundle_in => 'oracle.sysman.db.rsc');
END;
/

BEGIN 
emd_loader.end_metadata_set('oracle_database','5.3','MGMT_TARGET_TYPE_VERSIONS');
END;
/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'baselineTime',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Baseline SQL Response Time',
        p_column_label_nlsid => 'baseline_sql_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Baseline Response',
        p_short_name_nlsid => 'baseline_sql_response_time_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'currentTime',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Current SQL Response Time',
        p_column_label_nlsid => 'current_sql_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Current Response',
        p_short_name_nlsid => 'current_sql_response_time_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL Response Time (%)',
        p_column_label_nlsid => 'sql_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Response',
        p_short_name_nlsid => 'sql_response_time_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_2_choices => MGMT_CATEGORY_PROP_ARRAY('2','3')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sql_response',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'SQL Response Time',
    p_metric_label_nlsid => 'sql_response',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL Response Time (%)',
        p_column_label_nlsid => 'sql_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Response',
        p_short_name_nlsid => 'sql_response_time_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_2_choices => MGMT_CATEGORY_PROP_ARRAY('2','3')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sql_response_collect',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
    p_metric_label => 'Collect SQL Response Time',
    p_metric_label_nlsid => 'collect_sql_response',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_current',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'All Sessions',
        p_column_label_nlsid => 'instance_throughput_logons_current',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'All Sessions',
        p_short_name_nlsid => 'instance_throughput_logons_current',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'transactions_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number of Transactions (per second)',
        p_column_label_nlsid => 'instance_throughput_transactions_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Transactions/s',
        p_short_name_nlsid => 'instance_throughput_transactions_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per second)',
        p_column_label_nlsid => 'instance_throughput_physreads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads/s',
        p_short_name_nlsid => 'instance_throughput_physreads_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreads_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreads_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physreads_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwrites_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per second)',
        p_column_label_nlsid => 'instance_throughput_physwrites_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Phys Writes/sec',
        p_short_name_nlsid => 'instance_throughput_physwrites_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwrites_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwrites_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physwrites_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redosize_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generated (per second)',
        p_column_label_nlsid => 'instance_throughput_redosize_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Size/sec',
        p_short_name_nlsid => 'instance_throughput_redosize_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redosize_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generated (per transaction)',
        p_column_label_nlsid => 'instance_throughput_redosize_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Generated (per transaction)',
        p_short_name_nlsid => 'instance_throughput_redosize_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cumulative Logons (per second)',
        p_column_label_nlsid => 'instance_throughput_logons_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logons/sec',
        p_short_name_nlsid => 'instance_throughput_logons_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cumulative Logons (per transaction)',
        p_column_label_nlsid => 'instance_throughput_logons_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cumulative Logons (per transaction)',
        p_short_name_nlsid => 'instance_throughput_logons_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Commits (per second)',
        p_column_label_nlsid => 'instance_throughput_commits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Commits (per second)',
        p_short_name_nlsid => 'instance_throughput_commits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Commits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_commits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Commits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_commits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollbacks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollbacks (per second)',
        p_column_label_nlsid => 'instance_throughput_rollbacks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Rollbacks (per second)',
        p_short_name_nlsid => 'instance_throughput_rollbacks_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollbacks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollbacks (per transaction)',
        p_column_label_nlsid => 'instance_throughput_rollbacks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Rollbacks (per transaction)',
        p_short_name_nlsid => 'instance_throughput_rollbacks_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercalls_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (per second)',
        p_column_label_nlsid => 'instance_throughput_usercalls_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (per second)',
        p_short_name_nlsid => 'instance_throughput_usercalls_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercalls_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (per transaction)',
        p_column_label_nlsid => 'instance_throughput_usercalls_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (per transaction)',
        p_short_name_nlsid => 'instance_throughput_usercalls_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recurscalls_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recursive Calls (per second)',
        p_column_label_nlsid => 'instance_throughput_recurscalls_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recursive Calls (per second)',
        p_short_name_nlsid => 'instance_throughput_recurscalls_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recurscalls_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recursive Calls (per transaction)',
        p_column_label_nlsid => 'instance_throughput_recurscalls_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recursive Calls (per transaction)',
        p_short_name_nlsid => 'instance_throughput_recurscalls_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logreads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Logical Reads (per second)',
        p_column_label_nlsid => 'instance_throughput_logreads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logical Reads/s',
        p_short_name_nlsid => 'instance_throughput_logreads_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logreads_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Logical Reads (per transaction)',
        p_column_label_nlsid => 'instance_throughput_logreads_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Logical Reads (per transaction)',
        p_short_name_nlsid => 'instance_throughput_logreads_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbwrcheckpoints_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DBWR Checkpoints (per second)',
        p_column_label_nlsid => 'instance_throughput_dbwrcheckpoints_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'DBWR Checkpoints (per second)',
        p_short_name_nlsid => 'instance_throughput_dbwrcheckpoints_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redowrites_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Writes (per second)',
        p_column_label_nlsid => 'instance_throughput_redowrites_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Writes (per second)',
        p_short_name_nlsid => 'instance_throughput_redowrites_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redowrites_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Writes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_redowrites_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Writes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_redowrites_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanslong_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Scans on Long Tables (per second)',
        p_column_label_nlsid => 'instance_throughput_tabscanslong_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Scans on Long Tables (per second)',
        p_short_name_nlsid => 'instance_throughput_tabscanslong_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanslong_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Scans on Long Tables (per transaction)',
        p_column_label_nlsid => 'instance_throughput_tabscanslong_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Scans on Long Tables (per transaction)',
        p_short_name_nlsid => 'instance_throughput_tabscanslong_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Parses (per second)',
        p_column_label_nlsid => 'instance_throughput_parses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Parses (per second)',
        p_short_name_nlsid => 'instance_throughput_parses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Parses (per transaction)',
        p_column_label_nlsid => 'instance_throughput_parses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Parses (per transaction)',
        p_short_name_nlsid => 'instance_throughput_parses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hardparses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hard Parses (per second)',
        p_column_label_nlsid => 'instance_throughput_hardparses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Hard Parses (per second)',
        p_short_name_nlsid => 'instance_throughput_hardparses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hardparses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hard Parses (per transaction)',
        p_column_label_nlsid => 'instance_throughput_hardparses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Hard Parses (per transaction)',
        p_short_name_nlsid => 'instance_throughput_hardparses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'executions_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Executes (per second)',
        p_column_label_nlsid => 'instance_throughput_executions_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL Executions/s',
        p_short_name_nlsid => 'instance_throughput_executions_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sortsdisk_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts to Disk (per second)',
        p_column_label_nlsid => 'instance_throughput_sortsdisk_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts to Disk (per second)',
        p_short_name_nlsid => 'instance_throughput_sortsdisk_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sortsdisk_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts to Disk (per transaction)',
        p_column_label_nlsid => 'instance_throughput_sortsdisk_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts to Disk (per transaction)',
        p_short_name_nlsid => 'instance_throughput_sortsdisk_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rows_psort',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Rows Processed (per sort)',
        p_column_label_nlsid => 'instance_throughput_rows_psort',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rows Processed (per sort)',
        p_short_name_nlsid => 'instance_throughput_rows_psort',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'executeswoparse_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Executes Performed without Parses (%)',
        p_column_label_nlsid => 'instance_throughput_executeswoparse_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Executes Performed without Parses (%)',
        p_short_name_nlsid => 'instance_throughput_executeswoparse_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'softparse_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Soft Parse (%)',
        p_column_label_nlsid => 'instance_throughput_softparse_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Soft Parse (%)',
        p_short_name_nlsid => 'instance_throughput_softparse_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercall_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (%)',
        p_column_label_nlsid => 'instance_throughput_usercall_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (%)',
        p_short_name_nlsid => 'instance_throughput_usercall_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanstotal_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Table Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_tabscanstotal_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Table Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_tabscanstotal_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanstotal_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Table Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_tabscanstotal_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Table Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_tabscanstotal_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'networkbytes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Bytes (per second)',
        p_column_label_nlsid => 'instance_throughput_networkbytes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Network Bytes (per second)',
        p_short_name_nlsid => 'instance_throughput_networkbytes_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'instance_throughput',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Throughput',
    p_metric_label_nlsid => 'instance_throughput',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bufcachehit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffer Cache Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_bufcachehit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Buffer Cache Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_bufcachehit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'libcache_hit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Library Cache Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_libcache_hit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Library Cache Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_libcache_hit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dictionaryhit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Dictionary Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_dictionaryhit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Dictionary Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_dictionaryhit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inmem_sort_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts in Memory (%)',
        p_column_label_nlsid => 'instance_efficiency_inmem_sort_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts in Memory (%)',
        p_short_name_nlsid => 'instance_efficiency_inmem_sort_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redologalloc_hit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Log Allocation Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_redologalloc_hit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Log Allocation Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_redologalloc_hit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'instance_efficiency',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Efficiency',
    p_metric_label_nlsid => 'instance_efficiency',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'shared_free_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Shared Pool Free (%)',
        p_column_label_nlsid => 'sga_pool_wastage_shared_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Shared Pool Free (%)',
        p_short_name_nlsid => 'sga_pool_wastage_shared_free_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'large_free_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Large Pool Free (%)',
        p_column_label_nlsid => 'sga_pool_wastage_large_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Large Pool Free (%)',
        p_short_name_nlsid => 'sga_pool_wastage_large_free_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'java_free_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Java Pool Free (%)',
        p_column_label_nlsid => 'sga_pool_wastage_java_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Java Pool Free (%)',
        p_short_name_nlsid => 'sga_pool_wastage_java_free_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_pool_wastage',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'SGA Pool Wastage',
    p_metric_label_nlsid => 'sga_pool_wastage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'local_write_wait_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Local write wait (%)',
        p_column_label_nlsid => 'wait_bottlenecks_local_write_wait_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Local write wait (%)',
        p_short_name_nlsid => 'wait_bottlenecks_local_write_wait_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'net_reset_to_client_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL*Net break/reset to client (%)',
        p_column_label_nlsid => 'wait_bottlenecks_net_reset_to_client_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL*Net break/reset to client (%)',
        p_short_name_nlsid => 'wait_bottlenecks_net_reset_to_client_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'net_reset_to_dblink_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL*Net break/reset to dblink (%)',
        p_column_label_nlsid => 'wait_bottlenecks_net_reset_to_dblink_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL*Net break/reset to dblink (%)',
        p_short_name_nlsid => 'wait_bottlenecks_net_reset_to_dblink_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqueue_dml_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue: DML - contention (%)',
        p_column_label_nlsid => 'wait_bottlenecks_enqueue_dml_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue: DML - contention (%)',
        p_short_name_nlsid => 'wait_bottlenecks_enqueue_dml_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqueue_row_lock_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue: TM, TX, Transaction - row lock contention (%)',
        p_column_label_nlsid => 'wait_bottlenecks_enqueue_row_lock_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue: TM, TX, Txn (%)',
        p_short_name_nlsid => 'wait_bottlenecks_enqueue_row_lock_pct_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqueue_userdef_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue: UL: User-defined - contention (%)',
        p_column_label_nlsid => 'wait_bottlenecks_enqueue_userdef_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue: UL (%)',
        p_short_name_nlsid => 'wait_bottlenecks_enqueue_userdef_pct_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_sync_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Log file sync (%)',
        p_column_label_nlsid => 'wait_bottlenecks_log_file_sync_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Log file sync (%)',
        p_short_name_nlsid => 'wait_bottlenecks_log_file_sync_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'buffer_busy_waits_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffer busy waits (%)',
        p_column_label_nlsid => 'wait_bottlenecks_buffer_busy_waits_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Buffer busy waits (%)',
        p_short_name_nlsid => 'wait_bottlenecks_buffer_busy_waits_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'latch_cache_buffer_chains_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Latch: cache buffer chains (%)',
        p_column_label_nlsid => 'wait_bottlenecks_latch_cache_buffer_chains_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Latch: cache buffer chains (%)',
        p_short_name_nlsid => 'wait_bottlenecks_latch_cache_buffer_chains_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'latch_library_cache_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Latch: library cache (%)',
        p_column_label_nlsid => 'wait_bottlenecks_latch_library_cache_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Latch: library cache (%)',
        p_short_name_nlsid => 'wait_bottlenecks_latch_library_cache_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'library_cache_load_lock_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Library cache load lock (%)',
        p_column_label_nlsid => 'wait_bottlenecks_library_cache_load_lock_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Library cache load lock (%)',
        p_short_name_nlsid => 'wait_bottlenecks_library_cache_load_lock_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'library_cache_lock_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Library cache lock (%)',
        p_column_label_nlsid => 'wait_bottlenecks_library_cache_lock_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Library cache lock (%)',
        p_short_name_nlsid => 'wait_bottlenecks_library_cache_lock_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'library_cache_pin_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Library cache pin (%)',
        p_column_label_nlsid => 'wait_bottlenecks_library_cache_pin_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Library cache pin (%)',
        p_short_name_nlsid => 'wait_bottlenecks_library_cache_pin_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pipe_put_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Pipe put (%)',
        p_column_label_nlsid => 'wait_bottlenecks_pipe_put_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Pipe put (%)',
        p_short_name_nlsid => 'wait_bottlenecks_pipe_put_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'row_cache_lock_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Row cache lock (%)',
        p_column_label_nlsid => 'wait_bottlenecks_row_cache_lock_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Row cache lock (%)',
        p_short_name_nlsid => 'wait_bottlenecks_row_cache_lock_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqueue_hw_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue: HW, Segment High Water Mark - contention (%)',
        p_column_label_nlsid => 'wait_bottlenecks_enqueue_hw_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue: HW Segment HWM (%)',
        p_short_name_nlsid => 'wait_bottlenecks_enqueue_hw_pct_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqueue_st_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue: ST, Space Transaction - contention (%)',
        p_column_label_nlsid => 'wait_bottlenecks_enqueue_st_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue: ST, Space Txn (%)',
        p_short_name_nlsid => 'wait_bottlenecks_enqueue_st_pct_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqueue_alloc_itl_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue: TX mode 4, Transaction - allocate ITL entry (%)',
        p_column_label_nlsid => 'wait_bottlenecks_enqueue_alloc_itl_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue: TX mode 4, Txn (%)',
        p_short_name_nlsid => 'wait_bottlenecks_enqueue_alloc_itl_pct_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'free_buffer_waits_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free buffer waits (%)',
        p_column_label_nlsid => 'wait_bottlenecks_free_buffer_waits_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Free buffer waits (%)',
        p_short_name_nlsid => 'wait_bottlenecks_free_buffer_waits_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'latch_redo_copy_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Latch: redo copy (%)',
        p_column_label_nlsid => 'wait_bottlenecks_latch_redo_copy_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Latch: redo copy (%)',
        p_short_name_nlsid => 'wait_bottlenecks_latch_redo_copy_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'latch_shared_pool_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Latch: shared pool (%)',
        p_column_label_nlsid => 'wait_bottlenecks_latch_shared_pool_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Latch: shared pool (%)',
        p_short_name_nlsid => 'wait_bottlenecks_latch_shared_pool_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_buffer_space_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Log buffer space (%)',
        p_column_label_nlsid => 'wait_bottlenecks_log_buffer_space_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Log buffer space (%)',
        p_short_name_nlsid => 'wait_bottlenecks_log_buffer_space_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_switch_arch_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Log file switch (archiving needed) (%)',
        p_column_label_nlsid => 'wait_bottlenecks_log_file_switch_arch_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Log file switch (archiving needed) (%)',
        p_short_name_nlsid => 'wait_bottlenecks_log_file_switch_arch_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_switch_ckpt_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Log file switch (checkpoint complete) (%)',
        p_column_label_nlsid => 'wait_bottlenecks_log_file_switch_ckpt_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Log file switch (ckpt complete) (%)',
        p_short_name_nlsid => 'wait_bottlenecks_log_file_switch_ckpt_pct_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_switch_complete_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Log file switch completion (%)',
        p_column_label_nlsid => 'wait_bottlenecks_log_file_switch_complete_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Log file switch completion (%)',
        p_short_name_nlsid => 'wait_bottlenecks_log_file_switch_complete_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_switch_arch_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Log switch/archive (%)',
        p_column_label_nlsid => 'wait_bottlenecks_log_switch_arch_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Log switch/archive (%)',
        p_short_name_nlsid => 'wait_bottlenecks_log_switch_arch_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_complete_waits_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write complete waits (%)',
        p_column_label_nlsid => 'wait_bottlenecks_write_complete_waits_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Write complete waits (%)',
        p_short_name_nlsid => 'wait_bottlenecks_write_complete_waits_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'net_msg_to_client_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL*Net message to client (%)',
        p_column_label_nlsid => 'wait_bottlenecks_net_msg_to_client_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL*Net message to client (%)',
        p_short_name_nlsid => 'wait_bottlenecks_net_msg_to_client_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'net_msg_to_dblink_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL*Net message to dblink (%)',
        p_column_label_nlsid => 'wait_bottlenecks_net_msg_to_dblink_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL*Net message to dblink (%)',
        p_short_name_nlsid => 'wait_bottlenecks_net_msg_to_dblink_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'net_more_from_client_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL*Net more data from client (%)',
        p_column_label_nlsid => 'wait_bottlenecks_net_more_from_client_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL*Net more data from client (%)',
        p_short_name_nlsid => 'wait_bottlenecks_net_more_from_client_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'net_more_from_dblink_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL*Net more data from dblink (%)',
        p_column_label_nlsid => 'wait_bottlenecks_net_more_from_dblink_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL*Net more data from dblink (%)',
        p_short_name_nlsid => 'wait_bottlenecks_net_more_from_dblink_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'net_more_to_client_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL*Net more data to client (%)',
        p_column_label_nlsid => 'wait_bottlenecks_net_more_to_client_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL*Net more data to client (%)',
        p_short_name_nlsid => 'wait_bottlenecks_net_more_to_client_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'net_more_to_dblink_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'SQL*Net more data to dblink (%)',
        p_column_label_nlsid => 'wait_bottlenecks_net_more_to_dblink_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL*Net more data to dblink (%)',
        p_short_name_nlsid => 'wait_bottlenecks_net_more_to_dblink_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'db_file_scattered_read_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DB file scattered read (%)',
        p_column_label_nlsid => 'wait_bottlenecks_db_file_scattered_read_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'DB file scattered read (%)',
        p_short_name_nlsid => 'wait_bottlenecks_db_file_scattered_read_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'db_file_sequential_read_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DB file sequential read (%)',
        p_column_label_nlsid => 'wait_bottlenecks_db_file_sequential_read_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'DB file sequential read (%)',
        p_short_name_nlsid => 'wait_bottlenecks_db_file_sequential_read_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'db_file_single_write_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DB file single write (%)',
        p_column_label_nlsid => 'wait_bottlenecks_db_file_single_write_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'DB file single write (%)',
        p_short_name_nlsid => 'wait_bottlenecks_db_file_single_write_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'direct_path_read_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Direct path read (%)',
        p_column_label_nlsid => 'wait_bottlenecks_direct_path_read_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Direct path read (%)',
        p_short_name_nlsid => 'wait_bottlenecks_direct_path_read_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'direct_path_read_lob_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Direct path read (lob) (%)',
        p_column_label_nlsid => 'wait_bottlenecks_direct_path_read_lob_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Direct path read (lob) (%)',
        p_short_name_nlsid => 'wait_bottlenecks_direct_path_read_lob_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'direct_path_write_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Direct path write (%)',
        p_column_label_nlsid => 'wait_bottlenecks_direct_path_write_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Direct path write (%)',
        p_short_name_nlsid => 'wait_bottlenecks_direct_path_write_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'direct_path_write_lob_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Direct path write (lob) (%)',
        p_column_label_nlsid => 'wait_bottlenecks_direct_path_write_lob_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Direct path write (lob) (%)',
        p_short_name_nlsid => 'wait_bottlenecks_direct_path_write_lob_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'latch_free_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Latch free - other (%)',
        p_column_label_nlsid => 'wait_bottlenecks_latch_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Latch free - other (%)',
        p_short_name_nlsid => 'wait_bottlenecks_latch_free_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqueue_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue - other (%)',
        p_column_label_nlsid => 'wait_bottlenecks_enqueue_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue - other (%)',
        p_short_name_nlsid => 'wait_bottlenecks_enqueue_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'user_wait_time_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Wait Time (%)',
        p_column_label_nlsid => 'wait_bottlenecks_user_wait_time_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Wait Time %',
        p_short_name_nlsid => 'wait_bottlenecks_user_wait_time_pct_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'user_cpu_time_delta',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Time Delta (sec)',
        p_column_label_nlsid => 'wait_bottlenecks_user_cpu_time_delta',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU (sec)',
        p_short_name_nlsid => 'wait_bottlenecks_user_cpu_time_delta_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userio_wait_cnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Sessions Waiting: I/O',
        p_column_label_nlsid => 'wait_bottlenecks_userio_wait_cnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sessions: I/O',
        p_short_name_nlsid => 'wait_bottlenecks_userio_wait_cnt_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'user_cpu_time_cnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Sessions Using CPU',
        p_column_label_nlsid => 'wait_bottlenecks_user_cpu_time_cnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sessions: CPU',
        p_short_name_nlsid => 'wait_bottlenecks_user_cpu_time_cnt_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'other_wait_cnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Sessions Waiting: Other',
        p_column_label_nlsid => 'wait_bottlenecks_other_wait_cnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sessions: Other',
        p_short_name_nlsid => 'wait_bottlenecks_other_wait_cnt_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'avg_user_cpu_time_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Average Instance CPU (%)',
        p_column_label_nlsid => 'wait_bottlenecks_avg_user_cpu_time_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Instance CPU (%)',
        p_short_name_nlsid => 'wait_bottlenecks_avg_user_cpu_time_pct_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'wait_bottlenecks',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Wait Bottlenecks',
    p_metric_label_nlsid => 'wait_bottlenecks',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dumpType',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Type of Dump Area',
        p_column_label_nlsid => 'dump_dumpType',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dumpDir',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Dump Area Directory',
        p_column_label_nlsid => 'dump_dumpDir',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dumpTotal',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Dump Area (KB)',
        p_column_label_nlsid => 'dump_dumpTotal',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dumpUsed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Dump Area Used (KB)',
        p_column_label_nlsid => 'dump_dumpUsed',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dumpUsedPercent',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Dump Area Used (%)',
        p_column_label_nlsid => 'dump_dumpUsedPercent',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dumpAvail',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free Dump Area (KB)',
        p_column_label_nlsid => 'dump_dumpAvail',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dumpFull',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Dump Area',
    p_metric_label_nlsid => 'dump',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archDir',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Archive Area Destination',
        p_column_label_nlsid => 'arch_archDir',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archTotal',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Archive Area (KB)',
        p_column_label_nlsid => 'arch_archTotal',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archUsed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Archive Area Used (KB)',
        p_column_label_nlsid => 'arch_archUsed',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archUsedPercent',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Archive Area Used (%)',
        p_column_label_nlsid => 'arch_archUsedPercent',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Archive Area %',
        p_short_name_nlsid => 'arch_archUsedPercent_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archAvail',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free Archive Area (KB)',
        p_column_label_nlsid => 'arch_archAvail',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'archFull',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Archive Area',
    p_metric_label_nlsid => 'arch',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userLogon',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Logon Time (msec)',
        p_column_label_nlsid => 'resp_userLogon',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logon Time(ms)',
        p_short_name_nlsid => 'resp_userLogon_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Status',
        p_column_label_nlsid => 'resp_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'State',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'State',
        p_column_label_nlsid => 'resp_state',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'Response',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Response',
    p_metric_label_nlsid => 'resp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'lock_usage',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Lock Limit Usage (%)',
        p_column_label_nlsid => 'lock_usage_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Lock Limit Usage (%)',
        p_short_name_nlsid => 'lock_usage_name',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'process_usage',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Process Limit Usage (%)',
        p_column_label_nlsid => 'process_usage',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Process Limit Usage (%)',
        p_short_name_nlsid => 'process_usage',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'session_usage',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Limit Usage (%)',
        p_column_label_nlsid => 'session_usage',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Limit Usage (%)',
        p_short_name_nlsid => 'session_usage',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'user_limit',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Limit Usage (%)',
        p_column_label_nlsid => 'user_limit',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Limit Usage (%)',
        p_short_name_nlsid => 'user_limit',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'Database_Resource_Usage',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Database Limits',
    p_metric_label_nlsid => 'resource_usage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'alertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Generic Alert Log Error',
        p_column_label_nlsid => 'alertLog_genericErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archiveHungErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Archiver Hung Alert Log Error',
        p_column_label_nlsid => 'alertLog_archiveHungErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'blockCorruptErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Block Corruption Alert Log Error',
        p_column_label_nlsid => 'alertLog_blockCorruptErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Session Terminated Alert Log Error',
        p_column_label_nlsid => 'alertLog_sessTerminateErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Media Failure Alert Log Error',
        p_column_label_nlsid => 'alertLog_mediaFailureErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'traceFileName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Error Trace File',
        p_column_label_nlsid => 'alertLog_traceFileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'alertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2','10gR1','10gR2','10gR203')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'alertLog',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Alert Log',
    p_metric_label_nlsid => 'alertLog',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Generic Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_genericErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Alert Log Error Status',
        p_short_name_nlsid => 'alertLogStatus_genericErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archiveHungErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Archiver Hung Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_archiveHungErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Archiver Hung Alert Log Error Status',
        p_short_name_nlsid => 'alertLogStatus_archiveHungErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'blockCorruptErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Block Corruption Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_blockCorruptErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Block Corruption Error Status',
        p_short_name_nlsid => 'alertLogStatus_blockCorruptErrors_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Terminated Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_sessTerminateErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Terminated Error Status',
        p_short_name_nlsid => 'alertLogStatus_sessTerminateErrors_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Media Failure Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_mediaFailureErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Media Failure Error Status',
        p_short_name_nlsid => 'alertLogStatus_mediaFailureErrors_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2','10gR1','10gR2','10gR203')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'alertLogStatus',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Alert Log Error Status',
    p_metric_label_nlsid => 'alertLogStatus',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'timeLine',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'errorCategory',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'errorCategory',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericInternalErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'genericInternalErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'sessTerminateErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'internalSqlErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'internalSqlErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'accessViolationErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'accessViolationErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redoLogCorruptErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'redoLogCorruptErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fileAccessErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'fileAccessErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inconsistentDbStateErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'inconsistentDbStateErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'oraBlockCorruptErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'oraBlockCorruptErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'deadlockErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'deadlockErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outOfMemoryErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'outOfMemoryErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'clusterErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericIncidentErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'genericIncidentErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dataFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dataFailureErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archiveHungErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'archiveHungErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'blockCorruptErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'blockCorruptErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'mediaFailureErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericOperationalErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'genericOperationalErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'traceFileName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'traceFileName',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'errCodes',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'errCodes',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'alertLogName',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'impact',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'impact',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'incidentId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'incidentId',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'numberOfFailures',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'numberOfFailures',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'adrAlertLogError',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
    p_metric_label => 'adrAlertLogError',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'adrAlertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Time/Line Number',
        p_short_name_nlsid => 'adrAlertLog_timeLine',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericIncidentErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Generic Incident',
        p_column_label_nlsid => 'adrAlertLog_genericIncidentErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Incident',
        p_short_name_nlsid => 'adrAlertLog_genericIncidentErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericInternalErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Generic Internal Error',
        p_column_label_nlsid => 'adrAlertLog_genericInternalErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Internal Error',
        p_short_name_nlsid => 'adrAlertLog_genericInternalErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Session Terminated',
        p_column_label_nlsid => 'adrAlertLog_sessTerminateErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Terminated',
        p_short_name_nlsid => 'adrAlertLog_sessTerminateErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'internalSqlErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Internal SQL Error',
        p_column_label_nlsid => 'adrAlertLog_internalSqlErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Internal SQL Error',
        p_short_name_nlsid => 'adrAlertLog_internalSqlErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'accessViolationErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Access Violation',
        p_column_label_nlsid => 'adrAlertLog_accessViolationErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Access Violation',
        p_short_name_nlsid => 'adrAlertLog_accessViolationErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redoLogCorruptErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Redo Log Corruption',
        p_column_label_nlsid => 'adrAlertLog_redoLogCorruptErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Log Corruption',
        p_short_name_nlsid => 'adrAlertLog_redoLogCorruptErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fileAccessErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File Access Error',
        p_column_label_nlsid => 'adrAlertLog_fileAccessErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'File Access Error',
        p_short_name_nlsid => 'adrAlertLog_fileAccessErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inconsistentDbStateErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Inconsistent DB State',
        p_column_label_nlsid => 'adrAlertLog_inconsistentDbStateErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Inconsistent DB State',
        p_short_name_nlsid => 'adrAlertLog_inconsistentDbStateErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'oraBlockCorruptErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Oracle Data Block Corruption',
        p_column_label_nlsid => 'adrAlertLog_oraBlockCorruptErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Oracle Data Block Corruption',
        p_short_name_nlsid => 'adrAlertLog_oraBlockCorruptErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'deadlockErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Deadlock',
        p_column_label_nlsid => 'adrAlertLog_deadlockErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Deadlock',
        p_short_name_nlsid => 'adrAlertLog_deadlockErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outOfMemoryErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Out of Memory',
        p_column_label_nlsid => 'adrAlertLog_outOfMemoryErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Out of Memory',
        p_short_name_nlsid => 'adrAlertLog_outOfMemoryErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Cluster Error',
        p_column_label_nlsid => 'adrAlertLog_clusterErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cluster Error',
        p_short_name_nlsid => 'adrAlertLog_clusterErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'traceFileName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Error Trace File',
        p_column_label_nlsid => 'adrAlertLog_traceFileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Error Trace File',
        p_short_name_nlsid => 'adrAlertLog_traceFileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'adrAlertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Name',
        p_short_name_nlsid => 'adrAlertLog_fileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'impact',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Impact',
        p_column_label_nlsid => 'adrAlertLog_impact',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Impact',
        p_short_name_nlsid => 'adrAlertLog_impact',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'incidentId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Incident ID',
        p_column_label_nlsid => 'adrAlertLog_incidentId',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Incident ID',
        p_short_name_nlsid => 'adrAlertLog_incidentId',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'adrAlertLogIncidentError',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Incident',
    p_metric_label_nlsid => 'adrAlertLogIncidentError',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'adrAlertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Time/Line Number',
        p_short_name_nlsid => 'adrAlertLog_timeLine',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericOperationalErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Generic Operational Error',
        p_column_label_nlsid => 'adrAlertLog_genericOperationalErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Operational Error',
        p_short_name_nlsid => 'adrAlertLog_genericOperationalErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archiveHungErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Archiver Hung',
        p_column_label_nlsid => 'adrAlertLog_archiveHungErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Archiver Hung',
        p_short_name_nlsid => 'adrAlertLog_archiveHungErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'blockCorruptErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Block Corruption',
        p_column_label_nlsid => 'adrAlertLog_blockCorruptErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Block Corruption',
        p_short_name_nlsid => 'adrAlertLog_blockCorruptErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Media Failure',
        p_column_label_nlsid => 'adrAlertLog_mediaFailureErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Media Failure',
        p_short_name_nlsid => 'adrAlertLog_mediaFailureErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'traceFileName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Error Trace File',
        p_column_label_nlsid => 'adrAlertLog_traceFileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Error Trace File',
        p_short_name_nlsid => 'adrAlertLog_traceFileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'adrAlertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Name',
        p_short_name_nlsid => 'adrAlertLog_fileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'adrAlertLogOperationalError',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Operational Error',
    p_metric_label_nlsid => 'adrAlertLogOperationalError',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'adrAlertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Time/Line Number',
        p_short_name_nlsid => 'adrAlertLog_timeLine',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dataFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Failure Detected',
        p_column_label_nlsid => 'adrAlertLog_dataFailureErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Failure Detected',
        p_short_name_nlsid => 'adrAlertLog_dataFailureErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'adrAlertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Name',
        p_short_name_nlsid => 'adrAlertLog_fileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'adrAlertLogDataFailure',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Failure',
    p_metric_label_nlsid => 'adrAlertLogDataFailure',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericIncidentErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Generic Incident Status',
        p_column_label_nlsid => 'adrAlertLogStatus_genericIncidentErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Incident Status',
        p_short_name_nlsid => 'adrAlertLogStatus_genericIncidentErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericInternalErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Generic Internal Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_genericInternalErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Internal Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_genericInternalErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Terminated Status',
        p_column_label_nlsid => 'adrAlertLogStatus_sessTerminateErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Terminated Status',
        p_short_name_nlsid => 'adrAlertLogStatus_sessTerminateErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'internalSqlErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Internal SQL Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_internalSqlErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Internal SQL Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_internalSqlErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'accessViolationErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Access Violation Status',
        p_column_label_nlsid => 'adrAlertLogStatus_accessViolationErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Access Violation Status',
        p_short_name_nlsid => 'adrAlertLogStatus_accessViolationErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redoLogCorruptErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Log Corruption Status',
        p_column_label_nlsid => 'adrAlertLogStatus_redoLogCorruptErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Log Corruption Status',
        p_short_name_nlsid => 'adrAlertLogStatus_redoLogCorruptErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fileAccessErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'File Access Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_fileAccessErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'File Access Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_fileAccessErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inconsistentDbStateErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Inconsistent DB State Status',
        p_column_label_nlsid => 'adrAlertLogStatus_inconsistentDbStateErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Inconsistent DB State Status',
        p_short_name_nlsid => 'adrAlertLogStatus_inconsistentDbStateErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'oraBlockCorruptErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Oracle Data Block Corruption Status',
        p_column_label_nlsid => 'adrAlertLogStatus_oraBlockCorruptErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Oracle Data Block Corruption Status',
        p_short_name_nlsid => 'adrAlertLogStatus_oraBlockCorruptErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'deadlockErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Deadlock Status',
        p_column_label_nlsid => 'adrAlertLogStatus_deadlockErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Deadlock Status',
        p_short_name_nlsid => 'adrAlertLogStatus_deadlockErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outOfMemoryErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Out of Memory Status',
        p_column_label_nlsid => 'adrAlertLogStatus_outOfMemoryErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Out of Memory Status',
        p_short_name_nlsid => 'adrAlertLogStatus_outOfMemoryErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cluster Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_clusterErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cluster Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_clusterErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'adrAlertLogIncidentErrorStatus',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Incident Status',
    p_metric_label_nlsid => 'adrAlertLogIncidentErrorStatus',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericOperationalErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Generic Operational Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_genericOperationalErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Operational Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_genericOperationalErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archiveHungErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Archiver Hung Status',
        p_column_label_nlsid => 'adrAlertLogStatus_archiveHungErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Archiver Hung Status',
        p_short_name_nlsid => 'adrAlertLogStatus_archiveHungErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'blockCorruptErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Block Corruption Status',
        p_column_label_nlsid => 'adrAlertLogStatus_blockCorruptErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Block Corruption Status',
        p_short_name_nlsid => 'adrAlertLogStatus_blockCorruptErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Media Failure Status',
        p_column_label_nlsid => 'adrAlertLogStatus_mediaFailureErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Media Failure Status',
        p_short_name_nlsid => 'adrAlertLogStatus_mediaFailureErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'adrAlertLogOperationalErrorStatus',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Operational Error Status',
    p_metric_label_nlsid => 'adrAlertLogOperationalErrorStatus',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogContent',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Content',
        p_column_label_nlsid => 'alertLog_content',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'alertLogContent',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'Alert Log Content',
    p_metric_label_nlsid => 'alertLogContent',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logContent',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'logContent',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'adrAlertLogContent',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'adrAlertLogContent',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sid',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Blocking Session ID',
        p_column_label_nlsid => 'userBlock_blocking_sid',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Blocking Session Count',
        p_column_label_nlsid => 'userBlock_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'UserBlock',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'User Block',
    p_metric_label_nlsid => 'userBlock',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'username',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Audited User',
        p_column_label_nlsid => 'userAudit_username',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'machine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Audited User Host',
        p_column_label_nlsid => 'userAudit_machine',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Session Count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Audited User Session Count',
        p_column_label_nlsid => 'userAudit_session_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Username_machine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Username_Machine',
        p_column_label_nlsid => 'userAudit_username_machine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'UserAudit',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'User Audit',
    p_metric_label_nlsid => 'user_audit',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'snap_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Available',
        p_column_label_nlsid => 'mgmt_sql_metric_helper_data_available',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_2_choices => MGMT_CATEGORY_PROP_ARRAY('1','3'),
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'mgmt_sql_metric_helper',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_sql_metric_helper',
    p_metric_label_nlsid => 'mgmt_sql_metric_helper',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'snap_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Snap ID',
        p_column_label_nlsid => 'mgmt_sql_summary_snap_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'collection_timestamp',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Collection Timestamp',
        p_column_label_nlsid => 'mgmt_sql_summary_collection_timestamp',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sql',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'SQL Statement',
        p_column_label_nlsid => 'mgmt_sql_summary_sql',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'piece',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Piece',
        p_column_label_nlsid => 'mgmt_sql_summary_piece',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sharableMem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sharable Memory',
        p_column_label_nlsid => 'mgmt_sql_summary_sharableMem',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sorts',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts',
        p_column_label_nlsid => 'mgmt_sql_summary_sorts',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'modName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Module',
        p_column_label_nlsid => 'mgmt_sql_summary_mod',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'loadedVers',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Loaded Versions',
        p_column_label_nlsid => 'mgmt_sql_summary_loadedVers',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'executions',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Executions',
        p_column_label_nlsid => 'mgmt_sql_summary_executions',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'loads',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Loads',
        p_column_label_nlsid => 'mgmt_sql_summary_loads',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'invalidations',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Invalidations',
        p_column_label_nlsid => 'mgmt_sql_summary_invalidations',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parseCalls',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parse Calls',
        p_column_label_nlsid => 'mgmt_sql_summary_parseCalls',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskReads',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Reads',
        p_column_label_nlsid => 'mgmt_sql_summary_diskReads',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bufferGets',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffer Gets',
        p_column_label_nlsid => 'mgmt_sql_summary_bufferGets',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rowsProc',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Rows Processed',
        p_column_label_nlsid => 'mgmt_sql_summary_rowsProc',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cmdType',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Command Type',
        p_column_label_nlsid => 'mgmt_sql_summary_cmdType',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'address',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Address',
        p_column_label_nlsid => 'mgmt_sql_summary_address',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hashValue',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hash Value',
        p_column_label_nlsid => 'mgmt_sql_summary_hashValue',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'versionCount',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sql Version Count',
        p_column_label_nlsid => 'mgmt_sql_summary_versionCount',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuTime',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Time',
        p_column_label_nlsid => 'mgmt_sql_summary_cpuTime',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'elapsedTime',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Elapsed Time',
        p_column_label_nlsid => 'mgmt_sql_summary_elapsedTime',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outlineSid',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Outline SID',
        p_column_label_nlsid => 'mgmt_sql_summary_outlineSid',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outlineCat',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Outline Category',
        p_column_label_nlsid => 'mgmt_sql_summary_outlineCat',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'planId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Plan Hash Value',
        p_column_label_nlsid => 'mgmt_sql_summary_planId',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'optimizerMode',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Optimizer Mode',
        p_column_label_nlsid => 'mgmt_sql_summary_optimizerMode',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'optimizerCost',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Optimizer Cost ',
        p_column_label_nlsid => 'mgmt_sql_summary_optimizerCost',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_2_choices => MGMT_CATEGORY_PROP_ARRAY('1','3'),
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'mgmt_sql_summary',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_sql_summary',
    p_metric_label_nlsid => 'mgmt_sql_summary',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'snap_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Snap ID',
        p_column_label_nlsid => 'mgmt_sql_plan_snap_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'collection_timestamp',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Collection Timestamp',
        p_column_label_nlsid => 'mgmt_sql_plan_collection_timestamp',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'planId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Plan Hash Value',
        p_column_label_nlsid => 'mgmt_sql_plan_planId',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpOperation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Operation',
        p_column_label_nlsid => 'mgmt_sql_plan_xpOperation',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpOptions',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Options',
        p_column_label_nlsid => 'mgmt_sql_plan_xpOptions',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpObjectNode',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Object Node',
        p_column_label_nlsid => 'mgmt_sql_plan_xpObjectNode',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpObjectOwner',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Object Owner',
        p_column_label_nlsid => 'mgmt_sql_plan_xpObjectOwner',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpObjectName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Object Name',
        p_column_label_nlsid => 'mgmt_sql_plan_xpObjectName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpOptimizer',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Optimizer Mode',
        p_column_label_nlsid => 'mgmt_sql_plan_xpOptimizer',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Id',
        p_column_label_nlsid => 'mgmt_sql_plan_xpId',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpParentId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Parent Id',
        p_column_label_nlsid => 'mgmt_sql_plan_xpParentId',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpPosition',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Position',
        p_column_label_nlsid => 'mgmt_sql_plan_xpPosition',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpCost',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Cost',
        p_column_label_nlsid => 'mgmt_sql_plan_xpCost',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpCardinality',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Cardinality',
        p_column_label_nlsid => 'mgmt_sql_plan_xpCardinality',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpBytes',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Bytes',
        p_column_label_nlsid => 'mgmt_sql_plan_xpBytes',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpOtherTag',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Other Tag',
        p_column_label_nlsid => 'mgmt_sql_plan_xpOtherTag',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpPartitionStart',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Partition Start',
        p_column_label_nlsid => 'mgmt_sql_plan_xpPartitionStart',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpPartitionStop',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Partition Stop',
        p_column_label_nlsid => 'mgmt_sql_plan_xpPartitionStop',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpPartitionId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Partition Id',
        p_column_label_nlsid => 'mgmt_sql_plan_xpPartitionId',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpOther',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Other',
        p_column_label_nlsid => 'mgmt_sql_plan_xpOther',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpDistribution',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Explain Plan Distribution',
        p_column_label_nlsid => 'mgmt_sql_plan_xpDistribution',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpCPUCost',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan CPU Cost',
        p_column_label_nlsid => 'mgmt_sql_plan_xpCPUCost',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpIOCost',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan I-O Cost',
        p_column_label_nlsid => 'mgmt_sql_plan_xpIOCost',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpTempSpace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Temporary Space',
        p_column_label_nlsid => 'mgmt_sql_plan_xpTempSpace',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpObject#',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Object #',
        p_column_label_nlsid => 'mgmt_sql_plan_xpObject_num',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'xpDepth',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Explain Plan Depth',
        p_column_label_nlsid => 'mgmt_sql_plan_xpDepth',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'address',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Address',
        p_column_label_nlsid => 'mgmt_sql_plan_address',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hashValue',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hash Value',
        p_column_label_nlsid => 'mgmt_sql_plan_hashValue',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_2_choices => MGMT_CATEGORY_PROP_ARRAY('1','3'),
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'mgmt_sql_plan',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_sql_plan',
    p_metric_label_nlsid => 'mgmt_sql_plan',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Suspended Session Count',
        p_column_label_nlsid => 'suspended_session_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Suspended Session Count',
        p_short_name_nlsid => 'suspended_session_count',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('9i','9iR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'suspended_session',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Suspended Session',
    p_metric_label_nlsid => 'suspended_session',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'event',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Wait Event',
        p_column_label_nlsid => 'wait_sess_event',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Waiting for Event Count',
        p_column_label_nlsid => 'wait_sess_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'wait_sess',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Wait by Session Count',
    p_metric_label_nlsid => 'wait_sess',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'total_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Waiting Session Count',
        p_column_label_nlsid => 'sessions_in_wait_total_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Waiting Sessions',
        p_short_name_nlsid => 'sessions_in_wait_total_count_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sessions_in_wait',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'System Sessions Waiting',
    p_metric_label_nlsid => 'sessions_in_wait',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'lost',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Blocks Lost',
        p_column_label_nlsid => 'global_cache_blocks_lost',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Global Cache Blocks Lost',
        p_short_name_nlsid => 'global_cache_blocks_lost',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'corrupt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Blocks Corrupt',
        p_column_label_nlsid => 'global_cache_blocks_corrupt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Global Cache Blocks Corrupt',
        p_short_name_nlsid => 'global_cache_blocks_corrupt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'converts_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Average Convert Time (centi-seconds)',
        p_column_label_nlsid => 'global_cache_converts_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'GC Average Convert Time (cs)',
        p_short_name_nlsid => 'global_cache_converts_cs_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cr_request_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Average CR Block Request Time (centi-seconds)',
        p_column_label_nlsid => 'global_cache_cr_request_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'GC Average CR Block Get Time (cs)',
        p_short_name_nlsid => 'global_cache_cr_request_cs_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'currentgets_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Average Current Block Request Time (centi-seconds)',
        p_column_label_nlsid => 'global_cache_current_request_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'GC Average Current Block Get Time (cs)',
        p_short_name_nlsid => 'global_cache_current_request_cs_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'gets_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Average Get Time (centi-seconds)',
        p_column_label_nlsid => 'global_cache_gets_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'GC Average Get Time (cs)',
        p_short_name_nlsid => 'global_cache_gets_cs_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('9i','9iR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('RACINST')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'rac_global_cache',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Global Cache Statistics',
    p_metric_label_nlsid => 'global_cache',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'corrupt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Blocks Corrupt',
        p_column_label_nlsid => 'global_cache_blocks_corrupt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Global Cache Blocks Corrupt',
        p_short_name_nlsid => 'global_cache_blocks_corrupt',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'lost',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Blocks Lost',
        p_column_label_nlsid => 'global_cache_blocks_lost',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Global Cache Blocks Lost',
        p_short_name_nlsid => 'global_cache_blocks_lost',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cr_request_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Average CR Block Request Time (centi-seconds)',
        p_column_label_nlsid => 'global_cache_cr_request_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'GC Average CR Block Get Time (cs)',
        p_short_name_nlsid => 'global_cache_cr_request_cs_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'currentgets_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Global Cache Average Current Block Request Time (centi-seconds)',
        p_column_label_nlsid => 'global_cache_current_request_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'GC Average Current Block Get Time (cs)',
        p_short_name_nlsid => 'global_cache_current_request_cs_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('RACINST')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'rac_global_cache',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Global Cache Statistics',
    p_metric_label_nlsid => 'global_cache',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'transactions_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number of Transactions (per second)',
        p_column_label_nlsid => 'instance_throughput_transactions_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Transactions/s',
        p_short_name_nlsid => 'instance_throughput_transactions_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per second)',
        p_column_label_nlsid => 'instance_throughput_physreads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads/s',
        p_short_name_nlsid => 'instance_throughput_physreads_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreads_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreads_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physreads_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwrites_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per second)',
        p_column_label_nlsid => 'instance_throughput_physwrites_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Phys Writes/sec',
        p_short_name_nlsid => 'instance_throughput_physwrites_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwrites_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwrites_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physwrites_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadsdir_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct (per second)',
        p_column_label_nlsid => 'instance_throughput_physreadsdir_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct (per second)',
        p_short_name_nlsid => 'instance_throughput_physreadsdir_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadsdir_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreadsdir_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physreadsdir_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwritesdir_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct (per second)',
        p_column_label_nlsid => 'instance_throughput_physwritesdir_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct (per second)',
        p_short_name_nlsid => 'instance_throughput_physwritesdir_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwritesdir_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwritesdir_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physwritesdir_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadslob_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct Lobs (per second)',
        p_column_label_nlsid => 'instance_throughput_physreadslob_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct Lobs (per second)',
        p_short_name_nlsid => 'instance_throughput_physreadslob_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadslob_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct Lobs (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreadslob_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct Lobs (per txn)',
        p_short_name_nlsid => 'instance_throughput_physreadslob_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwriteslob_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct Lobs (per second)',
        p_column_label_nlsid => 'instance_throughput_physwriteslob_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct Lobs (per second)',
        p_short_name_nlsid => 'instance_throughput_physwriteslob_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwriteslob_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct Lobs (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwriteslob_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct Lobs (per txn)',
        p_short_name_nlsid => 'instance_throughput_physwriteslob_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redosize_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generated (per second)',
        p_column_label_nlsid => 'instance_throughput_redosize_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Size/sec',
        p_short_name_nlsid => 'instance_throughput_redosize_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cumulative Logons (per second)',
        p_column_label_nlsid => 'instance_throughput_logons_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logons/sec',
        p_short_name_nlsid => 'instance_throughput_logons_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cumulative Logons (per transaction)',
        p_column_label_nlsid => 'instance_throughput_logons_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cumulative Logons (per transaction)',
        p_short_name_nlsid => 'instance_throughput_logons_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'opncurs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Open Cursors (per second)',
        p_column_label_nlsid => 'instance_throughput_opncurs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Open Cursors (per second)',
        p_short_name_nlsid => 'instance_throughput_opncurs_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'opncurs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Open Cursors (per transaction)',
        p_column_label_nlsid => 'instance_throughput_opncurs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Open Cursors (per transaction)',
        p_short_name_nlsid => 'instance_throughput_opncurs_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Commits (per second)',
        p_column_label_nlsid => 'instance_throughput_commits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Commits (per second)',
        p_short_name_nlsid => 'instance_throughput_commits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Commits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_commits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Commits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_commits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollbacks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollbacks (per second)',
        p_column_label_nlsid => 'instance_throughput_rollbacks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Rollbacks (per second)',
        p_short_name_nlsid => 'instance_throughput_rollbacks_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollbacks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollbacks (per transaction)',
        p_column_label_nlsid => 'instance_throughput_rollbacks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Rollbacks (per transaction)',
        p_short_name_nlsid => 'instance_throughput_rollbacks_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercalls_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (per second)',
        p_column_label_nlsid => 'instance_throughput_usercalls_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (per second)',
        p_short_name_nlsid => 'instance_throughput_usercalls_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercalls_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (per transaction)',
        p_column_label_nlsid => 'instance_throughput_usercalls_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (per transaction)',
        p_short_name_nlsid => 'instance_throughput_usercalls_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recurscalls_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recursive Calls (per second)',
        p_column_label_nlsid => 'instance_throughput_recurscalls_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recursive Calls (per second)',
        p_short_name_nlsid => 'instance_throughput_recurscalls_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recurscalls_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recursive Calls (per transaction)',
        p_column_label_nlsid => 'instance_throughput_recurscalls_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recursive Calls (per transaction)',
        p_short_name_nlsid => 'instance_throughput_recurscalls_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logreads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Logical Reads (per second)',
        p_column_label_nlsid => 'instance_throughput_logreads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logical Reads/s',
        p_short_name_nlsid => 'instance_throughput_logreads_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logreads_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Logical Reads (per transaction)',
        p_column_label_nlsid => 'instance_throughput_logreads_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Logical Reads (per transaction)',
        p_short_name_nlsid => 'instance_throughput_logreads_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbwrcheckpoints_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DBWR Checkpoints (per second)',
        p_column_label_nlsid => 'instance_throughput_dbwrcheckpoints_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'DBWR Checkpoints (per second)',
        p_short_name_nlsid => 'instance_throughput_dbwrcheckpoints_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bgcheckpoints_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'BG Checkpoints (per second)',
        p_column_label_nlsid => 'instance_throughput_bgcheckpoints_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'BG Checkpoints (per second)',
        p_short_name_nlsid => 'instance_throughput_bgcheckpoints_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redowrites_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Writes (per second)',
        p_column_label_nlsid => 'instance_throughput_redowrites_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Writes (per second)',
        p_short_name_nlsid => 'instance_throughput_redowrites_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redowrites_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Writes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_redowrites_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Writes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_redowrites_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanslong_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Scans on Long Tables (per second)',
        p_column_label_nlsid => 'instance_throughput_tabscanslong_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Scans on Long Tables (per second)',
        p_short_name_nlsid => 'instance_throughput_tabscanslong_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanslong_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Scans on Long Tables (per transaction)',
        p_column_label_nlsid => 'instance_throughput_tabscanslong_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Scans on Long Tables (per transaction)',
        p_short_name_nlsid => 'instance_throughput_tabscanslong_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanstotal_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Table Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_tabscanstotal_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Table Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_tabscanstotal_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanstotal_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Table Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_tabscanstotal_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Table Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_tabscanstotal_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscansfull_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Full Index Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_indxscansfull_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Full Index Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_indxscansfull_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscansfull_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Full Index Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_indxscansfull_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Full Index Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_indxscansfull_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscanstotal_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Index Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_indxscanstotal_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Index Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_indxscanstotal_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscanstotal_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Index Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_indxscanstotal_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Index Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_indxscanstotal_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Parses (per second)',
        p_column_label_nlsid => 'instance_throughput_parses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Parses (per second)',
        p_short_name_nlsid => 'instance_throughput_parses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Parses (per transaction)',
        p_column_label_nlsid => 'instance_throughput_parses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Parses (per transaction)',
        p_short_name_nlsid => 'instance_throughput_parses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hardparses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hard Parses (per second)',
        p_column_label_nlsid => 'instance_throughput_hardparses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Hard Parses (per second)',
        p_short_name_nlsid => 'instance_throughput_hardparses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hardparses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hard Parses (per transaction)',
        p_column_label_nlsid => 'instance_throughput_hardparses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Hard Parses (per transaction)',
        p_short_name_nlsid => 'instance_throughput_hardparses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failedparses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parse Failure Count (per second)',
        p_column_label_nlsid => 'instance_throughput_failedparses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Parse Failure Count (per second)',
        p_short_name_nlsid => 'instance_throughput_failedparses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failedparses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parse Failure Count (per transaction)',
        p_column_label_nlsid => 'instance_throughput_failedparses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Parse Failure Count (per transaction)',
        p_short_name_nlsid => 'instance_throughput_failedparses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sortsdisk_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts to Disk (per second)',
        p_column_label_nlsid => 'instance_throughput_sortsdisk_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts to Disk (per second)',
        p_short_name_nlsid => 'instance_throughput_sortsdisk_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sortsdisk_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts to Disk (per transaction)',
        p_column_label_nlsid => 'instance_throughput_sortsdisk_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts to Disk (per transaction)',
        p_short_name_nlsid => 'instance_throughput_sortsdisk_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rows_psort',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Rows Processed (per sort)',
        p_column_label_nlsid => 'instance_throughput_rows_psort',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rows Processed (per sort)',
        p_short_name_nlsid => 'instance_throughput_rows_psort',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'executeswoparse_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Executes Performed without Parses (%)',
        p_column_label_nlsid => 'instance_throughput_executeswoparse_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Executes Performed without Parses (%)',
        p_short_name_nlsid => 'instance_throughput_executeswoparse_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'softparse_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Soft Parse (%)',
        p_column_label_nlsid => 'instance_throughput_softparse_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Soft Parse (%)',
        p_short_name_nlsid => 'instance_throughput_softparse_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercall_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (%)',
        p_column_label_nlsid => 'instance_throughput_usercall_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (%)',
        p_short_name_nlsid => 'instance_throughput_usercall_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'networkbytes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Bytes (per second)',
        p_column_label_nlsid => 'instance_throughput_networkbytes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Network Bytes (per second)',
        p_short_name_nlsid => 'instance_throughput_networkbytes_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqtimeouts_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Timeout (per second)',
        p_column_label_nlsid => 'instance_throughput_enqtimeouts_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Timeout (per second)',
        p_short_name_nlsid => 'instance_throughput_enqtimeouts_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqtimeouts_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Timeout (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqtimeouts_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Timeout (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqtimeouts_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqwaits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Waits (per second)',
        p_column_label_nlsid => 'instance_throughput_enqwaits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Waits (per second)',
        p_short_name_nlsid => 'instance_throughput_enqwaits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqwaits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Waits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqwaits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Waits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqwaits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqdeadlocks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Deadlocks (per second)',
        p_column_label_nlsid => 'instance_throughput_enqdeadlocks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Deadlocks (per second)',
        p_short_name_nlsid => 'instance_throughput_enqdeadlocks_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqdeadlocks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Deadlocks (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqdeadlocks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Deadlocks (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqdeadlocks_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqreqs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Requests (per second)',
        p_column_label_nlsid => 'instance_throughput_enqreqs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Requests (per second)',
        p_short_name_nlsid => 'instance_throughput_enqreqs_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqreqs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Requests (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqreqs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Requests (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqreqs_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkgets_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Gets (per second)',
        p_column_label_nlsid => 'instance_throughput_dbblkgets_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Gets (per second)',
        p_short_name_nlsid => 'instance_throughput_dbblkgets_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkgets_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Gets (per transaction)',
        p_column_label_nlsid => 'instance_throughput_dbblkgets_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Gets (per transaction)',
        p_short_name_nlsid => 'instance_throughput_dbblkgets_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadgets_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Gets (per second)',
        p_column_label_nlsid => 'instance_throughput_consistentreadgets_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Gets (per second)',
        p_short_name_nlsid => 'instance_throughput_consistentreadgets_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadgets_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Gets (per transaction)',
        p_column_label_nlsid => 'instance_throughput_consistentreadgets_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Gets (per transaction)',
        p_short_name_nlsid => 'instance_throughput_consistentreadgets_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkchanges_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Changes (per second)',
        p_column_label_nlsid => 'instance_throughput_dbblkchanges_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Changes (per second)',
        p_short_name_nlsid => 'instance_throughput_dbblkchanges_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkchanges_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Changes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_dbblkchanges_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Changes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_dbblkchanges_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadchanges_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Changes (per second)',
        p_column_label_nlsid => 'instance_throughput_consistentreadchanges_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Changes (per second)',
        p_short_name_nlsid => 'instance_throughput_consistentreadchanges_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadchanges_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Changes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_consistentreadchanges_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Changes (per txn)',
        p_short_name_nlsid => 'instance_throughput_consistentreadchanges_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crblks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Blocks Created (per second)',
        p_column_label_nlsid => 'instance_throughput_crblks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Blocks Created (per sec)',
        p_short_name_nlsid => 'instance_throughput_crblks_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crblks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Blocks Created (per transaction)',
        p_column_label_nlsid => 'instance_throughput_crblks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Blocks Created (per txn)',
        p_short_name_nlsid => 'instance_throughput_crblks_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crundorecs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Undo Records Applied (per transaction)',
        p_column_label_nlsid => 'instance_throughput_crundorecs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Undo Applied (per txn)',
        p_short_name_nlsid => 'instance_throughput_crundorecs_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userrollbackundorec_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollback Undo Records Applied (per second)',
        p_column_label_nlsid => 'instance_throughput_userrollbackundorec_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rollback Undo Applied (per sec)',
        p_short_name_nlsid => 'instance_throughput_userrollbackundorec_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userrollbackundorec_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollback Undo Records Applied (per transaction)',
        p_column_label_nlsid => 'instance_throughput_userrollbackundorec_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rollback Undo Applied (per txn)',
        p_short_name_nlsid => 'instance_throughput_userrollbackundorec_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'leafnodesplits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Leaf Node Splits (per second)',
        p_column_label_nlsid => 'instance_throughput_leafnodesplits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Leaf Node Splits (per second)',
        p_short_name_nlsid => 'instance_throughput_leafnodesplits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'leafnodesplits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Leaf Node Splits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_leafnodesplits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Leaf Node Splits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_leafnodesplits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'branchnodesplits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Branch Node Splits (per second)',
        p_column_label_nlsid => 'instance_throughput_branchnodesplits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Branch Node Splits (per second)',
        p_short_name_nlsid => 'instance_throughput_branchnodesplits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'branchnodesplits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Branch Node Splits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_branchnodesplits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Branch Node Splits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_branchnodesplits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redosize_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generated (per transaction)',
        p_column_label_nlsid => 'instance_throughput_redosize_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Generated (per transaction)',
        p_short_name_nlsid => 'instance_throughput_redosize_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crundorecs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Undo Records Applied (per second)',
        p_column_label_nlsid => 'instance_throughput_crundorecs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Undo Applied (per sec)',
        p_short_name_nlsid => 'instance_throughput_crundorecs_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'instance_throughput',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Throughput',
    p_metric_label_nlsid => 'instance_throughput',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'transactions_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number of Transactions (per second)',
        p_column_label_nlsid => 'instance_throughput_transactions_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Transactions/s',
        p_short_name_nlsid => 'instance_throughput_transactions_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per second)',
        p_column_label_nlsid => 'instance_throughput_physreads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads/s',
        p_short_name_nlsid => 'instance_throughput_physreads_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreads_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreads_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physreads_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwrites_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per second)',
        p_column_label_nlsid => 'instance_throughput_physwrites_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Phys Writes/sec',
        p_short_name_nlsid => 'instance_throughput_physwrites_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwrites_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwrites_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physwrites_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadsdir_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct (per second)',
        p_column_label_nlsid => 'instance_throughput_physreadsdir_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct (per second)',
        p_short_name_nlsid => 'instance_throughput_physreadsdir_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadsdir_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreadsdir_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physreadsdir_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwritesdir_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct (per second)',
        p_column_label_nlsid => 'instance_throughput_physwritesdir_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct (per second)',
        p_short_name_nlsid => 'instance_throughput_physwritesdir_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwritesdir_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwritesdir_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physwritesdir_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadslob_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct Lobs (per second)',
        p_column_label_nlsid => 'instance_throughput_physreadslob_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct Lobs (per second)',
        p_short_name_nlsid => 'instance_throughput_physreadslob_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadslob_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct Lobs (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreadslob_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct Lobs (per txn)',
        p_short_name_nlsid => 'instance_throughput_physreadslob_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwriteslob_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct Lobs (per second)',
        p_column_label_nlsid => 'instance_throughput_physwriteslob_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct Lobs (per second)',
        p_short_name_nlsid => 'instance_throughput_physwriteslob_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwriteslob_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct Lobs (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwriteslob_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct Lobs (per txn)',
        p_short_name_nlsid => 'instance_throughput_physwriteslob_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redosize_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generated (per second)',
        p_column_label_nlsid => 'instance_throughput_redosize_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Size/sec',
        p_short_name_nlsid => 'instance_throughput_redosize_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cumulative Logons (per second)',
        p_column_label_nlsid => 'instance_throughput_logons_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logons/sec',
        p_short_name_nlsid => 'instance_throughput_logons_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cumulative Logons (per transaction)',
        p_column_label_nlsid => 'instance_throughput_logons_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cumulative Logons (per transaction)',
        p_short_name_nlsid => 'instance_throughput_logons_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'opncurs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Open Cursors (per second)',
        p_column_label_nlsid => 'instance_throughput_opncurs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Open Cursors (per second)',
        p_short_name_nlsid => 'instance_throughput_opncurs_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'opncurs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Open Cursors (per transaction)',
        p_column_label_nlsid => 'instance_throughput_opncurs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Open Cursors (per transaction)',
        p_short_name_nlsid => 'instance_throughput_opncurs_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Commits (per second)',
        p_column_label_nlsid => 'instance_throughput_commits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Commits (per second)',
        p_short_name_nlsid => 'instance_throughput_commits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Commits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_commits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Commits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_commits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollbacks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollbacks (per second)',
        p_column_label_nlsid => 'instance_throughput_rollbacks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Rollbacks (per second)',
        p_short_name_nlsid => 'instance_throughput_rollbacks_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollbacks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollbacks (per transaction)',
        p_column_label_nlsid => 'instance_throughput_rollbacks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Rollbacks (per transaction)',
        p_short_name_nlsid => 'instance_throughput_rollbacks_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercalls_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (per second)',
        p_column_label_nlsid => 'instance_throughput_usercalls_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (per second)',
        p_short_name_nlsid => 'instance_throughput_usercalls_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercalls_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (per transaction)',
        p_column_label_nlsid => 'instance_throughput_usercalls_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (per transaction)',
        p_short_name_nlsid => 'instance_throughput_usercalls_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recurscalls_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recursive Calls (per second)',
        p_column_label_nlsid => 'instance_throughput_recurscalls_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recursive Calls (per second)',
        p_short_name_nlsid => 'instance_throughput_recurscalls_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recurscalls_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recursive Calls (per transaction)',
        p_column_label_nlsid => 'instance_throughput_recurscalls_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recursive Calls (per transaction)',
        p_short_name_nlsid => 'instance_throughput_recurscalls_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logreads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Logical Reads (per second)',
        p_column_label_nlsid => 'instance_throughput_logreads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logical Reads/s',
        p_short_name_nlsid => 'instance_throughput_logreads_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logreads_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Logical Reads (per transaction)',
        p_column_label_nlsid => 'instance_throughput_logreads_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Logical Reads (per transaction)',
        p_short_name_nlsid => 'instance_throughput_logreads_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbwrcheckpoints_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DBWR Checkpoints (per second)',
        p_column_label_nlsid => 'instance_throughput_dbwrcheckpoints_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'DBWR Checkpoints (per second)',
        p_short_name_nlsid => 'instance_throughput_dbwrcheckpoints_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bgcheckpoints_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'BG Checkpoints (per second)',
        p_column_label_nlsid => 'instance_throughput_bgcheckpoints_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'BG Checkpoints (per second)',
        p_short_name_nlsid => 'instance_throughput_bgcheckpoints_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redowrites_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Writes (per second)',
        p_column_label_nlsid => 'instance_throughput_redowrites_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Writes (per second)',
        p_short_name_nlsid => 'instance_throughput_redowrites_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redowrites_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Writes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_redowrites_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Writes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_redowrites_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanslong_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Scans on Long Tables (per second)',
        p_column_label_nlsid => 'instance_throughput_tabscanslong_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Scans on Long Tables (per second)',
        p_short_name_nlsid => 'instance_throughput_tabscanslong_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanslong_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Scans on Long Tables (per transaction)',
        p_column_label_nlsid => 'instance_throughput_tabscanslong_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Scans on Long Tables (per transaction)',
        p_short_name_nlsid => 'instance_throughput_tabscanslong_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanstotal_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Table Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_tabscanstotal_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Table Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_tabscanstotal_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanstotal_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Table Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_tabscanstotal_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Table Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_tabscanstotal_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscansfull_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Full Index Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_indxscansfull_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Full Index Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_indxscansfull_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscansfull_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Full Index Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_indxscansfull_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Full Index Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_indxscansfull_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscanstotal_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Index Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_indxscanstotal_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Index Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_indxscanstotal_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscanstotal_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Index Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_indxscanstotal_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Index Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_indxscanstotal_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Parses (per second)',
        p_column_label_nlsid => 'instance_throughput_parses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Parses (per second)',
        p_short_name_nlsid => 'instance_throughput_parses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Parses (per transaction)',
        p_column_label_nlsid => 'instance_throughput_parses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Parses (per transaction)',
        p_short_name_nlsid => 'instance_throughput_parses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hardparses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hard Parses (per second)',
        p_column_label_nlsid => 'instance_throughput_hardparses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Hard Parses (per second)',
        p_short_name_nlsid => 'instance_throughput_hardparses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hardparses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hard Parses (per transaction)',
        p_column_label_nlsid => 'instance_throughput_hardparses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Hard Parses (per transaction)',
        p_short_name_nlsid => 'instance_throughput_hardparses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failedparses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parse Failure Count (per second)',
        p_column_label_nlsid => 'instance_throughput_failedparses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Parse Failure Count (per second)',
        p_short_name_nlsid => 'instance_throughput_failedparses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failedparses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parse Failure Count (per transaction)',
        p_column_label_nlsid => 'instance_throughput_failedparses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Parse Failure Count (per transaction)',
        p_short_name_nlsid => 'instance_throughput_failedparses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'executions_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Executes (per second)',
        p_column_label_nlsid => 'instance_throughput_executions_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL Executions/s',
        p_short_name_nlsid => 'instance_throughput_executions_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sortsdisk_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts to Disk (per second)',
        p_column_label_nlsid => 'instance_throughput_sortsdisk_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts to Disk (per second)',
        p_short_name_nlsid => 'instance_throughput_sortsdisk_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sortsdisk_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts to Disk (per transaction)',
        p_column_label_nlsid => 'instance_throughput_sortsdisk_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts to Disk (per transaction)',
        p_short_name_nlsid => 'instance_throughput_sortsdisk_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rows_psort',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Rows Processed (per sort)',
        p_column_label_nlsid => 'instance_throughput_rows_psort',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rows Processed (per sort)',
        p_short_name_nlsid => 'instance_throughput_rows_psort',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'executeswoparse_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Executes Performed without Parses (%)',
        p_column_label_nlsid => 'instance_throughput_executeswoparse_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Executes Performed without Parses (%)',
        p_short_name_nlsid => 'instance_throughput_executeswoparse_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'softparse_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Soft Parse (%)',
        p_column_label_nlsid => 'instance_throughput_softparse_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Soft Parse (%)',
        p_short_name_nlsid => 'instance_throughput_softparse_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercall_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (%)',
        p_column_label_nlsid => 'instance_throughput_usercall_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (%)',
        p_short_name_nlsid => 'instance_throughput_usercall_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'networkbytes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Bytes (per second)',
        p_column_label_nlsid => 'instance_throughput_networkbytes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Network Bytes (per second)',
        p_short_name_nlsid => 'instance_throughput_networkbytes_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqtimeouts_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Timeout (per second)',
        p_column_label_nlsid => 'instance_throughput_enqtimeouts_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Timeout (per second)',
        p_short_name_nlsid => 'instance_throughput_enqtimeouts_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqtimeouts_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Timeout (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqtimeouts_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Timeout (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqtimeouts_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqwaits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Waits (per second)',
        p_column_label_nlsid => 'instance_throughput_enqwaits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Waits (per second)',
        p_short_name_nlsid => 'instance_throughput_enqwaits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqwaits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Waits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqwaits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Waits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqwaits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqdeadlocks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Deadlocks (per second)',
        p_column_label_nlsid => 'instance_throughput_enqdeadlocks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Deadlocks (per second)',
        p_short_name_nlsid => 'instance_throughput_enqdeadlocks_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqdeadlocks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Deadlocks (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqdeadlocks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Deadlocks (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqdeadlocks_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqreqs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Requests (per second)',
        p_column_label_nlsid => 'instance_throughput_enqreqs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Requests (per second)',
        p_short_name_nlsid => 'instance_throughput_enqreqs_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqreqs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Requests (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqreqs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Requests (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqreqs_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkgets_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Gets (per second)',
        p_column_label_nlsid => 'instance_throughput_dbblkgets_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Gets (per second)',
        p_short_name_nlsid => 'instance_throughput_dbblkgets_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkgets_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Gets (per transaction)',
        p_column_label_nlsid => 'instance_throughput_dbblkgets_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Gets (per transaction)',
        p_short_name_nlsid => 'instance_throughput_dbblkgets_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadgets_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Gets (per second)',
        p_column_label_nlsid => 'instance_throughput_consistentreadgets_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Gets (per second)',
        p_short_name_nlsid => 'instance_throughput_consistentreadgets_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadgets_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Gets (per transaction)',
        p_column_label_nlsid => 'instance_throughput_consistentreadgets_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Gets (per transaction)',
        p_short_name_nlsid => 'instance_throughput_consistentreadgets_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkchanges_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Changes (per second)',
        p_column_label_nlsid => 'instance_throughput_dbblkchanges_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Changes (per second)',
        p_short_name_nlsid => 'instance_throughput_dbblkchanges_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkchanges_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Changes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_dbblkchanges_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Changes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_dbblkchanges_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadchanges_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Changes (per second)',
        p_column_label_nlsid => 'instance_throughput_consistentreadchanges_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Changes (per second)',
        p_short_name_nlsid => 'instance_throughput_consistentreadchanges_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadchanges_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Changes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_consistentreadchanges_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Changes (per txn)',
        p_short_name_nlsid => 'instance_throughput_consistentreadchanges_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crblks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Blocks Created (per second)',
        p_column_label_nlsid => 'instance_throughput_crblks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Blocks Created (per sec)',
        p_short_name_nlsid => 'instance_throughput_crblks_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crblks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Blocks Created (per transaction)',
        p_column_label_nlsid => 'instance_throughput_crblks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Blocks Created (per txn)',
        p_short_name_nlsid => 'instance_throughput_crblks_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crundorecs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Undo Records Applied (per transaction)',
        p_column_label_nlsid => 'instance_throughput_crundorecs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Undo Applied (per txn)',
        p_short_name_nlsid => 'instance_throughput_crundorecs_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userrollbackundorec_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollback Undo Records Applied (per second)',
        p_column_label_nlsid => 'instance_throughput_userrollbackundorec_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rollback Undo Applied (per sec)',
        p_short_name_nlsid => 'instance_throughput_userrollbackundorec_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userrollbackundorec_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollback Undo Records Applied (per transaction)',
        p_column_label_nlsid => 'instance_throughput_userrollbackundorec_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rollback Undo Applied (per txn)',
        p_short_name_nlsid => 'instance_throughput_userrollbackundorec_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'leafnodesplits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Leaf Node Splits (per second)',
        p_column_label_nlsid => 'instance_throughput_leafnodesplits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Leaf Node Splits (per second)',
        p_short_name_nlsid => 'instance_throughput_leafnodesplits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'leafnodesplits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Leaf Node Splits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_leafnodesplits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Leaf Node Splits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_leafnodesplits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'branchnodesplits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Branch Node Splits (per second)',
        p_column_label_nlsid => 'instance_throughput_branchnodesplits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Branch Node Splits (per second)',
        p_short_name_nlsid => 'instance_throughput_branchnodesplits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'branchnodesplits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Branch Node Splits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_branchnodesplits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Branch Node Splits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_branchnodesplits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redosize_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generated (per transaction)',
        p_column_label_nlsid => 'instance_throughput_redosize_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Generated (per transaction)',
        p_short_name_nlsid => 'instance_throughput_redosize_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crundorecs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Undo Records Applied (per second)',
        p_column_label_nlsid => 'instance_throughput_crundorecs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Undo Applied (per sec)',
        p_short_name_nlsid => 'instance_throughput_crundorecs_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbtime_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Time (centiseconds per second)',
        p_column_label_nlsid => 'instance_throughput_dbtime_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Time (per second)',
        p_short_name_nlsid => 'instance_throughput_dbtime_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'instance_throughput',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Throughput',
    p_metric_label_nlsid => 'instance_throughput',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'transactions_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number of Transactions (per second)',
        p_column_label_nlsid => 'instance_throughput_transactions_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Transactions/s',
        p_short_name_nlsid => 'instance_throughput_transactions_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per second)',
        p_column_label_nlsid => 'instance_throughput_physreads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads/s',
        p_short_name_nlsid => 'instance_throughput_physreads_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreads_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreads_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physreads_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwrites_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per second)',
        p_column_label_nlsid => 'instance_throughput_physwrites_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Phys Writes/sec',
        p_short_name_nlsid => 'instance_throughput_physwrites_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwrites_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwrites_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physwrites_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadsdir_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct (per second)',
        p_column_label_nlsid => 'instance_throughput_physreadsdir_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct (per second)',
        p_short_name_nlsid => 'instance_throughput_physreadsdir_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadsdir_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreadsdir_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physreadsdir_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwritesdir_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct (per second)',
        p_column_label_nlsid => 'instance_throughput_physwritesdir_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct (per second)',
        p_short_name_nlsid => 'instance_throughput_physwritesdir_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwritesdir_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwritesdir_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct (per transaction)',
        p_short_name_nlsid => 'instance_throughput_physwritesdir_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadslob_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct Lobs (per second)',
        p_column_label_nlsid => 'instance_throughput_physreadslob_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct Lobs (per second)',
        p_short_name_nlsid => 'instance_throughput_physreadslob_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physreadslob_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads Direct Lobs (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physreadslob_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Reads Direct Lobs (per txn)',
        p_short_name_nlsid => 'instance_throughput_physreadslob_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwriteslob_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct Lobs (per second)',
        p_column_label_nlsid => 'instance_throughput_physwriteslob_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct Lobs (per second)',
        p_short_name_nlsid => 'instance_throughput_physwriteslob_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'physwriteslob_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes Direct Lobs (per transaction)',
        p_column_label_nlsid => 'instance_throughput_physwriteslob_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Physical Writes Direct Lobs (per txn)',
        p_short_name_nlsid => 'instance_throughput_physwriteslob_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redosize_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generated (per second)',
        p_column_label_nlsid => 'instance_throughput_redosize_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Size/sec',
        p_short_name_nlsid => 'instance_throughput_redosize_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cumulative Logons (per second)',
        p_column_label_nlsid => 'instance_throughput_logons_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logons/sec',
        p_short_name_nlsid => 'instance_throughput_logons_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cumulative Logons (per transaction)',
        p_column_label_nlsid => 'instance_throughput_logons_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cumulative Logons (per transaction)',
        p_short_name_nlsid => 'instance_throughput_logons_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'opncurs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Open Cursors (per second)',
        p_column_label_nlsid => 'instance_throughput_opncurs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Open Cursors (per second)',
        p_short_name_nlsid => 'instance_throughput_opncurs_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'opncurs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Open Cursors (per transaction)',
        p_column_label_nlsid => 'instance_throughput_opncurs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Open Cursors (per transaction)',
        p_short_name_nlsid => 'instance_throughput_opncurs_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Commits (per second)',
        p_column_label_nlsid => 'instance_throughput_commits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Commits (per second)',
        p_short_name_nlsid => 'instance_throughput_commits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Commits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_commits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Commits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_commits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollbacks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollbacks (per second)',
        p_column_label_nlsid => 'instance_throughput_rollbacks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Rollbacks (per second)',
        p_short_name_nlsid => 'instance_throughput_rollbacks_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollbacks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollbacks (per transaction)',
        p_column_label_nlsid => 'instance_throughput_rollbacks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Rollbacks (per transaction)',
        p_short_name_nlsid => 'instance_throughput_rollbacks_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercalls_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (per second)',
        p_column_label_nlsid => 'instance_throughput_usercalls_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (per second)',
        p_short_name_nlsid => 'instance_throughput_usercalls_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercalls_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (per transaction)',
        p_column_label_nlsid => 'instance_throughput_usercalls_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (per transaction)',
        p_short_name_nlsid => 'instance_throughput_usercalls_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recurscalls_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recursive Calls (per second)',
        p_column_label_nlsid => 'instance_throughput_recurscalls_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recursive Calls (per second)',
        p_short_name_nlsid => 'instance_throughput_recurscalls_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recurscalls_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recursive Calls (per transaction)',
        p_column_label_nlsid => 'instance_throughput_recurscalls_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recursive Calls (per transaction)',
        p_short_name_nlsid => 'instance_throughput_recurscalls_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logreads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Logical Reads (per second)',
        p_column_label_nlsid => 'instance_throughput_logreads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Logical Reads/s',
        p_short_name_nlsid => 'instance_throughput_logreads_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logreads_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Logical Reads (per transaction)',
        p_column_label_nlsid => 'instance_throughput_logreads_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Logical Reads (per transaction)',
        p_short_name_nlsid => 'instance_throughput_logreads_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbwrcheckpoints_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DBWR Checkpoints (per second)',
        p_column_label_nlsid => 'instance_throughput_dbwrcheckpoints_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'DBWR Checkpoints (per second)',
        p_short_name_nlsid => 'instance_throughput_dbwrcheckpoints_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bgcheckpoints_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'BG Checkpoints (per second)',
        p_column_label_nlsid => 'instance_throughput_bgcheckpoints_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'BG Checkpoints (per second)',
        p_short_name_nlsid => 'instance_throughput_bgcheckpoints_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redowrites_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Writes (per second)',
        p_column_label_nlsid => 'instance_throughput_redowrites_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Writes (per second)',
        p_short_name_nlsid => 'instance_throughput_redowrites_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redowrites_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Writes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_redowrites_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Writes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_redowrites_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanslong_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Scans on Long Tables (per second)',
        p_column_label_nlsid => 'instance_throughput_tabscanslong_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Scans on Long Tables (per second)',
        p_short_name_nlsid => 'instance_throughput_tabscanslong_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanslong_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Scans on Long Tables (per transaction)',
        p_column_label_nlsid => 'instance_throughput_tabscanslong_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Scans on Long Tables (per transaction)',
        p_short_name_nlsid => 'instance_throughput_tabscanslong_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanstotal_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Table Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_tabscanstotal_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Table Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_tabscanstotal_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tabscanstotal_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Table Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_tabscanstotal_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Table Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_tabscanstotal_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscansfull_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Full Index Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_indxscansfull_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Full Index Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_indxscansfull_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscansfull_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Full Index Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_indxscansfull_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Full Index Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_indxscansfull_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscanstotal_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Index Scans (per second)',
        p_column_label_nlsid => 'instance_throughput_indxscanstotal_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Index Scans (per second)',
        p_short_name_nlsid => 'instance_throughput_indxscanstotal_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'indxscanstotal_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Index Scans (per transaction)',
        p_column_label_nlsid => 'instance_throughput_indxscanstotal_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Index Scans (per transaction)',
        p_short_name_nlsid => 'instance_throughput_indxscanstotal_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Parses (per second)',
        p_column_label_nlsid => 'instance_throughput_parses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Parses (per second)',
        p_short_name_nlsid => 'instance_throughput_parses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Parses (per transaction)',
        p_column_label_nlsid => 'instance_throughput_parses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Parses (per transaction)',
        p_short_name_nlsid => 'instance_throughput_parses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hardparses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hard Parses (per second)',
        p_column_label_nlsid => 'instance_throughput_hardparses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Hard Parses (per second)',
        p_short_name_nlsid => 'instance_throughput_hardparses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hardparses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hard Parses (per transaction)',
        p_column_label_nlsid => 'instance_throughput_hardparses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Hard Parses (per transaction)',
        p_short_name_nlsid => 'instance_throughput_hardparses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failedparses_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parse Failure Count (per second)',
        p_column_label_nlsid => 'instance_throughput_failedparses_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Parse Failure Count (per second)',
        p_short_name_nlsid => 'instance_throughput_failedparses_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failedparses_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parse Failure Count (per transaction)',
        p_column_label_nlsid => 'instance_throughput_failedparses_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Parse Failure Count (per transaction)',
        p_short_name_nlsid => 'instance_throughput_failedparses_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'executions_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Executes (per second)',
        p_column_label_nlsid => 'instance_throughput_executions_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'SQL Executions/s',
        p_short_name_nlsid => 'instance_throughput_executions_ps_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sortsdisk_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts to Disk (per second)',
        p_column_label_nlsid => 'instance_throughput_sortsdisk_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts to Disk (per second)',
        p_short_name_nlsid => 'instance_throughput_sortsdisk_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sortsdisk_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts to Disk (per transaction)',
        p_column_label_nlsid => 'instance_throughput_sortsdisk_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts to Disk (per transaction)',
        p_short_name_nlsid => 'instance_throughput_sortsdisk_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rows_psort',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Rows Processed (per sort)',
        p_column_label_nlsid => 'instance_throughput_rows_psort',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rows Processed (per sort)',
        p_short_name_nlsid => 'instance_throughput_rows_psort',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'executeswoparse_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Executes Performed without Parses (%)',
        p_column_label_nlsid => 'instance_throughput_executeswoparse_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Executes Performed without Parses (%)',
        p_short_name_nlsid => 'instance_throughput_executeswoparse_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'softparse_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Soft Parse (%)',
        p_column_label_nlsid => 'instance_throughput_softparse_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Soft Parse (%)',
        p_short_name_nlsid => 'instance_throughput_softparse_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usercall_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Calls (%)',
        p_column_label_nlsid => 'instance_throughput_usercall_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Calls (%)',
        p_short_name_nlsid => 'instance_throughput_usercall_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'networkbytes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Bytes (per second)',
        p_column_label_nlsid => 'instance_throughput_networkbytes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Network Bytes (per second)',
        p_short_name_nlsid => 'instance_throughput_networkbytes_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqtimeouts_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Timeout (per second)',
        p_column_label_nlsid => 'instance_throughput_enqtimeouts_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Timeout (per second)',
        p_short_name_nlsid => 'instance_throughput_enqtimeouts_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqtimeouts_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Timeout (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqtimeouts_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Timeout (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqtimeouts_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqwaits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Waits (per second)',
        p_column_label_nlsid => 'instance_throughput_enqwaits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Waits (per second)',
        p_short_name_nlsid => 'instance_throughput_enqwaits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqwaits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Waits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqwaits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Waits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqwaits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqdeadlocks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Deadlocks (per second)',
        p_column_label_nlsid => 'instance_throughput_enqdeadlocks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Deadlocks (per second)',
        p_short_name_nlsid => 'instance_throughput_enqdeadlocks_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqdeadlocks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Deadlocks (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqdeadlocks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Deadlocks (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqdeadlocks_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqreqs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Requests (per second)',
        p_column_label_nlsid => 'instance_throughput_enqreqs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Requests (per second)',
        p_short_name_nlsid => 'instance_throughput_enqreqs_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'enqreqs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Enqueue Requests (per transaction)',
        p_column_label_nlsid => 'instance_throughput_enqreqs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Enqueue Requests (per transaction)',
        p_short_name_nlsid => 'instance_throughput_enqreqs_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkgets_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Gets (per second)',
        p_column_label_nlsid => 'instance_throughput_dbblkgets_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Gets (per second)',
        p_short_name_nlsid => 'instance_throughput_dbblkgets_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkgets_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Gets (per transaction)',
        p_column_label_nlsid => 'instance_throughput_dbblkgets_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Gets (per transaction)',
        p_short_name_nlsid => 'instance_throughput_dbblkgets_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadgets_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Gets (per second)',
        p_column_label_nlsid => 'instance_throughput_consistentreadgets_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Gets (per second)',
        p_short_name_nlsid => 'instance_throughput_consistentreadgets_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadgets_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Gets (per transaction)',
        p_column_label_nlsid => 'instance_throughput_consistentreadgets_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Gets (per transaction)',
        p_short_name_nlsid => 'instance_throughput_consistentreadgets_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkchanges_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Changes (per second)',
        p_column_label_nlsid => 'instance_throughput_dbblkchanges_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Changes (per second)',
        p_short_name_nlsid => 'instance_throughput_dbblkchanges_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbblkchanges_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Block Changes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_dbblkchanges_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Block Changes (per transaction)',
        p_short_name_nlsid => 'instance_throughput_dbblkchanges_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadchanges_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Changes (per second)',
        p_column_label_nlsid => 'instance_throughput_consistentreadchanges_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Consistent Read Changes (per second)',
        p_short_name_nlsid => 'instance_throughput_consistentreadchanges_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'consistentreadchanges_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Changes (per transaction)',
        p_column_label_nlsid => 'instance_throughput_consistentreadchanges_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Changes (per txn)',
        p_short_name_nlsid => 'instance_throughput_consistentreadchanges_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crblks_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Blocks Created (per second)',
        p_column_label_nlsid => 'instance_throughput_crblks_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Blocks Created (per sec)',
        p_short_name_nlsid => 'instance_throughput_crblks_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crblks_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Blocks Created (per transaction)',
        p_column_label_nlsid => 'instance_throughput_crblks_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Blocks Created (per txn)',
        p_short_name_nlsid => 'instance_throughput_crblks_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crundorecs_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Undo Records Applied (per transaction)',
        p_column_label_nlsid => 'instance_throughput_crundorecs_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Undo Applied (per txn)',
        p_short_name_nlsid => 'instance_throughput_crundorecs_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userrollbackundorec_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollback Undo Records Applied (per second)',
        p_column_label_nlsid => 'instance_throughput_userrollbackundorec_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rollback Undo Applied (per sec)',
        p_short_name_nlsid => 'instance_throughput_userrollbackundorec_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userrollbackundorec_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Rollback Undo Records Applied (per transaction)',
        p_column_label_nlsid => 'instance_throughput_userrollbackundorec_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Rollback Undo Applied (per txn)',
        p_short_name_nlsid => 'instance_throughput_userrollbackundorec_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'leafnodesplits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Leaf Node Splits (per second)',
        p_column_label_nlsid => 'instance_throughput_leafnodesplits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Leaf Node Splits (per second)',
        p_short_name_nlsid => 'instance_throughput_leafnodesplits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'leafnodesplits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Leaf Node Splits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_leafnodesplits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Leaf Node Splits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_leafnodesplits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'branchnodesplits_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Branch Node Splits (per second)',
        p_column_label_nlsid => 'instance_throughput_branchnodesplits_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Branch Node Splits (per second)',
        p_short_name_nlsid => 'instance_throughput_branchnodesplits_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'branchnodesplits_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Branch Node Splits (per transaction)',
        p_column_label_nlsid => 'instance_throughput_branchnodesplits_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Branch Node Splits (per transaction)',
        p_short_name_nlsid => 'instance_throughput_branchnodesplits_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redosize_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generated (per transaction)',
        p_column_label_nlsid => 'instance_throughput_redosize_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Generated (per transaction)',
        p_short_name_nlsid => 'instance_throughput_redosize_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'crundorecs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Consistent Read Undo Records Applied (per second)',
        p_column_label_nlsid => 'instance_throughput_crundorecs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cons Read Undo Applied (per sec)',
        p_short_name_nlsid => 'instance_throughput_crundorecs_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbtime_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Time (centiseconds per second)',
        p_column_label_nlsid => 'instance_throughput_dbtime_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database Time (per second)',
        p_short_name_nlsid => 'instance_throughput_dbtime_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'avg_active_sessions',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Average Active Sessions',
        p_column_label_nlsid => 'instance_throughput_avg_active_sessions',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Average Active Sessions',
        p_short_name_nlsid => 'instance_throughput_avg_active_sessions_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'avg_sync_singleblk_read_latency',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Average Synchronous Single-Block Read Latency (ms)',
        p_column_label_nlsid => 'instance_throughput_avg_sync_singleblk_read_latency',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Average Synchronous Single-Block Read La',
        p_short_name_nlsid => 'instance_throughput_avg_sync_singleblk_read_latency_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'iombs_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'I/O Megabytes (per second)',
        p_column_label_nlsid => 'instance_throughput_iombs_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'I/O Mb (per sec)',
        p_short_name_nlsid => 'instance_throughput_iombs_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'iorequests_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'I/O Requests (per second)',
        p_column_label_nlsid => 'instance_throughput_iorequests_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'I/O Reqs (per sec)',
        p_short_name_nlsid => 'instance_throughput_iorequests_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'instance_throughput',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Throughput',
    p_metric_label_nlsid => 'instance_throughput',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'user_wait_time_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Wait Time (%)',
        p_column_label_nlsid => 'wait_bottlenecks_user_wait_time_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Wait Time %',
        p_short_name_nlsid => 'wait_bottlenecks_user_wait_time_pct_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'host_cpu_usage_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Host CPU Utilization (%)',
        p_column_label_nlsid => 'wait_bottlenecks_host_cpu_usage_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Host CPU Utilization (%)',
        p_short_name_nlsid => 'wait_bottlenecks_host_cpu_usage_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'user_cpu_time_cnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Sessions Using CPU',
        p_column_label_nlsid => 'wait_bottlenecks_user_cpu_time_cnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sessions: CPU',
        p_short_name_nlsid => 'wait_bottlenecks_user_cpu_time_cnt_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userio_wait_cnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Sessions Waiting: I/O',
        p_column_label_nlsid => 'wait_bottlenecks_userio_wait_cnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sessions: I/O',
        p_short_name_nlsid => 'wait_bottlenecks_userio_wait_cnt_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'other_wait_cnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Sessions Waiting: Other',
        p_column_label_nlsid => 'wait_bottlenecks_other_wait_cnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sessions: Other',
        p_short_name_nlsid => 'wait_bottlenecks_other_wait_cnt_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'avg_user_cpu_time_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Average Instance CPU (%)',
        p_column_label_nlsid => 'wait_bottlenecks_avg_user_cpu_time_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Instance CPU (%)',
        p_short_name_nlsid => 'wait_bottlenecks_avg_user_cpu_time_pct_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'wait_bottlenecks',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Wait Bottlenecks',
    p_metric_label_nlsid => 'wait_bottlenecks',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File Name',
        p_column_label_nlsid => 'file_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Average File Read Time (centi-seconds)',
        p_column_label_nlsid => 'file_read_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Average File Write Time (centi-seconds)',
        p_column_label_nlsid => 'file_write_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'file',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Database Files',
    p_metric_label_nlsid => 'file',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Service Name',
        p_column_label_nlsid => 'service_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'elapsed_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Service Response Time (per user call) (microseconds)',
        p_column_label_nlsid => 'service_elapsed_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpu_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Service CPU Time (per user call) (microseconds)',
        p_column_label_nlsid => 'service_cpu_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'service',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Database Services',
    p_metric_label_nlsid => 'service',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'key_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'key_name',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_avg',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'metric_avg',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_min',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'metric_min',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_max',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'metric_max',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'summary_AWR',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'summary_AWR',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'key_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'key_name',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'metric_value',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'hour_AWR',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'hour_AWR',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_category',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'metric_category',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'metric_name',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'key_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'key_name',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'group_id_key',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'group_id_key',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'metric_value',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'current_AWR',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'current_AWR',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'time_cs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time (centi-seconds per call)',
        p_column_label_nlsid => 'system_response_time_per_call_time_cs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Response Time (centi-seconds per call)',
        p_short_name_nlsid => 'system_response_time_per_call_time_cs',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'system_response_time_per_call',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'System Response Time Per Call',
    p_metric_label_nlsid => 'system_response_time_per_call',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logons',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Current Logons Count',
        p_column_label_nlsid => 'logons',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Current Logons Count',
        p_short_name_nlsid => 'logons',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'opencursors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Current Open Cursors Count',
        p_column_label_nlsid => 'opencursors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Current Open Cursors Count',
        p_short_name_nlsid => 'opencursors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'user_limit',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Limit Usage (%)',
        p_column_label_nlsid => 'user_limit',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'User Limit Usage (%)',
        p_short_name_nlsid => 'user_limit',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'process_usage',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Process Limit Usage (%)',
        p_column_label_nlsid => 'process_usage',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Process Limit Usage (%)',
        p_short_name_nlsid => 'process_usage',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'session_usage',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Limit Usage (%)',
        p_column_label_nlsid => 'session_usage',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Limit Usage (%)',
        p_short_name_nlsid => 'session_usage',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'Database_Resource_Usage',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Database Limits',
    p_metric_label_nlsid => 'resource_usage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bufcachehit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffer Cache Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_bufcachehit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Buffer Cache Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_bufcachehit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inmem_sort_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sorts in Memory (%)',
        p_column_label_nlsid => 'instance_efficiency_inmem_sort_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Sorts in Memory (%)',
        p_short_name_nlsid => 'instance_efficiency_inmem_sort_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redologalloc_hit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Log Allocation Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_redologalloc_hit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Log Allocation Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_redologalloc_hit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cursorcachehit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cursor Cache Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_cursor_hit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cursor Cache Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_cursor_hit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuusage_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Usage (per second)',
        p_column_label_nlsid => 'instance_efficiency_cpu_usage_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Usage (per second)',
        p_short_name_nlsid => 'instance_efficiency_cpu_usage_ps',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuusage_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Usage (per transaction)',
        p_column_label_nlsid => 'instance_efficiency_cpuusage_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Usage (per transaction)',
        p_short_name_nlsid => 'instance_efficiency_cpuusage_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pxdwngrd25_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parallel Execution Downgraded 25% or more (per second)',
        p_column_label_nlsid => 'instance_efficiency_pxdwngrd25_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'PX Downgrade >=25% (per sec)',
        p_short_name_nlsid => 'instance_efficiency_pxdwngrd25_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pxdwngrd50_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parallel Execution Downgraded 50% or more (per second)',
        p_column_label_nlsid => 'instance_efficiency_pxdwngrd50_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'PX Downgrade >=50% (per sec)',
        p_short_name_nlsid => 'instance_efficiency_pxdwngrd50_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pxdwngrd75_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parallel Execution Downgraded 75% or more (per second)',
        p_column_label_nlsid => 'instance_efficiency_pxdwngrd75_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'PX Downgrade >=75% (per sec)',
        p_short_name_nlsid => 'instance_efficiency_pxdwngrd75_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pxdwngrd_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parallel Execution Downgraded (per second)',
        p_column_label_nlsid => 'instance_efficiency_pxdwngrd_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'PX Downgrade (per sec)',
        p_short_name_nlsid => 'instance_efficiency_pxdwngrd_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pxdwngrdserial_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parallel Execution Downgraded to Serial (per second)',
        p_column_label_nlsid => 'instance_efficiency_pxdwngrdserial_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'PX Serial Downgrade (per sec)',
        p_short_name_nlsid => 'instance_efficiency_pxdwngrdserial_ps_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pxdwngrdserial_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Parallel Execution Downgraded to Serial (per transaction)',
        p_column_label_nlsid => 'instance_efficiency_pxdwngrdserial_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'PX Serial Downgrade (per txn)',
        p_short_name_nlsid => 'instance_efficiency_pxdwngrdserial_pt_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpu_time_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database CPU Time (%)',
        p_column_label_nlsid => 'instance_efficiency_cpu_time_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Database CPU Time (%)',
        p_short_name_nlsid => 'instance_efficiency_cpu_time_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'response_time_pt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time (per transaction)',
        p_column_label_nlsid => 'instance_efficiency_response_time_pt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Response Time (per transaction)',
        p_short_name_nlsid => 'instance_efficiency_response_time_pt',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dictionaryhit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Dictionary Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_dictionaryhit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Dictionary Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_dictionaryhit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'libcache_hit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Library Cache Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_libcache_hit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Library Cache Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_libcache_hit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'libcache_miss_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Library Cache Miss (%)',
        p_column_label_nlsid => 'instance_efficiency_libcache_miss_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Library Cache Miss (%)',
        p_short_name_nlsid => 'instance_efficiency_libcache_miss_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pgacachehit_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'PGA Cache Hit (%)',
        p_column_label_nlsid => 'instance_efficiency_pgacachehit_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'PGA Cache Hit (%)',
        p_short_name_nlsid => 'instance_efficiency_pgacachehit_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dictionarymiss_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Row Cache Miss Ratio (%)',
        p_column_label_nlsid => 'instance_efficiency_dictionarymiss_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Row Cache Miss Ratio (%)',
        p_short_name_nlsid => 'instance_efficiency_dictionarymiss_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'instance_efficiency',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Efficiency',
    p_metric_label_nlsid => 'instance_efficiency',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'class',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Wait Class',
        p_column_label_nlsid => 'wait_sess_cls_class',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'avg_users_waiting_on_class',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Average Users Waiting Count',
        p_column_label_nlsid => 'wait_sess_cls_avg_users',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbtime_waitclass_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Time Spent Waiting (%)',
        p_column_label_nlsid => 'wait_sess_cls_dbtime_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'wait_sess_cls',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Waits by Wait Class',
    p_metric_label_nlsid => 'wait_sess_cls',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sid',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Blocking Session ID',
        p_column_label_nlsid => 'userBlock_blocking_sid',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Blocking Session Count',
        p_column_label_nlsid => 'userBlock_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'UserBlock',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'User Block',
    p_metric_label_nlsid => 'userBlock',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ID(lockID1_lockID2_sesID_sesSerial#)',
        p_column_label_nlsid => 'user_block_chain_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'db_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Blocking Session DB Time',
        p_column_label_nlsid => 'user_block_chain_db_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Blocking Session Count',
        p_column_label_nlsid => 'user_block_chain_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'UserBlockChain',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'User Block Chain',
    p_metric_label_nlsid => 'user_block_chain',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'shared_free_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Shared Pool Free (%)',
        p_column_label_nlsid => 'sga_pool_wastage_shared_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Shared Pool Free (%)',
        p_short_name_nlsid => 'sga_pool_wastage_shared_free_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'large_free_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Large Pool Free (%)',
        p_column_label_nlsid => 'sga_pool_wastage_large_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Large Pool Free (%)',
        p_short_name_nlsid => 'sga_pool_wastage_large_free_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'java_free_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Java Pool Free (%)',
        p_column_label_nlsid => 'sga_pool_wastage_java_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Java Pool Free (%)',
        p_short_name_nlsid => 'sga_pool_wastage_java_free_pct',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_pool_wastage',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'SGA Pool Wastage',
    p_metric_label_nlsid => 'sga_pool_wastage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'target_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Target Type',
        p_column_label_nlsid => 'db_bsln_adaptive_thresholds_target_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Metric Name',
        p_column_label_nlsid => 'db_bsln_adaptive_thresholds_metric_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'metric_column',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Metric Column',
        p_column_label_nlsid => 'db_bsln_adaptive_thresholds_metric_column',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'key_value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Key Value',
        p_column_label_nlsid => 'db_bsln_adaptive_thresholds_key_value',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'has_active_baseline',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Adaptive Threshold (0/1)',
        p_column_label_nlsid => 'db_bsln_adaptive_thresholds_hab',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_bsln_adaptive_thresholds',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Metrics with Adaptive Thresholds',
    p_metric_label_nlsid => 'db_bsln_adaptive_thresholds',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'secureOSAuditLevel',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Audit Syslog Level',
    p_metric_label_nlsid => 'secure_OS_audit_level',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'umaskSetting',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'umask_setting',
    p_metric_label_nlsid => 'umask_setting',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'osauthPrefixDomain',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'osauth_prefix_domain',
    p_metric_label_nlsid => 'osauth_prefix_domain',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'logArchiveDest',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Log Archive Dest',
    p_metric_label_nlsid => 'log_archive_dest',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ohBinFilesOwner',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'OracleHome/Bin Files Owner',
    p_metric_label_nlsid => 'oh_bin_files_owner',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ohFilesPermission',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'OracleHome Folder''s  File Permission',
    p_metric_label_nlsid => 'oh_files_perm',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'files_perm_owner',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => '  File Permission and Owner',
    p_metric_label_nlsid => 'files_perm_owner_metric',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'otrace',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'OracleHome/otrace/admin/ has *.dat file[s]  ',
    p_metric_label_nlsid => 'otrace_metric',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ohExeBinFilesPerm',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'OracleHome/Bin Executables Permission',
    p_metric_label_nlsid => 'oh_exebin_files_perm',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'windowsPlatform',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Oracle Installed on which windows platform',
    p_metric_label_nlsid => 'windows_platform',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'drivePerm',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Oracle Installed drive/partition permissions',
    p_metric_label_nlsid => 'install_drive_perm',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'domainUsersGrp',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Domain Users group in local users group',
    p_metric_label_nlsid => 'domain_users_grp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'wintools',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'windows tools permissions',
    p_metric_label_nlsid => 'win_tools_perm',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dbParamCollection',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Base parameter collection',
    p_metric_label_nlsid => 'db_parameter_collection',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dbInitParamFilesPerm',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'DB InitParameter File Permissions',
    p_metric_label_nlsid => 'db_initparam_files_perm',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dbAuditPerm',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'DB Audit Files Permissions',
    p_metric_label_nlsid => 'db_audit_perm',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'utlFileDirSetting',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Utl File Directroy Setting',
    p_metric_label_nlsid => 'utl_file_dir_setting',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'iFileRefPerm',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'IFiles Permissions',
    p_metric_label_nlsid => 'ifile_ref_files_perm',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'remoteRolesAndAuthentication',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Remote OS Roles and Authentication',
    p_metric_label_nlsid => 'remote_role_authentication',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'remoteLoginPasswordFile',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Remote Password File',
    p_metric_label_nlsid => 'remote_password_file',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'data',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data from the SGA',
        p_column_label_nlsid => 'sga_stats_data',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_stats',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'Statistics from Direct SGA Attach',
    p_metric_label_nlsid => 'sga_stats',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Instance Status',
        p_column_label_nlsid => 'health_check_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Unmounted',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Unmounted',
        p_column_label_nlsid => 'health_check_unmounted',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Mounted',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Mounted',
        p_column_label_nlsid => 'health_check_mounted',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Unavailable',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Unavailable',
        p_column_label_nlsid => 'health_check_unavailable',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Maintenance',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Maintenance',
        p_column_label_nlsid => 'health_check_maint',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'text',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'State Description',
        p_column_label_nlsid => 'health_check_state_desc',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'State_Table',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Instance State',
        p_column_label_nlsid => 'health_check_state',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'health_check',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Health Check',
    p_metric_label_nlsid => 'health_check_title',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'waiting_sessions',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'waiting_sessions',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'session_wait_chains',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'session_wait_chains',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tracefile',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'tracefile',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'hung_system_traces',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'hung_system_traces',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dummy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dummy',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_start',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_COLLECT_UPLOAD,
    p_metric_label => 'sga_start',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dummy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dummy',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_stop',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'sga_stop',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dummy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dummy',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_resume',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'sga_resume',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dummy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dummy',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_status',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'sga_status',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dummy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dummy',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_hostname',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'sga_hostname',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dummy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dummy',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sga_physicalcpu',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'sga_physicalcpu',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'estimated_mttr',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Estimated MTTR',
        p_column_label_nlsid => 'ha_mttr_estimated_mttr',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_mttr',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_ha_mttr',
    p_metric_label_nlsid => 'ha_mttr',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Interconnect Name',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_ip',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'IP Address',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_ip',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_public',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Public',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_public',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ic_source',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Source',
        p_column_label_nlsid => 'ha_cls_intrconn_ic_source',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('RACINST')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_rac_intrconn',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_ha_rac_intrconn',
    p_metric_label_nlsid => 'ha_rac_intrconn',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'instance',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Instance Name',
        p_column_label_nlsid => 'ha_rac_intrconn_traffic_instance',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'interconnect_rate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Transfer Rate (MB/s)',
        p_column_label_nlsid => 'ha_rac_intrconn_traffic_interconnect_rate',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('RACINST')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_rac_intrconn_traffic',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Interconnect Traffic',
    p_metric_label_nlsid => 'ha_rac_intrconn_traffic',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'if_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Interface Name',
        p_column_label_nlsid => 'ha_rac_intrconn_type_if_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'if_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Interface Type',
        p_column_label_nlsid => 'ha_rac_intrconn_type_if_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('RACINST')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_rac_intrconn_type',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Interconnect',
    p_metric_label_nlsid => 'ha_rac_intrconn_type',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'task_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Task ID',
        p_column_label_nlsid => 'latest_hdm_findings_task_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'finding_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Finding ID',
        p_column_label_nlsid => 'latest_hdm_findings_finding_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rec_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Rec Type',
        p_column_label_nlsid => 'latest_hdm_findings_rec_type',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rec_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Rec Count',
        p_column_label_nlsid => 'latest_hdm_findings_rec_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'impact_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Impact (%)',
        p_column_label_nlsid => 'latest_hdm_findings_impact_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'message',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Finding Message',
        p_column_label_nlsid => 'latest_hdm_findings_message',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'start_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Start Time',
        p_column_label_nlsid => 'latest_hdm_findings_start_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'end_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'End Time',
        p_column_label_nlsid => 'latest_hdm_findings_end_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'latest_hdm_findings',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Latest HDM Findings',
    p_metric_label_nlsid => 'hdm_findings_1',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'task_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Task ID',
        p_column_label_nlsid => 'latest_hdm_findings_task_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'finding_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Finding ID',
        p_column_label_nlsid => 'latest_hdm_findings_finding_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rec_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Rec Type',
        p_column_label_nlsid => 'latest_hdm_findings_rec_type',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rec_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Rec Count',
        p_column_label_nlsid => 'latest_hdm_findings_rec_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'impact_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Impact (%)',
        p_column_label_nlsid => 'latest_hdm_findings_impact_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'message',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Finding Message',
        p_column_label_nlsid => 'latest_hdm_findings_message',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'start_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Start Time',
        p_column_label_nlsid => 'latest_hdm_findings_start_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'end_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'End Time',
        p_column_label_nlsid => 'latest_hdm_findings_end_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'finding_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Finding Count',
        p_column_label_nlsid => 'latest_hdm_findings_finding_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'finding_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Finding Name',
        p_column_label_nlsid => 'latest_hdm_findings_finding_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'active_sessions',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Finding Count',
        p_column_label_nlsid => 'latest_hdm_findings_finding_active_sessions',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'latest_hdm_findings',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Latest HDM Findings',
    p_metric_label_nlsid => 'hdm_findings_1',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'task_available',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Task Available',
        p_column_label_nlsid => 'mgmt_db_hdm_metric_helper_task_available',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'latest_hdm_metric_helper',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'latest_hdm_metric_helper',
    p_metric_label_nlsid => 'latest_hdm_metric_helper',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'task_available',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Task Available',
        p_column_label_nlsid => 'mgmt_db_hdm_metric_helper_task_available',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'task_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Task Count',
        p_column_label_nlsid => 'latest_hdm_findings_task_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'latest_hdm_metric_helper',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'latest_hdm_metric_helper',
    p_metric_label_nlsid => 'latest_hdm_metric_helper',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'textIndexLogContent',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Content',
        p_column_label_nlsid => 'textIndexLog_content',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'textIndexLogContent',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_COLLECT_UPLOAD,
    p_metric_label => 'Text Index Log Content',
    p_metric_label_nlsid => 'textIndexLogContent',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'textIndexLogRemover',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Content',
        p_column_label_nlsid => 'textIndexLog_content',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'textIndexLogRemover',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_COLLECT_UPLOAD,
    p_metric_label => 'Text Index Log Remover',
    p_metric_label_nlsid => 'textIndexLogRemover',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'USER_IDS',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'USER_IDS',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'pwd_expiry',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_COLLECT_UPLOAD,
    p_metric_label => 'pwd_expiry',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SEVERITY_INDEX',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'SEVERITY_INDEX',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'CRITICAL_INCIDENTS',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CRITICAL_INCIDENTS',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'WARNING_INCIDENTS',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'WARNING_INCIDENTS',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'incident_meter',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_COLLECT_UPLOAD,
    p_metric_label => 'incident_meter',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'streams_pool_full',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Streams Pool Full',
        p_column_label_nlsid => 'streams_pool_full',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Streams Pool Full',
        p_short_name_nlsid => 'streams_pool_full',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'streams_pool',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Streams Pool Usage',
    p_metric_label_nlsid => 'streams_pool',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 0);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace Name',
        p_column_label_nlsid => 'tbspName',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pctUsed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Space Used (%)',
        p_column_label_nlsid => 'pctUsed',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bytesFree',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Free Space (MB)',
        p_column_label_nlsid => 'bytesFree',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('pre8','8i','8iR2','9i','9iR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'problemTbsp',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Tablespaces Full',
    p_metric_label_nlsid => 'problemTbsp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace Name',
        p_column_label_nlsid => 'tbspName',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pctUsed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Space Used (%)',
        p_column_label_nlsid => 'pctUsed',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'problemTbsp',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Tablespaces Full',
    p_metric_label_nlsid => 'problemTbsp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace Name',
        p_column_label_nlsid => 'tbspName',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pctUsed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Space Used (%)',
        p_column_label_nlsid => 'pctUsed',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bytesFree',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Free Space (MB)',
        p_column_label_nlsid => 'bytesFree',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'problemTbsp',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Tablespaces Full',
    p_metric_label_nlsid => 'problemTbsp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace Name',
        p_column_label_nlsid => 'tbspName',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pctUsed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Space Used (%) (dictionary managed)',
        p_column_label_nlsid => 'pctUsed10iDct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bytesFree',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Free Space (MB) (dictionary managed)',
        p_column_label_nlsid => 'bytesFree10iDct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'problemTbsp10iDct',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Tablespaces Full (dictionary managed)',
    p_metric_label_nlsid => 'problemTbsp10iDct',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace Name',
        p_column_label_nlsid => 'tbspName',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'segsChunkSmlCnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Segments Not Able to Extend Count',
        p_column_label_nlsid => 'segsChunkSmlCnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'segsChunkSmlMessage',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Segments Not Able to Extend',
        p_column_label_nlsid => 'segsChunkSmlMessage',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'segsMaxExtsCnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Segments Approaching Maximum Extents Count',
        p_column_label_nlsid => 'segsMaxExtsCnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'segsMaxExtsMessage',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Segments Approaching Maximum Extents',
        p_column_label_nlsid => 'segsMaxExtsMessage',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'problemSegTbsp',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Tablespaces With Problem Segments',
    p_metric_label_nlsid => 'problemSegTbsp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'name',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'problem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'problem',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'tablespace',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_recUserSettings',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'db_recUserSettings',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'tablespace',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'problem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'problem',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value1',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'value1',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_recTablespaceSettings',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'db_recTablespaceSettings',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Object Type',
        p_column_label_nlsid => 'db_recSegmentSettings_type',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_owner',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Object Owner',
        p_column_label_nlsid => 'db_recSegmentSettings_owner',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Object Name',
        p_column_label_nlsid => 'db_recSegmentSettings_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_partition',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Partition',
        p_column_label_nlsid => 'db_recSegmentSettings_partition',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_lob_col',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'LOB Column',
        p_column_label_nlsid => 'db_recSegmentSettings_lob_col',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'seg_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Segment Type',
        p_column_label_nlsid => 'db_recSegmentSettings_segment_type',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace',
        p_column_label_nlsid => 'db_recSegmentSettings_tablespace',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recommendation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Problem',
        p_column_label_nlsid => 'db_recSegmentSettings_problem_code',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_recSegmentSettings',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'db_recSegmentSettings',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Object Type',
        p_column_label_nlsid => 'db_recSegmentSettings_type',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_owner',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Object Owner',
        p_column_label_nlsid => 'db_recSegmentSettings_owner',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Object Name',
        p_column_label_nlsid => 'db_recSegmentSettings_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_partition',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Partition',
        p_column_label_nlsid => 'db_recSegmentSettings_partition',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_lob_col',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'LOB Column',
        p_column_label_nlsid => 'db_recSegmentSettings_lob_col',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'seg_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Segment Type',
        p_column_label_nlsid => 'db_recSegmentSettings_segment_type',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace',
        p_column_label_nlsid => 'db_recSegmentSettings_tablespace',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recommendation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Problem',
        p_column_label_nlsid => 'db_recSegmentSettings_problem_code',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_recSegmentSettings_sysseg',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'db_recSegmentSettings_sysseg',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mgmt_space_purge_metric_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'mgmt_space_purge_metric_name',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'recSettingsPurge',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'recSettingsPurge',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_dnr1',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Not Received (logs)',
        p_column_label_nlsid => 'dg_dnr1',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_dna1',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Not Applied (logs) ',
        p_column_label_nlsid => 'dg_dna1',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Guard Status',
        p_column_label_nlsid => 'dg_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('9iR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dataguard9',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard',
    p_metric_label_nlsid => 'dg',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_dnr1',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Not Received (logs)',
        p_column_label_nlsid => 'dg_dnr1',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_dnr2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Not Received (MB)',
        p_column_label_nlsid => 'dg_dnr2',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_dna1',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Not Applied (logs) ',
        p_column_label_nlsid => 'dg_dna1',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_dna2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Not Applied (MB) ',
        p_column_label_nlsid => 'dg_dna2',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Guard Status',
        p_column_label_nlsid => 'dg_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dataguard10',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard',
    p_metric_label_nlsid => 'dg',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'db_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'db_name',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Physical Standby','Logical Standby','Snapshot Standby')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'DGPrimaryDBName',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_COLLECT_UPLOAD,
    p_metric_label => 'DGPrimaryDBName',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Guard Status',
        p_column_label_nlsid => 'dg_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dataguard',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard Status',
    p_metric_label_nlsid => 'dg_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ob_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Observer Status',
        p_column_label_nlsid => 'dg_observer_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'observer',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard Fast-Start Failover Observer',
    p_metric_label_nlsid => 'dg_observer',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ob_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Observer Status',
        p_column_label_nlsid => 'dg_observer_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Observer Status',
        p_short_name_nlsid => 'dg_observer_status',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'observer_11g',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard Fast-Start Failover Observer',
    p_metric_label_nlsid => 'dg_observer',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_redo_rate_KB',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Generation Rate (KB/second)',
        p_column_label_nlsid => 'dg_redo_rate_KB',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dataguard_pperf',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard Performance',
    p_metric_label_nlsid => 'dg_pperf',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_fot',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Estimated Failover Time (seconds)',
        p_column_label_nlsid => 'dg_fot',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_lag',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Apply Lag (seconds)',
        p_column_label_nlsid => 'dg_lag',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_pdl',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Transport Lag (seconds)',
        p_column_label_nlsid => 'dg_pdl',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_redo_arate_KB',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Apply Rate (KB/second)',
        p_column_label_nlsid => 'dg_redo_arate_KB',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Physical Standby','Logical Standby','Snapshot Standby')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dataguard_sperf',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard Performance',
    p_metric_label_nlsid => 'dg_sperf',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_fs_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Fast-Start Failover Time',
        p_column_label_nlsid => 'dg_fs_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Fast-Start Failover Time',
        p_short_name_nlsid => 'dg_fs_time',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_fs_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Fast-Start Failover Status',
        p_column_label_nlsid => 'dg_fs_status_str',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Fast-Start Failover Status',
        p_short_name_nlsid => 'dg_fs_status_str',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_fs_pscn',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Fast-Start Failover SCN',
        p_column_label_nlsid => 'dg_fs_pscn',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_fs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Fast-Start Failover Occurred',
        p_column_label_nlsid => 'dg_fs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Fast-Start Failover Occurred',
        p_short_name_nlsid => 'dg_fs',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary','Physical Standby','Logical Standby')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dataguard_fsfo',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard Fast-Start Failover',
    p_metric_label_nlsid => 'dgfsfo_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Database_Down',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Failover Occurred',
        p_column_label_nlsid => 'dg_failover_occurred',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Failover Occurred',
        p_short_name_nlsid => 'dg_failover_occurred',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 1);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary','Physical Standby','Logical Standby')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'Availability',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Data Guard Failover',
    p_metric_label_nlsid => 'dg_failover_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 0);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SOURCE_TYPE',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'SOURCE_TYPE',
        p_column_label_nlsid => 'DB_ID',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ROW_TYPE',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ROW_TYPE',
        p_column_label_nlsid => 'ROW_TYPE',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'USING_BROKER',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'USING_BROKER',
        p_column_label_nlsid => 'USING_BROKER',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ACTIVE_STBY',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ACTIVE_STBY',
        p_column_label_nlsid => 'ACTIVE_STBY',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DB_UNIQUE_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'DB_UNIQUE_NAME',
        p_column_label_nlsid => 'DB_UNIQUE_NAME',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DB_ID',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DB_ID',
        p_column_label_nlsid => 'DB_ID',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRMY_DB_UNIQUE_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRMY_DB_UNIQUE_NAME',
        p_column_label_nlsid => 'PRMY_DB_UNIQUE_NAME',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRMY_DB_ID',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'PRMY_DB_ID',
        p_column_label_nlsid => 'PRMY_DB_ID',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ROLE',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ROLE',
        p_column_label_nlsid => 'ROLE',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'STBY_LIST',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ROW_TYPE',
        p_column_label_nlsid => 'STBY_LIST',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PROTECTION_MODE',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PROTECTION_MODE',
        p_column_label_nlsid => 'PROTECTION_MODE',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'FSFO_STATUS',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'FSFO_STATUS',
        p_column_label_nlsid => 'FSFO_STATUS',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'STATUS',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'STATUS',
        p_column_label_nlsid => 'STATUS',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TRANSPORT_LAG',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'TRANSPORT_LAG',
        p_column_label_nlsid => 'TRANSPORT_LAG',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'APPLY_LAG',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'APPLY_LAG',
        p_column_label_nlsid => 'APPLY_LAG',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('9iR2'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary','Physical Standby','Logical Standby')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_dg_target_summary',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'ha_dg_target_summary',
    p_metric_label_nlsid => 'ha_dg_target_summary',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SOURCE_TYPE',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'SOURCE_TYPE',
        p_column_label_nlsid => 'DB_ID',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ROW_TYPE',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ROW_TYPE',
        p_column_label_nlsid => 'ROW_TYPE',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'USING_BROKER',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'USING_BROKER',
        p_column_label_nlsid => 'USING_BROKER',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ACTIVE_STBY',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ACTIVE_STBY',
        p_column_label_nlsid => 'ACTIVE_STBY',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DB_UNIQUE_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'DB_UNIQUE_NAME',
        p_column_label_nlsid => 'DB_UNIQUE_NAME',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DB_ID',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DB_ID',
        p_column_label_nlsid => 'DB_ID',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRMY_DB_UNIQUE_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRMY_DB_UNIQUE_NAME',
        p_column_label_nlsid => 'PRMY_DB_UNIQUE_NAME',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRMY_DB_ID',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'PRMY_DB_ID',
        p_column_label_nlsid => 'PRMY_DB_ID',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ROLE',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ROLE',
        p_column_label_nlsid => 'ROLE',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'STBY_LIST',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ROW_TYPE',
        p_column_label_nlsid => 'STBY_LIST',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PROTECTION_MODE',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PROTECTION_MODE',
        p_column_label_nlsid => 'PROTECTION_MODE',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'FSFO_STATUS',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'FSFO_STATUS',
        p_column_label_nlsid => 'FSFO_STATUS',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'STATUS',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'STATUS',
        p_column_label_nlsid => 'STATUS',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TRANSPORT_LAG',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'TRANSPORT_LAG',
        p_column_label_nlsid => 'TRANSPORT_LAG',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'APPLY_LAG',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'APPLY_LAG',
        p_column_label_nlsid => 'APPLY_LAG',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('Primary','Physical Standby','Logical Standby','Snapshot Standby')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_dg_target_summary',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'ha_dg_target_summary',
    p_metric_label_nlsid => 'ha_dg_target_summary',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'errortrans_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Deferred Transaction Error Count',
        p_column_label_nlsid => 'errortrans_error',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Deferred Transaction Error Count',
        p_short_name_nlsid => 'errortrans_error',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'deftrans_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Deferred Transaction Count',
        p_column_label_nlsid => 'deftrans_count_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Deferred Transaction Count',
        p_short_name_nlsid => 'deftrans_count_name',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'DeferredTrans',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Deferred Transactions',
    p_metric_label_nlsid => 'deferredTrans_count',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DBID',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DBID',
        p_column_label_nlsid => 'db_FeatureUsage_database_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Feature Name',
        p_column_label_nlsid => 'db_FeatureUsage_feature_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'currently_used',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Currently Used',
        p_column_label_nlsid => 'db_FeatureUsage_currently_used',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'detected_usages',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Detected Usages',
        p_column_label_nlsid => 'db_FeatureUsage_detected_usages',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'first_usage_date',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'First Usage Date',
        p_column_label_nlsid => 'db_FeatureUsage_first_usage_date',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'last_usage_date',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Last Usage Date',
        p_column_label_nlsid => 'db_FeatureUsage_last_usage_date',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'version',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Version',
        p_column_label_nlsid => 'db_FeatureUsage_version',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'last_sample_date',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Last Sample Date',
        p_column_label_nlsid => 'db_FeatureUsage_last_sample_date',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'last_sample_period',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Last Sample Period',
        p_column_label_nlsid => 'db_FeatureUsage_last_sample_period',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'total_samples',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Samples',
        p_column_label_nlsid => 'db_FeatureUsage_total_samples',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'aux_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Count',
        p_column_label_nlsid => 'db_FeatureUsage_aux_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'description',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Description',
        p_column_label_nlsid => 'db_FeatureUsage_description',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_FeatureUsage',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Feature Usage',
    p_metric_label_nlsid => 'db_FeatureUsage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'object_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Object Type',
        p_column_label_nlsid => 'db_invObjects_type',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'object_owner',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Object Owner',
        p_column_label_nlsid => 'db_invObjects_owner',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'object_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Object Name',
        p_column_label_nlsid => 'db_invObjects_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_invalidObjects',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'db_invalidObjects',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'owner',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Invalid Object Owner',
        p_column_label_nlsid => 'invalid_objects_owner',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Owner''s Invalid Object Count',
        p_column_label_nlsid => 'invalid_objects_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'invalid_objects',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Invalid Objects by Schema',
    p_metric_label_nlsid => 'invalid_objects',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'total_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Invalid Object Count',
        p_column_label_nlsid => 'all_invalid_objects_total_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total Invalid Object Count',
        p_short_name_nlsid => 'all_invalid_objects_total_count',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'all_invalid_objects',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Invalid Objects',
    p_metric_label_nlsid => 'all_invalid_objects',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'broken',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Broken Job Count',
        p_column_label_nlsid => 'dbjob_status_broken',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Broken Job Count',
        p_short_name_nlsid => 'dbjob_status_broken',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Failed Job Count',
        p_column_label_nlsid => 'dbjob_status_failed',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Failed Job Count',
        p_short_name_nlsid => 'dbjob_status_failed',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dbjob_status',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Database Job Status',
    p_metric_label_nlsid => 'dbjob_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'obj_type_schema_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'obj_type_schema_name',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'seg_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'seg_type',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'tablespace',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'problem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'problem',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recommendations',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'recommendations',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'problemValue',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'problemValue',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'wastedSpace',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Segment Findings',
    p_metric_label_nlsid => 'stgPerf',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hasPriv',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'hasPriv',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'seg_find_privs',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'seg_find_privs',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dummy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'dummy',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'seg_grant_privs',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'seg_grant_privs',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Object_Causing',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Object Causing',
        p_column_label_nlsid => 'Suspended_Session_Object_Causing',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Tablespace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Session Suspended by Tablespace Limitation',
        p_column_label_nlsid => 'Suspended_Session_Tablespace',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 1);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Rollback_Segment',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Session Suspended by Rollback Segment Limitation',
        p_column_label_nlsid => 'Suspended_Session_Rollback_Segment',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 1);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Data_Object',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Session Suspended by Data Object Limitation',
        p_column_label_nlsid => 'Suspended_Session_Data_Object',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 1);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Quota',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Session Suspended by Quota Limitation',
        p_column_label_nlsid => 'Suspended_Session_Quota',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 1);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'Suspended_Session',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Session Suspended',
    p_metric_label_nlsid => 'Suspended_Session',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 0);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Recovery_Area',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Recovery Area',
        p_column_label_nlsid => 'Recovery_Area_Recovery_Area',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Free_Space',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Recovery Area Free Space (%)',
        p_column_label_nlsid => 'Recovery_Area_Free_Space',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Recovery Area Free Space (%)',
        p_short_name_nlsid => 'Recovery_Area_Free_Space',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 1);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'Recovery_Area',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Recovery Area',
    p_metric_label_nlsid => 'Recovery_Area',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Object_Causing',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Object Causing',
        p_column_label_nlsid => 'Snap_Shot_Too_Old_Object_Causing',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Tablespace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Snapshot Too Old due to Tablespace Limit',
        p_column_label_nlsid => 'Snap_Shot_Too_Old_Tablespace',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 1);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Rollback_Segment',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Snapshot Too Old due to Rollback Segment Limit',
        p_column_label_nlsid => 'Snap_Shot_Too_Old_Rollback_Segment',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 1);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'Snap_Shot_Too_Old',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Snapshot Too Old',
    p_metric_label_nlsid => 'Snap_Shot_Too_Old',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 1,
    p_has_pull => 0);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace Name',
        p_column_label_nlsid => 'tbspName',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'spaceAllocated',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Allocated Space (MB)',
        p_column_label_nlsid => 'spaceAllocated',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'spaceUsed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Tablespace Used Space (MB)',
        p_column_label_nlsid => 'spaceUsed',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'tbspAllocation',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Tablespace Allocation',
    p_metric_label_nlsid => 'tbspAllocation',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'database_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'DB Name',
        p_column_label_nlsid => 'db_dbNInstanceInfo_database_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'global_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Global Name',
        p_column_label_nlsid => 'db_dbNInstanceInfo_global_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'banner',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'DB Version',
        p_column_label_nlsid => 'db_dbNInstanceInfo_banner',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'host_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Host Name',
        p_column_label_nlsid => 'db_dbNInstanceInfo_host_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'instance_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Instance Name',
        p_column_label_nlsid => 'db_dbNInstanceInfo_instance_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'startup_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Instance Startup Time',
        p_column_label_nlsid => 'db_dbNInstanceInfo_startup_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logins',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Restricted Mode',
        p_column_label_nlsid => 'db_dbNInstanceInfo_logins',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_mode',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Log Mode',
        p_column_label_nlsid => 'db_dbNInstanceInfo_log_mode',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'open_mode',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Read Only Mode',
        p_column_label_nlsid => 'db_dbNInstanceInfo_open_mode',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'characterset',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Database Character Set',
        p_column_label_nlsid => 'db_dbNInstanceInfo_characterset',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'national_characterset',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'National Character Set',
        p_column_label_nlsid => 'db_dbNInstanceInfo_national_characterset',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'default_temp_tablespace',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Default Temporary Tablespace',
        p_column_label_nlsid => 'db_dbNInstanceInfo_default_temp_tablespace',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dv_status_code',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database Vault Status',
        p_column_label_nlsid => 'dv_status_nlsid',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_dbNInstanceInfo',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_dbNInstanceInfo',
    p_metric_label_nlsid => 'db_dbNInstanceInfo',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'db_init_params_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Value',
        p_column_label_nlsid => 'db_init_params_value',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'isdefault',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Default',
        p_column_label_nlsid => 'db_init_params_isdefault',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_init_params',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_init_params',
    p_metric_label_nlsid => 'db_init_params',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'group_num',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Group',
        p_column_label_nlsid => 'db_redoLogs_group_num',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Status',
        p_column_label_nlsid => 'db_redoLogs_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'members',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Members',
        p_column_label_nlsid => 'db_redoLogs_members',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File Name',
        p_column_label_nlsid => 'db_redoLogs_file_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archived',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Archived',
        p_column_label_nlsid => 'db_redoLogs_archived',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logsize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Log Size',
        p_column_label_nlsid => 'db_redoLogs_logsize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sequence_num',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sequence Number',
        p_column_label_nlsid => 'db_redoLogs_sequence_num',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'first_change_scn',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'First Change',
        p_column_label_nlsid => 'db_redoLogs_first_change',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'os_storage_entity',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Storage Entity',
        p_column_label_nlsid => 'db_redoLogs_os_storage_entity',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'thread_num',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Thread Num',
        p_column_label_nlsid => 'db_redoLogs_thread_num',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_redoLogs',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_redoLogs',
    p_metric_label_nlsid => 'db_redoLogs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Datafile Name',
        p_column_label_nlsid => 'db_datafiles_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Status',
        p_column_label_nlsid => 'db_datafiles_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace',
        p_column_label_nlsid => 'db_datafiles_tablespace_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'File Size',
        p_column_label_nlsid => 'db_datafiles_file_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'autoextensible',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Autoextensible',
        p_column_label_nlsid => 'db_datafiles_autoextensible',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'increment_by',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Increment By',
        p_column_label_nlsid => 'db_datafiles_increment_by',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'max_file_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Max File Size',
        p_column_label_nlsid => 'db_datafiles_max_file_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'os_storage_entity',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Storage Entity',
        p_column_label_nlsid => 'db_datafiles_os_storage_entity',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_datafiles',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_datafiles',
    p_metric_label_nlsid => 'db_datafiles',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace Name',
        p_column_label_nlsid => 'db_tablespaces_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Status',
        p_column_label_nlsid => 'db_tablespaces_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'contents',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Type',
        p_column_label_nlsid => 'db_tablespaces_contents',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'extent_management',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Extent Management',
        p_column_label_nlsid => 'db_tablespaces_extent_management',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'allocation_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Allocation Type',
        p_column_label_nlsid => 'db_tablespaces_allocation_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logging',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Logging',
        p_column_label_nlsid => 'db_tablespaces_logging',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size',
        p_column_label_nlsid => 'db_tablespaces_tablespace_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'initial_ext_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Initial Ext Size',
        p_column_label_nlsid => 'db_tablespaces_initial_ext_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'next_extent',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Next Extent',
        p_column_label_nlsid => 'db_tablespaces_next_extent',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'increment_by',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Increment By',
        p_column_label_nlsid => 'db_tablespaces_increment_by',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'max_extents',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Max Extents',
        p_column_label_nlsid => 'db_tablespaces_max_extents',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace_used_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Used Size(B)',
        p_column_label_nlsid => 'db_tablespaces_tablespace_used_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'min_extents',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Minimum Extents',
        p_column_label_nlsid => 'db_tablespaces_min_extents',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'min_extlen',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Minimum Extent Size',
        p_column_label_nlsid => 'db_tablespaces_min_extlen',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'segment_space_management',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Segment Space Management',
        p_column_label_nlsid => 'db_tablespaces_tablespace_seg_mgmt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'block_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Block Size',
        p_column_label_nlsid => 'db_tablespaces_block_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'bigfile',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Big File',
        p_column_label_nlsid => 'db_tablespaces_bigfile',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_tablespaces',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_tablespaces',
    p_metric_label_nlsid => 'db_tablespaces',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File Name',
        p_column_label_nlsid => 'db_controlfiles_file_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Status',
        p_column_label_nlsid => 'db_controlfiles_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'creation_date',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Creation Date',
        p_column_label_nlsid => 'db_controlfiles_creation_date',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sequence_num',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Sequence Number',
        p_column_label_nlsid => 'db_controlfiles_sequence_num',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'change_num',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Change Number',
        p_column_label_nlsid => 'db_controlfiles_change_num',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mod_date',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Modification Date',
        p_column_label_nlsid => 'db_controlfiles_mod_date',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'os_storage_entity',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Storage Entity',
        p_column_label_nlsid => 'db_controlfiles_os_storage_entity',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_controlfiles',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_controlfiles',
    p_metric_label_nlsid => 'db_controlfiles',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollname',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'db_rollback_segs_rollname',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Status',
        p_column_label_nlsid => 'db_rollback_segs_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tablespace_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Tablespace Name',
        p_column_label_nlsid => 'db_rollback_segs_tablespace_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'extents',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Extents',
        p_column_label_nlsid => 'db_rollback_segs_extents',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rollsize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size',
        p_column_label_nlsid => 'db_rollback_segs_rollsize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'initial_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Initial Size',
        p_column_label_nlsid => 'db_rollback_segs_initial_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'next_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Next Size',
        p_column_label_nlsid => 'db_rollback_segs_next_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'maximum_extents',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Maximum Size',
        p_column_label_nlsid => 'db_rollback_segs_maximum_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'minimum_extents',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Minimum Extents',
        p_column_label_nlsid => 'db_rollback_segs_minimum_extents',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pct_increase',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Pct Increase',
        p_column_label_nlsid => 'db_rollback_segs_pct_increase',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'optsize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Optsize',
        p_column_label_nlsid => 'db_rollback_segs_optsize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'aveactive',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Aveactive',
        p_column_label_nlsid => 'db_rollback_segs_aveactive',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'wraps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Wraps',
        p_column_label_nlsid => 'db_rollback_segs_wraps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'shrinks',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Shrinks',
        p_column_label_nlsid => 'db_rollback_segs_shrinks',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'aveshrink',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Aveshrink',
        p_column_label_nlsid => 'db_rollback_segs_aveshrink',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hwmsize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Hwmsize',
        p_column_label_nlsid => 'db_rollback_segs_hwmsize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_rollback_segs',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_rollback_segs',
    p_metric_label_nlsid => 'db_rollback_segs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sganame',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'SGA Name',
        p_column_label_nlsid => 'db_sga_sganame',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sgasize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size',
        p_column_label_nlsid => 'db_sga_sgasize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_sga',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_sga',
    p_metric_label_nlsid => 'db_sga',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessions_max',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Maximum Sessions',
        p_column_label_nlsid => 'db_license_sessions_max',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessions_warning',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Warning Sessions',
        p_column_label_nlsid => 'db_license_sessions_warning',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessions_current',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Current Sessions',
        p_column_label_nlsid => 'db_license_sessions_current',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessions_highwater',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Highwater Sessions',
        p_column_label_nlsid => 'db_license_sessions_highwater',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'users_max',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Maximum Users',
        p_column_label_nlsid => 'db_license_users_max',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_license',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_license',
    p_metric_label_nlsid => 'db_license',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'db_options_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'selected',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Selected',
        p_column_label_nlsid => 'db_options_selected',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'db_options',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_db_options',
    p_metric_label_nlsid => 'db_options',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dbid',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Database ID',
        p_column_label_nlsid => 'db_ha_dbid',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_mode',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Log Mode',
        p_column_label_nlsid => 'db_ha_log_mode',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'force_logging',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Force Logging',
        p_column_label_nlsid => 'db_ha_force_logging',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'database_role',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Database Role',
        p_column_label_nlsid => 'db_ha_database_role',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'flashback_on',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Flashback On',
        p_column_label_nlsid => 'db_ha_flashback_on',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'supplemental_logging',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Supplemental Logging',
        p_column_label_nlsid => 'db_ha_supplemental_logging',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8i','8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_info',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_ha_info',
    p_metric_label_nlsid => 'ha_info',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'end_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'End Time',
        p_column_label_nlsid => 'ha_backup_end_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Status',
        p_column_label_nlsid => 'ha_backup_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'session_key',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Key',
        p_column_label_nlsid => 'ha_backup_session_key',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'session_recid',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session RECID',
        p_column_label_nlsid => 'ha_backup_session_recid',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'session_stamp',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Stamp',
        p_column_label_nlsid => 'ha_backup_session_stamp',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'command_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Command Id',
        p_column_label_nlsid => 'ha_backup_command_id',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'start_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Start Time',
        p_column_label_nlsid => 'ha_backup_start_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'time_taken_display',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time Taken Display',
        p_column_label_nlsid => 'ha_backup_time_taken_display',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'input_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Input Type',
        p_column_label_nlsid => 'ha_backup_input_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'output_device_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Output Device Type',
        p_column_label_nlsid => 'ha_backup_output_device_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'input_bytes_display',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Input Bytes Display',
        p_column_label_nlsid => 'ha_backup_input_bytes_display',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'output_bytes_display',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Output Bytes Display',
        p_column_label_nlsid => 'ha_backup_output_bytes_display',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'output_bytes_per_sec_display',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Output Bytes Display',
        p_column_label_nlsid => 'ha_backup_output_bytes_per_sec_display',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8i','8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_backup',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_ha_backup',
    p_metric_label_nlsid => 'ha_backup',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'ha_rman_config_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Value',
        p_column_label_nlsid => 'ha_rman_config_value',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_rman_config',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'mgmt_ha_rman_config',
    p_metric_label_nlsid => 'ha_rman_config',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_mode',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Log Mode',
        p_column_label_nlsid => 'ha_log_mode',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'flash_recovery_area',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Flash Recovery Area',
        p_column_label_nlsid => 'ha_flash_recovery_area',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usable_area',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Usable Flash Recovery Area (%)',
        p_column_label_nlsid => 'ha_usable_area',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'reclaimable_area',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Reclaimable Flash Recovery Area (%)',
        p_column_label_nlsid => 'ha_reclaimable_area',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'nonreclaimable_area',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Non-reclaimable Flash Recovery Area (%)',
        p_column_label_nlsid => 'ha_nonreclaimable_area',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'flashback_on',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Flashback On',
        p_column_label_nlsid => 'ha_flashback_on',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'oldest_flashback_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Oldest Flashback Time',
        p_column_label_nlsid => 'ha_oldest_flashback_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'flash_recovery_area_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Flash Recovery Area Size',
        p_column_label_nlsid => 'ha_flash_recovery_area_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_flashrecovery',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Flash Recovery',
    p_metric_label_nlsid => 'ha_flashrecovery',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'missing_media_files',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Missing Media File Count',
        p_column_label_nlsid => 'ha_missing_media_files',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'corrupt_data_blocks',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Corrupt Data Block Count',
        p_column_label_nlsid => 'ha_corrupt_data_blocks',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'datafiles_need_recovery',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Datafiles Need Media Recovery',
        p_column_label_nlsid => 'ha_datafiles_need_recovery',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8i','8iR2','9i','9iR2','10gR1','10gR2','10gR203'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'ha_recovery',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Recovery',
    p_metric_label_nlsid => 'ha_recovery',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'esm_dirObjUsersWithExeAndOtherPrivs',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'EXECUTE and READ/WRITE privileges for the same user on the direc',
    p_metric_label_nlsid => 'esm_dirObjUsersWithExeAndOtherPrivs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'esm_publicHavingExePrivOnDirObj',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'EXECUTE privileges for PUBLIC on the directory object',
    p_metric_label_nlsid => 'esm_publicHavingExePrivOnDirObj',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'installAndDemoAcccounts',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Default Install and Demo Accounts',
    p_metric_label_nlsid => 'install_demo_accounts',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'defaultAccountPasswords',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Default Users and Passwords',
    p_metric_label_nlsid => 'default_user_password',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'systemPrivileges',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'System Privileges for Public Role',
    p_metric_label_nlsid => 'system_privileges',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'executePrivileges',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Object Execute Privilege for Public Role',
    p_metric_label_nlsid => 'execute_privilege',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value2',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'unlimitedFailedLoginAttempts',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Number of Failed Login Attempts',
    p_metric_label_nlsid => 'unlimited_login_attempts',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'recommendations',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number of recommendations',
        p_column_label_nlsid => 'database_stg_segAdv_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'segment_advisor_count',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Segment Advisor Recommendations',
    p_metric_label_nlsid => 'segment_advisor_count',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'privsWithAdminOption',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Privileges granted with WITH ADMIN option',
    p_metric_label_nlsid => 'with_admin_option',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'privsWithGrantOption',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Privileges granted with WITH GRANT option',
    p_metric_label_nlsid => 'with_grant_option',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'exemptAccessPolicy',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users with EXEMPT ACCESS POLICY privileges',
    p_metric_label_nlsid => 'exempt_access_policy_privs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dbaRole',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users with DBA roles',
    p_metric_label_nlsid => 'dba_role',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'createPrivileges',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users with CREATE privileges',
    p_metric_label_nlsid => 'create_privs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'catalogRole',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users with CATALOG roles',
    p_metric_label_nlsid => 'catalog_roles',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'becomeUserPriv',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users with BECOME USER privileges',
    p_metric_label_nlsid => 'become_user_privs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'auditSystemPriv',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users with AUDIT SYSTEM privileges',
    p_metric_label_nlsid => 'audit_sys_privs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'anyDictionaryPriv',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users with ANY DICTIONARY privileges',
    p_metric_label_nlsid => 'any_dictionary_privs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'directPrivileges',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users with direct privileges',
    p_metric_label_nlsid => 'users_with_direct_privs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sysPublicPackage',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'System Public Package',
    p_metric_label_nlsid => 'sys_public_package',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'connectRole',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Connect Role',
    p_metric_label_nlsid => 'connect_role',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'allPrivileges',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'ALL Privileges',
    p_metric_label_nlsid => 'all_privilege',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'anyPrivileges',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'ANY Privileges',
    p_metric_label_nlsid => 'any_privilege',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'powerPrivileges',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Power Privileges',
    p_metric_label_nlsid => 'power_privilege',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'dbaGroupAssign',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'DBA Group Assignment',
    p_metric_label_nlsid => 'dba_group',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'tableSpaceOwners',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'List tablespaces and their owners',
    p_metric_label_nlsid => 'tablespace_owners',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PRINCIPAL',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'PRINCIPAL',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OBJECT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OBJECT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'REPORT_NAME',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'REPORT_NAME',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('8iR2','9i','9iR2','10gR1','10gR2','10gR203','11gR1','11gR2'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_database',
    p_metric_name => 'sysPublicExePrivs',
    p_type_meta_ver => '5.3',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'List sys owned packages having public execute privileges',
    p_metric_label_nlsid => 'sys_public_execute_privs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_sh