rem handle target type osb_server

BEGIN 
mgmt_target.register_target_type(
    p_target_type_in => 'osb_server',
    p_type_meta_ver_in => '1.0',
    p_type_display_name_in => 'Oracle Secure Backup',
    p_type_display_nlsid_in => 'osb_server_title',
    p_type_resource_bundle_in => 'oracle.sysman.db.rsc.ob');
END;
/

BEGIN 
emd_loader.end_metadata_set('osb_server','1.0','MGMT_TARGET_TYPE_VERSIONS');
END;
/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Status',
        p_column_label_nlsid => 'osb_server_resp_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'State',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'State',
        p_column_label_nlsid => 'osb_server_resp_state',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Message',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Message',
        p_column_label_nlsid => 'osb_server_resp_mesg',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osb_server',
    p_metric_name => 'Response',
    p_type_meta_ver => '1.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Response',
    p_metric_label_nlsid => 'osb_server_resp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'osb_server_dev_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Type',
        p_column_label_nlsid => 'osb_server_dev_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Library',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Library',
        p_column_label_nlsid => 'osb_server_dev_lib',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Slot',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Slot',
        p_column_label_nlsid => 'osb_server_dev_slot',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Status',
        p_column_label_nlsid => 'osb_server_dev_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Active',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active',
        p_column_label_nlsid => 'osb_server_dev_active',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Cleanreq',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Cleaning Required',
        p_column_label_nlsid => 'osb_server_dev_cleanreq',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Mediaserver',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Media Server',
        p_column_label_nlsid => 'osb_server_mediaserver',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Vendor',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Vendor',
        p_column_label_nlsid => 'osb_server_dev_vendor',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Firmware',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Firmware',
        p_column_label_nlsid => 'osb_server_dev_firmware',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Component',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Component',
        p_column_label_nlsid => 'osb_server_res_component',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Process',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Process',
        p_column_label_nlsid => 'osb_server_res_process',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Host',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Host',
        p_column_label_nlsid => 'osb_server_res_host',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osb_server',
    p_metric_name => 'DeviceList',
    p_type_meta_ver => '1.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Devices',
    p_metric_label_nlsid => 'osb_server_devices',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'JobId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Operation Id',
        p_column_label_nlsid => 'osb_server_job_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Type',
        p_column_label_nlsid => 'osb_server_job_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'State',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'State',
        p_column_label_nlsid => 'osb_server_job_state',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'RunOnHost',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Run on Host',
        p_column_label_nlsid => 'osb_server_job_runonhost',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Info',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Additonal Information',
        p_column_label_nlsid => 'osb_server_job_information',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osb_server',
    p_metric_name => 'Jobs',
    p_type_meta_ver => '1.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Operations',
    p_metric_label_nlsid => 'osb_server_jobs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
emd_loader.end_metadata_set('osb_server','1.0','MGMT_METRICS');
END;
/

BEGIN 
MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osb_server',
              v_type_meta_ver => '1.0',
              v_property_name => 'InstallHome',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Installation Path',
              v_property_display_nlsid => 'osb_server_home_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osb_server',
              v_type_meta_ver => '1.0',
              v_property_name => 'AdminHost',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Administrative Server Host Name',
              v_property_display_nlsid => 'osb_server_host_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osb_server',
              v_type_meta_ver => '1.0',
              v_property_name => 'UserName',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Username',
              v_property_display_nlsid => 'osb_server_username_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osb_server',
              v_type_meta_ver => '1.0',
              v_property_name => 'password',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Password',
              v_property_display_nlsid => 'osb_server_password_iprop',
              v_required_flag => 1,
              v_credential_flag => 1,
              v_default_value => '',
              v_computed_flag => 0 );

END;
/

BEGIN 
emd_loader.end_metadata_set('osb_server','1.0','MGMT_TARGET_PROP_DEFS');
END;
/
commit;
