rem handle target type osm_instance

BEGIN 
mgmt_target.register_target_type(
    p_target_type_in => 'osm_instance',
    p_type_meta_ver_in => '3.7',
    p_type_display_name_in => 'Automatic Storage Management',
    p_type_display_nlsid_in => 'oracle_storage_manager',
    p_type_resource_bundle_in => 'oracle.sysman.db.rsc');
END;
/

BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_TARGET_TYPE_VERSIONS');
END;
/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Status',
        p_column_label_nlsid => 'osm_instance_resp_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Response',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Response',
    p_metric_label_nlsid => 'osm_instance_resp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group Name',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'total_mb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size (MB)',
        p_column_label_nlsid => 'osm_instance_total_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'free_mb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Free (MB)',
        p_column_label_nlsid => 'osm_instance_free_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Redundancy',
        p_column_label_nlsid => 'osm_instance_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'percent_used',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Used %',
        p_column_label_nlsid => 'osm_instance_used_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'DiskGroup_Usage',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Disk Group Usage',
    p_metric_label_nlsid => 'osm_instance_diskgroup_usage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 1,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group Name',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'total_mb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size (MB)',
        p_column_label_nlsid => 'osm_instance_total_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'free_mb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Free (MB)',
        p_column_label_nlsid => 'osm_instance_free_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Redundancy',
        p_column_label_nlsid => 'osm_instance_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usable_file_mb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Usable Free (MB)',
        p_column_label_nlsid => 'osm_instance_usable_file_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usable_total_mb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Usable (MB)',
        p_column_label_nlsid => 'osm_instance_usable_total_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'percent_used',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Used %',
        p_column_label_nlsid => 'osm_instance_used_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'safe_percent_used',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Used % of Safely Usable',
        p_column_label_nlsid => 'osm_instance_102_used_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'DiskGroup_Usage',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Disk Group Usage',
    p_metric_label_nlsid => 'osm_instance_diskgroup_usage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'group_number',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Group Number',
        p_column_label_nlsid => 'osm_instance_group_number',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'group_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Group Name',
        p_column_label_nlsid => 'osm_instance_group_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'disk_number',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Number',
        p_column_label_nlsid => 'osm_instance_disk_number',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'disk_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Name',
        p_column_label_nlsid => 'osm_instance_disk_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'disk_path',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Path',
        p_column_label_nlsid => 'osm_instance_disk_path',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Disk_Path',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Disk Path',
    p_metric_label_nlsid => 'osm_instance_disk_path',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group Name',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'db_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Database Name',
        p_column_label_nlsid => 'osm_instance_db_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'total_mb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Bytes',
        p_column_label_nlsid => 'osm_instance_total_bytes',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Database_DiskGroup_Usage',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Database Disk Group Usage',
    p_metric_label_nlsid => 'osm_instance_database_diskgroup_usage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inst_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Instance ID',
        p_column_label_nlsid => 'osm_instance_inst_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'disk_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Name',
        p_column_label_nlsid => 'osm_instance_disk_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_write_errs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Write Errors',
        p_column_label_nlsid => 'osm_instance_read_write_errs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Response Time',
        p_column_label_nlsid => 'osm_instance_read_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Response Time',
        p_column_label_nlsid => 'osm_instance_write_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time',
        p_column_label_nlsid => 'osm_instance_io_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'reads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Reads Per Second',
        p_column_label_nlsid => 'osm_instance_reads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Writes Per Second',
        p_column_label_nlsid => 'osm_instance_writes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IOPS',
        p_column_label_nlsid => 'osm_instance_io_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Throughput',
        p_column_label_nlsid => 'osm_instance_read_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Throughput',
        p_column_label_nlsid => 'osm_instance_write_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Throughput',
        p_column_label_nlsid => 'osm_instance_io_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Size (MB)',
        p_column_label_nlsid => 'osm_instance_io_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Size (MB)',
        p_column_label_nlsid => 'osm_instance_read_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Size (MB)',
        p_column_label_nlsid => 'osm_instance_write_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Instance_Disk_Performance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Instance Disk Performance',
    p_metric_label_nlsid => 'osm_instance_inst_disk_performance',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'disk_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Name',
        p_column_label_nlsid => 'osm_instance_disk_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_write_errs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Write Errors',
        p_column_label_nlsid => 'osm_instance_read_write_errs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Response Time',
        p_column_label_nlsid => 'osm_instance_read_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Response Time',
        p_column_label_nlsid => 'osm_instance_write_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time',
        p_column_label_nlsid => 'osm_instance_io_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'reads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Reads Per Second',
        p_column_label_nlsid => 'osm_instance_reads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Writes Per Second',
        p_column_label_nlsid => 'osm_instance_writes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => '>I/O per second',
        p_column_label_nlsid => 'osm_instance_io_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Throughput',
        p_column_label_nlsid => 'osm_instance_read_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Throughput',
        p_column_label_nlsid => 'osm_instance_write_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Throughput',
        p_column_label_nlsid => 'osm_instance_io_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Size (MB)',
        p_column_label_nlsid => 'osm_instance_io_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Size (MB)',
        p_column_label_nlsid => 'osm_instance_read_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Size (MB)',
        p_column_label_nlsid => 'osm_instance_write_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Disk_Performance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Cluster Disk Performance',
    p_metric_label_nlsid => 'osm_instance_disk_performance',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inst_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Instance ID',
        p_column_label_nlsid => 'osm_instance_inst_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'reads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Reads per second',
        p_column_label_nlsid => 'osm_instance_reads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Writes per second',
        p_column_label_nlsid => 'osm_instance_writes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'I/O per second',
        p_column_label_nlsid => 'osm_instance_io_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Throughput',
        p_column_label_nlsid => 'osm_instance_read_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Throughput',
        p_column_label_nlsid => 'osm_instance_writes_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Throughput',
        p_column_label_nlsid => 'osm_instance_io_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Response Time',
        p_column_label_nlsid => 'osm_instance_read_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Response Time',
        p_column_label_nlsid => 'osm_instance_write_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time',
        p_column_label_nlsid => 'osm_instance_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Size (MB)',
        p_column_label_nlsid => 'osm_instance_io_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Size (MB)',
        p_column_label_nlsid => 'osm_instance_read_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Size (MB)',
        p_column_label_nlsid => 'osm_instance_write_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Instance_DiskGroup_Performance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Instance Disk Group Performance',
    p_metric_label_nlsid => 'osm_instance_inst_disk_group_performance',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Response Time',
        p_column_label_nlsid => 'osm_instance_read_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Response Time',
        p_column_label_nlsid => 'osm_instance_write_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time',
        p_column_label_nlsid => 'osm_instance_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'reads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Reads per second',
        p_column_label_nlsid => 'osm_instance_reads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Writes per second',
        p_column_label_nlsid => 'osm_instance_writes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'I/O per second',
        p_column_label_nlsid => 'osm_instance_io_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Throughput',
        p_column_label_nlsid => 'osm_instance_read_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Throughput',
        p_column_label_nlsid => 'osm_instance_writes_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Throughput',
        p_column_label_nlsid => 'osm_instance_io_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Size (MB)',
        p_column_label_nlsid => 'osm_instance_io_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Size (MB)',
        p_column_label_nlsid => 'osm_instance_read_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Size (MB)',
        p_column_label_nlsid => 'osm_instance_write_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Single_Instance_DiskGroup_Performance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Single Instance Disk Group Performance',
    p_metric_label_nlsid => 'osm_instance_single_instance_disk_group_performance',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'reads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Reads per second',
        p_column_label_nlsid => 'osm_instance_reads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Writes per second',
        p_column_label_nlsid => 'osm_instance_writes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'I/O per second',
        p_column_label_nlsid => 'osm_instance_io_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Throughput',
        p_column_label_nlsid => 'osm_instance_read_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Throughput',
        p_column_label_nlsid => 'osm_instance_write_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Throughput',
        p_column_label_nlsid => 'osm_instance_io_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Response Time',
        p_column_label_nlsid => 'osm_instance_read_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Response Time',
        p_column_label_nlsid => 'osm_instance_write_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time',
        p_column_label_nlsid => 'osm_instance_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Size (MB)',
        p_column_label_nlsid => 'osm_instance_io_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Size (MB)',
        p_column_label_nlsid => 'osm_instance_read_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Size (MB)',
        p_column_label_nlsid => 'osm_instance_write_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'DiskGroup_Performance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Cluster Disk Group Performance',
    p_metric_label_nlsid => 'osm_instance_disk_group_performance',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskGroup',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sImbalance',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Size Imbalance (%)',
        p_column_label_nlsid => 'partner_space_imbalance_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pImbalance',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Count Imbalance Variance',
        p_column_label_nlsid => 'partner_count_imbalance',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failGrpCnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Failure Group Count',
        p_column_label_nlsid => 'failGroup_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'diskgroup_fg_imbalance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Failure Group Imbalance Status',
    p_metric_label_nlsid => 'diskgroup_fg_imbalance',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskGroup',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'imbalance',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Actual Imbalance (%)',
        p_column_label_nlsid => 'actual_imbalance_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'variance',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Size Variance (%)',
        p_column_label_nlsid => 'disk_size_variance_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'minFree',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Actual Minimum Percent Free',
        p_column_label_nlsid => 'actual_min_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskCnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Count',
        p_column_label_nlsid => 'disk_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rebalInProgress',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Rebalance In Progress',
        p_column_label_nlsid => 'rebal_in_progress',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'computedImbalance',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Imbalance (%) without Rebalance',
        p_column_label_nlsid => 'imbalance_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'computedMinFree',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Minimum Free (%) without Rebalance',
        p_column_label_nlsid => 'min_free_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'computedMaxUsed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Maximum Used (%) with Rebalance',
        p_column_label_nlsid => 'maximum_used_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'diskgroup_imbalance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Disk Group Imbalance Status',
    p_metric_label_nlsid => 'diskgroup_imbalance_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskGroup',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'failureGroup',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Failure Group',
        p_column_label_nlsid => 'failure_group_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fgDiskCount',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Disks',
        p_column_label_nlsid => 'disk_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fgAvailDiskCount',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Available Disks',
        p_column_label_nlsid => 'available_disks',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fgAlertDiskCount',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Count for Alerts',
        p_column_label_nlsid => 'alert_disk_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'unavailable_failure_group',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Failure Group Status',
    p_metric_label_nlsid => 'failure_group_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Timestamp/LineNumber',
        p_column_label_nlsid => 'oracle_database_alertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Error Stack',
        p_column_label_nlsid => 'oracle_database_alertLog_genericErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archiveHungErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Archive Hung Error Stack',
        p_column_label_nlsid => 'oracle_database_alertLog_archiveHungErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'blockCorruptErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Block Corruption Error Stack',
        p_column_label_nlsid => 'oracle_database_alertLog_blockCorruptErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Session Terminated Error Stack',
        p_column_label_nlsid => 'oracle_database_alertLog_sessTerminateErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Media Failure Error Stack',
        p_column_label_nlsid => 'oracle_database_alertLog_mediaFailureErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'traceFileName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Error Stack Trace File Name',
        p_column_label_nlsid => 'oracle_database_alertLog_traceFileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'oracle_database_alertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'alertLog',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Alert Log',
    p_metric_label_nlsid => 'oracle_database_alertLog',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Generic Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_genericErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Alert Log Error Status',
        p_short_name_nlsid => 'alertLogStatus_genericErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'archiveHungErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Archiver Hung Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_archiveHungErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Archiver Hung Alert Log Error Status',
        p_short_name_nlsid => 'alertLogStatus_archiveHungErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'blockCorruptErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Block Corruption Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_blockCorruptErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Block Corruption Error Status',
        p_short_name_nlsid => 'alertLogStatus_blockCorruptErrors_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Terminated Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_sessTerminateErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Terminated Error Status',
        p_short_name_nlsid => 'alertLogStatus_sessTerminateErrors_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Media Failure Alert Log Error Status',
        p_column_label_nlsid => 'alertLogStatus_mediaFailureErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Media Failure Error Status',
        p_short_name_nlsid => 'alertLogStatus_mediaFailureErrors_sht',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'alertLogStatus',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Alert Log Error Status',
    p_metric_label_nlsid => 'alertLogStatus',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogContent',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Content',
        p_column_label_nlsid => 'oracle_database_alertLog_content',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'alertLogContent',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'Alert Log Content',
    p_metric_label_nlsid => 'oracle_database_alertLogContent',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskGroup',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'diskGroup',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'problem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'problem',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'osm_diskGroupPolicies',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'osm_diskGroupPolicies',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group Name',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'disk_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Name',
        p_column_label_nlsid => 'osm_instance_disk_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mode_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Mode Status',
        p_column_label_nlsid => 'osm_instance_disk_mode_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'disk_status',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Disk Status',
    p_metric_label_nlsid => 'disk_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'offline_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Offline Disk Count',
        p_column_label_nlsid => 'disk_status_rollup',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'disk_status_rollup',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Offline Disk Count',
    p_metric_label_nlsid => 'disk_status_rollup',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'volume_device',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Volume Device',
        p_column_label_nlsid => 'volume_device',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_mountpoint',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ASM Cluster File System Mount Point',
        p_column_label_nlsid => 'ofs_mountpoint',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_mount_state',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ASM Cluster File System Mount State',
        p_column_label_nlsid => 'ofs_mount_state',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_availability',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ASM Cluster File System Availability',
        p_column_label_nlsid => 'ofs_availability',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_uptime',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ASM Cluster File System Available Time',
        p_column_label_nlsid => 'ofs_uptime',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_host',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Host',
        p_column_label_nlsid => 'ofs_host',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'OFS_State',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'ASM Cluster File System State',
    p_metric_label_nlsid => 'ofs_state_metric_name',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_volume_device',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Volume Device',
        p_column_label_nlsid => 'volume_device',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_volume_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Volume Name',
        p_column_label_nlsid => 'volume_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_corrupted_state',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Corrupt',
        p_column_label_nlsid => 'ofs_corrupt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_alloc_size_gb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Allocated Space (GB)',
        p_column_label_nlsid => 'dg_alloc_size_gb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_size_gb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size (GB)',
        p_column_label_nlsid => 'ofs_size_gb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_free_gb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free (GB)',
        p_column_label_nlsid => 'ofs_free_gb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_used_gb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Used (GB)',
        p_column_label_nlsid => 'ofs_used_gb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_snap_used_mb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Used (MB)',
        p_column_label_nlsid => 'ofs_snap_used_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_diskgroup',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'ofs_diskgroup',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ofs_used_pct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Used (%)',
        p_column_label_nlsid => 'ofs_used_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Single_Instance_OFS_Summary',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'ASM Cluster File System',
    p_metric_label_nlsid => 'single_instance_ofs_summary_metric_name',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'volume_device',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Volume Device',
        p_column_label_nlsid => 'volume_device',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'volume_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Volume Name',
        p_column_label_nlsid => 'volume_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'volume_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Status',
        p_column_label_nlsid => 'volume_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'volume_usage',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Usage',
        p_column_label_nlsid => 'volume_usage',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'volume_mountpath',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Mount Point',
        p_column_label_nlsid => 'volume_mountpoint',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'size_gb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size (GB)',
        p_column_label_nlsid => 'volume_size_gb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_alloc_size_gb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Group Allocated Space (GB)',
        p_column_label_nlsid => 'dg_alloc_size_gb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskgroup',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group',
        p_column_label_nlsid => 'volume_diskgroup',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redundancy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Redundancy',
        p_column_label_nlsid => 'volume_redundancy',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'host',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Host',
        p_column_label_nlsid => 'volume_host',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Volumes_Summary',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'ASM Volumes',
    p_metric_label_nlsid => 'volumes_summary_metric_name',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inst_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Instance ID',
        p_column_label_nlsid => 'osm_instance_inst_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group Name',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'volume_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Volume Name',
        p_column_label_nlsid => 'volume_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_write_errs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Write Errors',
        p_column_label_nlsid => 'osm_instance_read_write_errs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'reads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Reads Per Second',
        p_column_label_nlsid => 'osm_instance_reads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Writes Per Second',
        p_column_label_nlsid => 'osm_instance_writes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'I/O per second',
        p_column_label_nlsid => 'osm_instance_io_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Throughput',
        p_column_label_nlsid => 'osm_instance_read_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Throughput',
        p_column_label_nlsid => 'osm_instance_write_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Throughput',
        p_column_label_nlsid => 'osm_instance_io_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Response Time',
        p_column_label_nlsid => 'osm_instance_read_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Response Time',
        p_column_label_nlsid => 'osm_instance_write_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time',
        p_column_label_nlsid => 'osm_instance_io_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Size (MB)',
        p_column_label_nlsid => 'osm_instance_io_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Size (MB)',
        p_column_label_nlsid => 'osm_instance_read_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Size (MB)',
        p_column_label_nlsid => 'osm_instance_write_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Instance_Volume_Performance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Instance Volume Performance',
    p_metric_label_nlsid => 'volume_inst_performance',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dg_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Group Name',
        p_column_label_nlsid => 'osm_instance_dg_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'volume_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Volume Name',
        p_column_label_nlsid => 'volume_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_write_errs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Write Errors',
        p_column_label_nlsid => 'osm_instance_read_write_errs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'reads_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Reads per second',
        p_column_label_nlsid => 'osm_instance_reads_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writes_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Writes per second',
        p_column_label_nlsid => 'osm_instance_writes_ps',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_ps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'I/O per second',
        p_column_label_nlsid => 'osm_instance_io_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Throughput',
        p_column_label_nlsid => 'osm_instance_read_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Throughput',
        p_column_label_nlsid => 'osm_instance_writes_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_throughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Throughput',
        p_column_label_nlsid => 'osm_instance_io_throughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Response Time',
        p_column_label_nlsid => 'osm_instance_read_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Response Time',
        p_column_label_nlsid => 'osm_instance_write_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_response_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Response Time',
        p_column_label_nlsid => 'osm_instance_response_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'io_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'IO Size (MB)',
        p_column_label_nlsid => 'osm_instance_io_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'read_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Read Size (MB)',
        p_column_label_nlsid => 'osm_instance_read_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'write_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Write Size (MB)',
        p_column_label_nlsid => 'osm_instance_write_size_mb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'Volume_Performance',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Cluster Volume Performance',
    p_metric_label_nlsid => 'volume_cluster_inst_performance',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'severity_index',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'severity_index',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'critical_incidents',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'critical_incidents',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'warning_incidents',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'warning_incidents',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'incident_meter',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_COLLECT_UPLOAD,
    p_metric_label => 'incident_meter',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dummy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dummy',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'adr_viewer',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'adr_viewer',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'timeLine',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'errorCategory',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'errorCategory',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericInternalErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'genericInternalErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'sessTerminateErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'internalSqlErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'internalSqlErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'accessViolationErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'accessViolationErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fileAccessErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'fileAccessErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outOfMemoryErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'outOfMemoryErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'clusterErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'deadlockErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'deadlockErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'asmBlockCorruptionErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'asmBlockCorruptionErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redoLogCorruptionErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'redoLogCorruptionErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericIncidentErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'genericIncidentErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericCheckerFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'genericCheckerFailureErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dataBlockCorruptionErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'dataBlockCorruptionErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'mediaFailureErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericOperationalErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'genericOperationalErrStack',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'traceFileName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'traceFileName',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'errCodes',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'errCodes',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'alertLogName',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'impact',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'impact',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'incidentId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'incidentId',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'numberOfFailures',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'numberOfFailures',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'adrAlertLogError',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
    p_metric_label => 'adrAlertLogError',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'adrAlertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Time/Line Number',
        p_short_name_nlsid => 'adrAlertLog_timeLine',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericIncidentErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Generic Incident',
        p_column_label_nlsid => 'adrAlertLog_genericIncidentErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Incident',
        p_short_name_nlsid => 'adrAlertLog_genericIncidentErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericInternalErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Generic Internal Error',
        p_column_label_nlsid => 'adrAlertLog_genericInternalErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Internal Error',
        p_short_name_nlsid => 'adrAlertLog_genericInternalErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Session Terminated',
        p_column_label_nlsid => 'adrAlertLog_sessTerminateErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Terminated',
        p_short_name_nlsid => 'adrAlertLog_sessTerminateErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'internalSqlErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Internal SQL Error',
        p_column_label_nlsid => 'adrAlertLog_internalSqlErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Internal SQL Error',
        p_short_name_nlsid => 'adrAlertLog_internalSqlErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'accessViolationErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Access Violation',
        p_column_label_nlsid => 'adrAlertLog_accessViolationErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Access Violation',
        p_short_name_nlsid => 'adrAlertLog_accessViolationErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fileAccessErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File Access Error',
        p_column_label_nlsid => 'adrAlertLog_fileAccessErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'File Access Error',
        p_short_name_nlsid => 'adrAlertLog_fileAccessErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outOfMemoryErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Out of Memory',
        p_column_label_nlsid => 'adrAlertLog_outOfMemoryErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Out of Memory',
        p_short_name_nlsid => 'adrAlertLog_outOfMemoryErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Cluster Error',
        p_column_label_nlsid => 'adrAlertLog_clusterErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cluster Error',
        p_short_name_nlsid => 'adrAlertLog_clusterErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'deadlockErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Deadlock',
        p_column_label_nlsid => 'adrAlertLog_deadlockErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Deadlock',
        p_short_name_nlsid => 'adrAlertLog_deadlockErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'asmBlockCorruptionErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'ASM Block Corruption',
        p_column_label_nlsid => 'adrAlertLog_asmBlockCorruptionErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'ASM Block Corruption',
        p_short_name_nlsid => 'adrAlertLog_asmBlockCorruptionErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redoLogCorruptionErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Redo Log Corruption',
        p_column_label_nlsid => 'adrAlertLog_redoLogCorruptionErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Log Corruption',
        p_short_name_nlsid => 'adrAlertLog_redoLogCorruptionErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'traceFileName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Error Trace File',
        p_column_label_nlsid => 'adrAlertLog_traceFileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Error Trace File',
        p_short_name_nlsid => 'adrAlertLog_traceFileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'adrAlertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Name',
        p_short_name_nlsid => 'adrAlertLog_fileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'impact',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Impact',
        p_column_label_nlsid => 'adrAlertLog_impact',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Impact',
        p_short_name_nlsid => 'adrAlertLog_impact',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'incidentId',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Incident ID',
        p_column_label_nlsid => 'adrAlertLog_incidentId',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Incident ID',
        p_short_name_nlsid => 'adrAlertLog_incidentId',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'adrAlertLogIncidentError',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Incident',
    p_metric_label_nlsid => 'adrAlertLogIncidentError',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'adrAlertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Time/Line Number',
        p_short_name_nlsid => 'adrAlertLog_timeLine',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericOperationalErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Generic Operational Error',
        p_column_label_nlsid => 'adrAlertLog_genericOperationalErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Operational Error',
        p_short_name_nlsid => 'adrAlertLog_genericOperationalErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dataBlockCorruptionErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data Block Corruption',
        p_column_label_nlsid => 'adrAlertLog_dataBlockCorruptionErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Block Corruption',
        p_short_name_nlsid => 'adrAlertLog_dataBlockCorruptionErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Media Failure',
        p_column_label_nlsid => 'adrAlertLog_mediaFailureErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Media Failure',
        p_short_name_nlsid => 'adrAlertLog_mediaFailureErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'traceFileName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Error Trace File',
        p_column_label_nlsid => 'adrAlertLog_traceFileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Error Trace File',
        p_short_name_nlsid => 'adrAlertLog_traceFileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'adrAlertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Name',
        p_short_name_nlsid => 'adrAlertLog_fileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'adrAlertLogOperationalError',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Operational Error',
    p_metric_label_nlsid => 'adrAlertLogOperationalError',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'adrAlertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Time/Line Number',
        p_short_name_nlsid => 'adrAlertLog_timeLine',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericCheckerFailureErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Checker Failure Detected',
        p_column_label_nlsid => 'adrAlertLog_genericCheckerFailureErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Checker Failure Detected',
        p_short_name_nlsid => 'adrAlertLog_genericCheckerFailureErrStack',
        p_is_for_summary => 1,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'numberOfFailures',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Number of Failures',
        p_column_label_nlsid => 'adrAlertLog_numberOfFailures',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Number of Failures',
        p_short_name_nlsid => 'adrAlertLog_numberOfFailures',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'adrAlertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alert Log Name',
        p_short_name_nlsid => 'adrAlertLog_fileName',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'adrAlertLogCheckerFailure',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Checker Failure',
    p_metric_label_nlsid => 'adrAlertLogCheckerFailure',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericIncidentErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Generic Incident Status',
        p_column_label_nlsid => 'adrAlertLogStatus_genericIncidentErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Incident Status',
        p_short_name_nlsid => 'adrAlertLogStatus_genericIncidentErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericInternalErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Generic Internal Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_genericInternalErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Internal Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_genericInternalErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sessTerminateErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Session Terminated Status',
        p_column_label_nlsid => 'adrAlertLogStatus_sessTerminateErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Session Terminated Status',
        p_short_name_nlsid => 'adrAlertLogStatus_sessTerminateErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'internalSqlErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Internal SQL Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_internalSqlErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Internal SQL Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_internalSqlErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'accessViolationErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Access Violation Status',
        p_column_label_nlsid => 'adrAlertLogStatus_accessViolationErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Access Violation Status',
        p_short_name_nlsid => 'adrAlertLogStatus_accessViolationErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fileAccessErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'File Access Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_fileAccessErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'File Access Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_fileAccessErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outOfMemoryErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Out of Memory Status',
        p_column_label_nlsid => 'adrAlertLogStatus_outOfMemoryErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Out of Memory Status',
        p_short_name_nlsid => 'adrAlertLogStatus_outOfMemoryErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Cluster Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_clusterErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Cluster Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_clusterErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'deadlockErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Deadlock Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_deadlockErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Deadlock Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_deadlockErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'asmBlockCorruptionErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'ASM Block Corruption Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_asmBlockCorruptionErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'ASM Block Corruption Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_asmBlockCorruptionErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'redoLogCorruptionErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Redo Log Corruption Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_redoLogCorruptionErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Redo Log Corruption Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_redoLogCorruptionErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'adrAlertLogIncidentErrorStatus',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Incident Status',
    p_metric_label_nlsid => 'adrAlertLogIncidentErrorStatus',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'genericOperationalErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Generic Operational Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_genericOperationalErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Generic Operational Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_genericOperationalErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'dataBlockCorruptionErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Data Block Corruption Error Status',
        p_column_label_nlsid => 'adrAlertLogStatus_dataBlockCorruptionErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Data Block Corruption Error Status',
        p_short_name_nlsid => 'adrAlertLogStatus_dataBlockCorruptionErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mediaFailureErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Media Failure Status',
        p_column_label_nlsid => 'adrAlertLogStatus_mediaFailureErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Media Failure Status',
        p_short_name_nlsid => 'adrAlertLogStatus_mediaFailureErrors',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'adrAlertLogOperationalErrorStatus',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Operational Error Status',
    p_metric_label_nlsid => 'adrAlertLogOperationalErrorStatus',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logContent',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'logContent',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'adrAlertLogContent',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'adrAlertLogContent',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resource_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Resource Name',
        p_column_label_nlsid => 'resource_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'osm_instance',
    p_metric_name => 'cluster_resource_name',
    p_type_meta_ver => '3.7',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_COLLECT_UPLOAD,
    p_metric_label => 'Cluster Resource',
    p_metric_label_nlsid => 'cluster_resource_name',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_METRICS');
END;
/

BEGIN 
MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osm_instance',
              v_type_meta_ver => '3.7',
              v_property_name => 'OracleHome',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Oracle home path',
              v_property_display_nlsid => 'oracle_database_OracleHome_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osm_instance',
              v_type_meta_ver => '3.7',
              v_property_name => 'UserName',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Username',
              v_property_display_nlsid => 'oracle_database_UserName_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osm_instance',
              v_type_meta_ver => '3.7',
              v_property_name => 'password',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Password',
              v_property_display_nlsid => 'oracle_database_password_iprop',
              v_required_flag => 1,
              v_credential_flag => 1,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osm_instance',
              v_type_meta_ver => '3.7',
              v_property_name => 'Role',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Role',
              v_property_display_nlsid => 'oracle_database_role_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osm_instance',
              v_type_meta_ver => '3.7',
              v_property_name => 'MachineName',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Machine name',
              v_property_display_nlsid => 'oracle_database_MachineName_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osm_instance',
              v_type_meta_ver => '3.7',
              v_property_name => 'Port',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Port',
              v_property_display_nlsid => 'oracle_database_Port_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'osm_instance',
              v_type_meta_ver => '3.7',
              v_property_name => 'SID',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'SID',
              v_property_display_nlsid => 'oracle_database_SID_iprop',
              v_required_flag => 1,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

END;
/

BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_TARGET_PROP_DEFS');
END;
/
DECLARE
  l_ref MGMT_CRED_TYPE_REF;
  l_ref_list MGMT_CRED_TYPE_REF_ARRAY;
  l_type_column MGMT_CRED_TYPE_COL_RECORD;
  l_type_column_list MGMT_CRED_TYPE_COL_ARRAY;
  l_type_col_val MGMT_CRED_TYPE_COL_VAL;
  l_type_col_val_list MGMT_CRED_TYPE_COL_VAL_ARRAY; 
  l_ref_type_meta_ver MGMT_METRICS.TYPE_META_VER%TYPE; 
  col_count INTEGER;
  ref_count INTEGER;
  l_type_column_display_name MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NAME%TYPE;
  l_type_column_display_nlsid MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NLSID%TYPE;
  l_key MGMT_CREDENTIAL_TYPE_COLUMNS.KEY%TYPE;
BEGIN 

l_ref_list := MGMT_CRED_TYPE_REF_ARRAY();
l_type_column_list := MGMT_CRED_TYPE_COL_ARRAY();

emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPE_REF');
select MAX(target_type_meta_ver) into l_ref_type_meta_ver from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database';
l_ref := MGMT_CRED_TYPE_REF(
           ref_name => 'DBRef',
           type_name => 'DBCreds',
           target_type => 'oracle_database',
           ref_type_meta_ver =>  l_ref_type_meta_ver,
            association => 'self');
l_ref_list.extend(1);
ref_count := l_ref_list.count;
l_ref_list(ref_count) :=  l_ref;

emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPE_COLUMNS');
select unique type_column_display_name into l_type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBUserName' and rownum = 1;
select unique type_column_display_nlsid into l_type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBUserName' and rownum = 1;
select unique key into l_key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBUserName' and rownum = 1;
l_type_column := MGMT_CRED_TYPE_COL_RECORD(
    type_column_name => 'DBUserName',
    ref_name => 'DBRef',
    ref_column_name => 'DBUserName',
    type_column_display_name => l_type_column_display_name,
    type_column_display_nlsid => l_type_column_display_nlsid,
      key => l_key,
    col_values => NULL 
    );
l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPE_COLUMNS');
select unique type_column_display_name into l_type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBPassword' and rownum = 1;
select unique type_column_display_nlsid into l_type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBPassword' and rownum = 1;
select unique key into l_key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBPassword' and rownum = 1;
l_type_column := MGMT_CRED_TYPE_COL_RECORD(
    type_column_name => 'DBPassword',
    ref_name => 'DBRef',
    ref_column_name => 'DBPassword',
    type_column_display_name => l_type_column_display_name,
    type_column_display_nlsid => l_type_column_display_nlsid,
      key => l_key,
    col_values => NULL 
    );
l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPE_COLUMNS');
select unique type_column_display_name into l_type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBRole' and rownum = 1;
select unique type_column_display_nlsid into l_type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBRole' and rownum = 1;
select unique key into l_key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBRole' and rownum = 1;
l_type_column := MGMT_CRED_TYPE_COL_RECORD(
    type_column_name => 'DBRole',
    ref_name => 'DBRef',
    ref_column_name => 'DBRole',
    type_column_display_name => l_type_column_display_name,
    type_column_display_nlsid => l_type_column_display_nlsid,
      key => l_key,
    col_values => NULL 
    );
l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
mgmt_credential.create_credential_type( 
       p_target_type => 'osm_instance',
       p_type_name => 'ASMCreds',
       p_target_type_meta_ver => '3.7',
       p_type_display_name => 'ASM Credentials',
       p_type_display_nlsid => 'CREDS_ASM_CREDS',
       p_description => '' ,
       p_refs => l_ref_list,
       p_type_columns => l_type_column_list
        );
EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  BEGIN 
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPES ( target_type, target_type_meta_ver, type_name, type_display_name, type_display_nlsid, description ) values ( 'osm_instance','3.7','ASMCreds','ASM Credentials','CREDS_ASM_CREDS','' );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
      update MGMT_CREDENTIAL_TYPES set 
         target_type = 'osm_instance',
         target_type_meta_ver = '3.7',
         type_name = 'ASMCreds',
         type_display_name = 'ASM Credentials',
         type_display_nlsid = 'CREDS_ASM_CREDS',
         description = ''
      WHERE
         target_type = 'osm_instance' AND 
         target_type_meta_ver = '3.7' AND 
         type_name = 'ASMCreds';
    END;
     BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_REF ( target_type, target_type_meta_ver, type_name, ref_name, ref_type_name, ref_target_type, ref_type_meta_ver, association ) values ( 'osm_instance','3.7','ASMCreds','DBRef','DBCreds','oracle_database',    (select MAX(target_type_meta_ver) from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database'),'oracle_database' );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_REF SET 
        target_type = 'osm_instance',
        target_type_meta_ver = '3.7',
        type_name = 'ASMCreds',
        ref_name = 'DBRef',
        ref_type_name = 'DBCreds',
        ref_target_type = 'oracle_database',
        ref_type_meta_ver = (select MAX(target_type_meta_ver) from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database'),
        association = 'self'
    WHERE 
        target_type = 'osm_instance' AND 
        target_type_meta_ver = '3.7' AND 
        type_name = 'ASMCreds' AND 
        ref_name = 'DBRef' AND 
        ref_type_name = 'DBCreds' AND 
        ref_target_type = 'oracle_database';
    END; 
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 
                                          'osm_instance','3.7','ASMCreds','DBUserName','DBRef','DBUserName',
(select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBUserName' and rownum = 1),
(select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBUserName' and rownum = 1),
(select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database' and type_name = 'DBCreds' and target_type_meta_ver = l_ref_type_meta_ver and type_column_name = 'DBUserName' and rownum = 1)
 );
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_COLUMNS set 
      target_type = 'osm_instance',
      target_type_meta_ver = '3.7',
      type_name = 'ASMCreds',
      type_column_name = 'DBUserName',
      ref_name = 'DBRef',
      ref_column_name = 'DBUserName',
      type_column_display_name = (select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBUserName' and rownum = 1),
      type_column_display_nlsid = (select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBUserName' and rownum = 1),
      key = (select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBUserName' and rownum = 1)
    WHERE 
      TARGET_TYPE = 'osm_instance' AND 
      TARGET_TYPE_META_VER = '3.7' AND 
      TYPE_NAME = 'ASMCreds' AND 
      TYPE_COLUMN_NAME = 'DBUserName';
    END;
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 
                                          'osm_instance','3.7','ASMCreds','DBPassword','DBRef','DBPassword',
(select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBPassword' and rownum = 1),
(select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBPassword' and rownum = 1),
(select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database' and type_name = 'DBCreds' and target_type_meta_ver = l_ref_type_meta_ver and type_column_name = 'DBPassword' and rownum = 1)
 );
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_COLUMNS set 
      target_type = 'osm_instance',
      target_type_meta_ver = '3.7',
      type_name = 'ASMCreds',
      type_column_name = 'DBPassword',
      ref_name = 'DBRef',
      ref_column_name = 'DBPassword',
      type_column_display_name = (select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBPassword' and rownum = 1),
      type_column_display_nlsid = (select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBPassword' and rownum = 1),
      key = (select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBPassword' and rownum = 1)
    WHERE 
      TARGET_TYPE = 'osm_instance' AND 
      TARGET_TYPE_META_VER = '3.7' AND 
      TYPE_NAME = 'ASMCreds' AND 
      TYPE_COLUMN_NAME = 'DBPassword';
    END;
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 
                                          'osm_instance','3.7','ASMCreds','DBRole','DBRef','DBRole',
(select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBRole' and rownum = 1),
(select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBRole' and rownum = 1),
(select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database' and type_name = 'DBCreds' and target_type_meta_ver = l_ref_type_meta_ver and type_column_name = 'DBRole' and rownum = 1)
 );
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_COLUMNS set 
      target_type = 'osm_instance',
      target_type_meta_ver = '3.7',
      type_name = 'ASMCreds',
      type_column_name = 'DBRole',
      ref_name = 'DBRef',
      ref_column_name = 'DBRole',
      type_column_display_name = (select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBRole' and rownum = 1),
      type_column_display_nlsid = (select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBRole' and rownum = 1),
      key = (select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'oracle_database' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'DBCreds' and type_column_name = 'DBRole' and rownum = 1)
    WHERE 
      TARGET_TYPE = 'osm_instance' AND 
      TARGET_TYPE_META_VER = '3.7' AND 
      TYPE_NAME = 'ASMCreds' AND 
      TYPE_COLUMN_NAME = 'DBRole';
    END;
  END;
 END;
/
BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPES');
END;
/
DECLARE
  l_ref MGMT_CRED_TYPE_REF;
  l_ref_list MGMT_CRED_TYPE_REF_ARRAY;
  l_type_column MGMT_CRED_TYPE_COL_RECORD;
  l_type_column_list MGMT_CRED_TYPE_COL_ARRAY;
  l_type_col_val MGMT_CRED_TYPE_COL_VAL;
  l_type_col_val_list MGMT_CRED_TYPE_COL_VAL_ARRAY; 
  l_ref_type_meta_ver MGMT_METRICS.TYPE_META_VER%TYPE; 
  col_count INTEGER;
  ref_count INTEGER;
  l_type_column_display_name MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NAME%TYPE;
  l_type_column_display_nlsid MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NLSID%TYPE;
  l_key MGMT_CREDENTIAL_TYPE_COLUMNS.KEY%TYPE;
BEGIN 

l_ref_list := MGMT_CRED_TYPE_REF_ARRAY();
l_type_column_list := MGMT_CRED_TYPE_COL_ARRAY();

emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPE_REF');
select MAX(target_type_meta_ver) into l_ref_type_meta_ver from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host';
l_ref := MGMT_CRED_TYPE_REF(
           ref_name => 'HostRef',
           type_name => 'HostCreds',
           target_type => 'host',
           ref_type_meta_ver =>  l_ref_type_meta_ver,
            association => 'host');
l_ref_list.extend(1);
ref_count := l_ref_list.count;
l_ref_list(ref_count) :=  l_ref;

emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPE_COLUMNS');
select unique type_column_display_name into l_type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1;
select unique type_column_display_nlsid into l_type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1;
select unique key into l_key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1;
l_type_column := MGMT_CRED_TYPE_COL_RECORD(
    type_column_name => 'HostUserName',
    ref_name => 'HostRef',
    ref_column_name => 'HostUserName',
    type_column_display_name => l_type_column_display_name,
    type_column_display_nlsid => l_type_column_display_nlsid,
      key => l_key,
    col_values => NULL 
    );
l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPE_COLUMNS');
select unique type_column_display_name into l_type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1;
select unique type_column_display_nlsid into l_type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1;
select unique key into l_key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host'  and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1;
l_type_column := MGMT_CRED_TYPE_COL_RECORD(
    type_column_name => 'HostPassword',
    ref_name => 'HostRef',
    ref_column_name => 'HostPassword',
    type_column_display_name => l_type_column_display_name,
    type_column_display_nlsid => l_type_column_display_nlsid,
      key => l_key,
    col_values => NULL 
    );
l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
mgmt_credential.create_credential_type( 
       p_target_type => 'osm_instance',
       p_type_name => 'DBHostCreds',
       p_target_type_meta_ver => '3.7',
       p_type_display_name => 'ASM Host Credentials',
       p_type_display_nlsid => 'CREDS_ASM_HOSTCREDS',
       p_description => '' ,
       p_refs => l_ref_list,
       p_type_columns => l_type_column_list
        );
EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  BEGIN 
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPES ( target_type, target_type_meta_ver, type_name, type_display_name, type_display_nlsid, description ) values ( 'osm_instance','3.7','DBHostCreds','ASM Host Credentials','CREDS_ASM_HOSTCREDS','' );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
      update MGMT_CREDENTIAL_TYPES set 
         target_type = 'osm_instance',
         target_type_meta_ver = '3.7',
         type_name = 'DBHostCreds',
         type_display_name = 'ASM Host Credentials',
         type_display_nlsid = 'CREDS_ASM_HOSTCREDS',
         description = ''
      WHERE
         target_type = 'osm_instance' AND 
         target_type_meta_ver = '3.7' AND 
         type_name = 'DBHostCreds';
    END;
     BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_REF ( target_type, target_type_meta_ver, type_name, ref_name, ref_type_name, ref_target_type, ref_type_meta_ver, association ) values ( 'osm_instance','3.7','DBHostCreds','HostRef','HostCreds','host',    (select MAX(target_type_meta_ver) from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host'),'host' );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_REF SET 
        target_type = 'osm_instance',
        target_type_meta_ver = '3.7',
        type_name = 'DBHostCreds',
        ref_name = 'HostRef',
        ref_type_name = 'HostCreds',
        ref_target_type = 'host',
        ref_type_meta_ver = (select MAX(target_type_meta_ver) from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host'),
        association = 'host'
    WHERE 
        target_type = 'osm_instance' AND 
        target_type_meta_ver = '3.7' AND 
        type_name = 'DBHostCreds' AND 
        ref_name = 'HostRef' AND 
        ref_type_name = 'HostCreds' AND 
        ref_target_type = 'host';
    END; 
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 
                                          'osm_instance','3.7','DBHostCreds','HostUserName','HostRef','HostUserName',
(select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1),
(select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1),
(select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host' and type_name = 'HostCreds' and target_type_meta_ver = l_ref_type_meta_ver and type_column_name = 'HostUserName' and rownum = 1)
 );
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_COLUMNS set 
      target_type = 'osm_instance',
      target_type_meta_ver = '3.7',
      type_name = 'DBHostCreds',
      type_column_name = 'HostUserName',
      ref_name = 'HostRef',
      ref_column_name = 'HostUserName',
      type_column_display_name = (select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1),
      type_column_display_nlsid = (select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1),
      key = (select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostUserName' and rownum = 1)
    WHERE 
      TARGET_TYPE = 'osm_instance' AND 
      TARGET_TYPE_META_VER = '3.7' AND 
      TYPE_NAME = 'DBHostCreds' AND 
      TYPE_COLUMN_NAME = 'HostUserName';
    END;
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 
                                          'osm_instance','3.7','DBHostCreds','HostPassword','HostRef','HostPassword',
(select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1),
(select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1),
(select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host' and type_name = 'HostCreds' and target_type_meta_ver = l_ref_type_meta_ver and type_column_name = 'HostPassword' and rownum = 1)
 );
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
    update MGMT_CREDENTIAL_TYPE_COLUMNS set 
      target_type = 'osm_instance',
      target_type_meta_ver = '3.7',
      type_name = 'DBHostCreds',
      type_column_name = 'HostPassword',
      ref_name = 'HostRef',
      ref_column_name = 'HostPassword',
      type_column_display_name = (select unique type_column_display_name from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1),
      type_column_display_nlsid = (select unique type_column_display_nlsid from MGMT_CREDENTIAL_TYPE_COLUMNS where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1),
      key = (select unique key from MGMT_CREDENTIAL_TYPE_COLUMNS  where target_type = 'host' and target_type_meta_ver = l_ref_type_meta_ver and type_name = 'HostCreds' and type_column_name = 'HostPassword' and rownum = 1)
    WHERE 
      TARGET_TYPE = 'osm_instance' AND 
      TARGET_TYPE_META_VER = '3.7' AND 
      TYPE_NAME = 'DBHostCreds' AND 
      TYPE_COLUMN_NAME = 'HostPassword';
    END;
  END;
 END;
/
BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_TYPES');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBUserName',
            set_column_name => 'sysDBAUserName',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'SYSDBA Username',
          set_column_display_nlsid => 'CREDS_SYSDBA_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBPassword',
            set_column_name => 'sysDBAPassword',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'SYSDBA Password',
          set_column_display_nlsid => 'CREDS_SYSDBA_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_col_val := MGMT_CRED_SET_COL_VAL(
                       value => 'SYSDBA',
                          default_value => 0 
            );

l_set_col_val_list.extend(1);

l_set_col_val_list(1) :=  l_set_col_val;

l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBRole',
            set_column_name => 'sysDBARole',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'SYSDBA Role',
          set_column_display_nlsid => 'CREDS_SYSDBA_ROLE'
                        );
l_set_column_list.extend(1);
l_set_column_list(3) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'osm_instance',
         p_set_name => 'DBCredsSYSDBA',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'TARGET',
         p_set_context => NULL,
         p_set_display_name => 'SYSDBA ASM Credentials',
         p_set_display_nlsid => 'CREDS_ASM_DBCREDS_SYSDBA',
         p_type_name => 'ASMCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.7');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'osm_instance','3.7','DBCredsSYSDBA','SYSDBA ASM Credentials','CREDS_ASM_DBCREDS_SYSDBA','ASMCreds','PREFERRED_CRED','TARGET',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBCredsSYSDBA',
    set_display_name = 'SYSDBA ASM Credentials',
    set_display_nlsid = 'CREDS_ASM_DBCREDS_SYSDBA',
    credential_type_name = 'ASMCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'TARGET',
    set_context = ' '
  WHERE 
    target_type = 'osm_instance' AND 
    target_type_meta_ver = '3.7' AND 
    set_name = 'DBCredsSYSDBA';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','DBCredsSYSDBA','sysDBAUserName','SYSDBA Username','CREDS_SYSDBA_USER','DBUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBCredsSYSDBA',
    set_column_name = 'sysDBAUserName',
    set_column_display_name = 'SYSDBA Username',
    set_column_display_nlsid = 'CREDS_SYSDBA_USER',
    type_column_name = 'DBUserName'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'DBCredsSYSDBA' AND 
     set_column_name = 'sysDBAUserName';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','DBCredsSYSDBA','sysDBAPassword','SYSDBA Password','CREDS_SYSDBA_PASSWORD','DBPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBCredsSYSDBA',
    set_column_name = 'sysDBAPassword',
    set_column_display_name = 'SYSDBA Password',
    set_column_display_nlsid = 'CREDS_SYSDBA_PASSWORD',
    type_column_name = 'DBPassword'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'DBCredsSYSDBA' AND 
     set_column_name = 'sysDBAPassword';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','DBCredsSYSDBA','sysDBARole','SYSDBA Role','CREDS_SYSDBA_ROLE','DBRole' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBCredsSYSDBA',
    set_column_name = 'sysDBARole',
    set_column_display_name = 'SYSDBA Role',
    set_column_display_nlsid = 'CREDS_SYSDBA_ROLE',
    type_column_name = 'DBRole'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'DBCredsSYSDBA' AND 
     set_column_name = 'sysDBARole';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBUserName',
            set_column_name => 'sysASMUserName',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'SYSASM Username',
          set_column_display_nlsid => 'CREDS_SYSASM_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBPassword',
            set_column_name => 'sysASMPassword',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'SYSASM Password',
          set_column_display_nlsid => 'CREDS_SYSASM_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_col_val := MGMT_CRED_SET_COL_VAL(
                       value => 'SYSASM',
                          default_value => 1 
            );

l_set_col_val_list.extend(1);

l_set_col_val_list(1) :=  l_set_col_val;

l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBRole',
            set_column_name => 'sysASMRole',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'SYSASM Role',
          set_column_display_nlsid => 'CREDS_SYSASM_ROLE'
                        );
l_set_column_list.extend(1);
l_set_column_list(3) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'osm_instance',
         p_set_name => 'DBCredsSYSASM',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'TARGET',
         p_set_context => NULL,
         p_set_display_name => 'SYSASM ASM Credentials',
         p_set_display_nlsid => 'CREDS_ASM_DBCREDS_SYSASM',
         p_type_name => 'ASMCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.7');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'osm_instance','3.7','DBCredsSYSASM','SYSASM ASM Credentials','CREDS_ASM_DBCREDS_SYSASM','ASMCreds','PREFERRED_CRED','TARGET',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBCredsSYSASM',
    set_display_name = 'SYSASM ASM Credentials',
    set_display_nlsid = 'CREDS_ASM_DBCREDS_SYSASM',
    credential_type_name = 'ASMCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'TARGET',
    set_context = ' '
  WHERE 
    target_type = 'osm_instance' AND 
    target_type_meta_ver = '3.7' AND 
    set_name = 'DBCredsSYSASM';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','DBCredsSYSASM','sysASMUserName','SYSASM Username','CREDS_SYSASM_USER','DBUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBCredsSYSASM',
    set_column_name = 'sysASMUserName',
    set_column_display_name = 'SYSASM Username',
    set_column_display_nlsid = 'CREDS_SYSASM_USER',
    type_column_name = 'DBUserName'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'DBCredsSYSASM' AND 
     set_column_name = 'sysASMUserName';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','DBCredsSYSASM','sysASMPassword','SYSASM Password','CREDS_SYSASM_PASSWORD','DBPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBCredsSYSASM',
    set_column_name = 'sysASMPassword',
    set_column_display_name = 'SYSASM Password',
    set_column_display_nlsid = 'CREDS_SYSASM_PASSWORD',
    type_column_name = 'DBPassword'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'DBCredsSYSASM' AND 
     set_column_name = 'sysASMPassword';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','DBCredsSYSASM','sysASMRole','SYSASM Role','CREDS_SYSASM_ROLE','DBRole' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBCredsSYSASM',
    set_column_name = 'sysASMRole',
    set_column_display_name = 'SYSASM Role',
    set_column_display_nlsid = 'CREDS_SYSASM_ROLE',
    type_column_name = 'DBRole'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'DBCredsSYSASM' AND 
     set_column_name = 'sysASMRole';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostUserName',
            set_column_name => 'HostUsername',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Host Username',
          set_column_display_nlsid => 'CREDS_HOST_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostPassword',
            set_column_name => 'HostPassword',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Host Password',
          set_column_display_nlsid => 'CREDS_HOST_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'osm_instance',
         p_set_name => 'DBHostCreds',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'TARGET',
         p_set_context => NULL,
         p_set_display_name => 'ASM Host Credentials',
         p_set_display_nlsid => 'CREDS_ASM_DBHOSTCREDS',
         p_type_name => 'DBHostCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.7');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'osm_instance','3.7','DBHostCreds','ASM Host Credentials','CREDS_ASM_DBHOSTCREDS','DBHostCreds','PREFERRED_CRED','TARGET',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBHostCreds',
    set_display_name = 'ASM Host Credentials',
    set_display_nlsid = 'CREDS_ASM_DBHOSTCREDS',
    credential_type_name = 'DBHostCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'TARGET',
    set_context = ' '
  WHERE 
    target_type = 'osm_instance' AND 
    target_type_meta_ver = '3.7' AND 
    set_name = 'DBHostCreds';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','DBHostCreds','HostUsername','Host Username','CREDS_HOST_USER','HostUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBHostCreds',
    set_column_name = 'HostUsername',
    set_column_display_name = 'Host Username',
    set_column_display_nlsid = 'CREDS_HOST_USER',
    type_column_name = 'HostUserName'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'DBHostCreds' AND 
     set_column_name = 'HostUsername';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','DBHostCreds','HostPassword','Host Password','CREDS_HOST_PASSWORD','HostPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'DBHostCreds',
    set_column_name = 'HostPassword',
    set_column_display_name = 'Host Password',
    set_column_display_nlsid = 'CREDS_HOST_PASSWORD',
    type_column_name = 'HostPassword'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'DBHostCreds' AND 
     set_column_name = 'HostPassword';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBUserName',
            set_column_name => 'UserName',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'ASM Monitoring Username',
          set_column_display_nlsid => 'CREDS_ASM_USERNAME_MON'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBPassword',
            set_column_name => 'password',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'ASM Monitoring Password',
          set_column_display_nlsid => 'CREDS_ASM_PASSWORD_MON'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'DBRole',
            set_column_name => 'Role',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'ASM Monitoring Role',
          set_column_display_nlsid => 'CREDS_ASM_ROLE_MON'
                        );
l_set_column_list.extend(1);
l_set_column_list(3) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'osm_instance',
         p_set_name => 'ASMCredsMonitoring',
         p_set_usage => 'MONITORING',
         p_set_context_type => 'TARGET',
         p_set_context => NULL,
         p_set_display_name => 'ASM Monitoring Credentials',
         p_set_display_nlsid => 'CREDS_ASM_CREDS_MON',
         p_type_name => 'ASMCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.7');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'osm_instance','3.7','ASMCredsMonitoring','ASM Monitoring Credentials','CREDS_ASM_CREDS_MON','ASMCreds','MONITORING','TARGET',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'ASMCredsMonitoring',
    set_display_name = 'ASM Monitoring Credentials',
    set_display_nlsid = 'CREDS_ASM_CREDS_MON',
    credential_type_name = 'ASMCreds',
    set_usage = 'MONITORING',
    set_context_type = 'TARGET',
    set_context = ' '
  WHERE 
    target_type = 'osm_instance' AND 
    target_type_meta_ver = '3.7' AND 
    set_name = 'ASMCredsMonitoring';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','ASMCredsMonitoring','UserName','ASM Monitoring Username','CREDS_ASM_USERNAME_MON','DBUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'ASMCredsMonitoring',
    set_column_name = 'UserName',
    set_column_display_name = 'ASM Monitoring Username',
    set_column_display_nlsid = 'CREDS_ASM_USERNAME_MON',
    type_column_name = 'DBUserName'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'ASMCredsMonitoring' AND 
     set_column_name = 'UserName';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','ASMCredsMonitoring','password','ASM Monitoring Password','CREDS_ASM_PASSWORD_MON','DBPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'ASMCredsMonitoring',
    set_column_name = 'password',
    set_column_display_name = 'ASM Monitoring Password',
    set_column_display_nlsid = 'CREDS_ASM_PASSWORD_MON',
    type_column_name = 'DBPassword'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'ASMCredsMonitoring' AND 
     set_column_name = 'password';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'osm_instance','3.7','ASMCredsMonitoring','Role','ASM Monitoring Role','CREDS_ASM_ROLE_MON','DBRole' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'osm_instance',
    target_type_meta_ver = '3.7',
    set_name = 'ASMCredsMonitoring',
    set_column_name = 'Role',
    set_column_display_name = 'ASM Monitoring Role',
    set_column_display_nlsid = 'CREDS_ASM_ROLE_MON',
    type_column_name = 'DBRole'
   WHERE
     target_type = 'osm_instance' AND 
     target_type_meta_ver = '3.7' AND 
     set_name = 'ASMCredsMonitoring' AND 
     set_column_name = 'Role';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('osm_instance','3.7','MGMT_CREDENTIAL_SETS');
END;
/
commit;
