Rem drv: <migrate type="schema_upgrade" version="10.1.0.4"/>
Rem
Rem $Header: config_schema_upgrade.sql 12-jul-2005.11:33:03 chyu Exp $
Rem
Rem config_schema_upgrade.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      config_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/12/05 - adding the new rep manager header 
Rem    xshen       02/23/05 - 
Rem    xshen       11/19/04 - xshen_upgrade_4020067_for_main
Rem    xshen       11/18/04 - Created
Rem


Rem -------------------------------------------------------------------- 
Rem  This table is created in 10.1.0.4.0 patch set thus needs 
Rem     creating in the upgrade from lower versions. 
Rem
Rem  MGMT_DBCONFIG_LOG
Rem  PURPOSE
Rem
Rem     The MGMT_DBCONFIG_LOG table holds information 
Rem     For 400 data transfer TO 401 repository AND purge process
Rem
Rem  COLUMNS
Rem    LOGGED_MSG The logged message
Rem
Rem    LOGGED_GUID The target (snapshot) guid OF the config data 
REM                from which the logging was generated 
Rem
Rem    LOGGED_TIME The time AT which message was logged
Rem
Rem  NOTES
Rem

DECLARE
  l_cnt NUMBER := 0;
BEGIN
 IF ('&EM_REPOS_MODE' = 'CENTRAL') THEN

   BEGIN
     select count(*) into l_cnt 
       from all_objects 
      where object_name = 'MGMT_DBCONFIG_LOG' 
        and object_type = 'TABLE';
   EXCEPTION WHEN OTHERS THEN NULL;
   END;

   IF (l_cnt = 0) THEN

    -- This table is used for debugging 4.0.0 compatibility support.
    EXECUTE IMMEDIATE
   'CREATE TABLE MGMT_DBCONFIG_LOG
    ( LOGGED_MSG  VARCHAR2(2000) NOT NULL,
      LOGGED_GUID RAW(16),
      LOGGED_TIME DATE DEFAULT SYSDATE,
      CONSTRAINT MGMT_DBCONFIG_LOG_PK PRIMARY KEY (LOGGED_TIME)
    ) MONITORING';

    -- This table is used as interim table for 4.0.0 compatibility support.
    EXECUTE IMMEDIATE 'ALTER TABLE MGMT_DB_INIT_PARAMS DROP CONSTRAINT MGMT_DB_INIT_PARAMS_UK';

    EXECUTE IMMEDIATE 'ALTER TABLE MGMT_DB_INIT_PARAMS ADD CONSTRAINT MGMT_DB_INIT_PARAMS_PK PRIMARY KEY (TARGET_GUID, NAME)';

   END IF;

 END IF;
END;
/ 

