Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="policy/default_policy_setup.sql+"/>
Rem
Rem $Header: db_comp_data_upgrade.sql 10-aug-2005.12:16:24 chyu Exp $
Rem
Rem db_comp_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      db_comp_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        08/10/05 - adding changes by ysun
Rem    chyu        08/01/05 - fixing sql syntax 
Rem    chyu        07/13/05 - chyu_new_repmgr_upg_db
Rem    chyu        07/12/05 - Created; Wrapper file for the component upgrade
Rem                           codes.
Rem

Rem
Rem    YSUN
Rem

BEGIN

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_DATABASE_TARGET_TYPE,
                              'Database Instance', 'name', NULL, 'oracle.sysman.db.rsc');

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE,
                              'Cluster Database', 'rac_database_name', NULL, 'oracle.sysman.db.rsc');
  COMMIT;

END;
/
SHOW ERRORS;


Rem
Rem    RREILLY        04/10/06 
Rem


-- -----------------------------------------------
-- Register Type: osm_instance 
-- -----------------------------------------------
BEGIN

  MGMT_TARGET.register_target_type('osm_instance',
                                   'ASM', 
                                   'oracle_storage_manager',
                                   null,
                                   'oracle.sysman.db.rsc');
  COMMIT;

END;
/
SHOW ERRORS;

-- -----------------------------------------------
-- Register ECM Policy Metadata for ASM
-- -----------------------------------------------

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN

  --
  -- Register metadata for osm snapshots
  --


  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN 
      (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA 
        WHERE TARGET_TYPE = 'osm_instance' AND SNAPSHOT_TYPE = 'oracle_osm');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA 
      WHERE TARGET_TYPE = 'osm_instance' AND SNAPSHOT_TYPE = 'oracle_osm';

  -- Register metadata as loader (KIND='L') metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA 
            (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, 
             COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, 
             AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, 
             HISTORY_URL, SAME_TARGET_COMPARE) 
     VALUES ('oracle_osm', 'osm_instance', 'L', metadata_id, 'ASM Problems', 'Y',
             'N', 'N', NULL, NULL, 
             NULL, '1.0', NULL, NULL, 
             NULL, 'H');

  -- Register metadata as presentation (KIND='P') metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA 
            (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, 
             COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, 
             AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, 
             HISTORY_URL, SAME_TARGET_COMPARE) 
     VALUES ('oracle_osm', 'osm_instance', 'P', metadata_id, 'ASM Problems', 'Y', 
             'N', 'N', NULL, NULL, 
             NULL, '1.0', NULL, NULL, 
             NULL, 'H');


  --
  -- Register metadata for table MGMT_OSM_DISK_GROUP_ECM
  --


  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES 
            (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, 
             PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
     VALUES (metadata_id, 'MGMT_OSM_DISK_GROUP_ECM', 
             'ASM Disk Group Problems', 'Y', 'N', 'N', NULL, 'N', 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS 
            (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, 
             UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, 
             IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
     VALUES (metadata_id, 'MGMT_OSM_DISK_GROUP_ECM', 'DISK_GROUP', 
             'Disk Group', 'S', '30', 'Y', 'N', 'N', 'Y', 'N', 'N', 
             'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS 
            (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, 
             UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, 
             IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
     VALUES (metadata_id, 'MGMT_OSM_DISK_GROUP_ECM', 'PROBLEM_CODE', 
             'Object', 'N', '2', 'Y', 'N', 'N', 'N', 'N', 'N', 
             'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS 
            (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, 
             UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, 
             IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
     VALUES (metadata_id, 'MGMT_OSM_DISK_GROUP_ECM', 'VALUE1_N', 
             'Number Value1', 'N', '10', 'Y', 'N', 'N', 'N', 'N', 'N', 
             'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS 
            (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, 
             UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, 
             IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
     VALUES (metadata_id, 'MGMT_OSM_DISK_GROUP_ECM', 'VALUE2_N', 
             'Number Value2', 'N', '10', 'Y', 'N', 'N', 'N', 'N', 'N', 
             'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS 
            (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, 
             UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, 
             IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
     VALUES (metadata_id, 'MGMT_OSM_DISK_GROUP_ECM', 'VALUE3_S', 
             'Value3', 'S', '100', 'Y', 'N', 'N', 'N', 'N', 'N', 
             'N', NULL, 4);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS 
            (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, 
             UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, 
             IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
     VALUES (metadata_id, 'MGMT_OSM_DISK_GROUP_ECM', 'VALUE4_S', 
             'Value4', 'S', '100', 'Y', 'N', 'N', 'N', 'N', 'N', 
             'N', NULL, 5);

END;
/
SHOW ERRORS;

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;



COMMIT;

Rem
Rem    hying        05/02/09 
Rem


-- -----------------------------------------------
-- Register Job Command: preRman and postRman 
-- -----------------------------------------------
BEGIN
   mgmt_jobs.register_command('preRman',
                         'oracle.sysman.emo.util.rec.commands.PreRman',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

  mgmt_jobs.register_command('postRman',
                         'oracle.sysman.emo.util.rec.commands.PostRman',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

END;
/
COMMIT;
SHOW ERRORS;


Rem
Rem    PBANTIS        04/10/07 
Rem


DECLARE
                                                                               
  table_found NUMBER := 0;                                                                               

BEGIN

  -- Determine if the 10gR1 table exists.
  BEGIN
   select count(*) into table_found
     from all_objects
    where object_name = 'MGMT_RCVCAT_CRED'
      and object_type = 'TABLE';
  EXCEPTION WHEN OTHERS THEN NULL;
  END;

  -- Migrate the data from the 10gR1 table to the 10gR2 tables.
  IF (table_found = 1)
  THEN
    EXECUTE IMMEDIATE
    'DECLARE
      
        -- The uniquely generated GUID for the recovery catalog.
        c_rcvcat_guid mgmt_rcvcat_config.rcvcat_guid%TYPE;
      
        -- The count of recovery catalog configured with the connect string.
        count_cats NUMBER;
             
      BEGIN
             
        -- Loop for each entry in the MGMT_RCVCAT_CRED table.
        FOR cred_entry IN (select * from mgmt_rcvcat_cred)
        LOOP
             
          -- Ensure that the recovery catalog is not already in the 
          -- MGMT_RCVCAT_CONFIG table, based on the recovery catalog connect string.
          select count(*) into count_cats from mgmt_rcvcat_config
          where rcvcat_connect_str = cred_entry.rcvcat_connect_str;
             
          IF (count_cats = 0)
          THEN
            -- Create an entry for the recovery catalog in the MGMT_RCVCAT_CONFIG table.
            insert into mgmt_rcvcat_config (rcvcat_connect_str, rcvcat_username, rcvcat_password, target_guid)
            values (cred_entry.rcvcat_connect_str, cred_entry.rcvcat_username, cred_entry.rcvcat_password, cred_entry.rcvcat_guid);
            commit;
          END IF;
             
          -- Get the uniquely generated GUID of the recovery catalog.
          IF cred_entry.rcvcat_guid IS NULL
          THEN
            select rcvcat_guid into c_rcvcat_guid from mgmt_rcvcat_config
            where rcvcat_connect_str=cred_entry.rcvcat_connect_str
            and rcvcat_username=cred_entry.rcvcat_username
            and rcvcat_password=cred_entry.rcvcat_password;
          ELSE
            select rcvcat_guid into c_rcvcat_guid from mgmt_rcvcat_config
            where rcvcat_connect_str=cred_entry.rcvcat_connect_str
            and rcvcat_username=cred_entry.rcvcat_username
            and rcvcat_password=cred_entry.rcvcat_password
            and target_guid=cred_entry.rcvcat_guid;
          END IF;
             
          -- Create an entry for the target database in the MGMT_RCVCAT_REPOS table.
          insert into mgmt_rcvcat_repos (target_guid, use_rcvcat, rcvcat_guid)
          values (cred_entry.target_guid, ''YES'', c_rcvcat_guid);
          commit;       
      
        END LOOP;       
      
        EXCEPTION
        WHEN NO_DATA_FOUND THEN
              dbms_output.put_line(''Upgrade: NO_DATA_FOUND in MGMT_RCVCAT_*tables.'');
      END;';

    -- BL:  cannot drop this table in the upgrade schema script, because this data script depends on it
    -- Drop the 10gR1 Backup and Recovery tables.
    EXECUTE IMMEDIATE
    'DROP TABLE MGMT_RCVCAT_CRED';
    
  END IF;

END;
/
Rem
Rem    lhan        05/04/25
Rem

BEGIN
    mgmt_jobs.register_command('captureBaseline',
                         'oracle.sysman.dbTarget.db.changemgr.emo.job.CaptureBaselineJob',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('comparison',
                         'oracle.sysman.dbTarget.db.changemgr.emo.job.ComparisonJob',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

END;
/
COMMIT;
SHOW ERRORS;
