Rem
Rem $Header: esm_default_notification_rules_setup.sql 09-may-2005.00:33:24 dkjain Exp $
Rem
Rem esm_default_notification_rules_setup.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      esm_default_notification_rules_setup.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dkjain      05/09/05 - dkjain_bug-4340963_main
Rem    dkjain      04/26/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

Rem  1. Name of the repository user
Rem 
DEFINE EM_REPOS_USER           = "&1"


Rem
Rem Do the user pref email setup, rule emails setup, mail gateway setup for 
Rem default notification rules for types - oracle_database & oracle_listener 
Rem

BEGIN
 
 DECLARE 
 
         current_em_user VARCHAR2(128);
         
         -- variables for default notification rules
         rule_name VARCHAR2(64);
         rule_owner VARCHAR2(128);
         user_email VARCHAR2(128);
         send_email NUMBER(1);
         rule_emails SMP_EMD_STRING_ARRAY;
         rule_email_formats SMP_EMD_INTEGER_ARRAY;
         rule_device_names SMP_EMD_STRING_ARRAY;
         rule_device_types SMP_EMD_INTEGER_ARRAY;
         device_not_avail_list SMP_EMD_STRING_ARRAY;
         email_gateway_setup NUMBER;
         rules_subscribed NUMBER;
         schedule_setup NUMBER;
         mail_gateway_hosts SMP_EMD_STRING_ARRAY;
         mail_server_name VARCHAR2(128);
         mail_server_sender_name VARCHAR2(64);
         mail_server_sender_addr VARCHAR2(128);

         schedule_emails SMP_EMD_NVPAIR_ARRAY;
         emails_not_available SMP_EMD_STRING_ARRAY;
    BEGIN

        -- First get the currently logged in user. the default notification
        -- rules will be owned by this user
        current_em_user := mgmt_user.get_current_em_user();
        dbms_output.put_line( 'current em user: ' || current_em_user );
        rule_owner := current_em_user;
        
        -- get the user email address if available
        -- this will be the same for all the rules
        user_email := '&EMAIL_ADDRESS';
        dbms_output.put_line( 'user email as obtained from setup: ' || user_email );

        IF( user_email IS NULL OR 
            length(trim(user_email)) = 0 OR
            UPPER(user_email) = '_NOT_AVAILABLE_' OR
            UPPER(user_email) = '%EMAIL_ADDRESS%' )
        THEN
            dbms_output.put_line( 'email address of user is not specified' );
            send_email := 0;
            rule_emails := SMP_EMD_STRING_ARRAY();
            rule_email_formats := SMP_EMD_INTEGER_ARRAY();
        ELSE            
            dbms_output.put_line( 'email address of user is specified and is: ' || user_email );
            send_email := 1;
            rule_emails := SMP_EMD_STRING_ARRAY();
            rule_emails.extend( 1 );
            rule_emails( 1 ) := user_email;
            rule_email_formats := SMP_EMD_INTEGER_ARRAY();
            rule_email_formats.extend( 1 );
            rule_email_formats( 1 ) := 1;
        END IF;
            
        -- note that the mail gateway and the email of the user needs to be
        -- setup so as to be able to receive the email notifications. these
        -- are part of the core component and so are being setup in core only 
                    
        -- set up the preference email of the current user
        -- note, if the user email was supplied, rule_emails will be a string 
        -- array of size 1. otherwise, rule_emails will be empty
        dbms_output.put_line( 'setting pref emails of user: ' || current_em_user );        
        BEGIN
          mgmt_preferences.update_user_pref_data( '&EM_REPOS_USER',
                                                  ' ',
                                                  0,
                                                  rule_emails,
                                                  rule_email_formats,
                                                  email_gateway_setup,
                                                  rules_subscribed,
                                                  schedule_setup );
          dbms_output.put_line( 'email gateway setup: ' || email_gateway_setup );
          COMMIT;        
          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'Exception occurred while setting pref email of user: ' || current_em_user || ', SQLCODE: ' || SQLCODE || ', SQLERRM: ' || SQLERRM );
                      
        END;
      
        -- no devices to be assigned with the rules ...  
        rule_device_names := SMP_EMD_STRING_ARRAY();
        rule_device_types := SMP_EMD_INTEGER_ARRAY();

        -- now setup the emails for each of the rules of 
        -- type  database and listener 

        -- Assign email to the database targets rule 
        rule_name := 'Violation Notification for Database Security Policies';

        BEGIN
          dbms_output.put_line( 'Assign email: ' || user_email || ' of ' || current_em_user || ' to rule: ' || rule_name || ' of: ' || rule_owner  );
          mgmt_preferences.update_rule_devices_data( rule_name, 
                                                     rule_owner, 
                                                     send_email,  
                                                     rule_device_names,  
                                                     rule_device_types, 
                                                     device_not_avail_list, 
                                                     email_gateway_setup ); 
          dbms_output.put_line( 'email_gateway_setup: ' || email_gateway_setup );
          COMMIT;

          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'UNHANDLED EXCEPTION while assigning email: ' || user_email || ' to rule: ' || rule_name );
                      
        END;
        
       
    END;

END;
/

