Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="eval_data_upgrade.sql+"/>
Rem
Rem $Header: rac_post_creation.sql 15-aug-2005.11:33:56 pbantis Exp $
Rem
Rem rac_post_creation.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rac_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      RAC upgrade to 10.2 GC Beta.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pbantis     08/15/05 - File should reflect RAC upgrade to 10.2 GC Beta. 
Rem    ysun        07/15/05 - register version
Rem    chyu        07/12/05 - adding the new rep manager upgrade header 
Rem    pbantis     07/05/05 - pbantis_bug-4257917
Rem    pbantis     06/28/05 - Only keep 10.2 specific features. 
Rem    pbantis     06/13/05 - Upgrade RAC. 
Rem

Rem
Rem    YSUN        04/10/06 
Rem

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'cluster' AND SNAPSHOT_TYPE = 'ha_cls_intrconn');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'cluster' AND SNAPSHOT_TYPE = 'ha_cls_intrconn';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('ha_cls_intrconn', 'cluster', 'L', metadata_id, 'Cluster Interconnects', 'N', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('ha_cls_intrconn', 'cluster', 'P', metadata_id, 'Cluster Interconnects', 'N', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_HA_CLS_INTR_CONN
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', NULL, 'N', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_NAME', 'Interface Name', 'S', '50', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_NODE', 'Node Name', 'S', '100', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_SUBNET', 'Subnet', 'S', '16', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_IP', 'IP Address', 'S', '16', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_CLS_INTR_CONN', 'IC_PUBLIC', 'Is Public', 'S', '10', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 4);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;


ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'ha_rac_intrconn');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'ha_rac_intrconn';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('ha_rac_intrconn', 'oracle_database', 'L', metadata_id, 'Rac Instance Interconnects', 'N', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('ha_rac_intrconn', 'oracle_database', 'P', metadata_id, 'Rac Instance Interconnects', 'N', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_HA_RAC_INTR_CONN
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, HISTORY_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', NULL, 'N', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', 'IC_NAME', 'Interface Name', 'S', '50', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', 'IC_IP', 'IP Address', 'S', '16', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', 'IC_PUBLIC', 'Is Public', 'S', '10', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, HISTORY_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_HA_RAC_INTR_CONN', 'IC_SOURCE', 'Source', 'S', '100', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 3);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

BEGIN
    -- job command to remove host from cluster
    mgmt_jobs.register_command('removeHostFromCluster', 'oracle.sysman.emo.rac.clscfg.RemoveHostFromCluster');
END;
/
COMMIT;
