Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="reports/overview_outofbox.sql+" condition="EM_REPOS_MODE=CENTRAL"/>
Rem
Rem $Header: db_outofbox_elements.sql 28-nov-2006.06:33:54 mnihalan Exp $
Rem
Rem db_outofbox_elements.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      db_outofbox_elements.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      !!!!!! Please update upgrade script if updates are made. !!!!!!!
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mnihalan    11/28/06 - Fix bug 5683385
Rem    rreilly     07/15/05 - bug 4494270 make this dir match beta 
Rem    chyu        07/12/05 - adding the new rep manager upgrade header 
Rem    rreilly     05/03/05 - add group elements 
Rem    rreilly     04/28/05 - add cumulative target type 
Rem    rreilly     04/11/05 - add new generic elems for db reports
Rem    qsong       11/12/04 - qsong_asm_reports
Rem    mnihalan    10/07/04 - Created
Rem

SET DEFINE OFF

DECLARE
  l_target_types  MGMT_IP_TARGET_TYPES;
  l_param_classes MGMT_IP_PARAM_CLASSES;
    
BEGIN

    -- -------------------------------------------------------------------------
    -- Element Definitions
    -- -------------------------------------------------------------------------    
    -- Element that connects to the target
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(2);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.SQLStatementParamController';
   
    mgmt_ip.add_element_definition
     ('target_user_table_from_sql',
        'database_target_type',
        'target_user_table_from_sql',
        'oracle.sysman.db.util.reports.TableTargetRenderController',
        0,
        l_param_classes,
        null);
        
    COMMIT;  

  -- ----------------------------------------
  -- Create Generic Database Element Type
  -- 
  -- NOTE: Element SQL will be required to 
  --       exclude RAC Instances.
  -- Ideally this would return only Databases,
  -- but since there is no way to pass in 
  -- category props, this element type will
  -- return all instances and rac dbs
  -- ----------------------------------------

  l_target_types := MGMT_IP_TARGET_TYPES();
  l_target_types.extend(2);
  l_target_types(1) := 'oracle_database';
  l_target_types(2) := 'rac_database';

  mgmt_ip.add_element_type (
    p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE',
    p_target_types => l_target_types);

  -- ----------------------------------------
  -- Create Generic Table Elements
  -- ----------------------------------------

  -- 
  -- User Element: DBMSG_USER_TABLE_FROM_SQL_ELEM
  -- User can see the SQL 
  --
  mgmt_ip.add_table_from_sql_elem_def (
    p_element_name_nlsid => 'DBMSG_USER_TABLE_FROM_SQL_ELEM',
    p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE', 
    p_description_nlsid  => 'DBMSG_USER_TABLE_FROM_SQL_DESC',
    p_internal_use_only  => 1,
    p_query_views        => 1);

  --
  -- Internal Element: DBMSG_TABLE_FROM_SQL_ELEM
  -- User can't see the SQL 
  --
  mgmt_ip.add_table_from_sql_elem_def (
    p_element_name_nlsid => 'DBMSG_TABLE_FROM_SQL_ELEM',
    p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE',
    p_description_nlsid  => 'DBMSG_TABLE_FROM_SQL_DESC',
    p_internal_use_only  => 1,
    p_query_views        => 0);

  -- ----------------------------------------
  -- Create Generic Chart Elements
  -- ----------------------------------------

  -- 
  -- User Element: DBMSG_USER_CHART_FROM_SQL_ELEM
  -- User can see the SQL 
  --
  mgmt_ip.add_chart_from_sql_elem_def (
    p_element_name_nlsid => 'DBMSG_USER_CHART_FROM_SQL_ELEM',
    p_element_type_nlsid => 'DBMSG_DBINSTANCE_RAC_TARGET_TYPE', 
    p_description_nlsid  => 'DBMSG_USER_CHART_FROM_SQL_DESC',
    p_internal_use_only  => 1,
    p_query_views        => 1);
    
END;
/

SET DEFINE ON
