Rem
Rem $Header: db_policies_ext1_dbc.sql18956 30-aug-2006.00:54:12 rmadampa Exp $
Rem
Rem db_policies_ext1_dbc.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      db_policies_ext1_dbc.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmadampa    08/30/06 - only for DBControl
Rem    rmadampa    08/30/06 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


SET ESCAPE '\' ;
SET ESCAPE ON ;
DECLARE
 -- Metric Variable
 l_metric_column_list        	   	           MGMT_METRIC_COLUMN_ARRAY;
 l_metric_type				  	   NUMBER ;
 l_snapshot_list			           MGMT_SNAPSHOT_ARRAY;
 -- Policy Variable
 l_ctxList    		  			   MGMT_VIOL_CTXT_DEF_ARRAY;
 l_paramDefList            			   MGMT_POLICY_PARAM_DEF_ARRAY;
 l_defaultParamValList      			   MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList      			   MGMT_POLICY_KEY_VAL_ARRAY;
 l_auto_enable				           NUMBER ;	
 l_10gR1_db_meta_ver                   VARCHAR2(3) ; 
 l_valid_if_list                       MGMT_VALIDIF_ARRAY ;
 
BEGIN

  l_10gR1_db_meta_ver := '3.0' ;
  l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE ;
  l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));
   

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on USER_HISTORY$ Table',
                p_column_label_nlsid =>'HIST_TAB_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'userHistRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on USER_HISTORY$',
      p_metric_label_nlsid => 'USR_HIST_TAB_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_HISTORY$',
      p_description_nlsid => 'USR_HIST_TAB_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_history''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'userHistRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on USER_HISTORY$',
      p_metric_label_nlsid => 'USR_HIST_TAB_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_HISTORY$',
      p_description_nlsid => 'USR_HIST_TAB_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_history''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION

  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_USER_HISTORY_Table',   --Policy name
  p_metric_name =>'userHistRep',      --Metric name
  p_policy_label_nlsid =>'ACCESS_USER_HIST_NAME', 
  p_description =>'Ensures restricted access to SYS.USER_HISTORY$ table',
  p_description_nlsid =>'ACCESS_USER_HIST_DESC',
  p_impact => 'Username and password hash may be read from the SYS.USER_HISTORY$ table, enabling a hacker to launch a brute-force attack.',
  p_impact_nlsid =>'ACCESS_USER_HIST_IMPACT',
  p_recommendation =>'Revoke access to SYS.USER_HISTORY$ table from the non-DBA/SYS database users.',
  p_recommendation_nlsid =>'ACCESS_USER_HIST_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the SYS.USER_HISTORY$ table.',
  p_message_nlsid =>'ACCESS_USER_HIST_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_USER_HISTORY_Table',   --Policy name
  p_metric_name =>'userHistRep',      --Metric name
  p_policy_label_nlsid =>'ACCESS_USER_HIST_NAME', 
  p_description =>'Ensures restricted access to SYS.USER_HISTORY$ table',
  p_description_nlsid =>'ACCESS_USER_HIST_DESC',
  p_impact => 'Username and password hash may be read from the SYS.USER_HISTORY$ table, enabling a hacker to launch a brute-force attack.',
  p_impact_nlsid =>'ACCESS_USER_HIST_IMPACT',
  p_recommendation =>'Revoke access to SYS.USER_HISTORY$ table from the non-DBA/SYS database users.',
  p_recommendation_nlsid =>'ACCESS_USER_HIST_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the SYS.USER_HISTORY$ table.',
  p_message_nlsid =>'ACCESS_USER_HIST_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on SOURCE$ Table',
                p_column_label_nlsid =>'SRC_TAB_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sourceTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on SOURCE$',
      p_metric_label_nlsid => 'SRC_METRIC_LABEL',
      p_description  => 'Collect the database users having access on SOURCE$',
      p_description_nlsid => 'SRC_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_source_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'sourceTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on SOURCE$',
      p_metric_label_nlsid => 'SRC_METRIC_LABEL',
      p_description  => 'Collect the database users having access on SOURCE$',
      p_description_nlsid => 'SRC_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_source_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION

  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_SOURCE_Table',   --Policy name
  p_metric_name =>'sourceTabRep',      --Metric name
  p_policy_label_nlsid =>'ACSS_SRC_TAB_NAME', 
  p_description =>'Ensures restricted access to SYS.SOURCE$ table',
  p_description_nlsid =>'ACSS_SRC_TAB_DESC',
  p_impact => 'Contains source of all stored packages units in the database.',
  p_impact_nlsid =>'ACSS_SRC_TAB_IMPACT',
  p_recommendation =>'Revoke access to SYS.SOURCE$ table from the non-SYS/DBA database users.' ,
  p_recommendation_nlsid =>'ACSS_SRC_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the SOURCE$ table.',
  p_message_nlsid =>'ACSS_SRC_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_SOURCE_Table',   --Policy name
  p_metric_name =>'sourceTabRep',      --Metric name
  p_policy_label_nlsid =>'ACSS_SRC_TAB_NAME', 
  p_description =>'Ensures restricted access to SYS.SOURCE$ table',
  p_description_nlsid =>'ACSS_SRC_TAB_DESC',
  p_impact => 'Contains source of all stored packages units in the database.',
  p_impact_nlsid =>'ACSS_SRC_TAB_IMPACT',
  p_recommendation =>'Revoke access to SYS.SOURCE$ table from the non-SYS/DBA database users.' ,
  p_recommendation_nlsid =>'ACSS_SRC_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the SOURCE$ table.',
  p_message_nlsid =>'ACSS_SRC_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on LINK$ Table',
                p_column_label_nlsid =>'LINK_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'linkTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on LINK$',
      p_metric_label_nlsid => 'LINK_METRIC_LABEL',
      p_description  => 'Collect the database users having access on LINK$',
      p_description_nlsid => 'LINK_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_link_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'linkTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on LINK$',
      p_metric_label_nlsid => 'LINK_METRIC_LABEL',
      p_description  => 'Collect the database users having access on LINK$',
      p_description_nlsid => 'LINK_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_link_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_LINK_Table',   --Policy name
  p_metric_name =>'linkTabRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_LINK_TAB_NAME', 
  p_description =>'Ensures restricted access to LINK$ table',
  p_description_nlsid =>'ACCSS_LINK_TAB_DESC',
  p_impact => 'A knowlegeable and malicious user can gain access to user passwords from the SYS.LINK$ table.',
  p_impact_nlsid =>'ACCSS_LINK_TAB_IMPACT',
  p_recommendation =>'Restrict access to SYS.LINK$ table.' ,
  p_recommendation_nlsid =>'ACCSS_LINK_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the LINK$ table.',
  p_message_nlsid =>'ACCSS_LINK_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_LINK_Table',   --Policy name
  p_metric_name =>'linkTabRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_LINK_TAB_NAME', 
  p_description =>'Ensures restricted access to LINK$ table',
  p_description_nlsid =>'ACCSS_LINK_TAB_DESC',
  p_impact => 'A knowlegeable and malicious user can gain access to user passwords from the SYS.LINK$ table.',
  p_impact_nlsid =>'ACCSS_LINK_TAB_IMPACT',
  p_recommendation =>'Restrict access to SYS.LINK$ table.' ,
  p_recommendation_nlsid =>'ACCSS_LINK_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the LINK$ table.',
  p_message_nlsid =>'ACCSS_LINK_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on USER$ Table',
                p_column_label_nlsid =>'USR_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'userTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on USER$',
      p_metric_label_nlsid => 'USR_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER$',
      p_description_nlsid => 'USR_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'userTabRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on USER$',
      p_metric_label_nlsid => 'USR_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER$',
      p_description_nlsid => 'USR_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_table''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION

     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_USER_Table',   --Policy name
  p_metric_name =>'userTabRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_TAB_NAME', 
  p_description =>'Ensures restricted access to SYS.USER$ table',
  p_description_nlsid =>'ACCSS_USER_TAB_DESC',
  p_impact => 'Username and password hash may be read from the SYS.USER$ table, enabling a hacker to launch a brute-force attack.',
  p_impact_nlsid =>'ACCSS_USER_TAB_IMPACT',
  p_recommendation =>'Restrict access to SYS.USER$ table.' ,
  p_recommendation_nlsid =>'ACCSS_USER_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER$ table.',
  p_message_nlsid =>'ACCSS_USER_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_USER_Table',   --Policy name
  p_metric_name =>'userTabRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_TAB_NAME', 
  p_description =>'Ensures restricted access to SYS.USER$ table',
  p_description_nlsid =>'ACCSS_USER_TAB_DESC',
  p_impact => 'Username and password hash may be read from the SYS.USER$ table, enabling a hacker to launch a brute-force attack.',
  p_impact_nlsid =>'ACCSS_USER_TAB_IMPACT',
  p_recommendation =>'Restrict access to SYS.USER$ table.' ,
  p_recommendation_nlsid =>'ACCSS_USER_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER$ table.',
  p_message_nlsid =>'ACCSS_USER_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on STATS$SQL_TEXT Table',
                p_column_label_nlsid =>'SQLTEXT_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlTextRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on STATS$SQL_TEXT',
      p_metric_label_nlsid => 'SQL_TEXT_LABEL',
      p_description  => 'Collect the database users having access on STATS$SQL_TEXT',
      p_description_nlsid => 'SQL_TEXT_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_sql_text''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'sqlTextRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on STATS$SQL_TEXT',
      p_metric_label_nlsid => 'SQL_TEXT_LABEL',
      p_description  => 'Collect the database users having access on STATS$SQL_TEXT',
      p_description_nlsid => 'SQL_TEXT_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_sql_text''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION

  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_STATSSQLTEXT_Table',   --Policy name
  p_metric_name =>'sqlTextRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_SQLTEXT_TAB_NAME', 
  p_description =>'Ensures restricted access to STATS$SQLTEXT table',
  p_description_nlsid =>'ACCSS_SQLTEXT_TAB_DESC',
  p_impact => 'This table provides full text of the recently-executed SQL statements. The SQL statements can reveal sensitive information.',
  p_impact_nlsid =>'ACCSS_SQLTEXT_TAB_IMPACT',
  p_recommendation =>'Restrict access to STATS$SQLTEXT table.',
  p_recommendation_nlsid =>'ACCSS_SQLTEXT_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on STATS$SQLTEXT table.',
  p_message_nlsid =>'ACCSS_SQLTEXT_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_STATSSQLTEXT_Table',   --Policy name
  p_metric_name =>'sqlTextRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_SQLTEXT_TAB_NAME', 
  p_description =>'Ensures restricted access to STATS$SQLTEXT table',
  p_description_nlsid =>'ACCSS_SQLTEXT_TAB_DESC',
  p_impact => 'This table provides full text of the recently-executed SQL statements. The SQL statements can reveal sensitive information.',
  p_impact_nlsid =>'ACCSS_SQLTEXT_TAB_IMPACT',
  p_recommendation =>'Restrict access to STATS$SQLTEXT table.',
  p_recommendation_nlsid =>'ACCSS_SQLTEXT_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on STATS$SQLTEXT table.',
  p_message_nlsid =>'ACCSS_SQLTEXT_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
   
   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on STATS$SQL_SUMMARY Table',
                p_column_label_nlsid =>'SQL_SUMM_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlSummaryRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on STATS$SQL_SUMMARY',
      p_metric_label_nlsid => 'SQL_SUMM_METRIC_LABEL',
      p_description  => 'Collect the database users having access on STATS$SQL_SUMMARY',
      p_description_nlsid => 'SQL_SUMM_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_sql_summary''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'sqlSummaryRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on STATS$SQL_SUMMARY',
      p_metric_label_nlsid => 'SQL_SUMM_METRIC_LABEL',
      p_description  => 'Collect the database users having access on STATS$SQL_SUMMARY',
      p_description_nlsid => 'SQL_SUMM_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_sql_summary''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_STATSSQL_SUMMARY_Table',   --Policy name
  p_metric_name =>'sqlSummaryRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_SQLSUM_TAB_NAME', 
  p_description =>'Ensures restricted access to STATS$SQL_SUMMARY table',
  p_description_nlsid =>'ACCSS_SQLSUM_TAB_DESC',
  p_impact => 'Contains first few lines of SQL text of the most resource intensive commands given to the server. Sql statements executed without bind variables can show up here exposing privileged information.',
  p_impact_nlsid =>'ACCSS_SQLSUM_TAB_IMPACT',
  p_recommendation =>'Restrict access to STATS$SQL_SUMMARY table.',
  p_recommendation_nlsid =>'ACCSS_SQLSUM_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure. User %grantee% has %privilege%  privilege on the STATS$SQL_SUMMARY table.',
  p_message_nlsid =>'ACCSS_SQLSUM_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_STATSSQL_SUMMARY_Table',   --Policy name
  p_metric_name =>'sqlSummaryRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_SQLSUM_TAB_NAME', 
  p_description =>'Ensures restricted access to STATS$SQL_SUMMARY table',
  p_description_nlsid =>'ACCSS_SQLSUM_TAB_DESC',
  p_impact => 'Contains first few lines of SQL text of the most resource intensive commands given to the server. Sql statements executed without bind variables can show up here exposing privileged information.',
  p_impact_nlsid =>'ACCSS_SQLSUM_TAB_IMPACT',
  p_recommendation =>'Restrict access to STATS$SQL_SUMMARY table.',
  p_recommendation_nlsid =>'ACCSS_SQLSUM_TAB_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure. User %grantee% has %privilege%  privilege on the STATS$SQL_SUMMARY table.',
  p_message_nlsid =>'ACCSS_SQLSUM_TAB_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on ALL_SOURCE View',
                p_column_label_nlsid =>'ALL_SRC_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'allSourceRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on ALL_SOURCE',
      p_metric_label_nlsid => 'ALL_SRC_METRIC_LABEL',
      p_description  => 'Collect the database users having access on ALL_SOURCE',
      p_description_nlsid => 'ALL_SRC_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_all_source''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'allSourceRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on ALL_SOURCE',
      p_metric_label_nlsid => 'ALL_SRC_METRIC_LABEL',
      p_description  => 'Collect the database users having access on ALL_SOURCE',
      p_description_nlsid => 'ALL_SRC_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_all_source''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_ALL_SOURCE_View',   --Policy name
  p_metric_name =>'allSourceRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_ALL_SRC_NAME', 
  p_description =>'Ensures restricted access to ALL_SOURCE view',
  p_description_nlsid =>'ACCSS_ALL_SRC_DESC',
  p_impact => 'ALL_SOURCE view contains source of all stored packages in the database.',
  p_impact_nlsid =>'ACCSS_ALL_SRC_IMPACT',
  p_recommendation =>'Revoke access to ALL_SOURCE view from the non-SYS database users.',
  p_recommendation_nlsid =>'ACCSS_ALL_SRC_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege to the ALL_SOURCE view.',
  p_message_nlsid =>'ACCSS_ALL_SRC_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_ALL_SOURCE_View',   --Policy name
  p_metric_name =>'allSourceRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_ALL_SRC_NAME', 
  p_description =>'Ensures restricted access to ALL_SOURCE view',
  p_description_nlsid =>'ACCSS_ALL_SRC_DESC',
  p_impact => 'ALL_SOURCE view contains source of all stored packages in the database.',
  p_impact_nlsid =>'ACCSS_ALL_SRC_IMPACT',
  p_recommendation =>'Revoke access to ALL_SOURCE view from the non-SYS database users.',
  p_recommendation_nlsid =>'ACCSS_ALL_SRC_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege to the ALL_SOURCE view.',
  p_message_nlsid =>'ACCSS_ALL_SRC_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_ROLES View',
                p_column_label_nlsid =>'DBA_ROLE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaRoleRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_ROLES',
      p_metric_label_nlsid => 'DBA_ROLE_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_ROLES',
      p_description_nlsid => 'DBA_ROLE_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid,  '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roles''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaRoleRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_ROLES',
      p_metric_label_nlsid => 'DBA_ROLE_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_ROLES',
      p_description_nlsid => 'DBA_ROLE_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid,  '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roles''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_ROLES_View',   --Policy name
  p_metric_name =>'dbaRoleRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_ROLES_NAME', 
  p_description =>'Ensures restricted access to DBA_ROLES view',
  p_description_nlsid =>'ACCSS_DBA_ROLES_DESC',
  p_impact => 'DBA_ROLES view contains details of all roles in the database. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_ROLES_IMPACT',
  p_recommendation =>'Restrict access to DBA_ROLES view.',
  p_recommendation_nlsid =>'ACCSS_DBA_ROLES_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_ROLES view.',
  p_message_nlsid =>'ACCSS_DBA_ROLES_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_ROLES_View',   --Policy name
  p_metric_name =>'dbaRoleRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_ROLES_NAME', 
  p_description =>'Ensures restricted access to DBA_ROLES view',
  p_description_nlsid =>'ACCSS_DBA_ROLES_DESC',
  p_impact => 'DBA_ROLES view contains details of all roles in the database. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_ROLES_IMPACT',
  p_recommendation =>'Restrict access to DBA_ROLES view.',
  p_recommendation_nlsid =>'ACCSS_DBA_ROLES_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_ROLES view.',
  p_message_nlsid =>'ACCSS_DBA_ROLES_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_SYS_PRIVS View',
                p_column_label_nlsid =>'DBA_SYSPRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaSysPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_SYS_PRIVS',
      p_metric_label_nlsid => 'DBA_SYSPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_SYS_PRIVS',
      p_description_nlsid => 'DBA_SYSPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid,  '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_sysprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaSysPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_SYS_PRIVS',
      p_metric_label_nlsid => 'DBA_SYSPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_SYS_PRIVS',
      p_description_nlsid => 'DBA_SYSPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid,  '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_sysprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_SYS_PRIVS_View',   --Policy name
  p_metric_name =>'dbaSysPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_SYSPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_SYS_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_SYSPRIVS_DESC',
  p_impact => 'DBA_SYS_PRIVS view can be queried to find system privileges granted to roles and users. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_SYSPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_SYS_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_SYSPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_SYS_PRIVS view.',
  p_message_nlsid =>'ACCSS_DBA_SYSPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_SYS_PRIVS_View',   --Policy name
  p_metric_name =>'dbaSysPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_SYSPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_SYS_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_SYSPRIVS_DESC',
  p_impact => 'DBA_SYS_PRIVS view can be queried to find system privileges granted to roles and users. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_SYSPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_SYS_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_SYSPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_SYS_PRIVS view.',
  p_message_nlsid =>'ACCSS_DBA_SYSPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_ROLE_PRIVS View',
                p_column_label_nlsid =>'DBA_ROLE_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaRolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_ROLE_PRIVS',
      p_metric_label_nlsid => 'DBA_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_ROLE_PRIVS',
      p_description_nlsid => 'DBA_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaRolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_ROLE_PRIVS',
      p_metric_label_nlsid => 'DBA_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_ROLE_PRIVS',
      p_description_nlsid => 'DBA_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'dbaRolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_ROLEPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_ROLEPRIVS_DESC',
  p_impact => 'The DBA_ROLE_PRIVS view lists the roles granted to users and other roles. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_ROLEPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_ROLEPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_DBA_ROLEPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'dbaRolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_ROLEPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_ROLEPRIVS_DESC',
  p_impact => 'The DBA_ROLE_PRIVS view lists the roles granted to users and other roles. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_ROLEPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_ROLEPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_DBA_ROLEPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_TAB_PRIVS View',
                p_column_label_nlsid =>'DBA_TAB_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaTabPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_TAB_PRIVS',
      p_metric_label_nlsid => 'DBA_TABPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_TAB_PRIVS',
      p_description_nlsid => 'DBA_TABPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_tabprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaTabPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_TAB_PRIVS',
      p_metric_label_nlsid => 'DBA_TABPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_TAB_PRIVS',
      p_description_nlsid => 'DBA_TABPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_tabprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_TAB_PRIVS_View',   --Policy name
  p_metric_name =>'dbaTabPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_TABPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_TAB_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_TABPRIVS_DESC',
  p_impact => 'Lists privileges granted to users or roles on objects in the database. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_TABPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_TAB_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_TABPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be insecure as user %grantee% has %privilege%  privilege to the DBA_TAB_PRIVS  view.',
  p_message_nlsid =>'ACCSS_DBA_TABPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_TAB_PRIVS_View',   --Policy name
  p_metric_name =>'dbaTabPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_TABPRIVS_NAME', 
  p_description =>'Ensures restricted access to DBA_TAB_PRIVS view',
  p_description_nlsid =>'ACCSS_DBA_TABPRIVS_DESC',
  p_impact => 'Lists privileges granted to users or roles on objects in the database. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_DBA_TABPRIVS_IMPACT',
  p_recommendation =>'Restrict access to DBA_TAB_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_TABPRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be insecure as user %grantee% has %privilege%  privilege to the DBA_TAB_PRIVS  view.',
  p_message_nlsid =>'ACCSS_DBA_TABPRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on DBA_USERS View',
                p_column_label_nlsid =>'DBA_USR_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'dbaUsersRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_USERS',
      p_metric_label_nlsid => 'DBA_USR_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_USERS',
      p_description_nlsid => 'DBA_USR_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_users''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'dbaUsersRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on DBA_USERS',
      p_metric_label_nlsid => 'DBA_USR_METRIC_LABEL',
      p_description  => 'Collect the database users having access on DBA_USERS',
      p_description_nlsid => 'DBA_USR_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_users''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_DBA_USERS_View',   --Policy name
  p_metric_name =>'dbaUsersRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_USERS_NAME', 
  p_description =>'Ensures restricted access to DBA_USERS view',
  p_description_nlsid =>'ACCSS_DBA_USERS_DESC',
  p_impact => 'Contains user password hashes and other account information. Access to this information can be used to mount brute-force attacks.',
  p_impact_nlsid =>'ACCSS_DBA_USERS_IMPACT',
  p_recommendation =>'Restrict access to DBA_USERS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_USERS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_USERS  view.',
  p_message_nlsid =>'ACCSS_DBA_USERS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_DBA_USERS_View',   --Policy name
  p_metric_name =>'dbaUsersRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_DBA_USERS_NAME', 
  p_description =>'Ensures restricted access to DBA_USERS view',
  p_description_nlsid =>'ACCSS_DBA_USERS_DESC',
  p_impact => 'Contains user password hashes and other account information. Access to this information can be used to mount brute-force attacks.',
  p_impact_nlsid =>'ACCSS_DBA_USERS_IMPACT',
  p_recommendation =>'Restrict access to DBA_USERS view.',
  p_recommendation_nlsid =>'ACCSS_DBA_USERS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the DBA_USERS  view.',
  p_message_nlsid =>'ACCSS_DBA_USERS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on ROLE_ROLE_PRIVS View',
                p_column_label_nlsid =>'ROLE_ROLE_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'rolerolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on ROLE_ROLE_PRIVS',
      p_metric_label_nlsid => 'ROLE_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on ROLE_ROLE_PRIVS',
      p_description_nlsid => 'ROLE_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'rolerolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on ROLE_ROLE_PRIVS',
      p_metric_label_nlsid => 'ROLE_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on ROLE_ROLE_PRIVS',
      p_description_nlsid => 'ROLE_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_dba_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_ROLE_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'rolerolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_ROLE_ROLE_NAME', 
  p_description =>'Ensures restricted access to ROLE_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_ROLE_ROLE_DESC',
  p_impact => 'Lists roles granted to other roles. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_ROLE_ROLE_IMPACT',
  p_recommendation =>'Restrict access to ROLE_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_ROLE_ROLE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the ROLE_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_ROLE_ROLE_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_ROLE_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'rolerolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_ROLE_ROLE_NAME', 
  p_description =>'Ensures restricted access to ROLE_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_ROLE_ROLE_DESC',
  p_impact => 'Lists roles granted to other roles. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_ROLE_ROLE_IMPACT',
  p_recommendation =>'Restrict access to ROLE_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_ROLE_ROLE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the ROLE_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_ROLE_ROLE_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on USER_TAB_PRIVS View',
                p_column_label_nlsid =>'USR_TAB_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(

      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'userTabPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on USER_TAB_PRIVS',
      p_metric_label_nlsid => 'USR_TAB_PRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_TAB_PRIVS',
      p_description_nlsid => 'USR_TAB_PRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_tabprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(

      p_target_type => 'rac_database',
      p_metric_name => 'userTabPrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on USER_TAB_PRIVS',
      p_metric_label_nlsid => 'USR_TAB_PRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_TAB_PRIVS',
      p_description_nlsid => 'USR_TAB_PRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_tabprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
    -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    	MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_USER_TAB_PRIVS_View',   --Policy name
  p_metric_name =>'userTabPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_TAB_PRIVS_NAME', 
  p_description =>'Ensures restricted access to USER_TAB_PRIVS view',
  p_description_nlsid =>'ACCSS_USER_TAB_PRIVS_DESC',
  p_impact => 'Lists the grants on objects for which the user is the owner, grantor or grantee. Knowledge of the grants in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_USER_TAB_PRIVS_IMPACT',
  p_recommendation =>'Restrict access to USER_TAB_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_USER_TAB_PRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER_TAB_PRIVS  view.',
  p_message_nlsid =>'ACCSS_USER_TAB_PRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_USER_TAB_PRIVS_View',   --Policy name
  p_metric_name =>'userTabPrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_TAB_PRIVS_NAME', 
  p_description =>'Ensures restricted access to USER_TAB_PRIVS view',
  p_description_nlsid =>'ACCSS_USER_TAB_PRIVS_DESC',
  p_impact => 'Lists the grants on objects for which the user is the owner, grantor or grantee. Knowledge of the grants in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_USER_TAB_PRIVS_IMPACT',
  p_recommendation =>'Restrict access to USER_TAB_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_USER_TAB_PRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER_TAB_PRIVS  view.',
  p_message_nlsid =>'ACCSS_USER_TAB_PRIVS_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
	    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object Privilege on USER_ROLE_PRIVS View',
                p_column_label_nlsid =>'USR_ROLE_PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
		p_column_name => 'dummy',  
		p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
		p_is_key => MGMT_GLOBAL.G_FALSE, 
		p_column_label => 'Dummy',  
		p_column_label_nlsid =>'DUMMY_COL'));     
  -- METRIC CREATION 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'userRolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on USER_ROLE_PRIVS',
      p_metric_label_nlsid => 'USR_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_ROLE_PRIVS',
      p_description_nlsid => 'USR_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'userRolePrivsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Database Users with Access on USER_ROLE_PRIVS',
      p_metric_label_nlsid => 'USR_ROLEPRIV_METRIC_LABEL',
      p_description  => 'Collect the database users having access on USER_ROLE_PRIVS',
      p_description_nlsid => 'USR_ROLEPRIV_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, '
                 ||'value as grantee, value2 as privilege,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property =''access_user_roleprivs''',
     p_snapshot_name_list => l_snapshot_list,
     p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-- POLICY CREATION
     -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges assigned to user.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee',
                p_url_link_template =>'database/security/user?oname=^grantee^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Access_To_USER_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'userRolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_ROLE_PRIV_NAME', 
  p_description =>'Ensures restricted access to USER_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_USER_ROLE_PRIV_DESC',
  p_impact => 'Lists the roles granted to the current user. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_USER_ROLE_PRIV_IMPACT',
  p_recommendation =>'Restrict access to USER_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_USER_ROLE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_USER_ROLE_PRIV_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Access_To_USER_ROLE_PRIVS_View',   --Policy name
  p_metric_name =>'userRolePrivsRep',      --Metric name
  p_policy_label_nlsid =>'ACCSS_USER_ROLE_PRIV_NAME', 
  p_description =>'Ensures restricted access to USER_ROLE_PRIVS view',
  p_description_nlsid =>'ACCSS_USER_ROLE_PRIV_DESC',
  p_impact => 'Lists the roles granted to the current user. Knowledge of the structure of roles in the database can be taken advantage of by a malicious user.',
  p_impact_nlsid =>'ACCSS_USER_ROLE_PRIV_IMPACT',
  p_recommendation =>'Restrict access to USER_ROLE_PRIVS view.',
  p_recommendation_nlsid =>'ACCSS_USER_ROLE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. User %grantee% has %privilege%  privilege on the USER_ROLE_PRIVS view.',
  p_message_nlsid =>'ACCSS_USER_ROLE_PRIV_MESG',
  p_auto_enable => l_auto_enable,    -- auto_enable is disabled for the following policies
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList		
);
COMMIT ;
 
------------------------------------------------------------------------------------
   --sqlnet.allowed_logon_version parameter in sqlnet.ora

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
              p_column_name => 'version',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Allowed Client Logon Version',
                p_column_label_nlsid => 'ALLOWED_LOGON_VERSION_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbversion',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Database Version',
                p_column_label_nlsid => 'ALLOWED_LOGON_DBVERSION_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid => 'DUMMY_COL'));

   MGMT_METRIC.CREATE_METRIC(
       p_target_type => ESM.DB_TARGET_TYPE,
       p_metric_name => 'sqlnetAllowedLogonVersionRep',
       p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
       p_valid_if_list => l_valid_if_list,
       p_metric_type => l_metric_type,
       p_metric_label => 'Allowed Client Logon Version',
       p_metric_label_nlsid => 'ALLOWED_LOGON_VERSION_LABEL',
       p_description => 'Ensures that the server allows logon from clients with a matching version or higher only.',
       p_description_nlsid => 'ALLOWED_LOGON_VERSION_DESC',
       p_is_repository => MGMT_GLOBAL.G_TRUE,
       p_author => ESM.METRIC_AUTHOR,
       p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
       p_source => 'SELECT target_guid, value as version, value2 as dbversion, value2 as dummy '
                  ||'FROM esm_collection_latest '
                  ||'WHERE property = ''allowed_logon_version''',
       p_snapshot_name_list => l_snapshot_list,
       p_metric_column_list => l_metric_column_list
   );
   COMMIT ;

---------------Metric sqlnetAllowedLogonVersions Ends---------------------------------
---------------Policy starts here-----------------------------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'version'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dbversion'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Sqlnet_Allowed_Logon_Version',   --Policy name
  p_metric_name =>'sqlnetAllowedLogonVersionRep',      --Metric name
  p_policy_label_nlsid =>'ALLOWED_LOGON_VERSION_NAME',
  p_description =>'Ensures that the server allows logon from clients with a matching version or higher only.',
  p_description_nlsid =>'ALLOWED_LOGON_VERSION_DESC',
  p_impact =>'Setting the parameter SQLNET.ALLOWED_LOGON_VERSION in sqlnet.ora to a version lower than the server version will force the server to use a less secure authentication protocol',
  p_impact_nlsid =>'ALLOWED_LOGON_VERSION_IMPACT',
  p_recommendation =>'Set the parameter SQLNET.ALLOWED_LOGON_VERSION in sqlnet.ora to the server''s major version. Setting this value to older versions could expose vulnerabilities that may have existed in the authentication protocols.',
  p_recommendation_nlsid =>'ALLOWED_LOGON_VERSION_RECOM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  ':version <> :dbversion',
  p_message =>'Database is in an insecure state. The SQLNET.ALLOWED_LOGON_VERSION parameter is set to %version%.',
  p_message_nlsid =>'ALLOWED_LOGON_VERSION_MESSAGE',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT;

--------------Policy ends here------------------------------------------------------------


---------------Metric secureOSAuditLevel starts-----------------------------

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'logLevel',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Audit Syslog Level',
                p_column_label_nlsid => 'SECURE_OS_AUDIT_LEVEL_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid => 'DUMMY_COL'));

   MGMT_METRIC.CREATE_METRIC(
       p_target_type => ESM.DB_TARGET_TYPE,
       p_metric_name => 'secureOSAuditLevelRep',
       p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
       p_valid_if_list => l_valid_if_list,
       p_metric_type => l_metric_type,
       p_metric_label => 'Secure Audit System Log Level',
       p_metric_label_nlsid => 'SECURE_OS_AUDIT_LEVEL_LABEL',
       p_description => 'On UNIX systems, ensures that AUDIT_SYSLOG_LEVEL is set to a non-default value when OS-level auditing is enabled.',
       p_description_nlsid => 'SECURE_OS_AUDIT_LEVEL_DESC',
       p_is_repository => MGMT_GLOBAL.G_TRUE,
       p_author => ESM.METRIC_AUTHOR,
       p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
       p_source => 'SELECT target_guid, value as logLevel, value as dummy '
                  ||'FROM esm_collection_latest '
                  ||'WHERE property = ''audit_syslog_level''',
       p_snapshot_name_list => l_snapshot_list,
       p_metric_column_list => l_metric_column_list
   );
   COMMIT ;

---------------Metric secureOSAuditLevel Ends---------------------------------

---------------Policy secureOSAuditLevel Starts-------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'logLevel'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Secure_OS_Audit_Level',   --Policy name
  p_metric_name =>'secureOSAuditLevelRep',      --Metric name
  p_policy_label_nlsid =>'SECURE_OS_AUDIT_LEVEL_NAME',
  p_description =>'On UNIX systems, ensures that AUDIT_SYSLOG_LEVEL is set to a non-default value when OS-level auditing is enabled.',
  p_description_nlsid =>'SECURE_OS_AUDIT_LEVEL_DESC',
  p_impact =>'Setting the AUDIT_SYSLOG_LEVEL initialization parameter to the default value (NONE) will result in DBAs gaining access to the OS audit records',
  p_impact_nlsid =>'SECURE_OS_AUDIT_LEVEL_IMPACT',
  p_recommendation =>'When operating system auditing is enabled, set the AUDIT_SYSLOG_LEVEL initialization parameter to a valid value and configure /etc/syslog.conf so that Oracle OS audit records are written to a seperate file.',
  p_recommendation_nlsid =>'SECURE_OS_AUDIT_LEVEL_RECOM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'UPPER(:logLevel) = ''NONE'' OR :logLevel = '' ''',
  p_message =>'Database is in an insecure state. The AUDIT_SYSLOG_LEVEL initialization parameter is set to %logLevel%.',
  p_message_nlsid =>'SECURE_OS_AUDIT_LEVEL_MESSAGE',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT;

--------------Policy ends here------------------------------------------------------------


-- ----------------------------------------------------------------------------------

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'),
	 MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Log Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_LOG_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'clientLogDirRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'Client Log Directory Permissions', 
      p_metric_label_nlsid => 'CLIENT_LOG_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect the permission of client log directories',
      p_description_nlsid => 'CLIENT_LOG_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as permission, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''client_log_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------



----------------Policy sqlnet_Client_Log_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'),
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
 
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Log_Dir',   --Policy name
  p_metric_name =>'clientLogDirRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_LOG_DIR_PERM_NAME',   
  p_description =>'Ensures that the client log directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'CLIENT_LOG_DIR_PERM_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_LOG_DIR_PERM_IMPACT',
  p_recommendation =>'The client log directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'CLIENT_LOG_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'trunc(mod(:permission,10),0) > 0', 
  p_message =>'The database is in an insecure state. The client log directory %dir_name%  has permission %permission%.',
  p_message_nlsid =>'CLIENT_LOG_DIR_PERM_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Owner',
                p_column_label_nlsid =>'OWNER_COL'),
	 MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Log Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_LOG_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'clientLogDirOwnerRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'Client Log Directory Owner', 
      p_metric_label_nlsid => 'CLIENT_LOG_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect owner of client log directory',
      p_description_nlsid => 'CLIENT_LOG_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as owner, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''client_log_directory_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------



----------------Policy sqlnet_Client_Log_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'owner'),
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
 
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Log_Dir_Owner',   --Policy name
  p_metric_name =>'clientLogDirOwnerRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_LOG_DIR_OWN_NAME',   
  p_description =>'Ensures that the client log directory is a valid directory owned by Oracle set',
  p_description_nlsid =>'CLIENT_LOG_DIR_OWN_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_LOG_DIR_OWN_IMPACT',
  p_recommendation =>'The client log directory must be a valid directory owned by the Oracle set.',
  p_recommendation_nlsid =>'CLIENT_LOG_DIR_OWN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The database is in an insecure state. The client log directory %dir_name% is owned by %owner%.',
  p_message_nlsid =>'CLIENT_LOG_DIR_OWN_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
----------------Policy sqlnet_Client_Log_Dir Start----------------------------------
   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'),
	 MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Log Directory (Absolute Path)',
                p_column_label_nlsid =>'SERV_LOG_DIR_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'svrLogDirRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'Server Log Directory Permissions', 
      p_metric_label_nlsid => 'SERV_LOG_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permissions of server log directory',
      p_description_nlsid => 'SERV_LOG_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as permission, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''server_log_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------
----------------Policy sqlnet_Server_Log_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'),
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Log_Dir',   --Policy name
  p_metric_name =>'svrLogDirRep',      --Metric name
  p_policy_label_nlsid =>'SERV_LOG_DIR_PERM_NAME',   
  p_description =>'Ensures that the server log directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'SERV_LOG_DIR_PERM_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_LOG_DIR_PERM_IMPACT',
  p_recommendation =>'The server log directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'SERV_LOG_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'trunc(mod(:permission,10),0) > 0', 
  p_message =>'The database is in an insecure state. The server log directory %dir_name%  has permission %permission%.',
  p_message_nlsid =>'SERV_LOG_DIR_PERM_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));

   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Owner',
                p_column_label_nlsid =>'OWNER_COL'),
	 MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Log Directory (Absolute Path)',
                p_column_label_nlsid =>'SERV_LOG_DIR_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'svrLogDirOwnerRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'Server Log Directory Owner', 
      p_metric_label_nlsid => 'SERV_LOG_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect owner of server log directory',
      p_description_nlsid => 'SERV_LOG_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as owner, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''server_log_directory_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------
----------------Policy sqlnet_Server_Log_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'owner'),
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Log_Dir_Owner',   --Policy name
  p_metric_name =>'svrLogDirOwnerRep',      --Metric name
  p_policy_label_nlsid =>'SERV_LOG_DIR_OWN_NAME',   
  p_description =>'Ensures that the server log directory is a valid directory owned by Oracle set',
  p_description_nlsid =>'SERV_LOG_DIR_OWN_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_LOG_DIR_OWN_IMPACT',
  p_recommendation =>'The server log directory must be a valid directory owned by the Oracle set.',
  p_recommendation_nlsid =>'SERV_LOG_DIR_OWN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The database is in an insecure state. The server log directory %dir_name% is owner by %owner%.',
  p_message_nlsid =>'SERV_LOG_DIR_OWN_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'),
	 MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Trace Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'clientTrcDirRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'Client Trace Directory Permissions', 
      p_metric_label_nlsid => 'CLIENT_TRC_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permission of client trace directory',
      p_description_nlsid => 'CLIENT_TRC_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as permission, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''client_trace_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------

----------------Policy sqlnet_Client_Trace_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'),
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Trace_Dir',   --Policy name
  p_metric_name =>'clientTrcDirRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_TRC_DIR_PERM_NAME',   
  p_description =>'Ensures that the client trace directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'CLIENT_TRC_DIR_PERM_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_TRC_DIR_PERM_IMPACT',
  p_recommendation =>'The client trace directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'CLIENT_TRC_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'trunc(mod(:permission,10),0) > 0', 
  p_message =>'The database is in an insecure state. The client trace directory %dir_name% has permission %permission%.',
  p_message_nlsid =>'CLIENT_TRC_DIR_PERM_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Owner',
                p_column_label_nlsid =>'OWNER_COL'),
	 MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Client Trace Directory (Absolute Path)',
                p_column_label_nlsid =>'CLIENT_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'clientTrcDirOwnerRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'Client Trace Directory Owner', 
      p_metric_label_nlsid => 'CLIENT_TRC_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect owner of client trace directories',
      p_description_nlsid => 'CLIENT_TRC_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as owner, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''client_trace_directory_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------

----------------Policy sqlnet_Client_Trace_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'owner'),
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Trace_Dir_Owner',   --Policy name
  p_metric_name =>'clientTrcDirOwnerRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_TRC_DIR_OWN_NAME',   
  p_description =>'Ensures that the client trace directory is a valid directory owned by Oracle set',
  p_description_nlsid =>'CLIENT_TRC_DIR_OWN_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_TRC_DIR_OWN_IMPACT',
  p_recommendation =>'The client trace directory must be a valid directory owned by the Oracle set.',
  p_recommendation_nlsid =>'CLIENT_TRC_DIR_OWN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The database is in an insecure state. The client trace directory %dir_name% is owned by %owner%.',
  p_message_nlsid =>'CLIENT_TRC_DIR_OWN_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
----------------Policy sqlnet_Client_Trace_Dir Start----------------------------------

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'),
	 MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Trace Direcotry (Absolute Path)',
                p_column_label_nlsid =>'SERV_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'svrTrcDirRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'Server Trace Directory Permissions', 
      p_metric_label_nlsid => 'SERV_TRC_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect permissions of server trace directories',
      p_description_nlsid => 'SERV_TRC_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as permission, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''server_trace_directory_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------

----------------Policy sqlnet_Server_Trace_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'),
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Trace_Dir',   --Policy name
  p_metric_name =>'svrTrcDirRep',      --Metric name
  p_policy_label_nlsid =>'SERV_TRC_DIR_PERM_NAME',   
  p_description =>'Ensures that the server trace directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'SERV_TRC_DIR_PERM_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_TRC_DIR_PERM_IMPACT',
  p_recommendation =>'The server trace directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'SERV_TRC_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'trunc(mod(:permission,10),0) > 0', 
  p_message =>'The database is in an insecure state. The server trace directory %dir_name% has permission %permission%.',
  p_message_nlsid =>'SERV_TRC_DIR_PERM_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
     MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Owner',
                p_column_label_nlsid =>'OWNER_COL'),
	 MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Server Trace Direcotry (Absolute Path)',
                p_column_label_nlsid =>'SERV_TRC_DIR_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'svrTrcDirOwnerRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'Server Trace Directory Owner', 
      p_metric_label_nlsid => 'SERV_TRC_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect owner of server trace directories',
      p_description_nlsid => 'SERV_TRC_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid,value as owner, '
                 ||'value2 as dir_name FROM esm_collection_latest  '
                 ||'WHERE property =''server_trace_directory_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------

----------------Policy sqlnet_Server_Trace_Dir Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'owner'),
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Trace_Dir_Owner',   --Policy name
  p_metric_name =>'svrTrcDirOwnerRep',      --Metric name
  p_policy_label_nlsid =>'SERV_TRC_DIR_OWN_NAME',   
  p_description =>'Ensures that the server trace directory is a valid directory owned by Oracle set',
  p_description_nlsid =>'SERV_TRC_DIR_OWN_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_TRC_DIR_OWN_IMPACT',
  p_recommendation =>'The server trace directory must be a valid directory owned by the Oracle set.',
  p_recommendation_nlsid =>'SERV_TRC_DIR_OWN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The database is in an insecure state. The server trace directory %dir_name% is owned by %owner%.',
  p_message_nlsid =>'SERV_TRC_DIR_OWN_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
----------------Metric sqlnetora_metric Start----------------------------------

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Permission (In Octal)',
                p_column_label_nlsid =>'PERM_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlnetOraPermRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,   --table 			
      p_metric_label => 'SqlnetOra Permissions', 
      p_metric_label_nlsid => 'SQLNET_PERM_METRIC_LABEL',
      p_description  => 'Collect the permission information of sqlnet.ora file',
      p_description_nlsid => 'SQLNET_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property =''sqlnetora_permission''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT ;
----------------Metric sqlnetora_metric End----------------------------------

----------------Policy sqlnet_Ora_Restrict_Perms Start----------------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
	MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'permission'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Sqlnet_Ora_Restrict_Perms',   --Policy name
  p_metric_name =>'sqlnetOraPermRep',      --Metric name
  p_policy_label_nlsid =>'SQLNET_PERM_NAME',   
  p_description =>'Ensures that the sqlnet.ora file is not accessible to public',
  p_description_nlsid =>'SQLNET_PERM_DESC',
  p_impact =>'If sqlnet.ora is public readable a malicious user may attempt to read this hence could lead to sensitive information getting exposed .For example, log and trace destination information of the client and server.',
  p_impact_nlsid =>'SQLNET_PERM_IMPACT',
  p_recommendation =>'Public should not be given any  permissions on the sqlnet.ora file.',
  p_recommendation_nlsid =>'SQLNET_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'trunc(mod(:permission,10)/2,0) > 0',--'substr(:permission,-3,2) <> ''--'' ',
  p_message =>'Database is in insecure state. The sqlnet.ora file has permission %permission%.',
  p_message_nlsid =>'SQLNET_PERM_MESG',
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
----------------Policy sqlnet_Ora_Restrict_Perms End----------------------------------



-- ------------------------------------------------------------------------------------ 


-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbuser',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Database User',
                p_column_label_nlsid =>'DBUSER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'accountstatus',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Account Status',
                p_column_label_nlsid =>'ACCOUNT_STAT_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'installAndDemoAcccountsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as accountstatus,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default_user_account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'installAndDemoAcccountsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as accountstatus,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default_user_account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify account setting for the db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'dbuser',
                p_url_link_template =>'database/security/user?oname=^dbuser^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
      	MGMT_VIOL_CTXT_DEF.NEW(
	        	p_metric_column => 'accountstatus'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Well_known_Accounts',   --Policy name
  p_metric_name =>'installAndDemoAcccountsRep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT2_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as %dbuser%''s account status is %accountstatus%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT2_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Well_known_Accounts',   --Policy name
  p_metric_name =>'installAndDemoAcccountsRep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT2_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as %dbuser%''s account status is %accountstatus%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT2_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;




-- Atmost three rows
-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 ); 
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'package',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Package',
                p_column_label_nlsid =>'PKG_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,--here?
      p_metric_name => 'executePrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,    -- No end meta version since it is applicable for 10gR1 + 10gR2
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Public Execute Privileges on Powerful Packages(UTL_TCP,UTL_HTTP)',
      p_metric_label_nlsid =>'PKG_METRIC_LABEL',
      p_description  => 'Collect information of the system packages on which '||
                        'PUBLIC execute privileges has been granted',
      p_description_nlsid => 'PKG_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as package,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC can execute'' AND value in (''UTL_HTTP'',''UTL_TCP'',''UTL_SMTP'')',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'executePrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,    -- No end meta version since it is applicable for 10gR1 + 10gR2
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Public Execute Privileges on Powerful Packages(UTL_TCP,UTL_HTTP)',
      p_metric_label_nlsid =>'PKG_METRIC_LABEL',
      p_description  => 'Collect information of the system packages on which '||
                        'PUBLIC execute privileges has been granted',
      p_description_nlsid => 'PKG_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as package,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC can execute'' AND value in (''UTL_HTTP'',''UTL_TCP'',''UTL_SMTP'')',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
 
 -- This Url will take user to USER EDIT SETTING PAGE
 -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE, --here1?
  p_policy_name =>'Excessive_PUBLIC_EXECUTE_privileges',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_EXE_PRIV_NAME',    
  p_description =>'Ensure PUBLIC does not have execute privileges on powerful packages (UTL_HTTP and UTL_SMTP)',
  p_description_nlsid =>'PUB_EXE_PRIV_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on powerful packages.',
  p_recommendation_nlsid =>'PUB_EXE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database', --here1?
  p_policy_name =>'Excessive_PUBLIC_EXECUTE_privileges',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_EXE_PRIV_NAME',    
  p_description =>'Ensure PUBLIC does not have execute privileges on powerful packages (UTL_HTTP and UTL_SMTP)',
  p_description_nlsid =>'PUB_EXE_PRIV_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on powerful packages.',
  p_recommendation_nlsid =>'PUB_EXE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;


-- Metric may collect atmost four row per database target
-- One row per policy
-- These are violation row
-- Each Policy may result in one violation row
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'package',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Package',
                p_column_label_nlsid =>'PKG_COL'),
           MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'pubexecutePrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Public Execute Privileges on UTL_FILE,DBMS_JOB,DBMS_LOB',
      p_metric_label_nlsid => 'DBMSPKG_METRIC_LABEL',
      p_description  => 'Collect information of the system packages on which '||
                        'PUBLIC execute privileges has been granted',
      p_description_nlsid => 'PKG_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as package,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC can execute'' AND value in (''UTL_FILE'',''DBMS_SYS_SQL'',''DBMS_JOB'',''DBMS_LOB'')',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'pubexecutePrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Public Execute Privileges on UTL_FILE,DBMS_JOB,DBMS_LOB',
      p_metric_label_nlsid => 'DBMSPKG_METRIC_LABEL',
      p_description  => 'Collect information of the system packages on which '||
                        'PUBLIC execute privileges has been granted',
      p_description_nlsid => 'PKG_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as package,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC can execute'' AND value in (''UTL_FILE'',''DBMS_SYS_SQL'',''DBMS_JOB'',''DBMS_LOB'')',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
 
  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'EXECUTE_UTL_FILE_Privileges_To_PUBLIC',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_FILE_PKG_NAME',    
  p_description =>'Ensure PUBLIC does not have EXECUTE privilege on the UTL_FILE package',
  p_description_nlsid =>'UTL_FILE_PKG_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can read and write arbitrary files in the system when granted  the UTL_FILE privilege.',
  p_impact_nlsid =>'UTL_FILE_PKG_IMPACT',
  p_recommendation => 'Revoke EXECUTE privileges granted  to UTL_FILE package from  PUBLIC.',
  p_recommendation_nlsid =>'UTL_FILE_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_FILE''',
  p_message =>'Database is in an insecure state. EXECUTE privilege on UTL_FILE package is granted to PUBLIC.',
  p_message_nlsid =>'UTL_FILE_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'EXECUTE_UTL_FILE_Privileges_To_PUBLIC',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_FILE_PKG_NAME',    
  p_description =>'Ensure PUBLIC does not have EXECUTE privilege on the UTL_FILE package',
  p_description_nlsid =>'UTL_FILE_PKG_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can read and write arbitrary files in the system when granted  the UTL_FILE privilege.',
  p_impact_nlsid =>'UTL_FILE_PKG_IMPACT',
  p_recommendation => 'Revoke EXECUTE privileges granted  to UTL_FILE package from  PUBLIC.',
  p_recommendation_nlsid =>'UTL_FILE_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_FILE''',
  p_message =>'Database is in an insecure state. EXECUTE privilege on UTL_FILE package is granted to PUBLIC.',
  p_message_nlsid =>'UTL_FILE_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList	
);
COMMIT;


  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_JOB',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_JOB_PKG_NAME',    
  p_description =>'Ensures PUBLIC is not granted EXECUTE privileges on DBMS_JOB package',
  p_description_nlsid =>'DBMS_JOB_PKG_DESC',
  p_impact => 'Granting EXECUTE privilege to PUBLIC on DBMS_JOB package allows users to schedule jobs on the database.',
  p_impact_nlsid =>'DBMS_JOB_PKG_IMPACT',
  p_recommendation =>'PUBLIC must not be granted EXECUTE privileges on  DBMS_JOB package.',
  p_recommendation_nlsid =>'DBMS_JOB_PRIVS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_JOB''',
  p_message =>'Database is in an insecure state. DBMS_JOB package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_JOB_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_SYS_SQL',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_SYS_SQL_PKG_NAME',
  p_description =>'Ensures PUBLIC is not granted EXECUTE privileges on DBMS_SYS_SQL package',
  p_description_nlsid =>'DBMS_SYS_SQL_PKG_DESC', 
  p_impact => 'The DBMS_SYS_SQL package can be used to run PL/SQL and SQL as the owner of the procedure rather than the caller.',
  p_impact_nlsid =>'DBMS_SYS_SQL_PKG_IMPACT',
  p_recommendation =>'Revoke the EXECUTE privileges on DBMS_SYS_SQL package from the PUBLIC group.',
  p_recommendation_nlsid =>'DBMS_SYS_SQL_PKG_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_SYS_SQL''',
  p_message =>'Database is in an insecure state. DBMS_SYS_SQL package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_SYS_SQL_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


  -- This Url will take user to USER EDIT SETTING PAGE
  -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'PUBLIC_Privileges_To_DBMS_LOB',   --Policy name
  p_metric_name =>'pubexecutePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'DBMS_LOB_PKG_NAME',    
  p_description =>'Ensures PUBLIC group is not granted EXECUTE privileges to the DBMS_LOB package',
  p_description_nlsid =>'DBMS_LOB_PKG_DESC', 
  p_impact => 'The DBMS_LOB package can be used to access any file on the system as the owner of the Oracle software installation.',
  p_impact_nlsid =>'DBMS_LOB_PKG_IMPACT',
  p_recommendation =>'Revoke the EXECUTE privileges on DBMS_LOB package from the PUBLIC group.',
  p_recommendation_nlsid =>'DBMS_LOB_PKG_RECOMM',
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type => MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''DBMS_LOB''',
  p_message =>'Database is in an insecure state. DBMS_LOB package has PUBLIC EXECUTE privileges.',
  p_message_nlsid =>'DBMS_LOB_PKG_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  ESM.DB_TYPE_META_VERSION,  -- Applicable for 10gR2 only
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 ); 
  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'privilege',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,  -- Assuming some system priv can be given to pub
                p_column_label => 'System Privilege',
                p_column_label_nlsid =>'PRIV_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'systemPrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver, -- Applicable for 10gR1 + 10gR2
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'System Privileges to Public',
      p_metric_label_nlsid => 'PRIV_METRIC_LABEL',
      p_description  => 'Collect the information of  system privileges which has been granted to PUBLIC',
      p_description_nlsid => 'PRIV_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as privilege,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC has SYSTEM privilege''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'systemPrivilegesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver, -- Applicable for 10gR1 + 10gR2
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'System Privileges to Public',
      p_metric_label_nlsid => 'PRIV_METRIC_LABEL',
      p_description  => 'Collect the information of  system privileges which has been granted to PUBLIC',
      p_description_nlsid => 'PRIV_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as privilege,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''PUBLIC has SYSTEM privilege''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;
   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can revoke SYSTEM privs from db-users .
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'privilege',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));

  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'System_Privileges_To_Public',   --Policy name
  p_metric_name =>'systemPrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_SYSPRIV_NAME',    
  p_description =>'Ensure system privileges are not granted to PUBLIC',
  p_description_nlsid =>'PUB_SYSPRIV_DESC',
  p_impact =>'Privileges granted to the public role automatically apply to all users. '||
             'There are security risks granting SYSTEM privileges to all users.',
  p_impact_nlsid =>'PUB_SYSPRIV_IMPACT',
  p_recommendation =>'Revoke SYSTEM privileges from public.',
  p_recommendation_nlsid =>'PUB_SYSPRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. System privilege %privilege% is assigned to PUBLIC.',
  p_message_nlsid =>'PUB_SYSPRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'System_Privileges_To_Public',   --Policy name
  p_metric_name =>'systemPrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_SYSPRIV_NAME',    
  p_description =>'Ensure system privileges are not granted to PUBLIC',
  p_description_nlsid =>'PUB_SYSPRIV_DESC',
  p_impact =>'Privileges granted to the public role automatically apply to all users. '||
             'There are security risks granting SYSTEM privileges to all users.',
  p_impact_nlsid =>'PUB_SYSPRIV_IMPACT',
  p_recommendation =>'Revoke SYSTEM privileges from public.',
  p_recommendation_nlsid =>'PUB_SYSPRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. System privilege %privilege% is assigned to PUBLIC.',
  p_message_nlsid =>'PUB_SYSPRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbaccount',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Database User',
                p_column_label_nlsid =>'DBUSER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'defaultAccountPasswordsRep',	
      p_type_meta_ver =>l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Default Accounts Password',
      p_metric_label_nlsid => 'DFLT_ACCT_PWD_METRIC_LABEL',
      p_description  => 'Collect the information of default users and passwords',
      p_description_nlsid => 'DFLT_ACCT_PWD_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, property, value as dbaccount,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''Default account uid/pwd''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'defaultAccountPasswordsRep',	
      p_type_meta_ver =>l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Default Accounts Password',
      p_metric_label_nlsid => 'DFLT_ACCT_PWD_METRIC_LABEL',
      p_description  => 'Collect the information of default users and passwords',
      p_description_nlsid => 'DFLT_ACCT_PWD_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, property, value as dbaccount,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''Default account uid/pwd''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

    -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify default account setting for the known db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'dbaccount',
                p_url_link_template =>'database/security/user?oname=^dbaccount^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Default_Passwords',   --Policy name
  p_metric_name =>'defaultAccountPasswordsRep',      --Metric name
  p_policy_label_nlsid =>'DFLT_ACT_PWD_NAME',   
  p_description =>'Ensure there are no default passwords for known accounts',
  p_description_nlsid =>'DFLT_ACT_PWD_DESC',
  p_impact =>'A malicious user can gain access to the database using default passwords.',
  p_impact_nlsid =>'DFLT_ACT_PWD_IMPACT',
  p_recommendation =>'All default passwords should be changed.',
  p_recommendation_nlsid =>'DFLT_ACT_PWD_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. Default password for the account %dbaccount% has not been changed.',
  p_message_nlsid =>'DFLT_ACT_PWD_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Default_Passwords',   --Policy name
  p_metric_name =>'defaultAccountPasswordsRep',      --Metric name
  p_policy_label_nlsid =>'DFLT_ACT_PWD_NAME',   
  p_description =>'Ensure there are no default passwords for known accounts',
  p_description_nlsid =>'DFLT_ACT_PWD_DESC',
  p_impact =>'A malicious user can gain access to the database using default passwords.',
  p_impact_nlsid =>'DFLT_ACT_PWD_IMPACT',
  p_recommendation =>'All default passwords should be changed.',
  p_recommendation_nlsid =>'DFLT_ACT_PWD_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. Default password for the account %dbaccount% has not been changed.',
  p_message_nlsid =>'DFLT_ACT_PWD_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;


-- ------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------


-- ------------------------------------------------------------------------------------------------
-- Metric may collect one row per database target
-- These may be non-violation or violation row
-- Policy may result in one violation row

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Remote Login Passwordfile',
                p_column_label_nlsid =>'RMT_LOGIN_PWDFILE_COL_'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'remoteLoginPasswordFileRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,
      p_metric_label => 'Remote Login Password File',
      p_metric_label_nlsid => 'RMT_LOGIN_PWDFILE_METRIC_LABEL',
      p_description  => 'Collect the information of remote login password file',
      p_description_nlsid => 'RMT_LOGIN_PWDFILE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''remote_login_passwordfile''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
 -- This Url will direct to Initialization Parameters page
 -- From you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=remote_login_passwordfile\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Remote_Password_File',   --Policy name
  p_metric_name =>'remoteLoginPasswordFileRep',      --Metric name
  p_policy_label_nlsid =>'RMT_LGIN_NAME',   
  p_description =>'Ensure REMOTE_LOGIN_PASSWORDFILE initialization parameter is set to EXCLUSIVE',
  p_description_nlsid =>'RMT_LGIN_DESC',
  p_impact =>'A malicious user can gain access to the database if remote password files are allowed.',
  p_impact_nlsid =>'RMT_LGIN_IMPACT',
  p_recommendation =>'For non-RAC configurations, Oracle recommends setting REMOTE_LOGIN_PASSWORDFILE '||
        'to ''EXCLUSIVE'' mode, thereby assigning specific users SYSDBA/SYSOPER privilege to manage the database.',
  p_recommendation_nlsid =>'RMT_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'upper(:value)=''SHARED''',
  p_message =>'Database is in an insecure state. REMOTE_LOGIN_PASSWORDFILE initialization parameter is set to %value%.',
  p_message_nlsid =>'RMT_LGIN_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT; 



-- Metric may collect one row per database target
-- These may be non-violation or violation row
-- Policy may result in one violation row
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Remote Os Authentication',
                p_column_label_nlsid =>'RMT_OS_AUTH_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'remoteAuthenticationRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Remote Os Authentication',
      p_metric_label_nlsid => 'RMT_OS_AUTH_METRIC_LABEL',
      p_description  => 'Collect the information of REMOTE_OS_AUTHENTICATION parameter setting',
      p_description_nlsid => 'RMT_OS_AUTH_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''remote_os_authent''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
  -- This Url will direct to Initialization Parameters page
 -- From you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=remote_os_authent\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Remote_OS_Authentication',   --Policy name
  p_metric_name =>'remoteAuthenticationRep',      --Metric name
  p_policy_label_nlsid =>'RMT_ROLE_AUTH_NAME',   
  p_description =>'Ensure REMOTE_OS_AUTHENT initialization parameter is set to FALSE',
  p_description_nlsid =>'RMT_ROLE_AUTH_DESC',
  p_impact =>'A malicious user can gain access to the database if remote OS authentication is allowed.',
  p_impact_nlsid =>'RMT_ROLE_AUTH_IMPACT',
  p_recommendation =>'Set the REMOTE_OS_AUTHENT initialization parameter to FALSE.',
  p_recommendation_nlsid =>'RMT_ROLE_AUTH_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'upper(:value) <> ''FALSE''',
  p_message =>'Database is in an insecure state. REMOTE_OS_AUTHENT initialization parameter is set to %value%.',
  p_message_nlsid =>'RMT_ROLE_AUTH_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver, 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;


-- Metric may collect one row per database target
-- These may be non-violation or violation row
-- Policy may result in one violation row
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
   MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Remote Os Roles',
                p_column_label_nlsid =>'RMT_OS_ROLES_COL'));
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'remoteRolesRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Remote Os Roles',
      p_metric_label_nlsid => 'RMT_OS_ROLES_METRIC_LABEL',
      p_description  => 'Collect the information of REMOTE_OS_ROLES parameter setting',
      p_description_nlsid => 'RMT_OS_ROLES_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''remote_os_roles''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
 -- This Url will direct to Initialization Parameters page
 -- From you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=remote_os_roles\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Remote_OS_Role',   --Policy name
  p_metric_name =>'remoteRolesRep',      --Metric name
  p_policy_label_nlsid =>'RMT_OS_ROLE_NAME',   
  p_description =>'Ensure REMOTE_OS_ROLES initialization parameter is set to FALSE',
  p_description_nlsid =>'RMT_OS_ROLE_DESC',
  p_impact =>'A malicious user can gain access to the database if remote users can be granted privileged roles.',
  p_impact_nlsid =>'RMT_OS_ROLE_IMPACT',
  p_recommendation =>'Set the REMOTE_OS_ROLES initialization parameter to FALSE.',
  p_recommendation_nlsid =>'RMT_OS_ROLE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'upper(:value) <> ''FALSE''',
  p_message =>'Database is in an insecure state. REMOTE_OS_ROLES initialization parameter is set to %value%.',
  p_message_nlsid =>'RMT_OS_ROLE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver, 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

-- To support 10gR1 agent version we need to write one policy and one metric
--------------------------------------------------------------------------------------------------
-- This metric collect all the dbuser which has unlimited failed login attmpt assigned thru some profile
-- There may be many rows and all will be violation row only.
-- The followig code is 10gR1 agent metric(unlimitedFailedLoginAttempts) impl
-- SELECT 'Unlimited login attempts', u.username
-- FROM dba_users u, dba_profiles p
-- WHERE           p.resource_name = 'FAILED_LOGIN_ATTEMPTS'
--        AND     u.profile = p.profile
--        AND     p.limit = 'UNLIMITED'
--        AND  rownum < 200
--ORDER BY u.username

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbuser',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'DATABASE USER',
                p_column_label_nlsid =>'DBUSER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'unlimitedFailedLoginAttempts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- applicable upto 10gR1 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Db Users with Unlimited Login Attempts',
      p_metric_label_nlsid => 'USR_FAILED_LOGIN_ATTEMPTS_METRIC_LABEL',
      p_description  => 'Collect setting of FAILED_LOGIN_ATTEMPTS',
      p_description_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''Unlimited login attempts''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list, 
      p_end_type_meta_ver => l_10gR1_db_meta_ver    -- applicable upto 10gR1 
 );
COMMIT ;
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'unlimitedFailedLoginAttempts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- applicable upto 10gR1 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Db Users with Unlimited Login Attempts',
      p_metric_label_nlsid => 'USR_FAILED_LOGIN_ATTEMPTS_METRIC_LABEL',
      p_description  => 'Collect setting of FAILED_LOGIN_ATTEMPTS',
      p_description_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''Unlimited login attempts''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list, 
      p_end_type_meta_ver => l_10gR1_db_meta_ver    -- applicable upto 10gR1 
 );
COMMIT ;
  
  -- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
	         p_metric_column => 'dbuser'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
        MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Database_User_With_Unlimited_login_attempts',   --Policy name
  p_metric_name =>'unlimitedFailedLoginAttempts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'UNLMT_FAILED_LGIN_NAME',    
  p_description =>'Ensure that the number of allowed failed login attempts is set to a reasonable number of days for all users',
  p_description_nlsid =>'UNLMT_FAILED_LGIN_DESC',
  p_impact =>'Permits manual and automated password guessing by a malicious user.',
  p_impact_nlsid =>'UNLMT_FAILED_LGIN_IMPACT',
  p_recommendation =>'Oracle strongly recommends changing the parameter FAILED_LOGIN_ATTEMPTS '||
              'in user profiles to no more than 10.',
  p_recommendation_nlsid =>'UNLMT_FAILED_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as the UNLIMITED FAILED_LOGIN_ATTEMPTS is assigned to user %dbuser%.',
  p_message_nlsid =>'UNLMT_FAILED_LGIN1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_end_type_meta_ver => l_10gR1_db_meta_ver,	
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Database_User_With_Unlimited_login_attempts',   --Policy name
  p_metric_name =>'unlimitedFailedLoginAttempts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'UNLMT_FAILED_LGIN_NAME',    
  p_description =>'Ensure that the number of allowed failed login attempts is set to a reasonable number of days for all users',
  p_description_nlsid =>'UNLMT_FAILED_LGIN_DESC',
  p_impact =>'Permits manual and automated password guessing by a malicious user.',
  p_impact_nlsid =>'UNLMT_FAILED_LGIN_IMPACT',
  p_recommendation =>'Oracle strongly recommends changing the parameter FAILED_LOGIN_ATTEMPTS '||
              'in user profiles to no more than 10.',
  p_recommendation_nlsid =>'UNLMT_FAILED_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as the UNLIMITED FAILED_LOGIN_ATTEMPTS is assigned to user %dbuser%.',
  p_message_nlsid =>'UNLMT_FAILED_LGIN1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_end_type_meta_ver => l_10gR1_db_meta_ver,	
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;


-- Metric may collect more than one row per database target
-- These all are violation row
-- Policy may result in more than one violation row

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbuser',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'DATABASE USER(STATUS)',
                p_column_label_nlsid =>'DBUSER_STATUS_COL'),
         MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'installAndDemoAcccounts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default user account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list,
      p_end_type_meta_ver => l_10gR1_db_meta_ver	  -- Applicable for 10gR1 only
 );
COMMIT;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'installAndDemoAcccounts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type ,    			
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default user account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list,
      p_end_type_meta_ver => l_10gR1_db_meta_ver	  -- Applicable for 10gR1 only
 );
COMMIT;

   -- This Url will take user to USER EDIT SETTING PAGE
   -- From there he/she can modify account setting for the db-users.
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'dbuser',
                p_url_link_template =>'database/security/user?oname=^dbuser^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Well_known_Accounts_Status',   --Policy name 
  p_metric_name =>'installAndDemoAcccounts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT1_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as password status for db user is:%dbuser%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
  p_end_type_meta_ver => l_10gR1_db_meta_ver,	 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Well_known_Accounts_Status',   --Policy name 
  p_metric_name =>'installAndDemoAcccounts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT1_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as password status for db user is:%dbuser%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver =>  l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
  p_end_type_meta_ver => l_10gR1_db_meta_ver,	 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
END ;
/
show errors ;
SET ESCAPE OFF ;

