Rem
Rem $Header: lsnr_policies_dbc.sql18956 30-aug-2006.00:54:12 rmadampa Exp $
Rem
Rem lsnr_policies_dbc.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      lsnr_policies_dbc.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmadampa    08/30/06 - only for DBControl
Rem    rmadampa    08/30/06 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


DECLARE
 -- Metric Variable
 l_metric_column_list        	   	        MGMT_METRIC_COLUMN_ARRAY;
 l_metric_type					NUMBER ;
 l_snapshot_list				MGMT_SNAPSHOT_ARRAY; 
 -- Policy Variable
 l_ctxList    		     			MGMT_VIOL_CTXT_DEF_ARRAY; 
 l_paramDefList        			        MGMT_POLICY_PARAM_DEF_ARRAY;
 l_defaultParamValList    		        MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList      		        MGMT_POLICY_KEY_VAL_ARRAY;
BEGIN
  l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE ;
  l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => ESM.LSNR_TARGET_TYPE,
                p_snapshot_name =>ESM.SECURITY_SNAPSHOT_TYPE));


---NEW metrics, one per policy START-----------------------------------
----lsnrDirectAdminMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. Which is also why we do not need a key column.
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'admin_status',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Direct Administration Status',
                p_column_label_nlsid =>'ADMIN_STATUS_COL'));
              
  MGMT_METRIC.CREATE_METRIC(--used by policy Listener_Direct_Administration
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrDirectAdminMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Direct Administration',
      p_metric_label_nlsid => 'LSNR_DIRECT_ADMIN_METRIC_LABEL',
      p_description  => 'Collect listener direct administration parameter',
      p_description_nlsid => 'LSNR_DIRECT_ADMIN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as admin_status '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''listenerAdmin''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----Listener_Direct_Administration POLICY START-----------------------
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'admin_status'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Listener_Direct_Administration',   --Policy name
  p_metric_name => 'lsnrDirectAdminMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_DIRECT_ADMIN_NAME',   --policylabelnlsid
  p_description  => 'Ensures that no runtime modifications to the listener configuration is allowed',
  p_description_nlsid =>'LSNR_DIRECT_ADMIN_DESC',    --Policy Decription NLSID
  p_impact =>'An attacker who has access to a running listener can perform runtime modifications (for example, SET operations) using the lsnrctl program.', 
  p_impact_nlsid =>'LSNR_DIRECT_ADMIN_IMPACT',  --Impact NLSID
  p_recommendation =>'All listeners must have direct administration disabled. Set ADMIN_RESTRICTIONS_listener_name to ON in listener.ora.', --Recommendation
  p_recommendation_nlsid =>'LSNR_DIRECT_ADMIN_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'UPPER(:admin_status)<>''ON'' AND UPPER(:admin_status)<>''TRUE''', --condition
  p_message =>'Listener is in an insecure state. Direct administration is enabled.',  --message
  p_message_nlsid =>'LSNR_DIRECT_ADMIN_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION, 
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --consider percentage
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----Listener_Direct_Administration POLICY END-----------------
----lsnrDirectAdminMetricRep METRIC END-----------------------


----lsnrHostNameMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. Uniqueness of hostname is being taken 
--care of at the agent side, and hence it can be a key column. This would enable the user to exclude a particular 
--hostname from being reported as a violation even if not specified as IP address. consider_percentage will give 
--the percentage of hostnames of that listener which are violating/non-violating(a listener can have a list of 
--addresses, each of which can have a hostname)
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required column(host_name) has to be a key column, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'host_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Host Name',
                p_column_label_nlsid =>'HOST_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy lsnr_Host_Name
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrHostNameMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Host Name',
      p_metric_label_nlsid => 'LSNR_HOST_NAME_METRIC_LABEL',
      p_description  => 'Collect listener hostname parameter',
      p_description_nlsid => 'LSNR_HOST_NAME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid ,value as host_name,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''host_name''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy lsnr_Host_Name Start ----------------------------
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'host_name'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Host_Name',   --Policy name
  p_metric_name => 'lsnrHostNameMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_HOST_NAME_NAME',   --policylabelnlsid
  p_description  => 'Ensures that the listener host is specified as IP address and not hostname in the listener.ora',
  p_description_nlsid =>'LSNR_HOST_NAME_DESC',    --Policy Decription NLSID
  p_impact =>'An insecure Domain Name System (DNS) Server can be taken advantage of for mounting a spoofing attack. Name server failure can result in the listener unable to resolved the host.', --Impact
  p_impact_nlsid =>'LSNR_HOST_NAME_IMPACT',  --Impact NLSID
  p_recommendation =>'Host should be specified as IP address in listener.ora.', --Recommendation
  p_recommendation_nlsid =>'LSNR_HOST_NAME_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'instr(translate(lower(:host_name), ''abcdefghijklmnopqrstuvwxyz'', ''aaaaaaaaaaaaaaaaaaaaaaaaaa''),''a'') > 0', --condition
  p_message =>'Host is not specified as IP address in listener.ora.',  --message
  p_message_nlsid =>'LSNR_HOST_NAME_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE, 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy lsnr_Host_Name End----------------------------
----lsnrHostNameMetricRep  METRIC END-----------------------


----lsnrLogFileOwnerMetricRep METRIC START-----------------------
--Only violating rows are pushed from the agent. So consider percentage is false. A listener can apparently have 
--only one logfile. Still, keeping 2 key columns to enable the user to exclude a pair of (owner_name,log_file_name) 
--from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required columns have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'File Owner',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Log File',
                p_column_label_nlsid =>'LOG_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy lsnr_Ora_Logfile_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrLogFileOwnerMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Log File Owner',
      p_metric_label_nlsid => 'LSNR_LOG_FILE_OWN_METRIC_LABEL',
      p_description  => 'listener logfile owner',
      p_description_nlsid => 'LSNR_LOG_FILE_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid ,value as file_name, value2 as file_owner,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''log_file_lsnr_own'' ',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Logfile_Own_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_owner'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Logfile_Own_Policy',   --Policy name
  p_metric_name => 'lsnrLogFileOwnerMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_LOG_FILE_OWN_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the listener log file is owned by the Oracle software owner',  
  p_description_nlsid =>'LSNR_LOG_FILE_OWN_DESC',    --Policy Decription NLSID
  p_impact =>'The information in the logfile can reveal important network and database connection details. Having a log file not owned by the Oracle software owner can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_LOG_FILE_OWN_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener logfile must be owned by Oracle software owner.', --Recommendation
  p_recommendation_nlsid =>'LSNR_LOG_FILE_OWN_RECOMM',  --Recommendation NLSID
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  --p_condition =>':property = ''log_file_listener''', --condition
  p_condition =>'rownum > 0', --condition
  p_message =>'The listener is in an insecure state. The listener log file %file_name% is owned by %file_owner%.', 
  p_message_nlsid =>'LSNR_LOG_FILE_OWN_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Logfile_Own_Policy End ----------------------------
----lsnrLogFileOwnerMetricRep  METRIC END-----------------------


----lsnrLogFilePermMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. A listener can apparently have 
--only one logfile. Still, keeping 2 key columns to enable the user to exclude a pair of (permission,log_file_name) 
--from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required columns have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Log File Permission',
                p_column_label_nlsid =>'LOG_FILE_PER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Log File',
                p_column_label_nlsid =>'LOG_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Logfile_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrLogFilePermMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Lsnr Log File Permission',
      p_metric_label_nlsid => 'LSNR_LOG_FILE_PERM_METRIC_LABEL',
      p_description  => 'Listener logfile permission',
      p_description_nlsid => 'LSNR_LOG_FILE_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as file_name, value2 as file_permission,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''log_file_lsnr_perm'' ',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Logfile_Perm_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_permission'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Logfile_Perm_Policy',   --Policy name
  p_metric_name => 'lsnrLogFilePermMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_LOG_FILE_PERM_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the listener logfile cannot be read by  or written to by public',  
  p_description_nlsid =>'LSNR_LOG_FILE_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'The information in the logfile can reveal important network and database connection details. Allowing access to the log file can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_LOG_FILE_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener logfile must not allow public to read/write to it. Restrict the file permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_LOG_FILE_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  --p_condition =>':property = ''log_file_listener''', --condition
  p_condition =>'trunc(mod(:file_permission,10)/2,0) > 0', --condition
  p_message =>'The listener is in an insecure state. The listener log file %file_name% has permission %file_permission%.', 
  p_message_nlsid =>'LSNR_LOG_FILE_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Logfile_Perm_Policy End ----------------------------
----lsnrLogFilePermMetricRep  METRIC END-----------------------





----lsnrTraceDirPermMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. A listener can apparently have only one tracedir. Still, keeping 2 
--key columns to enable the user to exclude a pair of (permission,trace_dir_name) from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required columns have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory Permission',
                p_column_label_nlsid =>'TRC_DIR_PERM_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory',
                p_column_label_nlsid =>'TRC_DIR_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracedir_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceDirPermMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Trace Directory Permission',
      p_metric_label_nlsid => 'LSNR_TRACE_DIR_PERM_METRIC_LABEL',
      p_description  => 'Collect listener trace directory permission',
      p_description_nlsid => 'LSNR_TRACE_DIR_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as dir_name, value2 as dir_permission,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''trace_dir_lsnr_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracedir_Perm_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY( --show all the columns in violations list
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_permission'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracedir_Perm_Policy',   --Policy name
  p_metric_name => 'lsnrTraceDirPermMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_DIR_PERM_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the listener trace directory does not have public read/write permissions',
  p_description_nlsid =>'LSNR_TRACE_DIR_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'Allowing access to the trace directory can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_DIR_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace directory must not allow public to read/write to it. Restrict the directory permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_DIR_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  --(check for existence of row for violation)
  --p_condition =>':property = ''trace_directory_listener_name''', --condition 
  p_condition =>'mod(:dir_permission,10) > 0', --dir_permission comes in octal. Taking mod with 10 gives the permission for others, which should be 0 for directories
  p_message =>'The listener is in an insecure state. The listener trace directory %dir_name% has permission %dir_permission%.',  
  p_message_nlsid =>'LSNR_TRACE_DIR_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracedir_Perm_Policy End ----------------------------
----lsnrTraceDirPermMetricRep  METRIC END-----------------------


----lsnrTraceDirOwnMetricRep METRIC START-----------------------
--Only violating rows are pushed from the agent. So consider percentage is false. A listener can apparently have 
--only one trace directory. Still, keeping 2 key columns to enable the user to exclude a pair of 
--(owner_name,trace_dir_name) from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required column have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory Owner',
                p_column_label_nlsid =>'TRC_DIR_OWNER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dir_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace Directory',
                p_column_label_nlsid =>'TRC_DIR_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracedir_Own_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceDirOwnMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Trace Directory Owner',
      p_metric_label_nlsid => 'LSNR_TRACE_DIR_OWN_METRIC_LABEL',
      p_description  => 'Collect listener trace directory owner',
      p_description_nlsid => 'LSNR_TRACE_DIR_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as dir_name, value2 as dir_owner,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''trace_dir_lsnr_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracedir_Own_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY( --show all the columns in violations list
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_owner'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracedir_Own_Policy',   --Policy name
  p_metric_name => 'lsnrTraceDirOwnMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_DIR_OWN_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the listener trace directory is a valid directory owned by Oracle software owner',
  p_description_nlsid =>'LSNR_TRACE_DIR_OWN_DESC',    --Policy Decription NLSID
  p_impact =>'Having a trace directory not owned by the Oracle software owner can expose the trace files to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_DIR_OWN_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace directory must be owned by the Oracle software owner.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_DIR_OWN_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'rownum > 0', --condition 
  p_message =>'The listener is in an insecure state. The listener trace directory %dir_name% is owned by %dir_owner%.',  
  p_message_nlsid =>'LSNR_TRACE_DIR_OWN_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracedir_Own_Policy End ----------------------------
----lsnrTraceDirOwnMetricRep  METRIC END-----------------------


----lsnrTraceFileOwnMetricRep METRIC START-----------------------
--Only violating rows are pushed from the agent. So consider percentage is false. A listener can apparently have 
--only one tracefile. Still, keeping 2 key columns to enable the user to exclude a pair of --(owner_name,trace_file_name) from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required column have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File Owner',
                p_column_label_nlsid =>'TRC_FILE_OWNER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File',
                p_column_label_nlsid =>'TRC_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracefile_Own_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceFileOwnMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Trace File Owner',
      p_metric_label_nlsid => 'LSNR_TRACE_FILE_OWN_METRIC_LABEL',
      p_description  => 'Collect listener trace file owner',
      p_description_nlsid => 'LSNR_TRACE_FILE_OWN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as file_name, value2 as file_owner,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''trace_file_lsnr_own''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracefile_Own_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_owner'),
	    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL
                ));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracefile_Own_Policy',   --Policy name
  p_metric_name => 'lsnrTraceFileOwnMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_FILE_OWN_NAME',   --policylabelnlsid
  p_description  => 'Ensures that the listener trace file owner is same as the Oracle software owner',
  p_description_nlsid =>'LSNR_TRACE_FILE_OWN_DESC',    --Policy Decription NLSID
  p_impact =>'Having trace files not owned by the Oracle software owner can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_FILE_OWN_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace file must be owned by Oracle software owner.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_FILE_OWN_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
 -- p_condition =>':property = ''trace_file_listener_name'' ', --condition
  p_condition =>'rownum > 0',
  p_message =>'The listener is in an insecure state. The listener trace file %file_name% is owned by %file_owner%.',  --message
  p_message_nlsid =>'LSNR_TRACE_FILE_OWN_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracefile_Own_Policy End----------------------------
----lsnrTraceFileOwnMetricRep  METRIC END-----------------------



----lsnrTraceFilePermMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. A listener can apparently have only one tracefile. Still, keeping 
--2 key columns to enable the user to exclude a pair of (owner_name,trace_file_name) from evaluation.
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required columns have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File Permission',
                p_column_label_nlsid =>'TRC_FILE_PERM_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Trace File',
                p_column_label_nlsid =>'TRC_FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Lsnr_Tracefile_Perm_Policy
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrTraceFilePermMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Trace File Permissions',
      p_metric_label_nlsid => 'LSNR_TRACE_FILE_PERM_METRIC_LABEL',
      p_description  => 'Collect listener trace file permission',
      p_description_nlsid => 'LSNR_TRACE_FILE_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , '
                 ||'value as file_name, value2 as file_permission,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''trace_file_lsnr_perm''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy Lsnr_Tracefile_Perm_Policy Start ----------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_permission'),
	    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL
                ));

 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracefile_Perm_Policy',   --Policy name
  p_metric_name => 'lsnrTraceFilePermMetricRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_FILE_PERM_NAME',   --policylabelnlsid
  p_description  => 'Ensures that the listener trace file is not accessible to public',
  p_description_nlsid =>'LSNR_TRACE_FILE_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'Allowing access to the trace files can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_FILE_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace file must not allow public to read/write to it. Restrict the file permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_FILE_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
 -- p_condition =>':property = ''trace_file_listener_name'' ', --condition
  p_condition =>'trunc(mod(:file_permission,10)/2,0) > 0',--file_permission value comes in octal. Taking mod with 
  --10 gives the permission for others. Truncating this after dividing by 2 makes the execute bit a don't care bit.
  --All other bits(r  and   
  p_message =>'The listener is in an insecure state. The listener trace file %file_name% has permission %file_permission%.',  --message
  p_message_nlsid =>'LSNR_TRACE_FILE_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy Lsnr_Tracefile_Perm_Policy End----------------------------
----lsnrTraceFilePermMetricRep  METRIC END-----------------------


----lsnrPasswdMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. Hence do not need key columns.
--AGENT METRIC : lsnrCmdStatus, perl fetchlet lsnrCmdStatus.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'pwd_status',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Listener Password Status',
                p_column_label_nlsid =>'LSNR_PWD_STATUS_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Listener_Password
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrPasswdMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Password',
      p_metric_label_nlsid => 'LSNR_PASSWD_METRIC_LABEL',
      p_description  => 'Collect listener password parameter',
      p_description_nlsid => 'LSNR_PASSWD_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as pwd_status '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''listenerPwd''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
---Listener_Password POLICY START-----------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'pwd_status'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Listener_Password',   --Policy name
  p_metric_name =>'lsnrPasswdMetricRep',      --Metric name
  p_policy_label_nlsid =>'LSNR_PASSWD_NAME',    
  p_description =>'Ensures that access to listener is password protected',
  p_description_nlsid =>'LSNR_PASSWD_DESC',
  p_impact =>'Without password protection, a user can gain access to the listener. Once someone has access to the listener, he/she can stop the listener. He/she can also set a password and prevent others from managing the listener.',
  p_impact_nlsid =>'LSNR_PASSWD_IMPACT',
  p_recommendation =>'All listeners should be protected by a non-trivial password using the CHANGE_PASSWORD command.',
  p_recommendation_nlsid =>'LSNR_PASSWD_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'UPPER(:pwd_status) <> ''ON''',
  p_message =>'Listener is in an insecure state. It is running without password protection.',
  p_message_nlsid => 'LSNR_PASSWD_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage => MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list => l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList	
);
COMMIT ;
---Listener_Password POLICY END--------------------------
----lsnrPasswdMetricRep  METRIC END-----------------------


----lsnrLogStatusMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. But consider percentage does not make 
--sense as one listener will have only one row. Hence do not need key columns.
--AGENT METRIC : lsnrCmdStatus, perl fetchlet lsnrCmdStatus.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'log_status',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Logging Status',
                p_column_label_nlsid =>'LSNR_LOG_STATUS_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Listener_Logging_Status
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrLogStatusMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Log Status',
      p_metric_label_nlsid => 'LSNR_LOG_STATUS_METRIC_LABEL',
      p_description  => 'Collect listener log status parameter',
      p_description_nlsid => 'LSNR_LOG_STATUS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as log_status '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''loggingStatus''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----POLICY Listener_Logging_Status START----------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'log_status'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Listener_Logging_Status',   --Policy name
  p_metric_name =>'lsnrLogStatusMetricRep',      --Metric name
  p_policy_label_nlsid =>'LSNR_LOG_STATUS_NAME',    
  p_description =>'Ensures that listener logging is enabled',
  p_description_nlsid =>'LSNR_LOG_STATUS_DESC',
  p_impact =>'Without listener logging attacks on the listener can go unnoticed.',
  p_impact_nlsid =>'LSNR_LOG_STATUS_IMPACT',
  p_recommendation =>'Enable listener logging by setting the LOG_STATUS parameter to ON.',
  p_recommendation_nlsid =>'LSNR_LOG_STATUS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'UPPER(:log_status) <> ''ON''',
  p_message =>'Listener is in an insecure state. Logging is not enabled.',
  p_message_nlsid => 'LSNR_LOG_STATUS_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage => MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list => l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList	
);
COMMIT ;
----POLICY Listener_Logging_Status END------------------
----lsnrLogStatusMetricRep METRIC END-----------------------


----lsnrDefaultNameMetricRep METRIC START-----------------------
--Violating as well as non-violating rows are pushed from the agent side. One listener will have only one row, so 
--consider percentage is false. Exclusion of any name as violation also does not make sense here, 
--hence keeping no key columns
--AGENT METRIC : lsnrCmdStatus, perl fetchlet lsnrCmdStatus.pl
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'lsnr_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Listener Name',
                p_column_label_nlsid =>'LSNR_NAME_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used by policy Listener_Default_Name
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrDefaultNameMetricRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener Default Name',
      p_metric_label_nlsid => 'LSNR_DFLT_NAME_METRIC_LABEL',
      p_description  => 'Collect listener default name parameter',
      p_description_nlsid => 'LSNR_DFLT_NAME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as lsnr_name '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property = ''lsnr_default_name''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----POLICY Listener_Default_Name START-------------------------
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'lsnr_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Listener_Default_Name',   --Policy name
  p_metric_name =>'lsnrDefaultNameMetricRep',      --Metric name
  p_policy_label_nlsid =>'LSNR_DFLT_NAME_NAME',    
  p_description =>'Ensures that the default name of the listener is not used',
  p_description_nlsid =>'LSNR_DFLT_NAME_DESC',
  p_impact =>'Having a listener with the default name increases the risk of unauthorized access and denial of service attacks.',
  p_impact_nlsid =>'LSNR_DFLT_NAME_IMPACT',
  p_recommendation =>'Avoid having a listener with the default name (LISTENER).',
  p_recommendation_nlsid =>'LSNR_DFLT_NAME_RECOM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'UPPER(:lsnr_name) = ''LISTENER''',
  p_message =>'Listener is in an insecure state. The listener is addressed by the default name.',
  p_message_nlsid =>'LSNR_DFLT_NAME_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
----POLICY Listener_Default_Name START-------------------------
----lsnrDefaultNameMetricRep METRIC END-----------------------
---NEW metrics, one per policy END-------------------------------



---------------OLD METRICS, ALREADY ONE METRIC PER POLICY-----------------------------------------
--Violating as well as non-violating rows are pushed from the agent side. One listener will have only one row, so consider_percentage is false. Still keeping 2 key columns to enable the user to exclude some permission, filename
--Adding the metric column property , due to requirement of atleast one non-key column from the policy framework. 
--The policy does not need this property for its proper 
--evaluation or functioning. But policy framework requires that every repository metric have at least one non-key 
--column. The required column have to be key columns, so this dummy column is being added
--AGENT METRIC : lsnrParameters, perl fetchlet lsnrParams.pl
   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Listener.ora File Permission',
                p_column_label_nlsid =>'LSNRORA_PERM_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_path',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Listener.ora File',
                p_column_label_nlsid =>'LSNR_ORA_FILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
                
  MGMT_METRIC.CREATE_METRIC(--used only by policy lsnr_Ora_Restrict_Perms
      p_target_type => ESM.LSNR_TARGET_TYPE,
      p_metric_name => 'lsnrOraPermRep',
      p_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type , --it is table here
      p_metric_label => 'Listener.ora File Permissions',
      p_metric_label_nlsid => 'LSNR_ORA_PERM_METRIC_LABEL',
      p_description  => 'Collect listener.ora file permission',
      p_description_nlsid => 'LSNR_ORA_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE , --it is true here
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid ,value as file_path, value2 as file_permission,value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''lsnrora_permission''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list
 ) ;
COMMIT;
----------Policy lsnr_Ora_Restrict_Perms Start ----------------------------
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_permission'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_path'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Ora_Restrict_Perms',   --Policy name
  p_metric_name => 'lsnrOraPermRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_ORA_PERM_NAME',            --policylabelnlsid
  p_description  => 'Ensures that the file permissions for listener.ora are restricted to the owner of Oracle software',
  p_description_nlsid =>'LSNR_ORA_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'If the listener.ora file is public readable, passwords may be extracted from this file. This can also lead to exposure of detailed information on the Listener, database, and application configuration. Also, if public has write permissions, a malicious user can remove any password that has been set on the listener.', --Impact
  p_impact_nlsid =>'LSNR_ORA_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'Listener.ora permissions should be restricted to the owner of Oracle software installation and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_ORA_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'trunc(mod(:file_permission,10)/2,0) > 0',--'substr(:file_permission,-3,2) <> ''--'' ',
  p_message =>'Listener is in an insecure state. Permissions of listener.ora are not restricted to the Oracle set',
  p_message_nlsid =>'LSNR_ORA_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --consider percentage
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
----------Policy lsnr_Ora_Restrict_Perms End----------------------------
END ;
/
show errors ;

