Rem
Rem $Header: upgrade_delete_metrics.sql 09-sep-2005.15:21:43 rreilly Exp $
Rem
Rem upgrade_delete_metrics.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      upgrade_delete_metrics.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rreilly     09/09/05 - bug4602294 due to core4583478 can no longer run 
Rem                           beta scripts 
Rem    rreilly     08/16/05 - rreilly_bug_4541936_upgrade
Rem    rreilly     08/16/05 - Created
Rem

SET DEFINE OFF

-- Delete Metrics
--
-- NOTE: Metrics will not delete unless all associated policies
--       are first removed.  So, delete policy must run first,
--       then the metrics can be deleted.
--       After all policies and metrics are removed, then 
--       the metrics should be re-created and NEXT the
--       policies should be re-created.
--
-- Have to add error handling to PL/SQL because the fix for bug 4602294
-- means we cannot count on the metrics/policies being created, so
-- we have to handle the NO_SUCH_METRIC_FOUND and NO_SUCH_POLICY_FOUND 
-- exceptions.

-- 

-- --------------------------------------------------------
-- --------------------------------------------------------
--                CONFIGURATION: Delete Metrics
-- --------------------------------------------------------
-- --------------------------------------------------------

BEGIN

  --  Config: Database Instance Init Params
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_INIT_PARAMS',
      p_type_meta_ver => NULL);
  COMMIT;

  --  Config: DB Instance SGA_TARGET Init Param
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_SGA_TARGET_INIT_PARAM',
      p_type_meta_ver => NULL);
  COMMIT;

  --  Config: DB Tablespaces
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_TABLESPACES',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_TABLESPACES',
      p_type_meta_ver => NULL);
  COMMIT;    

  --  Config: DB Redo Logs
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_REDO_LOGS',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_REDO_LOGS',
      p_type_meta_ver => NULL);
  COMMIT;    

  --  Config: DB Optimizer Version
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_OPTIMIZER_VERSION',
      p_type_meta_ver => NULL);
  COMMIT;

  --  Config: DB Redo Log Count
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_REDO_LOG_COUNT',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_REDO_LOG_COUNT',
      p_type_meta_ver => NULL);
  COMMIT;    
  
  -- Config: DB Control File Count
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_CONTROL_FILE_COUNT',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_CONTROL_FILE_COUNT',
      p_type_meta_ver => NULL);
  COMMIT;    

  -- Config: DB ncomp JAccelerator Installation
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_INSTALL_NCOMPS',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_INSTALL_NCOMPS',
      p_type_meta_ver => NULL);
  COMMIT;   

  -- Config: High Availability - Recovery Area
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'HA_RECOVERY_AREA',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'HA_RECOVERY_AREA',
      p_type_meta_ver => NULL);
  COMMIT;   

  -- Config: High Availability - High Availability Information
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'HA_INFO',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'HA_INFO',
      p_type_meta_ver => NULL);
  COMMIT;   

  EXCEPTION
   WHEN MGMT_GLOBAL.NO_SUCH_METRIC_FOUND THEN
   NULL;

END;
/

-- --------------------------------------------------------
-- --------------------------------------------------------
--                STORAGE: Delete Metrics
-- --------------------------------------------------------
-- --------------------------------------------------------

BEGIN

  --  Storage: DB Rollback in SYSTEM Tablespace
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_RBS_IN_SYSTEM',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_RBS_IN_SYSTEM',
      p_type_meta_ver => NULL);
  COMMIT;    

  --  Storage: DB Recommended User Settings 
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_REC_USER_SETTINGS',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_REC_USER_SETTINGS',
      p_type_meta_ver => NULL);
  COMMIT;    

  --  Storage: DB Recommended Tablespace Settings 
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_REC_TS_SETTINGS',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_REC_TS_SETTINGS',
      p_type_meta_ver => NULL);
  COMMIT;    

  --  Storage: DB Tablespace Not Using Automatic Segment-Space Management
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_TBSP_SEGSPACE_MGMT',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_TBSP_SEGSPACE_MGMT',
      p_type_meta_ver => NULL);
  COMMIT;    


  --  Storage: DB Recommended Segment Settings
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'oracle_database',
      p_metric_name => 'DB_REC_SEGMENT_SETTINGS',
      p_type_meta_ver => NULL);
  COMMIT;
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'rac_database',
      p_metric_name => 'DB_REC_SEGMENT_SETTINGS',
      p_type_meta_ver => NULL);
  COMMIT;    

  --  Storage: ASM Instance Disk Group Settings
  MGMT_METRIC.DELETE_METRIC( 
      p_target_type => 'osm_instance',
      p_metric_name => 'DB_ASM_DISK_GROUP_SETTINGS',
      p_type_meta_ver => NULL);
  COMMIT;

  EXCEPTION
   WHEN MGMT_GLOBAL.NO_SUCH_METRIC_FOUND THEN
   NULL;

END;
/

SET DEFINE ON
