Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      apsdbmig.sql - migration script for upgrading olap aw component
Rem
Rem    DESCRIPTION
Rem      Migration script for providing upgrading to the olap aw component
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    zqiu        02/21/08 - 11gR1 support 
Rem    awesley     04/21/06 - 10gR2 support 
Rem    cdalessi    08/24/04 - 10gR1 support 
Rem    cdalessi    11/03/03 - fix banner 
Rem    cdalessi    08/20/03 - Add aps_validate call
Rem    cdalessi    02/06/03 - 
Rem    cdalessi    01/22/03 - Set registry to upgraded
Rem    cdalessi    01/21/03 - Fix typos, compatibility checks and
Rem                           reload logic
Rem    cdalessi    12/09/02 - 10i migration changes
Rem    cdalessi    10/14/02 - change to cataps
Rem    cdalessi    08/15/02 - Creation

execute sys.dbms_registry.upgrading('APS' ,'OLAP Analytic Workspace' ,'','');

COLUMN :aps_relod NEW_VALUE aps_relod NOPRINT
VARIABLE aps_relod VARCHAR2(128)
COLUMN :aps_fname NEW_VALUE aps_file NOPRINT
VARIABLE aps_fname VARCHAR2(128)
DECLARE
  compat VARCHAR2(30);
BEGIN
  :aps_relod := '?/rdbms/admin/nothing.sql';

  -- if the current version of APS is 11fR1
  IF substr(dbms_registry.version('APS'),1,4)='11.1' THEN
    :aps_fname := 'apsu111.sql';
    :aps_relod := 'apsrelod.sql';
  -- if the current version of APS is 10fR2
  ELSIF substr(dbms_registry.version('APS'),1,4)='10.2' THEN
    :aps_fname := 'apsu102.sql';
    :aps_relod := 'apsrelod.sql';
  -- if the current version of APS is 10fR1
  ELSIF substr(dbms_registry.version('APS'),1,4)='10.1' THEN
    :aps_fname := 'apsu101.sql';
    :aps_relod := 'apsrelod.sql';
  ELSIF substr(dbms_registry.version('APS'),1,5)='9.2.0' THEN
    -- upgrade it;  basically, we just rerun the install
    -- script; so no reload would be necessary; in fact, it
    -- would redundant;
    -- we call upgrade so the registry is set to 'Upgraded'
    :aps_fname := 'apsu920.sql';
  ELSE
    -- otherwise, if the OLAP option is turned ON
    select value into compat from v$option where parameter='OLAP';
    IF upper(compat) = 'TRUE' THEN
      -- AND, the compatibility setting is high enough to support
      -- this component
      select value into compat from v$parameter where name='compatible';
      IF substr(compat,1,5) >= '8.1.6' then
        -- Put the component in, no reload would be necessary
        :aps_fname := 'cataps.sql';
      ELSIF substr(compat,1,2) = '10' then
        -- Put the component in, no reload would be necessary
        :aps_fname := 'cataps.sql';
      ELSE
        :aps_fname := '?/rdbms/admin/nothing.sql';
      END IF;
    END IF;
  END IF;
END;
/
SELECT :aps_fname FROM DUAL;
@@&aps_file
SELECT :aps_relod from DUAL;
@@&aps_relod

execute sys.dbms_registry.upgraded('APS');

execute aps_validate;

