Rem
Rem Copyright (c) 2004, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      apsu101.sql - migration script for upgrading olap aw component
Rem
Rem    DESCRIPTION
Rem      Upgrade OLAP AW from 10.1.0
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    zqiu        05/02/08 - bug 6910052, revoke DML rights
Rem    zqiu        04/30/08 - stacking upgrades
Rem    cchiappa    06/30/04 - Dont insert duplicates
Rem    cchiappa    06/21/04 - Upgrade/downgrade for OLAP TTS support
Rem    cdalessi    05/26/04 - Creation

execute sys.dbms_registry.upgrading('APS');

INSERT INTO sys.expdepact$
  (SELECT o.obj#, 'DBMS_AW_EXP', 'SYS'
     FROM sys.obj$ o, sys.aw$ a
     WHERE o.name='AW$'||a.awname AND o.owner#=a.owner# AND o.type#=2
     AND o.obj# NOT IN
       (SELECT obj# FROM sys.expdepact$
          WHERE package='DBMS_AW_EXP' AND schema='SYS'));

Rem In 9.2 we gave too many privileges to select_catalog_role.
BEGIN
 execute immediate 
   'REVOKE DELETE, INSERT, UPDATE ON DBA_AWS from select_catalog_role';
 execute immediate 
   'REVOKE DELETE, INSERT, UPDATE ON DBA_AW_PS from select_catalog_role';
EXCEPTION
  WHEN OTHERS THEN
    NULL;
END;
/

Rem
Rem Call 10.2 upgrade script
Rem
@@apsu102.sql

execute sys.dbms_registry.upgraded('APS');
