declare
  b        boolean;
  r        PLS_INTEGER;
  ace      XMLType;
  ace_data VARCHAR2(2000); 
begin
  begin
    b := dbms_xdb.createfolder('/olap_data_security');
    b := dbms_xdb.createfolder('/olap_data_security/public');
    b := dbms_xdb.createfolder('/olap_data_security/public/acls');
  exception
    when others then
      if sqlcode <> -31003 then
        raise;
      end if;
  end;

  begin
    b := dbms_xdb.createfolder('/xds');
    b := dbms_xdb.createfolder('/xds/dsd');
  exception
    when others then
      if sqlcode <> -31003 then
        raise;
      end if;
  end;

  ace_data := '<ace xmlns="http://xmlns.oracle.com/xdb/acl.xsd"
                    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                    xsi:schemaLocation="http://xmlns.oracle.com/xdb/acl.xsd
                                        http://xmlns.oracle.com/xdb/acl.xsd
                                        DAV:http://xmlns.oracle.com/xdb/dav.xsd">
                 <principal>OLAP_XS_ADMIN</principal>
                 <grant>true</grant>
                 <privilege><all/></privilege>
               </ace>';
  ace := XMLType.createXML(ace_data);

  r := DBMS_XDB.changePrivileges('/olap_data_security', ace);
  r := DBMS_XDB.changePrivileges('/olap_data_security/public', ace);
  r := DBMS_XDB.changePrivileges('/olap_data_security/public/acls', ace);

  r := DBMS_XDB.changePrivileges('/xds', ace);
  r := DBMS_XDB.changePrivileges('/xds/dsd', ace);
end;
/
commit;
