Rem
Rem *************************************************************************
Rem *** IF YOU CHANGE THIS FILE,                                          ***
Rem ***        edit oraolap/test/olapdev/src/txolapsq.tsc accordingly!    ***
Rem *************************************************************************
Rem
Rem  cataps.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      cataps.sql
Rem
Rem    DESCRIPTION
Rem      Create OLAP AW
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cchiappa    01/11/05 - Move AW_XML into XOQ 
Rem    cchiappa    12/15/04 - Include AWXML 
Rem    zqiu        09/25/03 - include apsviews.sql
Rem    esoyleme    06/20/03 - validation procedure
Rem    cdalessi    10/14/02 - Change to cataps
Rem    cdalessi    02/25/02 - Creation

CREATE OR REPLACE PROCEDURE aps_validate IS
   AWok BOOLEAN;
   OBJok BOOLEAN;
   x NUMBER; -- dummy output spot
   junklob CLOB;
BEGIN

   -- AWs are valid if we can read an option
   BEGIN
     junklob := dbms_aw.INTERP('show SESSCACHE');
     AWok := TRUE;
   EXCEPTION
     WHEN OTHERS THEN 
       AWok := FALSE;
   END;

   -- supporting object things
   BEGIN
     SELECT 0 INTO x FROM DBA_OBJECTS
       WHERE STATUS = 'INVALID' AND rownum <=1 AND
         OWNER='SYS' AND OBJECT_NAME IN
        ('OLAP_TABLE', 'OLAPIMPL_T', 'OLAP_SRF_T', 'OLAP_NUMBER_SRF',
         'OLAP_EXPRESSION', 'OLAP_TEXT_SRF', 'OLAP_EXPRESSION_TEXT', 
         'OLAP_BOOL_SRF', 'OLAP_EXPRESSION_BOOL');
     -- at least one object is invalid so component is invalid
     OBJok := FALSE;
   EXCEPTION
   WHEN NO_DATA_FOUND THEN
     -- no invalid objects were found so component is valid
     OBJok := TRUE;
   END;

   IF AWok AND OBJok THEN 
     dbms_registry.valid('APS');
   ELSE
     dbms_registry.invalid('APS');
   END IF;
  END;
/

execute sys.dbms_registry.loading('APS' ,'OLAP Analytic Workspace' ,'aps_validate');

@@xumuts.plb

@@mvtabgs.sql
@@creatind.sql
@@apsviews.sql

BEGIN
 sys.dbms_registry.loaded('APS');
 aps_validate;
END;
/
