Rem
Rem *************************************************************************
Rem *** IF YOU CHANGE THIS FILE,                                          ***
Rem ***        edit oraolap/test/olapdev/src/txolapsq.tsc accordingly!    ***
Rem *************************************************************************
Rem
Rem  catxoq.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catxoq.sql
Rem
Rem    DESCRIPTION
Rem      Create OLAP API Packages and Libraries
Rem
Rem    NOTES
Rem      This script must be run as user SYS, and is typically called by
Rem      olap.sql installation time.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    akociube    04/08/09 - Add dbmscbu.sql
Rem    csperry     05/12/08 - Correct order due to new function dependency
Rem    glyon       06/04/07 - eliminate alter session table
Rem    csperry     05/16/07 - add install of dbms_cube_advise
Rem    dbardwel    12/21/06 - add awmxsrol.sql and awmcrxdb.plb
Rem    wechen      11/15/06 - add olapixds.plb
Rem    wechen      07/21/05 - remove olapi*92010.sql
Rem    cchiappa    01/11/05 - Move AW_XML into XOQ 
Rem    cdalessi    11/01/04 - move xoq_validate definition down 
Rem    wechen      01/05/04 - remove snapi
Rem    cdalessi    11/03/03 - fix banner 
Rem    cdalessi    10/21/03 - change refs to cwmlite and move olapimdx.plb
Rem                           down to catamd.sql
Rem    wechen      10/06/03 - re-enable xoq_validate to call OlapiBootstrap
Rem    cdalessi    08/20/03 - 
Rem    wechen      07/28/03 - xoq_validate
Rem    wechen      06/24/03 - invoke olapimov.plb
Rem    glyon       06/13/03 - add olapimdx for OLE DB for OLAP support
Rem    cdalessi    10/18/02 - cdalessi_txn103996
Rem    cdalessi    10/14/02 - Change to catxoq
Rem    wechen      08/21/02 -
Rem    cdalessi    08/15/02 -
Rem    wechen      06/26/02 -
Rem    wechen      06/05/02 -
Rem    kingols     05/31/02 -
Rem    cdalessi    02/27/02 - cdalessi_txn102058
Rem    cdalessi    02/25/02 - Creation

execute sys.dbms_registry.loading('XOQ' ,'Oracle OLAP API' ,'xoq_validate');

@@dbmscoad.sql
@@prvtcoas.plb
@@prvtcoad.plb

@@olapiboo.plb
@@olapimov.plb
@@olapimod.plb
@@olapiomd.plb
@@olapiecm.plb
@@olapimdm.plb
@@olapidcm.plb
@@olapidsm.plb
@@olapixds.plb

@@awmxsrol.sql
@@awmcrxdb.plb

@@catawxml.sql

@@dbmscbu.sql
@@prvtcbu.plb

-- XOQ is valid if compatible is set to 9.2 or higher and OlapiBootstrap() can
-- be executed successfully.  Also, since the AW_XML package is
-- dependant on it, make sure it seems to be OK as well.
CREATE OR REPLACE PROCEDURE xoq_validate IS
  compat          VARCHAR2(30);
  dummy_num       NUMBER;
  dummy_out_1_str VARCHAR2(100);
  dummy_out_2_str VARCHAR2(100);
  OLAPIok         BOOLEAN;
  XMLok           BOOLEAN;
BEGIN
  SELECT value INTO compat FROM v$parameter WHERE name='compatible';
  IF NOT (substr(compat,1,3) >= '9.2' OR substr(compat,1,2) >= '10') THEN
    OLAPIok := FALSE;
    XMLok := FALSE;
  ELSE
    BEGIN
      dummy_num := OlapiBootstrap2(compat, dummy_out_1_str, dummy_out_2_str);
      OLAPIok := TRUE;
    EXCEPTION
      WHEN OTHERS THEN
        OLAPIok := FALSE;
    END;
 
    -- Make sure AWXML got loaded OK
    BEGIN
      SELECT 0 INTO dummy_num FROM dba_objects
        WHERE owner = 'SYS' AND
             status = 'INVALID' AND
             object_type = 'JAVA CLASS' AND
             object_name LIKE 'oracle/AWXML/%';
      XMLok := FALSE;
    EXCEPTION
    WHEN NO_DATA_FOUND THEN
      XMLok := TRUE;
    END;
  END IF;

  IF OLAPIok AND XMLok THEN
    dbms_registry.valid('XOQ');
  ELSE
    dbms_registry.invalid('XOQ');
  END IF;
END;
/
show errors;

execute sys.dbms_registry.loaded('XOQ');
execute xoq_validate;
