--
-- $Header: dbmsawx.sql 01-apr-2008.13:47:51 glyon Exp $
--
-- dbmsawx.sql
--
-- Copyright (c) 2004, Oracle.  All rights reserved.  
--
--    NAME
--      dbmsawx.sql - Public definitions for DBMS_AW_XML
--
--    DESCRIPTION
--      Provides the prototype for the DBMS_AW_XML package
--
--    NOTES
--      <other useful comments, qualifications, etc.>
--
--    MODIFIED   (MM/DD/YY)
--    glyon       04/01/08 - add compressed form of readAWMetadata
--    cchiappa    03/07/05 - Add executefile 
--    dmellor     12/29/04 - Add readAWMetadata
--    cchiappa    12/13/04 - Created
--

CREATE OR REPLACE PACKAGE dbms_aw_xml AUTHID CURRENT_USER AS

  FUNCTION execute(input IN CLOB) RETURN VARCHAR2;
  FUNCTION readAWMetadata(input varchar2, input2 varchar2)
             RETURN GENWSTRINGSEQUENCE;
  PROCEDURE readAWMetadata1(byteParams IN OUT GENRAWSEQUENCE, wstrParams IN OUT GENWSTRINGSEQUENCE);
  FUNCTION executefile(dirname IN VARCHAR2, fname IN VARCHAR2) RETURN VARCHAR2;

END dbms_aw_xml;
/
SHOW ERRORS;

-- Give execute privileges
CREATE OR REPLACE PUBLIC SYNONYM dbms_aw_xml FOR sys.dbms_aw_xml
/
GRANT EXECUTE ON dbms_aw_xml TO PUBLIC
/
