Rem
Rem $Header: oraolap/src/sql/dbmscbu.sql /main/1 2009/03/26 10:09:03 smierau Exp $
Rem
Rem dbmscbu.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      dbmscbu.sql - DBMS_CUBE_UTIL declarations
Rem
Rem    DESCRIPTION
Rem      Provides interfaces for dbms_cube_util functions
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smierau     03/06/09 - Created
Rem

CREATE OR REPLACE PACKAGE dbms_cube_util AUTHID CURRENT_USER AS

  ---------------------
  --  OVERVIEW
  --
  --  This package is the interface to cube utility functions
  --
  ---------------------
  --  Visibility        
  --   All users
  --

  ---------------------
  --  CONSTANTS

  ---------------------
  --  EXCEPTIONS

  ---------------------
  --  PROCEDURES

  -- Create a report filter
  PROCEDURE create_rpt_filter(p_owner       IN VARCHAR2,
                              p_dimension   IN VARCHAR2,
                              p_rfname      IN VARCHAR2,
                              p_member_list IN VARCHAR2);

  -- Drop a report filter
  PROCEDURE drop_rpt_filter(p_owner       IN VARCHAR2,
                            p_dimension   IN VARCHAR2,
                            p_rfname      IN VARCHAR2);

  -- Drop a branch
  PROCEDURE drop_branch(p_owner       IN VARCHAR2,
                        p_dimension   IN VARCHAR2);

END dbms_cube_UTIL; 
/
show errors;

-- Give execute privileges
CREATE OR REPLACE PUBLIC SYNONYM dbms_cube_util FOR sys.dbms_cube_util
/
GRANT EXECUTE ON dbms_cube_util TO PUBLIC
/
