DROP VIEW GV_Olapi_Session_History;
DROP VIEW V_Olapi_Session_History;
DROP VIEW GV_Olapi_Iface_Object_History;
DROP VIEW V_Olapi_Iface_Object_History;
DROP VIEW GV_Olapi_Iface_Op_History;
DROP VIEW V_Olapi_Iface_Op_History;
DROP VIEW GV_Olapi_Memory_Op_History;
DROP VIEW V_Olapi_Memory_Op_History;
DROP VIEW GV_Ksmhp;
DROP SEQUENCE Olapi_History_Seq;
DROP TABLE Olapi_History CASCADE CONSTRAINTS;
DROP TABLE Olapi_Session_History CASCADE CONSTRAINTS;
DROP TABLE Olapi_Iface_Object_History CASCADE CONSTRAINTS;
DROP TABLE Olapi_Iface_Op_History CASCADE CONSTRAINTS;
DROP TABLE Olapi_Memory_Op_History CASCADE CONSTRAINTS;
DROP TABLE Olapi_Memory_Heap_History CASCADE CONSTRAINTS;
DROP PROCEDURE OlapiHistoryRetention;
DROP TRIGGER OlapiStartupTrigger;
DROP TRIGGER OlapiShutdownTrigger;
DROP PACKAGE DBMS_XSOQ;
DROP PACKAGE DBMS_XSOQ_UTIL;
CREATE OR REPLACE VIEW GV_Olapi_Session_History AS
  SELECT inst_id, hist_id, seqno, sess_id, sess_ser,
    DECODE(state, 0, 'ACTIVE', 'CLOSED') state,
    totsql2cpp, totcppexec, totcpp2sql
  FROM x$xsoqsehi;
CREATE OR REPLACE VIEW V_Olapi_Session_history AS
  SELECT hist_id, seqno, sess_id, sess_ser, state,
    totsql2cpp, totcppexec, totcpp2sql
  FROM GV_Olapi_Session_History
  WHERE inst_id = USERENV('Instance');
CREATE OR REPLACE VIEW GV_Olapi_Iface_Object_History AS
  SELECT a.inst_id, hist_id, seqno, xsoqsehi xsoqsehi_seqno,
    method_name iface_name, parent,
    DECODE(state, 0, 'ACTIVE', 'CLOSED') state,
    xsoqophi xsoqophi_seqno, totsql2cpp total_sql2cpp,
    totcppexec total_cppexec, totcpp2sql total_cpp2sql
  FROM x$xsoqojhi a, x$xsoqoplu b
  WHERE a.package_idx = b.package_idx AND a.iface_idx = b.iface_idx
    AND b.method_idx = 65535
  ORDER BY hist_id ASC, seqno ASC;
CREATE OR REPLACE VIEW V_Olapi_Iface_Object_History AS
  SELECT hist_id, seqno, xsoqsehi_seqno, iface_name, parent, state,
    xsoqophi_seqno, total_sql2cpp, total_cppexec, total_cpp2sql
  FROM GV_OLAPI_IFACE_OBJECT_HISTORY
  WHERE inst_id = USERENV('Instance');
CREATE OR REPLACE VIEW GV_Olapi_Iface_Op_History AS
  SELECT a.inst_id, hist_id, seqno, xsoqojhi xsoqojhi_seqno, method_name,
    DECODE(rpcstyle, 0, 'CLASSIC', 1, 'ADT', 2, 'CLOB', 3, 'VARRAY', 'MANUAL')
    rpcstyle, DECODE(state, 0, 'ACTIVE', 'CLOSED') state, sql2cpp sql2cpp_time,
    cppexec cppexec_time, cpp2sql cpp2sql_time, glbheap global_heap,
    gh_kghghs global_heap_size, gh_kghasp global_heap_allocated_size,
    gh_kghnsp global_heap_nonperm_size, sessheap session_heap,
    sh_kghghs session_heap_size, sh_kghasp session_heap_allocated_size,
    sh_kghnsp session_heap_nonperm_size
  FROM x$xsoqophi a, x$xsoqoplu b
  WHERE a.package_idx = b.package_idx AND a.iface_idx = b.iface_idx 
    AND a.method_idx = b.method_idx
  ORDER BY hist_id ASC, seqno ASC;
CREATE OR REPLACE VIEW V_Olapi_Iface_Op_History AS
  SELECT hist_id, seqno, xsoqojhi_seqno, method_name, rpcstyle, state,
    sql2cpp_time, cppexec_time, cpp2sql_time, global_heap,
    global_heap_size, global_heap_allocated_size, global_heap_nonperm_size,
    session_heap session_heap_size, session_heap_allocated_size,
    session_heap_nonperm_size
   FROM GV_OLAPI_IFACE_OP_HISTORY
   WHERE inst_id = USERENV('Instance');
CREATE OR REPLACE VIEW GV_Olapi_Memory_Op_History AS
  SELECT inst_id, hist_id, seqno, ' ' leakmark, xsoqophi, alt_seqno,
    DECODE(state, 0, 'ACTIVE', 'CLOSED') state,
    memop, heap, memaddr, memsize, filename, line
  FROM x$xsoqmehi;
CREATE OR REPLACE VIEW V_Olapi_Memory_Op_History AS
  SELECT hist_id, seqno, leakmark, xsoqophi, alt_seqno, state,
    memop, heap, memaddr, memsize, filename, line
  FROM GV_OLAPI_MEMORY_OP_HISTORY
  WHERE inst_id = USERENV('Instance');
CREATE OR REPLACE VIEW GV_Ksmhp AS
  SELECT * FROM x$ksmhp;
CREATE SEQUENCE Olapi_History_Seq;
CREATE TABLE Olapi_History (
  inst_id NUMBER, hist_id NUMBER, start_time TIMESTAMP, 
  collecting_stop_time TIMESTAMP, stop_time TIMESTAMP,
  session_count NUMBER,
  CONSTRAINT olapi_hist_pk PRIMARY KEY (inst_id, hist_id))
  TABLESPACE SYSAUX;
CREATE TABLE Olapi_Session_History (
  inst_id NUMBER, hist_id NUMBER, seqno NUMBER,
  session_id NUMBER, sess_ser NUMBER, state VARCHAR2(6), totsql2cpp NUMBER,
  totcppexec NUMBER, totcpp2sql NUMBER,
  CONSTRAINT olapi_sess_hist_pk PRIMARY KEY (inst_id, hist_id, seqno))
  TABLESPACE SYSAUX;
CREATE TABLE Olapi_Iface_Object_History (
  inst_id NUMBER, hist_id NUMBER, seqno NUMBER,
  xsoqsehi_seqno NUMBER, iface_name VARCHAR2(64),
  parent_seqno NUMBER, state VARCHAR2(6), xsoqophi_seqno NUMBER,
  totsql2cpp NUMBER, totcppexec NUMBER, totcpp2sql NUMBER,
  CONSTRAINT olapi_iface_object_hist_pk PRIMARY KEY (inst_id, hist_id, seqno))
  TABLESPACE SYSAUX;
CREATE TABLE Olapi_Iface_Op_History (
  inst_id NUMBER, hist_id NUMBER, seqno NUMBER,
  xsoqojhi_seqno NUMBER, method_name VARCHAR2(64), rpcstyle VARCHAR(8),
  state VARCHAR2(6), sql2cpp NUMBER, cppexec NUMBER,
  cpp2sql NUMBER, glbheap RAW(8), gh_kghghs NUMBER, gh_kghasp NUMBER,
  gh_kghnsp NUMBER, sessheap RAW(8), sh_kghghs NUMBER, sh_kghasp NUMBER,
  sh_kghnsp NUMBER, java2sql NUMBER, sqlexec NUMBER, sql2java NUMBER,
  CONSTRAINT olapi_iface_op_hist_pk PRIMARY KEY (inst_id, hist_id, seqno))
  TABLESPACE SYSAUX;
CREATE TABLE Olapi_Memory_Op_History (
  inst_id NUMBER, hist_id NUMBER, seqno NUMBER, leakmark VARCHAR2(1),
  xsoqophi_seqno NUMBER, alt_seqno NUMBER, state VARCHAR2(6),
  memop NUMBER, heap RAW(8), memaddr RAW(8), memsize NUMBER,
  filename VARCHAR2(35), line NUMBER,
  CONSTRAINT olapi_memory_op_hist_pk PRIMARY KEY (inst_id, hist_id, seqno))
  TABLESPACE SYSAUX;
CREATE TABLE Olapi_Memory_Heap_History (
  addr RAW(8), indx NUMBER, inst_id NUMBER, hist_id NUMBER,
  xsoqsehi_seqno NUMBER, KSMCHDS RAW(8), KSMCHCOM VARCHAR2(16),
  KSMCHPTR RAW(8), KSMCHSIZ NUMBER, KSMCHCLS VARCHAR2(8), KSMCHTYP NUMBER,
  KSMCHPAR RAW(8), KSMCHOWN RAW(8))
  TABLESPACE SYSAUX;
CREATE OR REPLACE PROCEDURE OlapiHistoryRetention wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
16f 12c
qTNPXQh1OUGd3rnUSofpirEsx0QwgzLQmBhqZ3TpxDPq48PLXSgJ+oJmb7TvjLPIVSe0ZgKo
FKgeybU/xn5xXVy99WTbrdYY70+JZ0qanC2kquhOgeoo6+4h8MFeYqTL02fxNe8l80CyoHYu
+hYEnOMPGooDEUqOjLeOfilGd3gaHp63DYqvbD2bFLBaozhGy2rR7krdXKZQUoxND48TIouI
1seT16HdQXCB8b8qwR0n3gTe2JA2jK4F3Z3GZZnIFwcbknBOVr+xEqUjSRKYk3J8EmFvSAQF
0CT64BGs

/
CREATE OR REPLACE TRIGGER OlapiStartupTrigger AFTER STARTUP ON DATABASE
  DECLARE openMode V$DATABASE.open_mode%TYPE;
          olapOn BOOLEAN;
          histRetention BOOLEAN;
          hist_id NUMBER;
          sessionCount NUMBER;
  BEGIN

  SELECT open_mode INTO openMode FROM V$DATABASE;
  IF (openMode != 'READ WRITE') THEN
    histRetention := FALSE;
    OlapiHistoryRetention(olapOn, histRetention, sessionCount);
    RETURN;
  END IF;

  OlapiHistoryRetention(olapOn, histRetention, hist_id);
  IF (olapOn AND histRetention) THEN
    BEGIN
    SELECT Olapi_History_Seq.NEXTVAL INTO hist_id FROM DUAL;


    INSERT INTO Olapi_History VALUES(SYS_CONTEXT('USERENV', 'Instance'), 
      hist_id, CURRENT_TIMESTAMP, NULL, NULL, 0);
    EXCEPTION


    WHEN OTHERS THEN
      histRetention := FALSE;
      OlapiHistoryRetention(olapOn, histRetention, sessionCount);
    END;
  END IF;
  END;
/
CREATE OR REPLACE TRIGGER OlapiShutdownTrigger BEFORE SHUTDOWN ON DATABASE
  DECLARE openMode V$DATABASE.open_mode%TYPE;
          olapOn BOOLEAN;
          histRetention BOOLEAN;
          sessionCount NUMBER;
          histID NUMBER;
  BEGIN

  SELECT open_mode INTO openMode FROM V$DATABASE;
  IF (openMode != 'READ WRITE') THEN
    histRetention := FALSE;
    OlapiHistoryRetention(olapOn, histRetention, sessionCount);
    RETURN;
  END IF;

  OlapiHistoryRetention(olapOn, histRetention, sessionCount);
  IF (olapOn AND histRetention) THEN



    BEGIN
    SELECT MAX(hist_id) INTO histID FROM Olapi_History;
    IF (histRetention) THEN
      UPDATE Olapi_History SET collecting_stop_time = CURRENT_TIMESTAMP WHERE
        inst_id = SYS_CONTEXT('USERENV', 'Instance') AND hist_id = histID;
    END IF;
    UPDATE Olapi_History SET stop_time = CURRENT_TIMESTAMP,
      session_count = sessionCount WHERE
      inst_id = SYS_CONTEXT('USERENV', 'Instance') AND hist_id = histID;
    EXCEPTION


    WHEN OTHERS THEN
      RETURN;
    END;
  END IF;
  END;
/
CREATE OR REPLACE PACKAGE DBMS_XSOQ wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
307 11f
0m1Za5LWqQaSCLgjHSILrbQOS3Uwg9f3vsvhf3SiJv7VcayglGKNeH9+otHPuMM6tZ3KWo7n
2yuOiWHkyWBBGLnjW+EkbN7qPkln660wuNRZkxO9fw50aqZpvleb1DZs4LImbiktoxLTeXu9
RnQXkXjvIHiYeBqrLBHLUQIgHsjpf9onVSaEMSV3eXrNs1Ezf9QtaqZy+LsXLN9lnAxRd6gt
iaWch+9wdxv1lwGT40vfzD8Qxhd9ZL7v7ggohNBwXNlRJQmIGJJPLmkzmD2kdDf6Aw==

/
CREATE OR REPLACE PACKAGE BODY DBMS_XSOQ wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
5f5b 1299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/
CREATE OR REPLACE PACKAGE DBMS_XSOQ_UTIL wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
36b 1a5
kriipyAxDu3fB9vpWAnLAYv+6GEwg/Dx1ytGyo7GuviOv97BUxYFQ96v3TKR5meWWesY/qpt
DqCikEraU/n5LKmnCL+fYC+wQRXwRy80t54ElERng7/CMjfIWquyaBHAWdpQvCTu52QgpXdW
NTFlSq9u0YVVHHM0gAUAwv+FHBKCPxk1D+xmDQ2M7hbk47hgsaHAzKjprTusjnDkVhJ+Zfsn
fzgBeyeP1MY2JklFGNmOq9lgnJ1S0qZUzrU/kzH25HXNnGADOvdAGZ6LpQ7ZwoCLJcWupF7l
XxAwv8S7eNSNqI6AWow28bq3lC/LNRM0LujccvbRzKdRl6TPHQX18ovffkRog+w5DT+QV9T9
m9g8DvxX+XhNhMkCu83P7hKc+LZLefGg3qoB77u0VID4zqoqKA/ewIu/

/
CREATE OR REPLACE PACKAGE BODY DBMS_XSOQ_UTIL wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
1273 4ac
g4//Q43XHeKTqNAOzbA6nTWLAUEwgz1UDMeDfC+5WA9r/VAwe1h22bgvPKyQtPHIkcrtMHuQ
h8fetbX1gRWW4dwbKOzW90MQz/g6uq9gJdI3SKnYNhIUflz8kg6VYeJZhy/lSbbmGtM+S/L7
Man6wHlGI0cxVtj8bvPMiBUKwEQnSBDnk68bwc4ma6l3yPEcbq2D/6H/8MpiwQ3TbPNEjUKk
nx99vQeOGvoC8OaFIh3cRvpn3qzqnaGDzLyW+s1mftV8jQbRnhdtSL1TtjTJq6DiXsxS1nXh
+Tacg2lBrLKDfq4jKUquI0Tq8cwdVcDIRIS4bPa3nGenFDuJ4UhoYhvVYyggCHCv+yXxoKU4
c+NV5gP6nKTIiQPve7Wgr63s+seJUrSAl4NC7zgL9ak/Dl+qgUxIn6BNZ8QdEmV7Kw1AzXjL
W9Y8+r2SfN7M2x7Nz1KNl04lBPpdbYGNGBVvbk4uECsnLU3HwCMkPjtt8hegFslNTSESYZeJ
J8r/GqGRrmNWDxN7oKHaQ2mHLZyrGG52vPGPNeTZmor8tzNttkJOKulA2/wZOXsTNHmtZ6V0
qV4iF2mFzOddmQMszbeMkPgTRP66wK6/0twgeRPz5KkdGjhCFyw6S9hRleSOztPy1egMfdDJ
C+4odqySbsgZ3FPeqCFLruu5VylAi9RA3zOmdSNQ6x5p0tmvTJ1Q0PPUsTM4ELg5XrAA3B5M
jnSdIZIjri+VYYsG/NqmYefAiFCHnPnG5vi1d6otwiix+aazEz9/tEXbABhVnzyK5hf1P+0A
jD6CfTz6rSOa6KbeTl6C3dAkYWOg5n3Q5lN56bOtlGl2UwAWGedexhb5r1ExMjVFmH/cAwUT
G7MW2wwVgx4Dk9qorW47XaHaFyWhAY1dJiPpHmEeapMOEBK2KR7qaLS+BROFF0/WcB8gIGb6
bS3gGBSiotn77/OEW8zTc+CL0Uq/lAs5w8LliVIJeyqUlTe+ZCse9ru/w2OIXL8fxlC4J1Sd
+TWEiMe1y3BbT2JfDKFuStMHK4ai6tob05sO2SELe1YJzCOAv0nwnvh7tfNiGBH2HAFUoavN
2xmCi0q+MCHEhVcV5yH1syHiuXXcijX0OIKtBPnFXTbOSN/XT/nkczrSHv53LPyfL3SUMTUv
sCBrfT/JJuydkgEFHpyqWu0D4A==

/
declare
  cursor xoqrole is select role from dba_roles where role = 'OLAPI_TRACE_USER';
  xoqrolename varchar2(30);
begin
  if not  xoqrole%isopen then 
    open xoqrole;
    fetch xoqrole into xoqrolename;
    if xoqrole%notfound then
      execute immediate 'CREATE ROLE OLAPI_TRACE_USER';
    end if;
    close xoqrole;
  end if;
end;
/
;
CREATE OR REPLACE PUBLIC SYNONYM GV_Olapi_Session_History FOR sys.GV_Olapi_Session_History;
GRANT ALL ON GV_Olapi_Session_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM V_Olapi_Session_History FOR sys.V_Olapi_Session_History;
GRANT ALL ON V_Olapi_Session_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM GV_Olapi_Iface_Object_History FOR sys.GV_Olapi_Iface_Object_History;
GRANT ALL ON GV_Olapi_Iface_Object_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM V_Olapi_Iface_Object_History FOR sys.V_Olapi_Iface_Object_History;
GRANT ALL ON V_Olapi_Iface_Object_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM GV_Olapi_Iface_Op_History FOR sys.GV_Olapi_Iface_Op_History;
GRANT ALL ON GV_Olapi_Iface_Op_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM V_Olapi_Iface_Op_History FOR sys.V_Olapi_Iface_Op_History;
GRANT ALL ON V_Olapi_Iface_Op_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM GV_Olapi_Memory_Op_History FOR sys.GV_Olapi_Memory_Op_History;
GRANT ALL ON GV_Olapi_Memory_Op_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM V_Olapi_Memory_Op_History FOR sys.V_Olapi_Memory_Op_History;
GRANT ALL ON V_Olapi_Memory_Op_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM GV_Ksmhp FOR sys.GV_Ksmhp;
GRANT ALL ON GV_Ksmhp TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM Olapi_History_Seq FOR sys.Olapi_History_Seq;
GRANT ALL ON Olapi_History_Seq TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM Olapi_History FOR sys.Olapi_History;
GRANT ALL ON Olapi_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM Olapi_Session_History FOR sys.Olapi_Session_History;
GRANT ALL ON Olapi_Session_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM Olapi_Iface_Object_History FOR sys.Olapi_Iface_Object_History;
GRANT ALL ON Olapi_Iface_Object_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM Olapi_Iface_Op_History FOR sys.Olapi_Iface_Op_History;
GRANT ALL ON Olapi_Iface_Op_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM Olapi_Memory_Op_History FOR sys.Olapi_Memory_Op_History;
GRANT ALL ON Olapi_Memory_Op_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM Olapi_Memory_Heap_History FOR sys.Olapi_Memory_Heap_History;
GRANT ALL ON Olapi_Memory_Heap_History TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM DBMS_XSOQ FOR sys.DBMS_XSOQ;
GRANT EXECUTE ON DBMS_XSOQ TO OLAPI_TRACE_USER;
CREATE OR REPLACE PUBLIC SYNONYM DBMS_XSOQ_UTIL FOR sys.DBMS_XSOQ_UTIL;
GRANT EXECUTE ON DBMS_XSOQ_UTIL TO OLAPI_TRACE_USER;
