DECLARE
 tmp BOOLEAN := FALSE;
BEGIN
  BEGIN
    DBMS_XDB.deleteresource('/OLAP_XDS', DBMS_XDB.DELETE_RECURSIVE_FORCE);
  EXCEPTION
    WHEN OTHERS THEN
    tmp := FALSE; 
  END;
  tmp := DBMS_XDB.createfolder('/OLAP_XDS');
  tmp := DBMS_XDB.createResource(
         '/OLAP_XDS/dsclass.xml',
         '<securityClass xmlns="http://xmlns.oracle.com/xs"
                         xmlns:sc="http://xmlns.oracle.com/xs"
                         xmlns:oa="http://xmlns.oracle.com/S"
                         xmlns:dav="DAV:"
                         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                         xsi:schemaLocation="http://xmlns.oracle.com/xs
                         http://xmlns.oracle.com/xs/securityclass.xsd"
                         targetNamespace="http://xmlns.oracle.com/S"
                         name="OlapPrivileges">
          <inherits-from>dav:dav</inherits-from>
          <privilege name="delete"/>
          <privilege name="insert"/>
          <privilege name="select"/>
          <privilege name="update"/>
          <aggregatePrivilege name="read">
            <privilegeRef name="oa:select"/>
          </aggregatePrivilege>
          <aggregatePrivilege name="write">
            <privilegeRef name="oa:delete"/>
            <privilegeRef name="oa:insert"/>
            <privilegeRef name="oa:update"/>
          </aggregatePrivilege>
          <aggregatePrivilege name="all">
            <privilegeRef name="oa:delete"/>
            <privilegeRef name="oa:insert"/>
            <privilegeRef name="oa:select"/>
            <privilegeRef name="oa:update"/>
          </aggregatePrivilege>
          </securityClass>');
END;
/
