Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xoqdbmig.sql - migration script for upgrading olap api component
Rem
Rem    DESCRIPTION
Rem      Migration script for upgrading the olap api component
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jhartsin    02/21/08 - 11gR1 support
Rem    awesley     04/21/06 - 10gR2 support 
Rem    cdalessi    08/24/04 - 10gR1 support 
Rem    cdalessi    11/03/03 - fix banner 
Rem    cdalessi    08/06/03 - Fix placement of xoq_validate argument
Rem    wechen      07/30/03 - xoq_validate
Rem    cdalessi    01/22/03 - Set registry to upgraded
Rem    cdalessi    01/21/03 - Fix typos, compatibility checks and
Rem                           reload logic
Rem    cdalessi    12/09/02 - 10i migration changes
Rem    cdalessi    10/14/02 - change to catxoq
Rem    cdalessi    08/15/02 - Creation

execute sys.dbms_registry.upgrading('XOQ' ,'Oracle OLAP API' ,'xoq_validate','');

COLUMN :xoq_relod NEW_VALUE xoq_relod NOPRINT
VARIABLE xoq_relod VARCHAR2(128)
COLUMN :xoq_fname NEW_VALUE xoq_file NOPRINT
VARIABLE xoq_fname VARCHAR2(128)
DECLARE
  compat          VARCHAR2(30);
BEGIN

  -- if the current version of XOQ is 11gR1
  IF substr(dbms_registry.version('XOQ'),1,4)='11.1' THEN
    -- upgrade it
    :xoq_fname := 'xoqu111.sql';
    -- finish it off with a reload
    :xoq_relod := 'xoqrelod.sql';
  -- if the current version of XOQ is 10gR2
  ELSIF substr(dbms_registry.version('XOQ'),1,4)='10.2' THEN
    -- upgrade it
    :xoq_fname := 'xoqu102.sql';
    -- finish it off with a reload
    :xoq_relod := 'xoqrelod.sql';
  -- if the current version of XOQ is 10gR1
  ELSIF substr(dbms_registry.version('XOQ'),1,4)='10.1' THEN
    -- upgrade it
    :xoq_fname := 'xoqu101.sql';
    -- finish it off with a reload
    :xoq_relod := 'xoqrelod.sql';
  -- if the current version of XOQ is 9.2.0
  ELSIF substr(dbms_registry.version('XOQ'),1,5)='9.2.0' THEN
    -- upgrade it
    :xoq_fname := 'xoqu920.sql';
    -- finish it off with a reload
    :xoq_relod := 'xoqrelod.sql';
  ELSE
    :xoq_relod := '?/rdbms/admin/nothing.sql';
    -- otherwise, if the OLAP option is turned ON
    select value into compat from v$option where parameter='OLAP';
    IF upper(compat) = 'TRUE' THEN
      -- AND, the compatibility setting is high enough to support
      -- this component
      select value into compat from v$parameter where name='compatible';
      IF substr(compat,1,3) >= '9.2' then
        -- Put the component in, no reload would be necessary
        :xoq_fname := 'catxoq.sql';
      ELSIF substr(compat,1,2) = '10' then
        -- Put the component in, no reload would be necessary
        :xoq_fname := 'catxoq.sql';
       ELSE
        :xoq_fname := '?/rdbms/admin/nothing.sql';
      END IF;
    END IF;
  END IF;
END;
/

SELECT :xoq_fname FROM DUAL;
@@&xoq_file

SELECT :xoq_relod from DUAL;
@@&xoq_relod

execute sys.dbms_registry.upgraded('XOQ');

execute xoq_validate;
